package com.jhscale.meter.protocol.ble_print.entity.disassembly;

import com.jhscale.common.em.DeviceType;
import com.jhscale.common.model.device.log.DLOGV1;
import com.jhscale.common.model.device.log.module.DGoods;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.ble_print.BLEPrintConstant;
import com.jhscale.meter.protocol.ble_print.entity.BPPackDisassemblyResponse;
import com.jhscale.meter.protocol.ble_print.entity.assembly.ReadLOGBPPARequest;

import java.math.BigDecimal;
import java.util.*;

/**
 * @author lie_w
 * @title: WeighingModelPA
 * @projectName meter-jar
 * @description: 日志信息（读）响应
 * @date 2021/6/109:33
 */
public class ReadLOGBPPDResponse extends BPPackDisassemblyResponse<ReadLOGBPPARequest> {

    // 执行内容
    private String action;

    // 执行标志
    private String flag;

    // 日志记录
    private List<DLOGV1> logs;

    @Override
    public ReadLOGBPPDResponse disassembly() throws MeterException {
        ReadLOGBPPARequest request = this.getRequest();
        this.action = request.getAction();
        if (BLEPrintConstant.DL_LOG.equals(request.getAction())) {
            super.disassembly();
        } else {
            this.flag = this.split_bin();
            this.end = flag.charAt(0) == '1';
            int count = this.split_int(2);
            for (int i = 0; i < count; i++) {

                int fid = this.split_int(4);
                int goods_no = this.split_int(4);
                Date date = this.split_date();
                BigDecimal gross = this.split_bigDecimal();
                BigDecimal tare = this.split_bigDecimal();
                BigDecimal weight = gross.subtract(tare);

                this.add(new DLOGV1<>()
                        .setFid(fid)
                        .setKind(DeviceType.BT_Print_Scales.getItype())
                        .setTradeTime(date)
                        .addGoods(new DGoods()
                                .setNo(goods_no)
                                .setAmount(weight)
                                .setText1(gross.toString())
                                .setText2(tare.toString())));
            }
        }
        return this;
    }

    public void add(DLOGV1... logs) {
        if (logs != null && logs.length > 0) {
            this.add(Arrays.asList(logs));
        }
    }

    public void add(List<DLOGV1> logs) {
        if (logs != null && !logs.isEmpty()) {
            if (this.logs == null) this.logs = new ArrayList<>();
            this.logs.addAll(logs);
        }
    }

    public Integer length() {
        return Objects.nonNull(this.logs) ? this.logs.size() : 0;
    }

    public Integer lastFid() {
        return Objects.isNull(this.logs) || this.logs.isEmpty() ? 0 : this.logs.get(this.logs.size() - 1).getFid();
    }

    public String getAction() {
        return action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getFlag() {
        return flag;
    }

    public void setFlag(String flag) {
        this.flag = flag;
    }

    public List<DLOGV1> getLogs() {
        return logs;
    }

    public void setLogs(List<DLOGV1> logs) {
        this.logs = logs;
    }
}
