package com.jhscale.meter.protocol.ble_print.listener;

import com.jhscale.common.utils.ByteUtils;
import com.jhscale.meter.entity.ProtocolAnalyse;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.io.listener.DeviceClientEventListener;
import com.jhscale.meter.protocol.*;
import com.jhscale.meter.protocol.ad.em.CommunicationState;
import com.jhscale.meter.protocol.ble_print.entity.BPPackDisassemblyRequest;
import com.jhscale.meter.protocol.ble_print.entity.BPPackDisassemblyResponse;
import com.jhscale.meter.protocol.entity.ProtocolEntity;
import com.jhscale.meter.protocol.model.GlobalPara;
import com.jhscale.meter.utils.CodeUtils;
import com.jhscale.meter.utils.MeterUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lie_w
 * @title: BlePrintClientEventListener
 * @projectName meter-jar
 * @description: TODO
 * @date 2023/5/2713:25
 */
public class BlePrintClientEventListener implements DeviceClientEventListener, ProtocolBufferEvent {

    // 通讯状态
    private CommunicationState communication = CommunicationState.NORMAL;

    // 加密
    private boolean code = true;

    // 回调执行器
    private IBProtocolResponse defaultResponse;

    // 协议控制器
    private IProtocolManager manager;

    // 指令响应回调器
    private Map<String, ProtocolEntity> responseMap;

    // 线程
    public ProtocolBufferThread thread;

    public BlePrintClientEventListener(IBProtocolResponse defaultResponse, IProtocolManager manager, boolean code) {
        this.defaultResponse = defaultResponse;
        this.manager = manager;
        this.responseMap = new HashMap<>();
        this.code = code;
        this.thread = new ProtocolBufferThread(this);
        this.thread.switchOn();
        this.thread.start();
    }

    /**
     * @param bytes
     * @description: 连接监听
     */
    @Override
    public void onClientEvent(byte[] bytes) throws MeterException {
        boolean other = this.defaultResponse != null && this.defaultResponse instanceof IOProtocolResponse;
        if (other) {
            ((IOProtocolResponse) this.defaultResponse).target(bytes);
        } else {
            boolean debug = this.defaultResponse != null && this.defaultResponse instanceof IDebugProtocolResponse;
            if (bytes != null && bytes.length > 0) {
                if (GlobalPara.getInstance().isRunLog()) System.out.println("源码： " + ByteUtils.toHexString(bytes));
                if (debug) ((IDebugProtocolResponse) this.defaultResponse).source(bytes);
                if (this.code) bytes = CodeUtils.decode(bytes);
                if (GlobalPara.getInstance().isRunLog()) System.out.println("解码： " + ByteUtils.toHexString(bytes));
                if (debug) ((IDebugProtocolResponse) this.defaultResponse).target(bytes);
                // 添加缓冲区
                this.addBuffer(bytes);
            }
        }
    }

    /**
     * @param buffer
     * @description: 执行解析发送
     */
    @Override
    public byte[] execute(byte[] buffer) {
        ProtocolAnalyse analyse = MeterUtils.analyse(buffer);
        if (!analyse.getBytes().isEmpty()) {
            analyse.getBytes().forEach(bytes -> {
                if (GlobalPara.getInstance().isRunLog())
                    System.out.printf("解析内容[%s]：%s%n", bytes.length, ByteUtils.toHexString(bytes));
                try {
                    BPPackDisassemblyResponse response = (BPPackDisassemblyResponse) this.manager.execute(new BPPackDisassemblyRequest(this.responseMap, bytes));
                    ProtocolEntity protocolEntity = response.end() ? this.responseMap.remove(response.KEY()) : this.responseMap.get(response.KEY());
                    if (protocolEntity != null && protocolEntity.getResponse() instanceof IProtocolResponse) {
                        ((IProtocolResponse) protocolEntity.getResponse()).target(response);
                    } else if (this.defaultResponse != null && this.defaultResponse instanceof IProtocolResponse) {
                        ((IProtocolResponse) this.defaultResponse).target(response);
                    } else {
                        throw new MeterException(MeterStateEnum.BP_响应通道对象异常);
                    }
                } catch (MeterException e) {
                    e.printStackTrace();
                    if (this.defaultResponse != null) this.defaultResponse.exp(e);
                } catch (Exception e) {
                    e.printStackTrace();
                    if (this.defaultResponse != null)
                        this.defaultResponse.exp(new MeterException(e, MeterStateEnum.其他未知异常));
                }

            });
        }
        return analyse.getSurplus();
    }

    /**
     * @param key
     * @param response
     * @description: 发送命令添加回调
     */
    @Override
    public void addProtocolResponse(String key, ProtocolEntity response) {
        this.responseMap.put(key, response);
    }

    /**
     * @description: 监听器停止
     **/
    @Override
    public void stop() {
        this.thread.giveOver();
    }

    /**
     * @description: 修改通讯状态
     **/
    public synchronized void setCommunication(CommunicationState communication) {
        this.communication = communication;
        this.thread.switchOn();
        try {
            Thread.sleep(500);
        } catch (InterruptedException e) {
        }
        this.thread.switchOn();
    }

    /**
     * @param e
     * @description: 连接异常监听
     */
    @Override
    public void onClientEventExp(MeterException e) {
        if (this.defaultResponse != null)
            this.defaultResponse.exp(e);
    }

    /**
     * @param bytes
     * @description: 添加缓冲区
     */
    @Override
    public void addBuffer(byte[] bytes) {
        this.thread.addBuffer(bytes);
    }

    /**
     * @description: 缓冲区清空
     **/
    @Override
    public void clear() {
        this.thread.clear();
    }
}
