package com.jhscale.meter.protocol.entity;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.log.JLog;
import com.jhscale.meter.model.base.JSONMeter;

/**
 * @author lie_w
 * @title: IPackRequest
 * @projectName meter-jar
 * @description: 协议执行器 请求
 * @date 2021/6/1010:32
 */
public interface IPackRequest<T extends IPackResponse> extends JSONMeter {

    /**
     * @description: 协议执行器
     **/
    T execute() throws MeterException;

    /**
     * @description: 获取返回值类型
     **/
    <T extends IPackResponse> Class<T> getClazz();

    /**
     * @description: 响应对象信息
     **/
    default T response() throws MeterException {
        T response = null;
        try {
            response = (T) this.getClazz().newInstance();
        } catch (Exception e) {
            JLog.error("Response resClass ERROR:{}", e.getMessage(), e);
            throw new MeterException(MeterStateEnum.反射结果异常);
        }
        if (response == null)
            throw new MeterException(MeterStateEnum.反射结果失败);
        return response;
    }

    /**
     * @description: 是否加密
     **/
    boolean code();

    /**
     * @description: 是否加密
     **/
    void code(boolean code);
}
