package com.jhscale.meter.protocol.entity;

import com.jhscale.meter.model.base.JSONMeter;

/**
 * @author lie_w
 * @title: IPackResponse
 * @projectName meter-jar
 * @description: 协议执行器 响应
 * @date 2021/6/1010:34
 */
public interface IPackResponse extends JSONMeter {

    /**
     * @description: 通讯标识
     **/
    int nid();

    /**
     * @description: 操作指令
     **/
    default int command() {
        return 0;
    }

    /**
     * @description: 通讯指令集合标识
     **/
    default String KEY() {
        return this.nid() + "$" + this.command();
    }

    /**
     * @description: 组装发送写的内容
     **/
    byte[] HEX();

    /**
     * @description: 是否结束
     **/
    default boolean end() {
        return true;
    }
}
