package com.jhscale.meter.protocol.entity;

import java.lang.reflect.ParameterizedType;

/**
 * @author lie_w
 * @title: AgreeRequest
 * @projectName meter-jar
 * @description: 协议组装 请求
 * @date 2021/6/109:26
 */
public interface PackAssemblyRequest<T extends PackAssemblyResponse> extends IPackRequest<PackAssemblyResponse>, InnerPackAssembly {

    /**
     * @description: 返回值Interface 定义泛型类型 类型
     **/
    @Override
    default <T extends IPackResponse> Class<T> getClazz() {
        ParameterizedType parameterizedType = (ParameterizedType) this.getClass().getGenericSuperclass();
        return (Class<T>) parameterizedType.getActualTypeArguments()[0];
    }

    /**
     * @description: 存在继续数据包
     **/
    default boolean hasNext() {
        return false;
    }


}
