package com.jhscale.meter.protocol.entity;

import com.jhscale.common.model.inter.GJSONModel;
import com.jhscale.meter.protocol.IBProtocolResponse;

/**
 * @author lie_w
 * @title: ProtocolEntity
 * @projectName meter-jar
 * @description: TODO
 * @date 2023/5/2923:11
 */
public class ProtocolEntity implements GJSONModel {

    private IPackRequest request;

    private IBProtocolResponse response;

    private final long start = System.currentTimeMillis();

    public ProtocolEntity() {
    }

    public ProtocolEntity(IBProtocolResponse response) {
        this.response = response;
    }

    public ProtocolEntity(IPackRequest request, IBProtocolResponse response) {
        this.request = request;
        this.response = response;
    }

    public IPackRequest getRequest() {
        return request;
    }

    public void setRequest(IPackRequest request) {
        this.request = request;
    }

    public IBProtocolResponse getResponse() {
        return response;
    }

    public void setResponse(IBProtocolResponse response) {
        this.response = response;
    }

    /**
     * @description: 创建超过最大时间 即可过期处理
     * @date: 2024-08-16 14:08:29
     **/
    public boolean expire(int max) {
        return System.currentTimeMillis() - this.start > max;
    }
}
