package com.jhscale.meter.protocol.model;

import com.jhscale.common.model.device.barcode_format.DBarcodeFormat;
import com.jhscale.meter.protocol.constant.TMS;

public class BarCodeItemSearch {

    private BarCodeItemSearch() {
    }

    public static byte BarcodeF_CheckSum_EAN_UPC(byte[] Local_Data, int FixLength) {
        int EUC_Reversed = GlobalPara.getInstance().getTMS(TMS.SP_Barcode_EUC_Reversed);
        int Loop;
        int Check;
        int Temp;

        if (EUC_Reversed >= 2)
            return '0';

        FixLength--;
        for (Loop = 0, Check = 0; Loop < FixLength; Loop++) {
            Temp = Local_Data[Loop] - 0x30;
            Check = (Check + Temp * (1 + 2 * ((FixLength - Loop + EUC_Reversed) & 0x01))) % 10;
        }

        return (byte) ((10 - Check) % 10 + 0x30);
    }

    public static BarCodeItemResult Calulate(String input) {
        int SpecSort;
        for (SpecSort = 0; SpecSort < 4; SpecSort++) {
            int barNo = GlobalPara.getInstance().getTMS(TMS.Scanner_Note_1_Bar + 2 * SpecSort);
            int barFlag = GlobalPara.getInstance().getTMS(TMS.Scanner_Note_1_Flag + 2 * SpecSort);
            if ((barNo == 0) && (SpecSort == 0)) {
                barNo = GlobalPara.getInstance().getTMS(TMS.Print_Item1_Barcode);
                barFlag = GlobalPara.getInstance().getTMS(TMS.Print_Item1_Barcode_Flag);
            }
            BarCodeItemResult result = Calulate(input, barNo, barFlag);
            if (result != null)
                return result;
        }
        return null;
    }

    public static BarCodeItemResult Calulate(String input, int barNo, int barFlag) {
        if (input == null)
            return null;
        if (barNo == 0)
            return null;
        DBarcodeFormat barFormat = GlobalPara.getInstance().GetBarcode(barNo);
        if (barFormat == null)
            return null;
        int index_Pos = 0;
        int index_Lng = input.length();
        byte[] index = input.getBytes();
        byte[] barBytes = barFormat.getDis().getBytes();
        int loop = 0;            //ngff: V2.38A
        Integer number = null;
        Integer itemcode = null;
        Integer amount = null;
        Integer price = null;
        if (barBytes.length == 24) {
            for (; loop < 6; loop++) {
                int GetNumber;
                int GetLng;
                int GetLngMax;
                if (barBytes[loop * 4 + 1] < index_Lng)
                    break;
                GetLngMax = barBytes[loop * 4 + 1] - 0x30;
                if (GetLngMax > 9)
                    break;
                for (GetLng = GetNumber = 0; GetLng < GetLngMax; GetLng++) {
                    GetNumber = GetNumber * 10 + (index[index_Pos] - 0x30);
                    index_Pos++;
                    index_Lng--;
                }
                int dl = barBytes[loop * 4 + 2] - 0x30;
                if ((dl > 0) && (dl <= 9)) {
                    while (dl > 0) {
                        dl--;
                        GetNumber *= 10;
                    }
                }

                if (barBytes[loop * 4 + 0] == 'A' + 1) {
                    if (GetNumber != barFlag)
                        break;
                } else if (barBytes[loop * 4 + 0] == 'A' + 2) {
                    if (GetNumber != barFormat.getnConst1())
                        break;
                } else if (barBytes[loop * 4 + 0] == 'A' + 3) {
                    if (GetNumber != barFormat.getnConst2())
                        break;
                } else if (barBytes[loop * 4 + 0] == 'A' + 4) {
                    number = GetNumber;
                } else if (barBytes[loop * 4 + 0] == 'A' + 5) {
                    itemcode = GetNumber;
                } else if (barBytes[loop * 4 + 0] == 'A' + 9) {
                    amount = GetNumber;
                } else if ((barBytes[loop * 4 + 0] == 'A' + 10) ||
                        (barBytes[loop * 4 + 0] == 'A' + 11)) {
                    price = GetNumber;
                } else if (barBytes[loop * 4 + 0] == 'A' + 0) {
                    ;
                } else {
                    break;            //ngff: V2.38A
                }
            }
        }
        if (loop >= 6) {
            int Check = GlobalPara.getInstance().getTMS(TMS.Scanner_EANCheck);
            if (Check >= 1) {
                if (index_Lng == 0)
                    return new BarCodeItemResult();
                byte a = BarcodeF_CheckSum_EAN_UPC(index, index_Pos + 1);
                if (a != index[index_Pos])
                    return new BarCodeItemResult();
            }
            if (Check >= 2) {
                if (index_Lng != 1)
                    return new BarCodeItemResult();
            }
            if (((number != null) || (itemcode != null)) && ((amount != null) || (price != null))) {
                return new BarCodeItemResult(number, itemcode, amount, price);
            } else
                return null;
        } else
            return null;
    }

}
