package com.jhscale.meter.protocol.model;

import com.jhscale.common.model.device.plu.module.DTimeV2;
import com.jhscale.common.model.inter.GJSONModel;
import com.jhscale.meter.protocol.constant.TMS;
import io.swagger.annotations.ApiModel;

import java.util.Calendar;
import java.util.Date;

/**
 * @author lie_w
 * @title: CalPLU_ShelfDate
 * @projectName meter-jar
 * @description: TODO
 * @date 2022/9/2112:49
 */
@ApiModel("有效期信息")
public class CalPLU_ShelfDate implements GJSONModel {

    private boolean Printable = false;
    private boolean byHour = false;
    private Integer InType;
    private Integer directValue = 0;
    private Calendar calendar = Calendar.getInstance();

    public CalPLU_ShelfDate() {
    }

    public CalPLU_ShelfDate(int days, Date tradeTime) {
        InType = GlobalPara.getInstance().getTMS(TMS.Arith_SpecShelfDay_Type);
        // DTimeV2 dTime = itemC.getPlu().time(GlobalPara.getInstance().getDeviceLevel());
        if (InType == 3) {
            Printable = false;
            return;
        }
        calendar.add(Calendar.HOUR_OF_DAY, days);
        Printable = true;
    }

    public CalPLU_ShelfDate(ItemContent itemC, Date tradeTime) {
        InType = GlobalPara.getInstance().getTMS(TMS.Arith_SpecShelfDay_Type);
        // DTimeV2 dTime = itemC.getPlu().time(GlobalPara.getInstance().getDeviceLevel());
        DTimeV2 dTime = itemC.getPlu().getTime();
        if (InType == 3) {
            Printable = false;
            return;
        }
        if ((InType < 0) || (InType > 6))
            InType = 0;
        calendar.setTime(tradeTime);
        if ((InType == 2)
                || (InType == 6)
                || ((dTime.useDatePS() == 0) && ((InType == 1) || (InType == 5)))
                ) {
            directValue = GlobalPara.getInstance().getTMS(TMS.Arith_SpecShelfDay_Days);
            calendar.add(Calendar.DAY_OF_MONTH, directValue);
        } else if (dTime.useDatePS() == 1) {
            directValue = dTime.useDatePC();
            calendar.add(Calendar.DAY_OF_MONTH, dTime.useDatePC());
        } else if (dTime.useDatePS() == 2) {
            directValue = dTime.useDatePC();
            calendar.add(Calendar.HOUR_OF_DAY, dTime.useDatePC());
            byHour = true;
        } else {
            Printable = false;
            return;
        }

        Printable = true;
    }

    /*************************************************** 属性 get set *******************************************************************/

    public boolean isPrintable() {
        return Printable;
    }

    public void setPrintable(boolean printable) {
        Printable = printable;
    }

    public boolean isByHour() {
        return byHour;
    }

    public void setByHour(boolean byHour) {
        this.byHour = byHour;
    }

    public Integer getInType() {
        return InType;
    }

    public void setInType(Integer inType) {
        InType = inType;
    }

    public Integer getDirectValue() {
        return directValue;
    }

    public void setDirectValue(Integer directValue) {
        this.directValue = directValue;
    }

    public Calendar getCalendar() {
        return calendar;
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
    }

    /*************************************************** 属性 get set *******************************************************************/
}
