package com.jhscale.meter.protocol.model;

import com.jhscale.common.em.DeviceType;
import com.jhscale.common.model.device.barcode_format.DBarcodeFormat;
import com.jhscale.common.model.device.barcode_format.DBarcodeFormatV1;
import com.jhscale.common.model.device.category.DCategory;
import com.jhscale.common.model.device.data_parameter.DDataParameter;
import com.jhscale.common.model.device.info.DDeviceInfo;
import com.jhscale.common.model.device.info.DDeviceInfoV1;
import com.jhscale.common.model.device.info.DMAC;
import com.jhscale.common.model.device.info.DServerInfo;
import com.jhscale.common.model.device.info.inner.DDeviceInfo_INA;
import com.jhscale.common.model.device.info.inner.DDeviceInfo_INF;
import com.jhscale.common.model.device.info.inner.DDeviceInfo_INI;
import com.jhscale.common.model.device.info.inner.DDeviceInfo_INM;
import com.jhscale.common.model.device.label_format.DLabelFormat;
import com.jhscale.common.model.device.other.DSpDWL;
import com.jhscale.common.model.device.other.DSpDWLV1;
import com.jhscale.common.model.device.saleman.DSaleMan;
import com.jhscale.common.model.device.text_parameter.DTextParameter;
import com.jhscale.common.model.inter.DataJSONModel;
import com.jhscale.common.model.inter.GJSONModel;
import com.jhscale.common.model.license.RSAEncryptDecrypt;
import com.jhscale.common.utils.DDataExecute;
import com.jhscale.common.utils.DDataUtils;
import com.jhscale.common.utils.DateUtils;
import com.jhscale.common.utils.FileUtils;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.mqtt.em.Encoding;
import com.jhscale.meter.protocol.constant.TMS;
import com.jhscale.meter.protocol.constant.TMT;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import static com.jhscale.common.model.device.DConstant.PUBLIC_FIELD_SPLIT;
import static com.jhscale.meter.protocol.constant.TMS.*;
import static com.jhscale.meter.protocol.constant.TMT.*;
import static com.jhscale.meter.utils.AConstant.POS_VERSION;
import static com.jhscale.meter.utils.AConstant.WIFI_LAN;

/**
 * @author lie_w
 * @title: PrintContent
 * @projectName hardware-core
 * @description: TODO
 * @date 2022/8/820:06
 */
@ApiModel("全局参数")
public class GlobalPara implements GJSONModel, DDataExecute {

//    统一使用 枚举 TradeType
//    public static final int TradeType_Sale = 0;    //	        put("TradeType-0", "销售");
//    public static final int TradeType_Rejected = 1;    //	        put("TradeType-1", "退货");
//    public static final int TradeType_Unconfirmed = 2;    //	        put("TradeType-2", "未确认");
//    public static final int TradeType_Cancelled = 3;    //	        put("TradeType-3", "清除");
//    public static final int TradeType_Hangup = 4;    //	        put("TradeType-4", "挂单");
//    public static final int TradeType_AutoMode= 5;    //	        put("TradeType-5", "自动模式");
//    public static final int TradeType_Inbound = 10;    //	        put("TradeType-10", "入库");
//    public static final int TradeType_Outbound = 11;    //	        put("TradeType-11", "出库");
//    public static final int TradeType_Stocktaking = 12;    //	        put("TradeType-12", "盘库");
//    public static final int TradeType_Order = 13;    //	        put("TradeType-13", "订货");
//    public static final int TradeType_Spoilage = 14;    //	        put("TradeType-14", "折损");
//    public static final int TradeType_Error = 255;    //	        put("TradeType-255", "错误日志");

//    @ApiModelProperty(value = "POS参数表", name = "tmt")
//    private Map<String, String> posPara = new HashMap<Integer, String>();
//    @ApiModelProperty(value = "店铺名称", name = "storeName")
//    private String storeName = "上海精函信息科技有限公司";
//    @ApiModelProperty(value = "设备名称", name = "deviceName")
//    private String deviceName = "出厂机";
//    @ApiModelProperty(value = "设备编号", name = "deviceNumber")
//    private int deviceNumber = 0;
//    @ApiModelProperty(value = "系统重量单位", name = "weightUNIT")              //需和称重模块同步, 可设，同Spec212概念
//    private int weightUNIT = 3;
//    @ApiModelProperty(value = "系统单价单位", name = "priceUNIT")              //可设，同Spec211
//    private int priceUNIT = 3;
//    @ApiModelProperty(value = "重量精度", name = "weightPrecision")              //Spec213： Range：0-6
//    private int weightPrecision = 0;
//    @ApiModelProperty(value = "重量零点判定", name = "weightZeroJudge")              //Spec223： Range：0-199
//    private int weightZeroJudge = 6;
//    @ApiModelProperty(value = "去皮有效规则", name = "tareRule")
//    private int tareRule = 0;                                   //Spec68: Range 0-3
//    @ApiModelProperty(value = "零价销售", name = "zeroSale")
//    private int zeroSale = 0;                                   //Spec70: Range 0-1
//    @ApiModelProperty(value = "商品服务费类型", name = "serviceFee_ItemType")
//    private int serviceFee_ItemType = 0;                                   //Spec301
//    @ApiModelProperty(value = "总服务费类型", name = "serviceFee_TotalType")
//    private int serviceFee_TotalType = 0;                                   //Spec302
//    @ApiModelProperty(value = "总服务费额度", name = "serviceFee_TotalRate")
//    private BigDecimal serviceFee_TotalRate = BigDecimal.ZERO;                  //Spec303
//    @ApiModelProperty(value = "总服务费比例基准", name = "serviceFeeRate_PerBase")
//    private int serviceFeeRate_PerBase = 0;                                //Spec304
//    @ApiModelProperty(value = "全局服务费税种", name = "taxType")
//    private int serviceFeeRate_TaxType = 0;                                 //Spec305: Range: 0-3: 0: No Default, 1: Default is exclude Tax with Excluded Rate, 2: Default is include Tax with Excluded Rate, 3: Defaultx with included Rate.
//    @ApiModelProperty(value = "全局服务费税率", name = "taxRate")
//    private int serviceFeeRate_TaxRate = 0;                                   //Spec306: Range: 0-9999. 100=1%
//    @ApiModelProperty(value = "重量小数位", name = "pointOfWeight")          //Spec201: Range: 0-7
//    private int pointOfWeight = 3;
//    @ApiModelProperty(value = "单价小数位", name = "pointOfPrice")          //Spec202: Range: 0-7
//    private int pointOfPrice = 2;
//    @ApiModelProperty(value = "合计小数位", name = "pointOfMoney")          //Spec203: Range: 0-7
//    private int pointOfMoney = 2;
//    @ApiModelProperty(value = "自动折扣跟踪", name = "discountAuto_PriceTrack")          //Spec115: Range: 0-3
//    private int discountAuto_PriceTrack = 1;
//    @ApiModelProperty(value = "自动折扣区间有效性", name = "discountAuto_InTime")          //Based From Spec318/319
//    private boolean discountAuto_InTime = true;
//    @ApiModelProperty(value = "全局非会员折扣", name = "discountAlways_p1")          //Spec287: Range: 0-99. 5 means -5%
//    private int discountAlways_p1 = 0;
//    @ApiModelProperty(value = "条码EAN验证码模式", name = "barcode_EUC")    //Spec139, Range:0-2, do not need set. keep default is ok
//    private int barcode_EUC = 0;
//    @ApiModelProperty(value = "全局商品税种", name = "taxType")
//    private int taxType = 0;    //Spec116: Range: 0-3: 0: No Default, 1: Default is exclude Tax with Excluded Rate, 2: Default is include Tax with Excluded Rate, 3: Defaultx with included Rate.
//    @ApiModelProperty(value = "全局商品税率", name = "taxRate")                 //Spec117: Range: 0-9999. 100=1%
//    private BigDecimal taxRate = BigDecimal.ZERO;
//    @ApiModelProperty(value = "单价舍入方式", name = "roundingOfSingle")          //Spec100
//    private int roundingOfSingle = 0;
//    @ApiModelProperty(value = "合计舍入方式", name = "roundingOfTotal")         //Spec101
//    private int roundingOfTotal = 0;
//    @ApiModelProperty(value = "金额前缀", name = "moneyPrefix")
//    private String moneyPrefix = "￥";
//    @ApiModelProperty(value = "金额后缀", name = "moneySuffix")
//    private String moneySuffix = "";
//    @ApiModelProperty(value = "打印数重量时附带单位", name = "printUnitWAmount")          //Spec185
//    private boolean printUnitWAmount = false;
//    @ApiModelProperty(value = "打印单价时附带单位", name = "printUnitWPrice")              //Spec186
//    private boolean printUnitWPrice = false;
//    @ApiModelProperty(value = "打印金额时附带单位", name = "printUnitWTotal")            //Spec187
//    private boolean printUnitWTotal = false;
//    @ApiModelProperty(value = "条码中金额的小数位", name = "pointOfBarcodeMoney")        //Spec209
//    private int pointOfBarcodeMoney = 2;
//    @ApiModelProperty(value = "条码中重量的小数位", name = "pointOfBarcodeWeight")      //Spec208
//    private int pointOfBarcodeWeight = 3;
//    @ApiModelProperty(value = "条码中数量的小数位", name = "pointOfBarcodePcs")      //Spec196
//    private int pointOfBarcodePcs = 3;
//    @ApiModelProperty(value = "使用日期打印", name = "specShelfDay_Type")         //Spec143, Range:0-29
//    private int spec_FSID_LLng = 6;
//    @ApiModelProperty(value = "使用日期打印", name = "specShelfDay_Type")         //Spec105, Range:0-6
//    private int spec_ShelfDay_Type = 0;
//    @ApiModelProperty(value = "使用日期期限", name = "specShelfDay_Days")         //Spec106, Range:0-9999
//    private int spec_ShelfDay_Days = 0;
//    @ApiModelProperty(value = "票据文本1", name = "receiptText1")         //全局文本4
//    private String receiptText1 = "";
//    @ApiModelProperty(value = "票据文本2", name = "receiptText2")         //全局文本5
//    private String receiptText2 = "";
//    @ApiModelProperty(value = "票据文本3", name = "receiptText3")         //全局文本6
//    private String receiptText3 = "";
//    @ApiModelProperty(value = "票据文本4", name = "receiptText4")         //全局文本7
//    private String receiptText4 = "";
//    @ApiModelProperty(value = "票据文本5", name = "receiptText5")         //全局文本8
//    private String receiptText5 = "谢谢惠顾,欢迎再次光临!";
//    @ApiModelProperty(value = "票据文本6", name = "receiptText6")         //全局文本9
//    private String receiptText6 = "";
//    @ApiModelProperty(value = "票据文本7", name = "receiptText7")         //全局文本10
//    private String receiptText7 = "";
//    @ApiModelProperty(value = "票据文本8", name = "receiptText8")         //全局文本11
//    private String receiptText8 = "";
//    Keep all spText1 reserved
//    @ApiModelProperty(value = "保留文本1", name = "spText1")         //全局文本12
//    private String spText1;
//    @ApiModelProperty(value = "保留文本2", name = "spText2")         //全局文本13
//    private String spText2;
//    @ApiModelProperty(value = "保留文本3", name = "spText3")         //全局文本14
//    private String spText3;
//    @ApiModelProperty(value = "保留文本4", name = "spText4")         //全局文本15
//    private String spText4;
//    @ApiModelProperty(value = "保留文本5", name = "spText5")         //全局文本16
//    private String spText5;
//    @ApiModelProperty(value = "保留文本6", name = "spText6")         //全局文本17
//    private String spText6;
//    @ApiModelProperty(value = "保留文本7", name = "spText7")         //全局文本18
//    private String spText7;
//    @ApiModelProperty(value = "保留文本8", name = "spText8")         //全局文本19
//    private String spText8;

    private boolean isPrivilege = false;

    public boolean isPrivilege() {
        return isPrivilege;
    }

    public void setPrivilege(boolean privilege) {
        isPrivilege = privilege;
    }

    final private int weightUnit_Size = 10;
    private boolean[] weightUNIT_Allowed = new boolean[]{false, false, false, true, true, false, true, false, false, false};
    private boolean[][] moneyUnit_Allowed = new boolean[][]
            {
                    {false, false, false, false, false, false, false, false, false, false,},            // DatabaseC_Unit_Input				0
                    {false, false, false, false, false, false, false, false, false, false,},            // DatabaseC_Unit_Wdefault			1
                    {false, false, false, false, false, false, false, false, false, false,},            // DatabaseC_Unit_pcs				2
                    {false, false, false, true, false, false, false, true, true, false,},               // DatabaseC_Unit_kg					3
                    {false, false, false, false, true, false, false, true, true, false,},               // DatabaseC_Unit_g					4
                    {false, false, false, false, false, true, false, false, false, false,},             // DatabaseC_Unit_ton				5
                    {false, false, false, false, false, false, true, false, false, true,},              // DatabaseC_Unit_lb					6
                    {false, false, false, false, false, false, false, false, false, false,},            // DatabaseC_Unit_500g				7
                    {false, false, false, false, false, false, false, false, false, false,},            // DatabaseC_Unit_100g				8
                    {false, false, false, false, false, false, false, false, false, false,},            // DatabaseC_Unit_1_4lb				9
            };
    private static final String[] ecsCal_PrintMonth_1 = new String[]{"", "JA", "FE", "MR", "AL", "MA", "JN", "JL", "AU", "SE", "OC", "NO", "DE"};
    private static final int[][] ecsCal_PrintPersianOffset = new int[][]
            {
                    {1378, -286},
                    {1407, 10306},
                    {1440, 22359},
                    {1477, 35873},
                    {1506, 46465},
            };

    /**
     * @description: 数据参数类型 3 转义 整数转小数
     **/
    public static BigDecimal ecsCal_getNumS32(int value) {
        return new BigDecimal(value >> 3).movePointLeft(value & 0x07);
    }

    /**
     * @description: 数据参数类型 3 转义 小数转整数
     **/
    public static int ecsCal_setNumS32(BigDecimal value) {
        BigInteger a = value.unscaledValue();
        int b = value.scale();
        while ((b > 7) || (a.compareTo(BigInteger.valueOf(268435455)) > 0) || (a.compareTo(BigInteger.valueOf(-268435455)) < 0)) {
            if (b <= 0) {
                a = BigInteger.valueOf(268435455);
                b = 0;
                break;
            }
            b--;
            a = a.divide(BigInteger.TEN);
        }
        int c = a.intValue();
        return (c << 3) | b;
    }

    @ApiModelProperty(value = "条码格式缓冲区", name = "systemBarcode")
    private Map<Integer, DBarcodeFormat> systemBarcode;
    @ApiModelProperty(value = "条码格式系统编号", name = "systemBarcodeNo")
    private int systemBarcodeNo = 0;

    @ApiModelProperty(value = "打印格式缓冲区", name = "systemLabel")
    private Map<Integer, DLabelFormat> systemLabel;
    @ApiModelProperty(value = "打印格式系统编号", name = "systemLabelNo")
    private int systemLabelNo = 0;

    @ApiModelProperty(value = "组别格式缓冲区", name = "systemCategory")
    private Map<Integer, DCategory> systemCategory;

    // @ApiModelProperty(value = "特殊量程定义", name = "sp_WeightSN")
    // private List<WeightSN> sp_WeightSN = new ArrayList<>();

    @ApiModelProperty(value = "特殊量程定义", name = "sp_WeightMN")
    private Map<String, WeightMN> sp_WeightMN = new HashMap<>();

    private String title_WeightMN(BigDecimal kgCap, int spec213, int unitWeight) {
        return kgCap.stripTrailingZeros().toPlainString() + "_" + Integer.toString(spec213) + "_" + Integer.toString(unitWeight);
    }

    public WeightMN get_WeightMN(BigDecimal kgCap, int spec213, int unitWeight) {
        return sp_WeightMN.get(title_WeightMN(kgCap, spec213, unitWeight));
    }

    // 循环启动器
    private Timer timer;

    private Map<String, GlobalParaRefresh> globalParaRefreshMap = new HashMap<>();

    /**
     * @description: 添加执行器
     **/
    public void addRefresh(GlobalParaRefresh refresh) {
        this.globalParaRefreshMap.put(refresh.getClass().getSimpleName(), refresh);
    }

    /**
     * @description: 全局参数刷新
     **/
    public interface GlobalParaRefresh {
        /**
         * @description: 检查id 是否存在此刷新器中
         **/
        int[] refreshIds();

        /**
         * @description: 执行内容
         **/
        void refreshAction(int no, int value);
    }

    private GlobalPara() {
        this.systemBarcode = new HashMap<>();
        this.systemLabel = new HashMap<>();
        this.systemCategory = new HashMap<>();
        this.tms_Update = new ConcurrentHashMap<>();

        this.timer = new Timer();
        this.timer.schedule(new TimerTask() {
            @Override
            public void run() {
                // if (GlobalPara.getInstance().isRunLog())
                //     System.out.println("GlobalPara Check...");
                if (tms_Update != null && !tms_Update.isEmpty()) {
                    Iterator<Integer> iterator = tms_Update.keySet().iterator();
                    while (iterator.hasNext()) {
                        Integer no = iterator.next();
                        Integer value = tms_Update.remove(no);
                        if (GlobalPara.getInstance().isRunLog())
                            System.out.printf("GlobalPara tms_Update %s ~~ %s%n", no, value);

                        for (GlobalParaRefresh globalParaRefresh : globalParaRefreshMap.values()) {
                            int[] ids = globalParaRefresh.refreshIds();
                            if (ids != null && ids.length > 0 && Arrays.binarySearch(ids, no) >= 0) {
                                globalParaRefresh.refreshAction(no, value);
                            }
                        }

                        // switch (no) {
                        //     case Print_Gray_GapPaper:
                        //     case Print_Gray_GenericPaper:
                        //     case HW_Print_IgnorePBS:
                        //     case HW_Print_Ignore_P2:
                        //     case HW_ConPaper_vPPS:
                        //         PrintGeneralFactory.getInstance().print_set(no);
                        //         break;
                        //     case Ethernet_CustomProtocol:
                        //         SocketCommunication.getInstance().Init_CMPT();
                        //         break;
                        // }
                    }
                }
            }
        }, 5, 1000);
        DDataUtils.setDataExecute(this);
    }

    public GlobalPara close() {
        if (this.timer != null) this.timer.cancel();
        return this;
    }

    private static class SingleGlobalPara {
        private static final GlobalPara SINGLETON = new GlobalPara();
    }

    /**
     * @description: 全局参数作为单例
     **/
    public static GlobalPara getInstance() {
        return SingleGlobalPara.SINGLETON;
    }

    @ApiModelProperty(value = "本机系统ID", name = "systemID")
    private String systemID = "123456";
    @ApiModelProperty(value = "设备类型", name = "deviceType")
    private int deviceType = DeviceType.Android_Scales.getItype();
    @ApiModelProperty(value = "设备等级", name = "deviceLevel")
    private int deviceLevel = 0;

    @ApiModelProperty(value = "日期格式", name = "dateFormat")
    private String dateFormat = null;               //Keep this null for let Spec to Cal
    @ApiModelProperty(value = "时间格式", name = "timeFormat")
    private String timeFormat = null;               //Keep this null for let Spec to Cal

    // AI触发条件
    @ApiModelProperty(value = "AI触发重量分度（0代表根据最小称量，其他数值为指定值）", name = "aiWeightValid")
    private BigDecimal aiWeightValid = BigDecimal.ZERO;
    @ApiModelProperty(value = "AI触发重量次数", name = "aiWeightValidCount")
    private int aiWeightValidCount = 3;
    @ApiModelProperty(value = "AI退出重量分度（0代表根据最小称量，其他数值为指定值）", name = "aiWeightQuit")
    private BigDecimal aiWeightQuit = BigDecimal.ZERO;

    @ApiModelProperty(value = "语言文本", name = "langText")
    private Map<String, String> langText = new HashMap<String, String>() {{
        put("Days", "天");
        put("Hours", "小时");
        put("pcs", "pcs");
        put("kg", "kg");
        put("g", "g");
        put("ton", "ton");
        put("lb", "lb");
        put("500g", "斤");
        put("100g", "100g");
        put("lb/4", "lb/4");
        // put("Sale", "销售");
        // put("Rejected", "退货");
        // put("Unconfirmed", "未确认");
        // put("Cancelled", "清除");
        // put("Hangup", "挂单");
        // put("Auto Mode", "自动模式");
        // put("Inbound", "入库");
        // put("Outbound", "出库");
        // put("Stocktaking", "盘库");
        // put("Order", "订货");
        // put("Spoilage", "折损");
        put("TradeType-0", "销售");
        put("TradeType-1", "退货");
        put("TradeType-2", "未确认");
        put("TradeType-3", "清除");
        put("TradeType-4", "挂单");
        put("TradeType-5", "自动模式");
        put("TradeType-10", "入库");
        put("TradeType-11", "出库");
        put("TradeType-12", "盘库");
        put("TradeType-13", "订货");
        put("TradeType-14", "折损");
        put("TradeType-255", "错误日志");
        put("TradeType-266", "采购入库");
        put("TradeType-267", "采购出库");
        put("TradeType-522", "领用入库");
        put("TradeType-523", "领用出库");
        put("TradeType-778", "调拨入库");
        put("TradeType-779", "调拨出库");
    }};

    // @ApiModelProperty(value = "lang_Days", name = "lang_Days")         //Spec105, Range:0-6
    // private String lang_Days = "天";
    // @ApiModelProperty(value = "lang_Hours", name = "lang_Hours")
    // private String lang_Hours = "小时";
    // @ApiModelProperty(value = "lang_pcs", name = "lang_pcs")
    // private String lang_pcs = "pcs";
    // @ApiModelProperty(value = "lang_kg", name = "lang_kg")
    // private String lang_kg = "kg";
    // @ApiModelProperty(value = "lang_g", name = "lang_g")
    // private String lang_g = "g";
    // @ApiModelProperty(value = "lang_ton", name = "lang_ton")
    // private String lang_ton = "ton";
    // @ApiModelProperty(value = "lang_lb", name = "lang_lb")
    // private String lang_lb = "lb";
    // @ApiModelProperty(value = "lang_500g", name = "lang_500g")
    // private String lang_500g = "500g";
    // @ApiModelProperty(value = "lang_100g", name = "lang_100g")
    // private String lang_100g = "100g";
    // @ApiModelProperty(value = "lang_lb_4", name = "lang_lb_4")
    // private String lang_lb_4 = "lb/4";


    @ApiModelProperty(value = "TM数据参数表", name = "tms")
    private Map<Integer, Integer> tms = new HashMap<>();
    private Map<Integer, Integer> tms_Max = new HashMap<>();
    private Map<Integer, Integer> tms_Access = new HashMap<>();
    private Map<Integer, Integer> tms_Update;
    private Map<String, Integer> tms_SpDWL = new HashMap<>();
    private Integer tms_SpFNT = 23;

    @ApiModelProperty(value = "营养表（SPP）参数", name = "sds")
    private Map<String, Map<Integer, DSpDWL>> sds = new HashMap<>();
    @ApiModelProperty(value = "默认营养表（SPP）参数", name = "df_sds")
    private Map<String, Map<Integer, DSpDWL>> df_sds = new HashMap<>();

    @ApiModelProperty(value = "TM文本参数表", name = "tmt")
    private Map<Integer, String> tmt = new HashMap<>();

    // @ApiModelProperty(value = "特殊版本标识", name = "spVersion")
    // private Integer spVersion = 0;

    // @ApiModelProperty(value = "特殊协议前缀", name = "spContentSegs")
    // private List<String> spContentSegs = new ArrayList<>();

    // @ApiModelProperty(value = "特殊协议存储", name = "spContentBuf")
    // private Map<String, Map<Integer, String>> spContentBuf = new HashMap<String, Map<Integer, String>>();

    @ApiModelProperty(value = "营业员信息", name = "saleMan")
    private DSaleMan saleMan;

    @ApiModelProperty(value = "网络状态 1-无线网 2-有线网", name = "lan")
    private Integer lan;

    // 加解密对象信息
    private RSAEncryptDecrypt encryptDecrypt;

    // 运行日志
    private boolean runLog;

    // 程序字符集
    private Charset program_encoding = Encoding.UTF_8.getCharset();

    // 打印机字库字符集
    private Charset word_encoding = Encoding.UTF_8.getCharset();

    // 登陆服务器返回信息
    private DServerInfo serverInfo;

    // AI版本信息
    private String ai_version;

    // DB存储
    private MeterDBService service;

    // 文件夹目录
    private String logDir;
    private boolean writeLog;
    private File logFile;

    public String db_find(String key) {
        return this.service != null && StringUtils.isNotBlank(key) ? this.service.find(key) : null;
    }

    public boolean db_insert(String key, String value) {
        if (Objects.nonNull(this.service)) {
            return this.service.insert(key, value);
        }
        return false;
    }

    public boolean db_delete(String key) {
        return this.service != null && StringUtils.isNotBlank(key) && this.service.delete(key);
    }

    /**
     * @description: 添加AI版本信息
     **/
    public GlobalPara set_ai_version(String ai_version) {
        this.ai_version = ai_version;
        return this;
    }

    public String getAi_version() {
        return StringUtils.isNotBlank(this.ai_version) ? this.ai_version : "";
    }

    /**
     * @description: 获取AI版本信息
     **/
    public String getAi_version_overall() {
        if (StringUtils.isNotBlank(this.getAi_version())) {
            return String.format("%s.%s.%s", this.getAi_version(), this.getTMS(AI_Fun, AI_Unable), this.getTMS(Server_AI_Function, AI_Unable));
        }
        return "";
    }

    /**
     * @param logDir   日志文件目录
     * @param writeLog 是否写入文件
     * @description: 初始化日志文件
     * @date: 2024-11-19 16:41:54
     **/
    public GlobalPara Init_Log_Dir(String logDir, boolean writeLog) {
        this.logDir = logDir;
        this.writeLog = writeLog;
        return this;
    }

    /**
     * @param title   文件标题
     * @param content 文件内容
     * @description: 写日志文件
     * @date: 2024-11-19 16:42:38
     **/
    public boolean Write_Log(String title, String content) {
        if (this.writeLog) {
            try {
                if (StringUtils.isNotBlank(this.logDir)) {
                    if (this.logFile == null) {
                        File file = new File(this.logDir);
                        if (!file.exists()) file.mkdirs();
                        File logFile = new File(file, String.format("%s.txt", DateUtils.getNowDayVal()));
                        if (!logFile.exists()) logFile.createNewFile();
                        String text = String.format("%s\t%s\t%s\n", DateUtils.getDate_YYYY_MM_DD_HH_MM_SS(new Date()), title, content);
                        executor.execute(() -> {
                            FileUtils.writer(text, logFile, true);
                        });
                        return true;
                    }
                }
            } catch (Exception e) {
                System.err.printf("Meter.jar 写日志文件错误：%s %n", e.getMessage());
            }
        }
        return false;
    }

    /**
     * @description: 铅封检查
     * @date: 2024-11-19 17:49:55
     */
    public boolean Lead_Check() {
        return this.getTMS(LEAD_CHECK, LEAD_CHECK_ENABLE) == LEAD_CHECK_ENABLE;
    }

    // 异步线程池
    private final ExecutorService executor = Executors.newFixedThreadPool(10);

    /**
     * @description: 初始化加密工具
     **/
    public GlobalPara Init_Encrypt_Decrypt(RSAEncryptDecrypt encryptDecrypt) {
        this.encryptDecrypt = encryptDecrypt;
        return this;
    }

    /**
     * @description: 初始化版本信息
     **/
    public GlobalPara Init_Encoding(Charset program_encoding, Charset word_encoding) {
        this.program_encoding = program_encoding;
        this.word_encoding = word_encoding;
        return this;
    }

    public GlobalPara Init_DB(MeterDBService service) {
        this.service = service;
        return this;
    }

    public RSAEncryptDecrypt getEncryptDecrypt() {
        return encryptDecrypt;
    }

    public Integer lan() {
        return Objects.nonNull(this.lan) ? this.lan : WIFI_LAN;
    }

    public String POS_Version() {
        return this.serverInfo != null && Objects.nonNull(this.serverInfo.getDevice()) && StringUtils.isNotBlank(this.serverInfo.getDevice().getVersion())
                ? this.serverInfo.getDevice().getVersion() : POS_VERSION;
    }

    public String Pos_TMSVersion() {
        String[] tms = POS_Version().split(" ");
        if (tms.length >= 2)
            return tms[1];
        return "";
    }

    public Integer getLan() {
        return lan;
    }

    public GlobalPara setLan(Integer lan) {
        this.lan = lan;
        return this;
    }

    public boolean isRunLog() {
        return runLog;
    }

    public GlobalPara setRunLog(boolean runLog) {
        this.runLog = runLog;
        return this;
    }

    public Charset getProgram_encoding() {
        return Objects.nonNull(this.program_encoding) ? this.program_encoding : Encoding.UTF_8.getCharset();
    }

    public GlobalPara setProgram_encoding(Charset program_encoding) {
        this.program_encoding = program_encoding;
        return this;
    }

    public Charset getWord_encoding() {
        return Objects.nonNull(this.word_encoding) ? this.word_encoding : Encoding.UTF_8.getCharset();
    }

    public GlobalPara setWord_encoding(Charset word_encoding) {
        this.word_encoding = word_encoding;
        return this;
    }

    public DServerInfo getServerInfo() {
        return serverInfo;
    }

    public GlobalPara setServerInfo(DServerInfo serverInfo) {
        this.serverInfo = serverInfo;
        return this;
    }

    /**
     * @description: 获取异步线程
     **/
    public ExecutorService executor() {
        return this.executor;
    }

    /**
     * @description: 设备信息
     **/
    public DDeviceInfo deviceInfo() {
        DDeviceInfo deviceInfo = new DDeviceInfoV1<>()
                .setIna(new DDeviceInfo_INA()
                        .setEncoding(this.getProgram_encoding().toString())
                        .setWord_encoding(this.getWord_encoding().toString())
                        .setRom(1)
                        .setWord_rom(0)
                        .setF1(0)
                        .setF2(0)
                        .setF3(0))
                .setInm(new DDeviceInfo_INM()
                        .setSign(this.getSystemID())
                        .setUnique_sign(this.getSystemID())
                        .setLan(this.lan()))
                .setInf(new DDeviceInfo_INF()
                        .setStore_name(this.getStoreName())
                        .setDevice_name(this.getDeviceName())
                        .setDevice_serial(this.getTMS(Device_No))
                        .setDevice_version(this.POS_Version()))
                .setIni(new DDeviceInfo_INI()
                        .setAi_open(this.getTMS(AI_Fun, AI_Unable))
                        .setAi_server_open(this.getTMS(Server_AI_Function, AI_Unable))
                        .setAiVersion(this.getAi_version()));
        return deviceInfo;
    }

    /**
     * @description: 设备MAC
     **/
    public DMAC deviceMac() {
        DMAC mac = new DMAC()
                .setMac(this.getSystemID());
        return mac;
    }

    /**
     * @description: 营业员信息
     **/
    public GlobalPara setSaleMan(DSaleMan saleMan) {
        this.saleMan = saleMan;
        return this;
    }

    public DSaleMan getSaleMan() {
        return this.saleMan;
    }

    /**
     * @description: 检查是否有能力执行
     **/
    public boolean hasPower(int power) {
        return Objects.isNull(this.saleMan) || this.saleMan.hasPower(power);
    }

    /**
     * @description: 条码格式
     **/
    public Map<Integer, DBarcodeFormat> AllBarcode() {
        if (this.systemBarcode == null) this.systemBarcode = new HashMap<>();
        return this.systemBarcode;
    }

    /**
     * @description: 添加条码格式
     **/
    @SuppressWarnings("all")
    public GlobalPara SetBarcode(DBarcodeFormat data, boolean isDefault) {
        if (data == null) return this;
        Integer id = data.no();
        if (id == null) return this;
        if (isDefault) {
            if (systemBarcodeNo < id) systemBarcodeNo = id;
            this.AllBarcode().put(id, data);
        } else if (id > systemBarcodeNo) {
            this.AllBarcode().put(id, data);
        }
        return this;
    }

    /**
     * @description: 批量添加条码格式
     **/
    public GlobalPara SetBarcode(DBarcodeFormatV1... data) {
        if (data == null || data.length == 0) return this;
        for (DBarcodeFormatV1 datum : data) {
            this.SetBarcode(datum, false);
        }
        return this;
    }

    /**
     * @description: 删除条码格式 0 清空
     **/
    public GlobalPara DeleteBarcode(Integer id) {
        if (id == null || id == 0) {
            this.AllBarcode().clear();
        } else {
            this.AllBarcode().remove(id);
        }
        return this;
    }

    /**
     * @description: 获取条码格式
     **/
    public DBarcodeFormat GetBarcode(Integer id) {
        return this.AllBarcode().get(id);
    }

    /**
     * @description: 打印格式
     **/
    public Map<Integer, DLabelFormat> AllLabelFormat() {
        if (this.systemLabel == null) this.systemLabel = new HashMap<>();
        return this.systemLabel;
    }

    /**
     * @description: 添加打印格式
     **/
    @SuppressWarnings("all")
    public GlobalPara SetLabelFormat(DLabelFormat data, boolean isDefault) {
        if (data == null) return this;
        Integer id = data.no();
        if (id == null) return this;
        if (isDefault) {
            if (this.systemLabelNo < id) systemLabelNo = id;
            this.AllLabelFormat().put(id, data);
        } else if (id > this.systemLabelNo) {
            this.AllLabelFormat().put(id, data);
        }
        return this;
    }

    /**
     * @description: 批量添加条码格式
     **/
    public GlobalPara SetLabelFormat(DLabelFormat... data) {
        if (data == null || data.length == 0) return this;
        for (DLabelFormat datum : data) {
            this.SetLabelFormat(datum, false);
        }
        return this;
    }

    /**
     * @description: 删除打印格式 id == 0 清空
     **/
    public GlobalPara DeleteLabelFormat(Integer id) {
        if (id == 0) {
            this.AllLabelFormat().clear();
        } else {
            this.AllLabelFormat().remove(id);
        }
        return this;
    }

    /**
     * @description: 获取打印格式
     **/
    public DLabelFormat GetLabelFormat(Integer id) {
        return this.AllLabelFormat().get(id);
    }

    /**
     * @description: 添加组别缓冲信息
     **/
    public Map<Integer, DCategory> AllCategory() {
        if (this.systemCategory == null) this.systemCategory = new HashMap<>();
        return this.systemCategory;
    }

    /**
     * @description: 添加分类信息
     **/
    public GlobalPara SetCategory(DCategory data) {
        if ((data != null) && (data.no() != null))
            this.AllCategory().put(data.no(), data);
        return this;
    }

    /**
     * @description: 删除分类信息
     **/
    public GlobalPara DeleteCategory(Integer id) {
        if (id == 0) {
            this.AllCategory().clear();
        } else {
            this.AllCategory().remove(id);
        }
        return this;
    }

    /**
     * @description: 获取分类信息
     **/
    public DCategory GetCategory(Integer id) {
        return this.AllCategory().get(id);
    }

    /**
     * @description: 添加 配置参数
     **/
    public GlobalPara Set_SDS(DSpDWL... spDWLS) {
        if (spDWLS == null) return this;
        for (DSpDWL spDWL : spDWLS) {
            if (StringUtils.isBlank(spDWL.getKey())
                    || StringUtils.isBlank(spDWL.getName())
                    || Objects.isNull(spDWL.no())) {
                String[] kidSeg = spDWL.getKid().split(PUBLIC_FIELD_SPLIT);
                if (kidSeg.length < 2) continue;
                Integer nameOffset = this.getSpDWL(kidSeg[0]);
                if (nameOffset == null) continue;
                String name;
                if (nameOffset > 0) {
                    String[] contentSeg = spDWL.getContent().split("\t", -1);
                    if (contentSeg.length < nameOffset) continue;
                    name = contentSeg[nameOffset - 1];
                } else
                    name = "";

                spDWL.setKey(kidSeg[0]);
                spDWL.sno(tryParseInt(kidSeg[1]));
                spDWL.setName(nameOffset > 0 ? name : "");
            }

            Map<Integer, DSpDWL> lsp = this.sds.get(spDWL.getKey());
            if (lsp == null) {
                lsp = new HashMap<>();
                this.sds.put(spDWL.getKey(), lsp);
            }
            lsp.put(spDWL.no(), spDWL);
        }
        return this;
    }

    public DSpDWL getSpData(String key, Integer id) {
        Map<Integer, DSpDWL> lsp = sds.get(key);
        if (lsp == null) return null;
        return lsp.get(id);
    }

    public DSpDWL getSpData(String kid) {
        String[] kidSeg = kid.split("\t");
        if (kidSeg.length < 2) return null;
        return getSpData(kidSeg[0], tryParseInt(kidSeg[1]));
    }

    public String[] getSpSeg(String key, Integer id) {
        Map<Integer, DSpDWL> lsp = sds.get(key);
        if (lsp == null) return null;
        DSpDWL spDWL = lsp.get(id);
        if (spDWL == null) return null;
        return spDWL.getContent().split("\t", -1);
    }

    public String[] getSpSeg(String kid) {
        String[] kidSeg = kid.split("\t");
        if (kidSeg.length < 2) return null;
        DSpDWL spDWL = getSpData(kidSeg[0], tryParseInt(kidSeg[1]));
        if (spDWL == null) return null;
        return spDWL.getContent().split("\t", -1);
    }

    /**
     * @description: 获取全部SPP信息
     **/
    public Map<Integer, DSpDWL> getSpSeg(String key, boolean withDef) {
        Map<Integer, DSpDWL> spDWLMap = this.sds.get(key);
        Map<Integer, DSpDWL> collection = new HashMap<>();
        if (spDWLMap != null) collection.putAll(spDWLMap);
        if (withDef) {
            Map<Integer, DSpDWL> def_spDWLMap = this.df_sds.get(key);
            if (def_spDWLMap != null) collection.putAll(def_spDWLMap);
        }
        return collection;
    }

    /************************************* 设置参数 ************************************************/

    public boolean checkTMS_Update(int... nos) {
        boolean result = false;
        for (int no : nos) {
            result = this.tms_Update.remove(no) != null || result;
        }
        return result;
    }

//    private DecimalFormatSymbols tmsDFS = new DecimalFormatSymbols();
//    private DecimalFormat tmsDF = new DecimalFormat();
//    private DecimalFormatSymbols digitDFS = new DecimalFormatSymbols();
//    private DecimalFormat digitDF = new DecimalFormat();     //.setGroupingUsed(false)

    final static private BigInteger n10 = new BigInteger("10");

    public String GetStringSpec_BigInteger(BigInteger number, int dot, int llng, int display_DecimalPoint, int display_KiloCharacter, int arith_Number) {
        //char[] origin=input.toString().toCharArray();
        char[] output = new char[64];
        int minus = number.signum();
        if (minus < 0)
            number = number.negate();

        int pos = 63;
        output[pos] = ' ';
        if (llng < dot + 1)
            llng = dot + 1;

        for (int loop = 0; (pos > 2) && ((loop < llng) || (number.signum() > 0)); loop++) {
            pos--;
            int tp = number.mod(n10).intValue();
            number = number.divide(n10);
            if ((dot > 0) && (dot == loop)) {
                if (display_DecimalPoint == 1)
                    output[pos] = ',';
                else
                    output[pos] = '.';
                pos--;
            }
            if ((loop > dot) && ((loop - dot) % 3 == 0) && (display_KiloCharacter > 0)) {
                if (display_KiloCharacter == 1)
                    output[pos] = '.';
                else if (display_KiloCharacter == 2)
                    output[pos] = ',';
                else
                    output[pos] = '\'';
                pos--;
            }

            if (arith_Number == 1)
                output[pos] = (char) (tp + 1632);
            else if (arith_Number == 2)
                output[pos] = (char) (tp + 1776);
            else
                output[pos] = (char) (tp + 0x30);
        }
        if (minus < 0) {
            pos--;
            output[pos] = '-';
        }

        return new String(output, pos, 63 - pos);
    }

    public String GetStringSpec_BigDecimal(BigDecimal number, int display_DecimalPoint, int display_KiloCharacter, int arith_Number) {
        return GetStringSpec_BigInteger(number.unscaledValue(), number.scale(), 1, display_DecimalPoint, display_KiloCharacter, arith_Number);
    }

    /**
     * @description: 数字全部特殊化
     **/
    public String GetStringTMS(BigDecimal number) {
        return GetStringSpec_BigInteger(number.unscaledValue(), number.scale(), 1, getTMS(TMS.Display_DecimalPoint), getTMS(TMS.Display_KiloCharacter), getTMS(TMS.Arith_Number));
        //return tmsDF.format(input);
    }

    /**
     * @description: 小数点特殊化
     **/
    public String GetStringDigit(BigDecimal number) {
        return GetStringSpec_BigInteger(number.unscaledValue(), number.scale(), 1, getTMS(TMS.Display_DecimalPoint), 0, 0);
        //return digitDF.format(input);
    }

    /**
     * @description: 参数允许修改
     **/
    public boolean tms_access(int no) {
        return !tms_Access.containsKey(no) || (tms_Access.get(no) <= (isPrivilege ? 2 : 1));
    }

    /**
     * @description: 数值允许修改
     **/
    public boolean tms_max(int no, int value) {
        return value >= 0 && (!tms_Max.containsKey(no) || value <= tms_Max.get(no));
    }

    /**
     * @description: 商城文本
     * @date: 2024-11-15 17:36:59
     **/
    public List<String> Mall_Text() {
        List<String> text = new ArrayList<>();
        String mall_1 = this.getTMT(MALL_1);
        if (StringUtils.isNotBlank(mall_1)) text.add(mall_1);
        String mall_2 = this.getTMT(MALL_2);
        if (StringUtils.isNotBlank(mall_2)) text.add(mall_2);
        String mall_3 = this.getTMT(MALL_3);
        if (StringUtils.isNotBlank(mall_3)) text.add(mall_3);
        String mall_4 = this.getTMT(MALL_4);
        if (StringUtils.isNotBlank(mall_4)) text.add(mall_4);
        String mall_5 = this.getTMT(MALL_5);
        if (StringUtils.isNotBlank(mall_5)) text.add(mall_5);
        String mall_6 = this.getTMT(MALL_6);
        if (StringUtils.isNotBlank(mall_6)) text.add(mall_6);
        String mall_7 = this.getTMT(MALL_7);
        if (StringUtils.isNotBlank(mall_7)) text.add(mall_7);
        String mall_8 = this.getTMT(MALL_8);
        if (StringUtils.isNotBlank(mall_8)) text.add(mall_8);

        if (text.isEmpty()) {
            String p5 = this.getTMT(Postil_5);
            if (StringUtils.isNotBlank(p5)) text.add(p5);
            String p6 = this.getTMT(Postil_6);
            if (StringUtils.isNotBlank(p6)) text.add(p6);
            String p7 = this.getTMT(Postil_7);
            if (StringUtils.isNotBlank(p7)) text.add(p7);
            String p8 = this.getTMT(Postil_8);
            if (StringUtils.isNotBlank(p8)) text.add(p8);
        }
        return text;
    }

    /**
     * @description: 首次加载
     **/
    public boolean Init_SetTMS(int no, int value, boolean isDefault) {
        boolean result = false;
        if (no >= 0) {

            int lastValue = getTMS(no);

            if (isDefault) {
                tms.put(no, value);
                result = true;
            } else if (this.tms_access(no) && this.tms_max(no, value)) {
                tms.put(no, value);
                result = true;
            }

            if (result && (value != lastValue)) {
                if ((no == TMS.Scale_WUnit_AutoConver) || (no == TMS.Money_PureUnit))
                    Unit_ReloadFromTMS();
                else if (no == TMS.Scale_PureUnit) {
                    Unit_ReloadFromTMS();
                    WeightCal.getInstance().ReInit();
                } else if (no == TMS.Scale_Precision)
                    WeightCal.getInstance().ReInit();
            }

            // if (no == TMS.Display_DecimalPoint) {
            //     if (value == 1) {
            //         tmsDFS.setDecimalSeparator(',');
            //         digitDFS.setDecimalSeparator(',');
            //     } else {
            //         tmsDFS.setDecimalSeparator('.');
            //         digitDFS.setDecimalSeparator('.');
            //     }
            //     tmsDF.setDecimalFormatSymbols(tmsDFS);
            //     digitDF.setDecimalFormatSymbols(tmsDFS);
            //     digitDF.setGroupingUsed(false);
            // } else if (no == TMS.Display_KiloCharacter) {
            //     boolean valid = true;
            //     if (value == 1)
            //         tmsDFS.setGroupingSeparator('.');
            //     else if (value == 2)
            //         tmsDFS.setGroupingSeparator(',');
            //     else if (value == 3)
            //         tmsDFS.setGroupingSeparator('\'');
            //     else
            //         valid = false;
            //     tmsDF.setDecimalFormatSymbols(tmsDFS);
            //     tmsDF.setGroupingUsed(valid);
            // } else if (no == TMS.Arith_Number) {
            //     if (value == 1)
            //         tmsDFS.setZeroDigit('\u0660');
            //     else if (value == 2)
            //         tmsDFS.setZeroDigit('\u06F0');
            //     else
            //         tmsDFS.setZeroDigit('0');
            //     tmsDF.setDecimalFormatSymbols(tmsDFS);
            // }
        }
        return result;
    }

    /**
     * @description: 后期修改参数
     **/
    public boolean setTMS(int no, int value, boolean isDefault) {
        boolean result = this.Init_SetTMS(no, value, isDefault);
        if (result) this.tms_Update.put(no, value);
        return result;
    }

    public boolean setTMS(int no, int value) {
        return this.setTMS(no, value, false);
    }

    public GlobalPara setTMS(Map<Integer, Integer> tms) {
        if (tms != null && !tms.isEmpty()) {
            for (Map.Entry<Integer, Integer> entry : tms.entrySet()) {
                this.setTMS(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    public int getTMS(int no) {
        return this.tms.getOrDefault(no, 0);
    }

    public int getTMS(int no, int def) {
        return this.tms.getOrDefault(no, def);
    }

    public int getTMS(int no, int def, int min) {
        int tms = this.getTMS(no, def);
        return tms < min ? min : tms;
    }

    // 文本参数
    public GlobalPara setTMT(int no, String value) {
        this.tmt.put(no, value);
        return this;
    }

    public GlobalPara setTMT(Map<Integer, String> tmt) {
        if (tmt != null && !tmt.isEmpty()) {
            for (Map.Entry<Integer, String> entry : tmt.entrySet()) {
                this.setTMT(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    public String getTMT(int no) {
        return this.tmt.getOrDefault(no, "");
    }

    public String getTMT(int no, String def) {
        return this.tmt.getOrDefault(no, StringUtils.isNotBlank(def) ? def : "");
    }

    // 语言文本
    public GlobalPara setLang(String key, String value) {
        this.langText.put(key, value);
        return this;
    }

    public String getLang(String key) {
        return this.langText.getOrDefault(key, "");
    }

    public String getTradeTypeName(int tradeType) {
        return getLang("TradeType-" + Integer.toString(tradeType));
    }

    // AI触发条件参数
    public BigDecimal getAiWeightValid() {
        return aiWeightValid;
    }

    public GlobalPara setAiWeightValid(BigDecimal aiWeightValid) {
        this.aiWeightValid = aiWeightValid;
        return this;
    }

    public int getAiWeightValidCount() {
        return aiWeightValidCount;
    }

    public GlobalPara setAiWeightValidCount(int aiWeightValidCount) {
        this.aiWeightValidCount = aiWeightValidCount;
        return this;
    }

    public BigDecimal getAiWeightQuit() {
        return aiWeightQuit;
    }

    public GlobalPara setAiWeightQuit(BigDecimal aiWeightQuit) {
        this.aiWeightQuit = aiWeightQuit;
        return this;
    }

    /************************************* 设置参数 ************************************************/


    public BigDecimal EcsCal_Rounding(BigDecimal input, int pointOfTarget, int roundingType) {
        if ((roundingType < 0) || (roundingType > 11))
            return input;
        if ((pointOfTarget < 0) || (pointOfTarget > 7))
            return input;
        int pn = pointOfTarget;
        Integer realType = roundingType / 3;
        pn = pointOfTarget - roundingType % 3;
        Integer Multi = 1;
        while (pn < 0) {
            Multi *= 10;
            pn++;
        }
        if (realType == 3) {
            Multi *= 5;
            realType = 0;
        }
        if (Multi != 1) {
            input = input.divide(new BigDecimal(Multi));
        }
        if (realType == 0)
            input = input.setScale(pn, BigDecimal.ROUND_HALF_UP);
        else if (realType == 1)
            input = input.setScale(pn, BigDecimal.ROUND_HALF_EVEN);
        else if (realType == 2)
            input = input.setScale(pn, BigDecimal.ROUND_DOWN);

        if (Multi != 1) {
            input = input.multiply(new BigDecimal(Multi));
        }
        return input.setScale(pointOfTarget);
    }

    public boolean EcsCal_Unit_isWeight(int unit) {
        return unit != 2;
    }

    public BigDecimal EcsCal_Unit_LoadPack(int unit)     //return 1 for not weight unit
    {
        if (unit == 2)     //计件商品按照1000计算，为了与常用的kg单位匹配
            return new BigDecimal(1000);
        if ((unit < 2) || (unit > 9))     //位置单位也按kg单位匹配
            return new BigDecimal(1000);

        if (unit == 3)         //kg
            return new BigDecimal("1000");
        else if (unit == 4)         //g
            return new BigDecimal("1");
        else if (unit == 5)         //ton
            return new BigDecimal("1000000");
        else if (unit == 6)         //lb
            return new BigDecimal("453.592");
        else if (unit == 7)         //500g
            return new BigDecimal("500");
        else if (unit == 8)         //100g
            return new BigDecimal("100");
        else if (unit == 9)         //lb/4
            return new BigDecimal("113.398");
        else    //如果系统单位不正确，按照kg计算
            return new BigDecimal(1000);
    }

    public String EcsCal_Unit_LoadName(int Unit, String UnitName)     //return 0 for not weight unit
    {
        if (Unit == 2) {
            if ((UnitName == null) || (UnitName.isEmpty()))
                return getLang("pcs");
            return UnitName;
        } else if (Unit == 3)         //kg
            return getLang("kg");   //"kg";
        else if (Unit == 4)         //g
            return getLang("g");    //"g";
        else if (Unit == 5)         //ton
            return getLang("ton");  //"ton";
        else if (Unit == 6)         //lb
            return getLang("lb");   //"lb";
        else if (Unit == 7)         //500g
            return getLang("500g"); //"500g";
        else if (Unit == 8)         //100g
            return getLang("100g"); //"100g";
        else if (Unit == 9)         //lb/4
            return getLang("lb/4"); //"lb/4";
        else
            return "";
    }

    public BigDecimal EcsCal_Unit_ValueConvert(BigDecimal value, int oldUnit, int newUnit) {
        if (oldUnit == newUnit)
            return value;
        if ((oldUnit == 1) || (newUnit == 1))
            return value;
        BigDecimal oldpack = EcsCal_Unit_LoadPack(oldUnit);
        if (oldpack.compareTo(BigDecimal.ZERO) == 0)
            return value;
        BigDecimal newpack = EcsCal_Unit_LoadPack(newUnit);
        if (newpack.compareTo(BigDecimal.ZERO) == 0)
            return value;
        return value.multiply(oldpack).divide(newpack, 7, BigDecimal.ROUND_HALF_UP);
    }

    public BigDecimal EcsCal_Unit_WeightConvertTo(BigDecimal weight, int oldUnit, int newUnit) {
        if (oldUnit == newUnit)
            return weight;
        return EcsCal_Rounding(EcsCal_Unit_ValueConvert(weight, oldUnit, newUnit), getTMS(TMS.Dot_Weight), 0);
    }

    public BigDecimal EcsCal_Unit_WeightConvertSystem(BigDecimal weight, int oldUnit) {
        if (oldUnit == getWeightUNIT())
            return weight;
        return EcsCal_Rounding(EcsCal_Unit_ValueConvert(weight, oldUnit, getWeightUNIT()), getTMS(TMS.Dot_Weight), 0);
    }

    public BigDecimal EcsCal_Rounding_Price(BigDecimal price) {
        return EcsCal_Rounding(price, getTMS(TMS.Dot_Price), 0);
    }

    public BigDecimal EcsCal_Unit_PriceConvertTo(BigDecimal price, int oldUnit, int newUnit) {
        if (oldUnit == newUnit)
            return price;
        return EcsCal_Rounding(EcsCal_Unit_ValueConvert(price, newUnit, oldUnit), getTMS(TMS.Dot_Price), 0);
    }

    /**
     * @description: 单价单位换算
     **/
    public BigDecimal CalPLU_Price_wUnit(BigDecimal price, int unit) {
        if (unit == 2)
            return EcsCal_Rounding(price, getTMS(TMS.Dot_Price), 0);
        else {
            int newUnit = CalPLU_PriceUnit_wUnit(unit);
            if (newUnit == unit)
                return EcsCal_Rounding(price, getTMS(TMS.Dot_Price), 0);
            return EcsCal_Rounding(EcsCal_Unit_ValueConvert(price, newUnit, unit), getTMS(TMS.Dot_Price), 0);
        }
    }

    public int CalPLU_PriceUnit_wUnit(int unit) {
        if (unit == 2)
            return 2;
        int spec228 = getTMS(TMS.Scale_WUnit_AutoConver);
        if ((spec228 == 4) || (spec228 == 5))
            return unit;
        else
            return getPriceUNIT();
    }

    /**
     * @description: 格式化金额
     * @date: 2024-11-15 15:07:31
     **/
    public BigDecimal Cal_Item(BigDecimal money) {
        money = Objects.nonNull(money) ? money : BigDecimal.ZERO;
        return money.setScale(GlobalPara.getInstance().getTMS(TMS.Dot_Money), RoundingMode.HALF_UP);
    }

    /**
     * @description: 系统重量单位换算
     **/
    private BigDecimal EcsCal_Unit_PriceConvertSystem(BigDecimal price, int oldUnit) {
        if (oldUnit == getPriceUNIT())
            return EcsCal_Rounding(price, getTMS(TMS.Dot_Price), 0);
        return EcsCal_Rounding(EcsCal_Unit_ValueConvert(price, getPriceUNIT(), oldUnit), getTMS(TMS.Dot_Price), 0);
    }

    public BigDecimal EcsCal_Rounding_Single(BigDecimal input) {
        return EcsCal_Rounding(input, getTMS(TMS.Dot_Money), getTMS(TMS.Arith_Round_STotal));
    }

    public BigDecimal EcsCal_Rounding_Total(BigDecimal input) {
        return EcsCal_Rounding(input, getTMS(TMS.Dot_Money), getTMS(TMS.Arith_Round_Pay));
    }

    public String EcsCal_PrintDate(Calendar calendar) {
        if ((dateFormat != null) && (!dateFormat.isEmpty())) {
            SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
            return formatter.format(calendar.getTime());
        } else {
            int dateSort = getTMS(TMS.Arith_DateType) % 100;
            int monthSort = getTMS(TMS.Arith_DateType_Month);
            int year4 = calendar.get(Calendar.YEAR);
            int year2 = year4 % 100;
            int month = calendar.get(Calendar.MONTH) + 1;
            String monthString;
            if (monthSort == 1)
                monthString = ecsCal_PrintMonth_1[month];
            else
                monthString = String.format("%02d", month);
            int day = calendar.get(Calendar.DAY_OF_MONTH);

            if (dateSort == 0)
                return String.format("%02d.%s.%02d", year4, monthString, day);
            else if (dateSort == 1)
                return String.format("%02d.%s.%02d", year2, monthString, day);
            else if (dateSort == 2)
                return String.format("%s/%02d/%02d", monthString, day, year2);
            else if (dateSort == 3)
                return String.format("%s-%02d-%02d", monthString, day, year2);
            else if (dateSort == 4)
                return String.format("%02d/%s/%02d", day, monthString, year2);
            else if (dateSort == 5)
                return String.format("%02d/%s/%02d", day, monthString, year2);
            else if (dateSort == 11)
                return String.format("%02d.%s.%02d", day, monthString, year4);
            else if (dateSort == 12)
                return String.format("%s.%02d.%02d", monthString, day, year4);
            else if ((dateSort > 5) && (dateSort < 11)) {
                Date datebase = new Date();
                SimpleDateFormat format = new SimpleDateFormat("yyyy-mm-dd hh:mm:ss");
                try {
                    datebase = format.parse("2000-01-01 00:00:00");
                } catch (Exception e) {
                }
                int allDays = (int) ((calendar.getTimeInMillis() - datebase.getTime()) / (24 * 60 * 60 * 1000));
                allDays = allDays + dateSort - 8;
                int loop = ecsCal_PrintPersianOffset[0].length;
                while (true) {
                    loop--;
                    if (loop < 0)
                        return "";
                    if (allDays >= ecsCal_PrintPersianOffset[loop][1]) {
                        year4 = ecsCal_PrintPersianOffset[loop][0];
                        day = year4 - ecsCal_PrintPersianOffset[loop][1];
                        break;
                    }
                }
                year4 += day / (365 * 3 + 366) * 4;
                day %= (365 * 3 + 366);
                if (day >= 2 * 365 + 366) {
                    day -= 2 * 365 + 366;
                    year4 += 3;
                } else if (day >= 365 + 366) {
                    day -= 365 + 366;
                    year4 += 2;
                } else if (day >= 365) {
                    day -= 365;
                    year4 += 1;
                }
                if (day < 31 * 6) {
                    month = day / 31;
                    day %= 31;
                } else {
                    month = 6 + (day - 31 * 6) / 30;
                    day = (day - 31 * 6) % 30;
                }
                return String.format("04d-%02d-%02d", year4, month + 1, day + 1);
            } else
                return String.format("%02d.%s.%02d", year4, monthString, day);
        }
    }

    public String EcsCal_PrintTime(Calendar calendar) {
        if ((timeFormat != null) && (!timeFormat.isEmpty())) {
            SimpleDateFormat formatter = new SimpleDateFormat(timeFormat);
            return formatter.format(calendar.getTime());
        } else {
            int timeSort = getTMS(TMS.Arith_DateType) / 100;
            int hour = calendar.get(Calendar.HOUR_OF_DAY);
            int tv = hour;
            if (timeSort > 0)
                tv = (tv + 11) % 12 + 1;
            String rv = String.format("%02d:%02d:%02d", tv, calendar.get(Calendar.MINUTE), calendar.get(Calendar.SECOND));
            if (timeSort > 0) {
                if (hour >= 12)
                    rv += " PM";
                else
                    rv += " AM";
            }
            return rv;
        }
    }

    /*************************************************** 属性 get set *******************************************************************/

    public String getSystemID() {
        return systemID;
    }

    public GlobalPara setSystemID(String systemID) {
        this.systemID = systemID;
        return this;
    }

    public String getStoreName() {
        return getTMT(TMT.StoreName);
    }

    public GlobalPara setStoreName(String storeName) {
        setTMT(TMT.StoreName, storeName);
        return this;
    }

    public String getDeviceName() {
        return getTMT(TMT.DeviceName);
    }

    public GlobalPara setDeviceName(String deviceName) {
        setTMT(TMT.DeviceName, deviceName);
        return this;
    }

    public int getDeviceNumber() {
        return getTMS(Device_No);
    }

    public GlobalPara setDeviceNumber(int deviceNumber) {
        setTMS(Device_No, deviceNumber);
        return this;
    }

    public int getDeviceType() {
        return deviceType;
    }

    public GlobalPara setDeviceType(int deviceType) {
        this.deviceType = deviceType;
        return this;
    }

    public String getMoneyPrefix() {
        return getTMT(TMT.Money_Prefix);
    }

    public GlobalPara setMoneyPrefix(String moneyPrefix) {
        setTMT(TMT.Money_Prefix, moneyPrefix);
        return this;
    }

    public String getMoneySuffix() {
        return getTMT(TMT.Money_Suffix);
    }

    public GlobalPara setMoneySuffix(String moneySuffix) {
        setTMT(TMT.Money_Suffix, moneySuffix);
        return this;
    }

    public int getDeviceLevel() {
        return deviceLevel;
    }

    public GlobalPara setDeviceLevel(int deviceLevel) {
        this.deviceLevel = deviceLevel;
        return this;
    }

    public boolean getWeightUNIT_Allowed(int no) {
        if ((no < 0) || (no >= weightUNIT_Allowed.length))
            return false;
        else
            return weightUNIT_Allowed[no];
    }

    public boolean getMoneyUnit_Allowed(int weightno, int moneyno) {
        if ((weightno < 0) || (weightno >= weightUNIT_Allowed.length))
            return false;
        if ((moneyno < 0) || (moneyno >= weightUNIT_Allowed.length))
            return false;
        else
            return moneyUnit_Allowed[weightno][moneyno];
    }

    private int unit_Weight = 3;
    private int unit_Price = 3;
    private int unit_Price_Hold = 3;
    private boolean unit_Loaded = false;

    public void Unit_ReloadFromTMS() {
        int tw = getTMS(TMS.Scale_PureUnit);
        if (tw != unit_Weight) {
            unit_Weight = tw;
            WeightCal.getInstance().ReInit();
        }
        unit_Price = unit_Price_Hold = getTMS(TMS.Money_PureUnit);
        unit_Loaded = true;
    }

    public int getWeightUNIT() {
        if (!unit_Loaded) Unit_ReloadFromTMS();
        int result = unit_Weight;
        if ((result < 0) || (result >= weightUNIT_Allowed.length) || (!weightUNIT_Allowed[result]))
            return 3;
        return result;
    }

    public int setWeightUNIT(int weightUNIT) {
        if (weightUNIT != unit_Weight) {
            unit_Weight = weightUNIT;
            WeightCal.getInstance().ReInit();
        }
        //unit_Loaded = true;
        return getWeightUNIT();
    }

    public int getPriceUNIT() {
        if (!unit_Loaded) Unit_ReloadFromTMS();
        int result = unit_Price;
        int wu = getWeightUNIT();
        if ((result < 0) || (result >= weightUNIT_Allowed.length) || (!moneyUnit_Allowed[wu][result]))
            return wu;
        return result;
    }

    public int setPriceUNIT(int priceUNIT, boolean hold) {
        if (hold)
            unit_Price_Hold = priceUNIT;
        unit_Price = priceUNIT;
        unit_Loaded = true;
        return getPriceUNIT();
    }

    public int getPriceUNIT_Hold() {
        unit_Price = unit_Price_Hold;
        return getPriceUNIT();
    }

    public int getPointOfWeight() {
        return getTMS(TMS.Dot_Weight);
    }

    public GlobalPara setPointOfWeight(int pointOfWeight) {
        setTMS(TMS.Dot_Weight, pointOfWeight);
        return this;
    }

    public int getPointOfPrice() {
        return getTMS(TMS.Dot_Price);
    }

    public GlobalPara setPointOfPrice(int pointOfPrice) {
        setTMS(TMS.Dot_Price, pointOfPrice);
        return this;
    }

    public int getPointOfMoney() {
        return getTMS(TMS.Dot_Money);
    }

    public GlobalPara setPointOfMoney(int pointOfMoney) {
        setTMS(TMS.Dot_Money, pointOfMoney);
        return this;
    }

    public boolean isDiscountAuto_InTime() {
        int dayStart, dayEnd;
        dayStart = getTMS(TMS.Discount_Auto_DayStart);
        dayEnd = getTMS(TMS.Discount_Auto_DayEnd);
        if (dayStart == 0)
            return true;
        if (dayStart > dayEnd)
            return false;

        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int ctday = (calendar.get(Calendar.YEAR) - 2000) * 10000 + (calendar.get(Calendar.MONTH) + 1) * 100 + calendar.get(Calendar.DAY_OF_MONTH);

        return (ctday >= dayStart) && (ctday <= dayEnd);
    }

    public boolean EcsCal_MoneyUnitAllowed(int unit) throws MeterException {
        if (unit == 2)
            return true;
        int spec228 = getTMS(TMS.Scale_WUnit_AutoConver);
        if ((spec228 == 4) || (spec228 == 5)) {
            int loop = 0;
            while (true) {
                if ((getWeightUNIT_Allowed(loop)) && (getMoneyUnit_Allowed(loop, unit)))
                    break;
                loop++;
                if (loop > 9) {
                    if (unit == 1)
                        throw new MeterException(MeterStateEnum.重量单位不明确不允许交易);
                        // return false;               //商品重量必须是一个明确的重量单位（和下面一个是相同的）
                    else
                        throw new MeterException(MeterStateEnum.重量单位无效不允许交易);
                    // return false;               //商品重量单位不允许交易
                }
            }
            if (spec228 == 4)
                setPriceUNIT(unit, true);
            else //if(spec228==5)
                setPriceUNIT(unit, false);
        } else if (unit <= 1) {
            if ((spec228 & 0x02) != 0)
                throw new MeterException(MeterStateEnum.重量单位不明确不允许交易);
            // return false;               //商品重量必须是一个明确的重量单位（和上面一个是相同的）
        } else {
            if (((spec228 & 0x01) != 0) && (!getMoneyUnit_Allowed(getWeightUNIT(), unit)))
                throw new MeterException(MeterStateEnum.商品单位与重量单位不兼容不允许交易);
            // return false;               //商品重量单位与当前重量单位不兼容
        }
        return true;
    }

    public static final String DEFAULT_CONFIG = "DWL\tTMS\t\n" +
            "TMS\t0\t9\t\n" +
            "TMS\t1\t2\t\n" +
            "TMS\t2\t20\t\n" +
            "TMS\t3\t1\t\n" +
            "TMS\t4\t0\t\n" +
            "TMS\t5\t9\t\n" +
            "TMS\t6\t7\t\n" +
            "TMS\t7\t2099999\t\n" +
            "TMS\t8\t1\t\n" +
            "TMS\t9\t0\t\n" +
            "TMS\t10\t0\t\n" +
            "TMS\t11\t0\t\n" +
            "TMS\t12\t0\t\n" +
            "TMS\t13\t0\t\n" +
            "TMS\t14\t0\t\n" +
            "TMS\t15\t0\t\n" +
            "TMS\t16\t0\t\n" +
            "TMS\t17\t0\t\n" +
            "TMS\t18\t0\t\n" +
            "TMS\t19\t0\t\n" +
            "TMS\t20\t33\t\n" +
            "TMS\t21\t1\t\n" +
            "TMS\t22\t7\t\n" +
            "TMS\t23\t7\t\n" +
            "TMS\t24\t5\t\n" +
            "TMS\t25\t35\t\n" +
            "TMS\t26\t16\t\n" +
            "TMS\t27\t48\t\n" +
            "TMS\t28\t1\t\n" +
            "TMS\t29\t0\t\n" +
            "TMS\t30\t270\t\n" +
            "TMS\t31\t0\t\n" +
            "TMS\t32\t0\t\n" +
            "TMS\t33\t0\t\n" +
            "TMS\t34\t3\t\n" +
            "TMS\t35\t1\t\n" +
            "TMS\t36\t1\t\n" +
            "TMS\t37\t8\t\n" +
            "TMS\t38\t20\t\n" +
            "TMS\t39\t0\t\n" +
            "TMS\t40\t0\t\n" +
            "TMS\t41\t5\t\n" +
            "TMS\t42\t1\t\n" +
            "TMS\t43\t1\t\n" +
            "TMS\t44\t30\t\n" +
            "TMS\t45\t1\t\n" +
            "TMS\t46\t0\t\n" +
            "TMS\t47\t0\t\n" +
            "TMS\t48\t10\t\n" +
            "TMS\t49\t1\t\n" +
            "TMS\t50\t0\t\n" +
            "TMS\t51\t2\t\n" +
            "TMS\t52\t0\t\n" +
            "TMS\t53\t0\t\n" +
            "TMS\t54\t0\t\n" +
            "TMS\t55\t0\t\n" +
            "TMS\t56\t0\t\n" +
            "TMS\t57\t0\t\n" +
            "TMS\t58\t1\t\n" +
            "TMS\t59\t0\t\n" +
            "TMS\t60\t1\t\n" +
            "TMS\t61\t3\t\n" +
            "TMS\t62\t3\t\n" +
            "TMS\t63\t3\t\n" +
            "TMS\t64\t3\t\n" +
            "TMS\t65\t4\t\n" +
            "TMS\t66\t0\t\n" +
            "TMS\t67\t1\t\n" +
            "TMS\t68\t1\t\n" +
            "TMS\t69\t2\t\n" +
            "TMS\t70\t0\t\n" +
            "TMS\t71\t0\t\n" +
            "TMS\t72\t0\t\n" +
            "TMS\t73\t0\t\n" +
            "TMS\t74\t0\t\n" +
            "TMS\t75\t0\t\n" +
            "TMS\t76\t0\t\n" +
            "TMS\t77\t0\t\n" +
            "TMS\t78\t2\t\n" +
            "TMS\t79\t1\t\n" +
            "TMS\t80\t1\t\n" +
            "TMS\t81\t1\t\n" +
            "TMS\t82\t1\t\n" +
            "TMS\t83\t1\t\n" +
            "TMS\t84\t0\t\n" +
            "TMS\t85\t20\t\n" +
            "TMS\t86\t20\t\n" +
            "TMS\t87\t0\t\n" +
            "TMS\t88\t0\t\n" +
            "TMS\t89\t1\t\n" +
            "TMS\t90\t1\t\n" +
            "TMS\t91\t0\t\n" +
            "TMS\t92\t1\t\n" +
            "TMS\t93\t0\t\n" +
            "TMS\t94\t0\t\n" +
            "TMS\t95\t0\t\n" +
            "TMS\t96\t0\t\n" +
            "TMS\t97\t1\t\n" +
            "TMS\t98\t3\t\n" +
            "TMS\t99\t3\t\n" +
            "TMS\t100\t0\t\n" +
            "TMS\t101\t0\t\n" +
            "TMS\t102\t0\t\n" +
            "TMS\t103\t3\t\n" +
            "TMS\t104\t0\t\n" +
            "TMS\t105\t0\t\n" +
            "TMS\t106\t0\t\n" +
            "TMS\t107\t0\t\n" +
            "TMS\t108\t0\t\n" +
            "TMS\t109\t0\t\n" +
            "TMS\t110\t0\t\n" +
            "TMS\t111\t0\t\n" +
            "TMS\t112\t0\t\n" +
            "TMS\t113\t0\t\n" +
            "TMS\t114\t0\t\n" +
            "TMS\t115\t1\t\n" +
            "TMS\t116\t0\t\n" +
            "TMS\t117\t0\t\n" +
            "TMS\t118\t3\t\n" +
            "TMS\t119\t2\t\n" +
            "TMS\t120\t3\t\n" +
            "TMS\t121\t1\t\n" +
            "TMS\t122\t0\t\n" +
            "TMS\t123\t0\t\n" +
            "TMS\t124\t0\t\n" +
            "TMS\t125\t0\t\n" +
            "TMS\t126\t0\t\n" +
            "TMS\t127\t0\t\n" +
            "TMS\t128\t0\t\n" +
            "TMS\t129\t0\t\n" +
            "TMS\t130\t0\t\n" +
            "TMS\t131\t0\t\n" +
            "TMS\t132\t0\t\n" +
            "TMS\t133\t2\t\n" +
            "TMS\t134\t2\t\n" +
            "TMS\t135\t0\t\n" +
            "TMS\t136\t0\t\n" +
            "TMS\t137\t0\t\n" +
            "TMS\t138\t0\t\n" +
            "TMS\t139\t0\t\n" +
            "TMS\t140\t2\t\n" +
            "TMS\t141\t1\t\n" +
            "TMS\t142\t1\t\n" +
            "TMS\t143\t6\t\n" +
            "TMS\t144\t0\t\n" +
            "TMS\t145\t0\t\n" +
            "TMS\t146\t0\t\n" +
            "TMS\t147\t0\t\n" +
            "TMS\t148\t0\t\n" +
            "TMS\t149\t1\t\n" +
            "TMS\t150\t192\t\n" +
            "TMS\t151\t168\t\n" +
            "TMS\t152\t0\t\n" +
            "TMS\t153\t0\t\n" +
            "TMS\t154\t0\t\n" +
            "TMS\t155\t0\t\n" +
            "TMS\t156\t0\t\n" +
            "TMS\t157\t0\t\n" +
            "TMS\t158\t192\t\n" +
            "TMS\t159\t168\t\n" +
            "TMS\t160\t0\t\n" +
            "TMS\t161\t1\t\n" +
            "TMS\t162\t255\t\n" +
            "TMS\t163\t255\t\n" +
            "TMS\t164\t255\t\n" +
            "TMS\t165\t0\t\n" +
            "TMS\t166\t33581\t\n" +
            "TMS\t167\t33582\t\n" +
            "TMS\t168\t33583\t\n" +
            "TMS\t169\t33584\t\n" +
            "TMS\t170\t8\t\n" +
            "TMS\t171\t8\t\n" +
            "TMS\t172\t8\t\n" +
            "TMS\t173\t8\t\n" +
            "TMS\t174\t0\t\n" +
            "TMS\t175\t0\t\n" +
            "TMS\t176\t0\t\n" +
            "TMS\t177\t0\t\n" +
            "TMS\t178\t0\t\n" +
            "TMS\t179\t0\t\n" +
            "TMS\t180\t0\t\n" +
            "TMS\t181\t0\t\n" +
            "TMS\t182\t0\t\n" +
            "TMS\t183\t0\t\n" +
            "TMS\t184\t0\t\n" +
            "TMS\t185\t0\t\n" +
            "TMS\t186\t0\t\n" +
            "TMS\t187\t0\t\n" +
            "TMS\t188\t6\t\n" +
            "TMS\t189\t7\t\n" +
            "TMS\t190\t0\t\n" +
            "TMS\t191\t1\t\n" +
            "TMS\t192\t0\t\n" +
            "TMS\t193\t0\t\n" +
            "TMS\t194\t0\t\n" +
            "TMS\t195\t1\t\n" +
            "TMS\t196\t3\t\n" +
            "TMS\t197\t0\t\n" +
            "TMS\t198\t4\t\n" +
            "TMS\t199\t0\t\n" +
            "TMS\t200\t3\t\n" +
            "TMS\t201\t3\t\n" +
            "TMS\t202\t2\t\n" +
            "TMS\t203\t2\t\n" +
            "TMS\t204\t0\t\n" +
            "TMS\t205\t0\t\n" +
            "TMS\t206\t3\t\n" +
            "TMS\t207\t2\t\n" +
            "TMS\t208\t3\t\n" +
            "TMS\t209\t2\t\n" +
            "TMS\t210\t0\t\n" +
            "TMS\t211\t0\t\n" +
            "TMS\t212\t3\t\n" +
            "TMS\t213\t0\t\n" +
            "TMS\t214\t0\t\n" +
            "TMS\t215\t9\t\n" +
            "TMS\t216\t9\t\n" +
            "TMS\t217\t4\t\n" +
            "TMS\t218\t0\t\n" +
            "TMS\t219\t40\t\n" +
            "TMS\t220\t18\t\n" +
            "TMS\t221\t2\t\n" +
            "TMS\t222\t2\t\n" +
            "TMS\t223\t4\t\n" +
            "TMS\t224\t4\t\n" +
            "TMS\t225\t5\t\n" +
            "TMS\t226\t0\t\n" +
            "TMS\t227\t0\t\n" +
            "TMS\t228\t0\t\n" +
            "TMS\t229\t1\t\n" +
            "TMS\t230\t0\t\n" +
            "TMS\t231\t0\t\n" +
            "TMS\t232\t0\t\n" +
            "TMS\t233\t0\t\n" +
            "TMS\t234\t0\t\n" +
            "TMS\t235\t0\t\n" +
            "TMS\t236\t0\t\n" +
            "TMS\t237\t0\t\n" +
            "TMS\t238\t0\t\n" +
            "TMS\t239\t100\t\n" +
            "TMS\t240\t54\t\n" +
            "TMS\t241\t0\t\n" +
            "TMS\t242\t0\t\n" +
            "TMS\t243\t1\t\n" +
            "TMS\t244\t0\t\n" +
            "TMS\t245\t0\t\n" +
            "TMS\t246\t0\t\n" +
            "TMS\t247\t0\t\n" +
            "TMS\t248\t0\t\n" +
            "TMS\t249\t0\t\n" +
            "TMS\t250\t0\t\n" +
            "TMS\t251\t0\t\n" +
            "TMS\t252\t0\t\n" +
            "TMS\t253\t0\t\n" +
            "TMS\t254\t0\t\n" +
            "TMS\t255\t0\t\n" +
            "TMS\t256\t0\t\n" +
            "TMS\t257\t7\t\n" +
            "TMS\t258\t3\t\n" +
            "TMS\t259\t0\t\n" +
            "TMS\t260\t0\t\n" +
            "TMS\t261\t0\t\n" +
            "TMS\t262\t0\t\n" +
            "TMS\t263\t0\t\n" +
            "TMS\t264\t0\t\n" +
            "TMS\t265\t0\t\n" +
            "TMS\t266\t0\t\n" +
            "TMS\t267\t0\t\n" +
            "TMS\t268\t1\t\n" +
            "TMS\t269\t0\t\n" +
            "TMS\t270\t0\t\n" +
            "TMS\t271\t1\t\n" +
            "TMS\t272\t0\t\n" +
            "TMS\t273\t1\t\n" +
            "TMS\t274\t9999979\t\n" +
            "TMS\t275\t1\t\n" +
            "TMS\t276\t0\t\n" +
            "TMS\t277\t0\t\n" +
            "TMS\t278\t0\t\n" +
            "TMS\t279\t0\t\n" +
            "TMS\t280\t0\t\n" +
            "TMS\t281\t0\t\n" +
            "TMS\t282\t0\t\n" +
            "TMS\t283\t1\t\n" +
            "TMS\t284\t0\t\n" +
            "TMS\t285\t0\t\n" +
            "TMS\t286\t0\t\n" +
            "TMS\t287\t0\t\n" +
            "TMS\t288\t0\t\n" +
            "TMS\t289\t0\t\n" +
            "TMS\t290\t0\t\n" +
            "TMS\t291\t0\t\n" +
            "TMS\t292\t0\t\n" +
            "TMS\t293\t0\t\n" +
            "TMS\t294\t0\t\n" +
            "TMS\t295\t0\t\n" +
            "TMS\t296\t0\t\n" +
            "TMS\t297\t0\t\n" +
            "TMS\t298\t2\t\n" +
            "TMS\t299\t0\t\n" +
            "TMS\t300\t0\t\n" +
            "TMS\t301\t0\t\n" +
            "TMS\t302\t0\t\n" +
            "TMS\t303\t0\t\n" +
            "TMS\t304\t0\t\n" +
            "TMS\t305\t0\t\n" +
            "TMS\t306\t0\t\n" +
            "TMS\t307\t1\t\n" +
            "TMS\t308\t1\t\n" +
            "TMS\t309\t0\t\n" +
            "TMS\t310\t0\t\n" +
            "TMS\t311\t0\t\n" +
            "TMS\t312\t0\t\n" +
            "TMS\t313\t0\t\n" +
            "TMS\t314\t0\t\n" +
            "TMS\t315\t0\t\n" +
            "TMS\t316\t0\t\n" +
            "TMS\t317\t0\t\n" +
            "TMS\t318\t0\t\n" +
            "TMS\t319\t0\t\n" +
            "TMS\t320\t0\t\n" +
            "TMS\t321\t0\t\n" +
            "TMS\t322\t0\t\n" +
            "TMS\t323\t0\t\n" +
            "TMS\t324\t0\t\n" +
            "TMS\t325\t0\t\n" +
            "TMS\t326\t0\t\n" +
            "TMS\t327\t0\t\n" +
            "TMS\t328\t0\t\n" +
            "TMS\t329\t0\t\n" +
            "TMS\t330\t0\t\n" +
            "TMS\t331\t0\t\n" +
            "TMS\t332\t0\t\n" +
            "TMS\t333\t0\t\n" +
            "TMS\t334\t0\t\n" +
            "TMS\t335\t0\t\n" +
            "TMS\t336\t0\t\n" +
            "TMS\t337\t0\t\n" +
            "TMS\t338\t0\t\n" +
            "TMS\t339\t0\t\n" +
            "TMS\t340\t4\t\n" +
            "TMS\t341\t13\t\n" +
            "TMS\t342\t0\t\n" +
            "TMS\t343\t0\t\n" +
            "TMS\t344\t0\t\n" +
            "TMS\t345\t0\t\n" +
            "TMS\t346\t0\t\n" +
            "TMS\t347\t0\t\n" +
            "TMS\t348\t0\t\n" +
            "TMS\t349\t0\t\n" +
            "TMS\t350\t0\t\n" +
            "TMS\t351\t0\t\n" +
            "TMS\t352\t0\t\n" +
            "TMS\t353\t1\t\n" +
            "TMS\t354\t0\t\n" +
            "TMS\t355\t0\t\n" +
            "TMS\t356\t0\t\n" +
            "TMS\t357\t0\t\n" +
            "TMS\t358\t1\t\n" +
            "TMS\t359\t0\t\n" +
            "TMS\t360\t100\t\n" +
            "TMS\t361\t1\t\n" +
            "TMS\t362\t1\t\n" +
            "TMS\t363\t10\t\n" +
            "TMS\t364\t0\t\n" +
            "TMS\t365\t0\t\n" +
            "TMS\t366\t0\t\n" +
            "TMS\t367\t0\t\n" +
            "TMS\t368\t0\t\n" +
            "TMS\t369\t0\t\n" +
            "TMS\t370\t0\t\n" +
            "TMS\t371\t0\t\n" +
            "TMS\t372\t0\t\n" +
            "TMS\t373\t0\t\n" +
            "TMS\t374\t0\t\n" +
            "TMS\t375\t0\t\n" +
            "TMS\t376\t33591\t\n" +
            "TMS\t377\t33592\t\n" +
            "TMS\t378\t33593\t\n" +
            "TMS\t379\t33594\t\n" +
            "TMS\t380\t0\t\n" +
            "TMS\t381\t0\t\n" +
            "TMS\t382\t0\t\n" +
            "TMS\t383\t0\t\n" +
            "TMS\t384\t0\t\n" +
            "TMS\t385\t0\t\n" +
            "TMS\t386\t0\t\n" +
            "TMS\t387\t0\t\n" +
            "TMS\t388\t0\t\n" +
            "TMS\t389\t0\t\n" +
            "TMS\t390\t0\t\n" +
            "TMS\t391\t0\t\n" +
            "TMS\t392\t0\t\n" +
            "TMS\t393\t0\t\n" +
            "TMS\t394\t0\t\n" +
            "TMS\t395\t0\t\n" +
            "TMS\t396\t0\t\n" +
            "TMS\t397\t0\t\n" +
            "TMS\t398\t0\t\n" +
            "TMS\t399\t0\t\n" +
            "TMS\t400\t0\t\n" +
            "TMS\t401\t0\t\n" +
            "TMS\t402\t0\t\n" +
            "TMS\t403\t0\t\n" +
            "TMS\t404\t0\t\n" +
            "TMS\t405\t0\t\n" +
            "TMS\t406\t0\t\n" +
            "TMS\t407\t0\t\n" +
            "TMS\t408\t0\t\n" +
            "TMS\t409\t0\t\n" +
            "TMS\t410\t0\t\n" +
            "TMS\t411\t0\t\n" +
            "TMS\t412\t0\t\n" +
            "TMS\t413\t0\t\n" +
            "TMS\t414\t0\t\n" +
            "TMS\t415\t1\t\n" +
            "TMS\t416\t1\t\n" +
            "TMS\t417\t8\t\n" +
            "TMS\t418\t20\t\n" +
            "TMS\t419\t0\t\n" +
            "TMS\t420\t0\t\n" +
            "TMS\t421\t0\t\n" +
            "TMS\t422\t1\t\n" +
            "TMS\t423\t0\t\n" +
            "TMS\t424\t0\t\n" +
            "TMS\t425\t0\t\n" +
            "TMS\t426\t0\t\n" +
            "TMS\t427\t0\t\n" +
            "TMS\t428\t0\t\n" +
            "TMS\t429\t0\t\n" +
            "TMS\t430\t192\t\n" +
            "TMS\t431\t168\t\n" +
            "TMS\t432\t0\t\n" +
            "TMS\t433\t0\t\n" +
            "TMS\t434\t192\t\n" +
            "TMS\t435\t168\t\n" +
            "TMS\t436\t0\t\n" +
            "TMS\t437\t1\t\n" +
            "TMS\t438\t255\t\n" +
            "TMS\t439\t255\t\n" +
            "TMS\t440\t255\t\n" +
            "TMS\t441\t0\t\n" +
            "TMS\t442\t0\t\n" +
            "TMS\t443\t0\t\n" +
            "TMS\t444\t0\t\n" +
            "TMS\t445\t0\t\n" +
            "TMS\t446\t0\t\n" +
            "TMS\t447\t0\t\n" +
            "TMS\t448\t0\t\n" +
            "TMS\t449\t0\t\n" +
            "TMS\t450\t9\t\n" +
            "TMS\t451\t0\t\n" +
            "TMS\t452\t0\t\n" +
            "TMS\t453\t2\t\n" +
            "TMS\t454\t6\t\n" +
            "TMS\t455\t1\t\n" +
            "TMS\t456\t0\t\n" +
            "TMS\t457\t0\t\n" +
            "TMS\t458\t0\t\n" +
            "TMS\t459\t0\t\n" +
            "TMS\t460\t0\t\n" +
            "TMS\t461\t0\t\n" +
            "TMS\t462\t0\t\n" +
            "TMS\t463\t0\t\n" +
            "TMS\t464\t0\t\n" +
            "TMS\t465\t0\t\n" +
            "TMS\t466\t0\t\n" +
            "TMS\t467\t0\t\n" +
            "TMS\t468\t0\t\n" +
            "TMS\t469\t0\t\n" +
            "TMS\t470\t0\t\n" +
            "TMS\t471\t0\t\n" +
            "TMS\t472\t0\t\n" +
            "TMS\t473\t0\t\n" +
            "TMS\t474\t0\t\n" +
            "TMS\t475\t0\t\n" +
            "TMS\t476\t0\t\n" +
            "TMS\t477\t0\t\n" +
            "TMS\t478\t0\t\n" +
            "TMS\t479\t0\t\n" +
            "TMS\t480\t0\t\n" +
            "TMS\t481\t0\t\n" +
            "TMS\t482\t0\t\n" +
            "TMS\t483\t0\t\n" +
            "TMS\t484\t0\t\n" +
            "TMS\t485\t0\t\n" +
            "TMS\t486\t0\t\n" +
            "TMS\t487\t0\t\n" +
            "TMS\t488\t0\t\n" +
            "TMS\t489\t0\t\n" +
            "TMS\t490\t0\t\n" +
            "TMS\t491\t0\t\n" +
            "TMS\t492\t0\t\n" +
            "TMS\t493\t0\t\n" +
            "TMS\t494\t0\t\n" +
            "TMS\t495\t0\t\n" +
            "TMS\t496\t0\t\n" +
            "TMS\t497\t0\t\n" +
            "TMS\t498\t0\t\n" +
            "TMS\t499\t1522729470\t\n" +
            "END\tTMS\t\n" +
            "\n" +
            "DWL\tTMT\t\n" +
            "TMT\t0\t上海精函信息科技有限公司\t\n" +
            "TMT\t1\t出厂机\t\n" +
            "TMT\t2\t￥\t\n" +
            "TMT\t3\t\t\n" +
            "TMT\t4\t\t\n" +
            "TMT\t5\t\t\n" +
            "TMT\t6\t\t\n" +
            "TMT\t7\t\t\n" +
            "TMT\t8\t谢谢惠顾,欢迎再次光临!\t\n" +
            "TMT\t9\t\t\n" +
            "TMT\t10\t\t\n" +
            "TMT\t11\t\t\n" +
            "TMT\t12\t\t\n" +
            "TMT\t13\t\t\n" +
            "TMT\t14\t\t\n" +
            "TMT\t15\tJHSCALE\t\n" +
            "TMT\t16\t\t\n" +
            "TMT\t17\t\t\n" +
            "TMT\t18\t\t\n" +
            "TMT\t19\t\t\n" +
            "TMT\t20\t\t\n" +
            "TMT\t21\t\t\n" +
            "TMT\t22\t\t\n" +
            "TMT\t23\t\t\n" +
            "TMT\t24\t\t\n" +
            "TMT\t25\t\t\n" +
            "TMT\t26\t\t\n" +
            "TMT\t27\t\t\n" +
            "END\tTMT\t\n" +
            "\n" +
            "DWL\tBAR\t\n" +
            "BAR\t1\tBarcode-1\t0\t0\t0\t0\tB201E500K500A000A000A000\t\n" +
            "BAR\t2\tBarcode-2\t0\t0\t0\t0\tB201F501K500A000A000A000\t\n" +
            "BAR\t3\tBarcode-3\t0\t0\t0\t0\tF701K500A000A000A000A000\t\n" +
            "BAR\t4\tBarcode-4\t0\t0\t0\t0\tB201E400K600A000A000A000\t\n" +
            "BAR\t5\tBarcode-5\t0\t0\t0\t0\tB201F401K600A000A000A000\t\n" +
            "BAR\t6\tBarcode-6\t0\t0\t0\t0\tF601K600A000A000A000A000\t\n" +
            "BAR\t7\tB-Sum 1\t0\t0\t0\t0\tB701L500A000A000A000A000\t\n" +
            "BAR\t8\tB-Sum 2\t0\t0\t0\t0\tB601L600A000A000A000A000\t\n" +
            "BAR\t9\tB-Sum 3\t0\t0\t0\t0\tB501L700A000A000A000A000\t\n" +
            "END\tBAR\t\n" +
            "\n" +
            "DWL\tLAT\t\n" +
            "LAT\t1\tPF-1\t1,1,432,296|5Y2V5Lu3CeWHgOmHjQnmlbDph48J5oC75Lu3CemUgOWUruaXpeacnwnplIDllK7ml7bpl7QJ5pyJ5pWI5pel5pyfCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQ==|0,0,0,0,1,0,5,1,0,88,281,113|1,2,0,0,1,0,5,1,0,240,432,26|2,2,1,0,1,0,5,1,0,266,431,26|3,2,3,0,1,0,5,0,1,220,138,20|4,2,4,0,1,0,5,0,141,220,136,20|5,1,0,6,1,0,5,0,362,0,70,34|6,1,0,0,1,0,5,2,0,0,362,34|7,1,0,1,1,0,5,1,139,60,141,26|8,2,27,0,1,0,5,2,282,60,149,34|9,1,0,4,1,0,5,1,0,60,137,26|10,1,0,15,9,0,5,0,280,220,148,20|11,1,0,16,1,0,5,0,285,94,147,107|12,1,0,24,1,0,4,1,236,34,57,26|13,1,0,25,1,0,4,1,82,34,60,26|14,2,16,0,1,0,4,1,380,34,42,26|15,3,0,0,1,0,6,1,0,34,80,26|16,3,1,0,2,0,6,1,160,34,74,26|17,3,2,0,3,0,6,1,160,34,74,26|18,3,3,0,1,0,6,1,300,34,72,26|19,3,4,0,1,0,5,0,2,202,138,18|20,3,5,0,1,0,5,0,142,202,134,18|21,3,6,0,9,0,5,0,283,202,144,18\t\n" +
            "LAT\t2\tPF-2\t1,1,304,216|5Y2V5Lu3CeWHgOmHjQnmlbDph48J5oC75Lu3CeacieaViOacnwkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQ==|0,0,0,0,1,0,5,0,0,70,242,97|1,2,0,0,1,0,5,1,0,185,304,26|2,2,3,0,1,0,5,0,2,167,100,18|3,2,4,0,1,0,5,0,105,167,80,18|4,1,0,6,1,0,5,0,251,70,53,30|5,1,0,0,1,0,5,1,0,0,304,26|6,1,0,1,1,0,5,0,104,47,91,18|7,2,27,0,1,0,5,1,197,44,107,26|8,1,0,4,1,0,5,0,0,47,104,18|9,1,0,15,9,0,5,0,204,167,100,18|10,1,0,24,1,0,4,0,160,26,50,18|11,1,0,25,1,0,4,0,50,26,50,18|12,2,16,0,1,0,4,0,264,26,30,18|13,3,0,0,1,0,6,0,0,26,50,18|14,3,1,0,2,0,6,0,110,26,50,18|15,3,2,0,3,0,6,0,110,26,50,18|16,3,3,0,1,0,6,0,214,26,50,18|17,3,4,0,9,0,5,0,250,149,54,18\t\n" +
            "LAT\t3\tPF-3\t1,1,432,232|5Y2V5Lu3CeWHgOmHjQnmlbDph48J5oC75Lu3CemUgOWUruaXpeacnwnplIDllK7ml7bpl7QJ5pyJ5pWI5pel5pyfCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQ==|0,0,0,0,1,0,5,1,0,80,281,93|1,2,0,0,1,0,5,2,0,193,431,34|2,2,3,0,1,0,5,0,0,173,138,20|3,2,4,0,1,0,5,0,139,173,136,20|4,1,0,6,1,0,5,0,362,0,70,34|5,1,0,0,1,0,5,2,0,0,362,34|6,1,0,1,1,0,5,1,140,54,141,26|7,2,27,0,1,0,5,2,282,60,149,34|8,1,0,4,1,0,5,1,0,54,137,26|9,1,0,15,9,0,5,0,283,173,148,20|10,1,0,24,1,0,4,1,236,34,57,18|11,1,0,25,1,0,4,1,74,34,60,18|12,2,16,0,1,0,4,1,380,34,42,18|13,3,0,0,1,0,6,1,0,34,70,18|14,3,1,0,2,0,6,1,150,34,74,18|15,3,2,0,3,0,6,1,150,34,74,18|16,3,3,0,1,0,6,1,301,34,72,18|17,3,6,0,9,0,5,0,284,155,145,18\t\n" +
            "LAT\t4\tPF-4\t2,1,432,296|5ZCI6K6h5qCH562+OgnplIDllK7ml6XmnJ8J6ZSA5ZSu5pe26Ze0CeaAu+aVsOmHjwnmgLvlh4Dph40J5oC75Lu3CQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQk=|0,0,0,0,1,0,5,1,2,32,247,143|1,2,0,0,1,0,5,1,0,241,432,26|2,2,1,0,1,0,5,1,0,267,432,26|3,2,3,0,1,0,5,0,6,191,126,18|4,2,4,0,1,0,5,0,131,191,122,18|5,2,27,0,1,0,5,2,316,207,103,34|6,2,6,0,1,0,5,1,84,209,70,32|7,2,7,0,1,0,5,1,236,209,78,32|8,2,5,0,1,0,5,2,177,0,36,32|9,1,1,0,1,0,5,0,252,0,108,18|10,1,2,0,1,0,5,0,252,18,108,18|11,1,3,0,1,0,5,0,252,36,108,18|12,1,4,0,1,0,5,0,252,54,108,18|13,1,5,0,1,0,5,0,252,72,108,18|14,1,6,0,1,0,5,0,252,90,108,18|15,1,7,0,1,0,5,0,252,108,108,18|16,1,8,0,1,0,5,0,252,126,108,18|17,1,9,0,1,0,5,0,252,144,108,18|18,1,10,0,1,0,5,0,252,160,108,18|19,1,1,5,1,0,5,0,360,0,70,18|20,1,2,5,1,0,5,0,360,18,70,18|21,1,3,5,1,0,5,0,360,36,70,18|22,1,4,5,1,0,5,0,360,54,70,18|23,1,5,5,1,0,5,0,360,72,70,18|24,1,6,5,1,0,5,0,360,90,70,18|25,1,7,5,1,0,5,0,360,108,70,18|26,1,8,5,1,0,5,0,360,126,70,18|27,1,9,5,1,0,5,0,360,144,70,18|28,1,10,5,1,0,5,0,360,160,70,18|29,3,0,0,1,0,5,2,13,0,160,32|30,3,1,0,1,0,5,0,15,175,108,16|31,3,2,0,1,0,5,0,135,175,100,16|32,3,3,0,1,0,5,1,5,209,78,32|33,3,4,0,1,0,5,1,156,209,78,32|34,3,5,0,1,0,5,1,332,179,67,26\t\n" +
            "LAT\t5\tPF-5\t2,1,304,216|5ZCI6K6h5qCH562+OgkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQk=|0,0,0,0,1,0,5,1,0,26,224,117|1,2,0,0,1,0,5,1,0,173,303,34|2,2,3,0,1,0,5,0,0,153,110,20|3,2,4,0,1,0,5,0,108,153,103,20|4,2,27,0,1,0,5,1,211,147,92,26|5,2,5,0,1,0,5,1,146,0,36,26|6,1,1,0,1,0,5,0,229,0,74,18|7,1,2,0,1,0,5,0,229,18,74,18|8,1,3,0,1,0,5,0,229,36,74,18|9,1,4,0,1,0,5,0,229,54,74,18|10,1,5,0,1,0,5,0,229,72,74,18|11,1,6,0,1,0,5,0,229,90,74,18|12,1,7,0,1,0,5,0,229,108,74,18|13,1,8,0,1,0,5,0,229,126,74,18|14,3,0,0,1,0,5,1,13,0,130,26\t\n" +
            "LAT\t6\tPF-6\t2,1,432,224|5ZCI6K6h5qCH562+OgkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQk=|0,0,0,0,1,0,5,1,2,35,247,125|1,2,0,0,1,0,5,2,0,182,432,34|2,2,3,0,1,0,5,0,6,161,125,20|3,2,4,0,1,0,5,0,132,161,124,20|4,2,27,0,1,0,5,2,279,146,114,34|5,2,5,0,1,0,5,2,177,0,36,34|6,1,1,0,1,0,5,0,252,0,108,18|7,1,2,0,1,0,5,0,252,18,108,18|8,1,3,0,1,0,5,0,252,36,108,18|9,1,4,0,1,0,5,0,252,54,108,18|10,1,5,0,1,0,5,0,252,72,108,18|11,1,6,0,1,0,5,0,252,90,108,18|12,1,7,0,1,0,5,0,252,108,108,18|13,1,8,0,1,0,5,0,252,126,108,18|14,1,1,5,1,0,5,0,360,0,70,18|15,1,2,5,1,0,5,0,360,18,70,18|16,1,3,5,1,0,5,0,360,36,70,18|17,1,4,5,1,0,5,0,360,54,70,18|18,1,5,5,1,0,5,0,360,72,70,18|19,1,6,5,1,0,5,0,360,90,70,18|20,1,7,5,1,0,5,0,360,108,70,18|21,1,8,5,1,0,5,0,360,126,70,18|22,3,0,0,1,0,5,2,13,0,160,34\t\n" +
            "LAT\t7\tPF-7\t3,1,384,1072|6ZSA5ZSu5pe26Ze0OgktIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLQnllYblk4EJCeWNleS7twnph43ph48v5pWw6YePCemHkeminQnntK/orqE6CeWunuaUtumHkeminToJ5pS26ZO26YeR6aKdOgnmipjoiI3ph5Hpop06CeaJvumbtumHkeminToJ5Y2h5Y6f6aKdOgnljaHkvZnpop06CeWNoeWPtzoJ5Y2V5ZOB5pyN5Yqh6LS5CeacjeWKoei0uQnnqI7pop06CeWPsOWPtzoJ5ZCI6K6h6YeR6aKdOgnljaHmlK/ku5g6CeaUr+S7mDE6CeaUr+S7mDI6CeaUr+S7mDM6CeS8muWRmOenr+WIhjoJ5Y6f5Lu36YeR6aKdOgnoioLnnIHph5Hpop06CeWQieWNoeS6keaUr+S7mDoJCQkJ|0,6,1,0,1,0,192,1,0,0,384,26|1,2,0,0,1,0,192,1,0,26,384,26|2,2,17,0,1,0,192,1,0,52,384,26|3,2,18,0,1,0,192,1,0,78,384,26|4,2,19,0,1,0,192,1,0,104,384,26|5,2,20,0,1,0,192,1,0,130,384,26|6,2,2,0,1,0,4,1,0,156,84,26|7,2,47,0,1,0,4,1,84,156,30,26|8,2,31,0,1,0,5,1,128,156,125,26|9,2,26,0,1,0,5,1,259,156,125,26|10,5,0,0,1,0,0,0,20,182,200,50|11,3,0,0,1,0,4,1,0,182,114,26|12,2,3,0,1,0,0,1,115,182,140,26|13,2,4,0,1,0,6,1,270,182,112,26|14,3,1,0,1,0,192,0,0,208,384,16|15,3,2,0,1,0,4,1,0,224,104,26|16,3,3,0,1,0,5,1,181,224,160,26|17,3,4,0,1,0,4,1,14,250,76,26|18,3,5,0,1,0,5,1,99,250,172,26|19,3,6,0,1,0,5,1,280,250,104,26|20,3,1,0,1,0,192,0,0,276,384,15|21,5,0,0,1,0,0,0,50,291,200,50|22,1,0,0,1,0,4,1,0,291,180,26|23,1,0,38,1,0,6,1,238,291,146,26|24,1,0,31,1,0,4,1,96,317,96,26|25,1,0,4,1,0,5,1,0,317,96,26|26,1,0,1,1,0,4,1,192,317,96,26|27,1,0,26,1,0,6,1,288,317,96,26|28,5,2,0,1,0,0,0,20,343,200,50|29,5,2,0,1,0,0,0,21,395,200,50|30,1,0,19,1,0,4,1,0,395,128,26|31,1,0,20,1,0,5,1,128,395,128,26|32,1,0,21,1,0,6,1,256,395,128,26|33,5,2,0,1,0,0,0,50,421,200,50|34,3,17,0,13,0,4,1,15,421,140,26|35,1,0,29,13,0,5,1,170,421,50,26|36,1,0,27,13,0,6,1,220,421,150,26|37,5,2,0,1,0,0,0,50,447,200,50|38,3,15,0,11,0,4,1,15,447,140,26|39,1,0,28,11,0,6,1,220,447,150,26|40,5,0,0,1,0,0,0,50,473,200,50|41,3,1,0,1,0,192,0,0,473,384,18|42,3,16,0,12,0,4,1,15,491,140,26|43,2,44,0,12,0,6,1,220,491,150,26|44,5,0,0,1,0,0,0,38,517,200,50|45,3,25,0,34,0,4,1,151,517,118,26|46,2,71,0,34,0,5,1,269,517,112,26|47,3,26,0,34,0,4,1,151,543,118,26|48,2,72,0,34,0,5,1,269,543,112,26|49,5,0,0,1,0,0,0,38,569,200,50|50,3,19,0,16,0,4,1,151,569,118,26|51,2,28,0,16,0,5,1,269,569,112,26|52,3,10,0,16,0,4,1,151,595,118,26|53,2,29,0,16,0,5,1,269,595,112,26|54,5,0,0,1,0,0,0,38,621,200,50|55,3,8,0,1,0,5,2,4,621,200,34|56,2,27,0,1,0,5,2,221,621,160,34|57,5,0,0,1,0,0,0,20,655,200,50|58,3,21,0,17,0,4,1,143,655,118,26|59,2,52,0,17,0,5,1,261,655,120,26|60,5,0,0,1,0,0,0,48,681,200,50|61,3,22,0,18,0,4,1,143,681,118,26|62,2,53,0,18,0,5,1,261,681,120,26|63,5,0,0,1,0,0,0,48,707,200,50|64,3,23,0,19,0,4,1,143,707,118,26|65,2,54,0,19,0,5,1,261,707,120,26|66,5,0,0,1,0,0,0,48,733,200,50|67,3,20,0,15,0,4,1,143,733,118,26|68,2,51,0,15,0,5,1,261,733,120,26|69,5,0,0,1,0,0,0,48,759,200,50|70,3,27,0,35,0,4,1,143,759,118,26|71,2,70,0,35,0,5,1,261,759,120,26|72,5,0,0,1,0,0,0,48,785,200,50|73,3,14,0,31,0,4,1,4,785,118,26|74,3,12,0,31,0,4,1,143,785,118,26|75,2,49,0,31,0,5,1,261,785,120,26|76,5,0,0,1,0,0,0,20,811,200,50|77,2,50,0,31,0,5,1,0,811,143,26|78,3,13,0,36,0,4,1,143,811,118,26|79,2,48,0,36,0,5,1,261,811,120,26|80,5,0,0,1,0,0,0,20,837,200,50|81,2,67,0,32,0,4,1,143,837,118,26|82,2,68,0,32,0,5,1,261,837,120,26|83,2,69,0,32,0,198,1,11,863,370,26|84,3,9,0,14,0,4,1,143,889,118,26|85,2,9,0,14,0,5,1,261,889,120,26|86,3,11,0,14,0,4,1,143,915,118,26|87,2,10,0,14,0,5,1,261,915,120,26|88,5,0,0,1,0,0,0,20,941,200,50|89,3,24,0,20,0,4,1,143,941,118,26|90,2,59,0,20,0,5,1,261,941,120,26|91,2,21,0,1,0,192,1,0,967,384,26|92,2,22,0,1,0,192,1,0,993,384,26|93,2,23,0,1,0,192,1,0,1019,384,26|94,2,24,0,1,0,192,1,0,1045,384,26|95,2,73,0,1,0,192,1,0,1071,384,1\t\n" +
            "LAT\t8\tPF-8\t3,1,384,1072|6ZSA5ZSu5pe26Ze0OgktIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLQnllYblk4HlkI3np7AJ5ZWG5ZOB57yW5Y+3CeWNleS7twnph43ph48v5pWw6YePCemHkeminQnntK/orqE6CeWunuaUtumHkeminToJ5pS26ZO26YeR6aKdOgnmipjoiI3ph5Hpop06CeaJvumbtumHkeminToJ5Y2h5Y6f6aKdOgnljaHkvZnpop06CeWNoeWPtzoJ5Y2V5ZOB5pyN5Yqh6LS5CeacjeWKoei0uQnnqI7pop06CeWPsOWPtzoJ5ZCI6K6h6YeR6aKdOgnljaHmlK/ku5g6CeaUr+S7mDE6CeaUr+S7mDI6CeaUr+S7mDM6CeS8muWRmOenr+WIhjoJ5Y6f5Lu36YeR6aKdOgnoioLnnIHph5Hpop06CeWQieWNoeS6keaUr+S7mDoJCQkJ|0,6,1,0,1,0,192,1,0,0,384,26|1,2,0,0,1,0,192,1,0,26,384,26|2,2,17,0,1,0,192,1,0,52,384,26|3,2,18,0,1,0,192,1,0,78,384,26|4,2,19,0,1,0,192,1,0,104,384,26|5,2,20,0,1,0,192,1,0,130,384,26|6,2,2,0,1,0,4,1,0,156,84,26|7,2,47,0,1,0,4,1,84,156,30,26|8,2,31,0,1,0,5,1,128,156,125,26|9,2,26,0,1,0,5,1,259,156,125,26|10,5,0,0,1,0,0,0,20,182,200,50|11,3,0,0,1,0,4,1,0,182,114,26|12,2,3,0,1,0,0,1,115,182,140,26|13,2,4,0,1,0,6,1,270,182,112,26|14,3,1,0,1,0,192,0,0,208,384,16|15,3,2,0,1,0,4,1,0,224,104,26|16,3,3,0,1,0,5,1,181,224,160,26|17,3,4,0,1,0,4,1,14,250,76,26|18,3,5,0,1,0,5,1,99,250,172,26|19,3,6,0,1,0,5,1,280,250,104,26|20,3,1,0,1,0,192,0,0,276,384,15|21,5,0,0,1,0,0,0,50,291,200,50|22,1,0,0,1,0,4,1,0,291,180,26|23,1,0,6,1,0,5,1,180,291,200,26|24,1,0,4,1,0,6,1,0,317,96,26|25,1,0,1,1,0,4,1,192,317,96,26|26,1,0,26,1,0,6,1,288,317,96,26|27,5,2,0,1,0,0,0,20,343,200,50|28,5,2,0,1,0,0,0,21,395,200,50|29,1,0,19,1,0,4,1,0,395,128,26|30,1,0,20,1,0,5,1,128,395,128,26|31,1,0,21,1,0,6,1,256,395,128,26|32,5,2,0,1,0,0,0,50,421,200,50|33,3,17,0,13,0,4,1,15,421,140,26|34,1,0,29,13,0,5,1,170,421,50,26|35,1,0,27,13,0,6,1,220,421,150,26|36,5,2,0,1,0,0,0,50,447,200,50|37,3,15,0,11,0,4,1,15,447,140,26|38,1,0,28,11,0,6,1,220,447,150,26|39,5,0,0,1,0,0,0,50,473,200,50|40,3,1,0,1,0,192,0,0,473,384,18|41,3,16,0,12,0,4,1,15,491,140,26|42,2,44,0,12,0,6,1,220,491,150,26|43,5,0,0,1,0,0,0,38,517,200,50|44,3,25,0,34,0,4,1,151,517,118,26|45,2,71,0,34,0,5,1,269,517,112,26|46,3,26,0,34,0,4,1,151,543,118,26|47,2,72,0,34,0,5,1,269,543,112,26|48,5,0,0,1,0,0,0,38,569,200,50|49,3,19,0,16,0,4,1,151,569,118,26|50,2,28,0,16,0,5,1,269,569,112,26|51,3,10,0,16,0,4,1,151,595,118,26|52,2,29,0,16,0,5,1,269,595,112,26|53,5,0,0,1,0,0,0,38,621,200,50|54,3,8,0,1,0,5,2,4,621,200,34|55,2,27,0,1,0,5,2,221,621,160,34|56,5,0,0,1,0,0,0,20,655,200,50|57,3,21,0,17,0,4,1,143,655,118,26|58,2,52,0,17,0,5,1,261,655,120,26|59,5,0,0,1,0,0,0,48,681,200,50|60,3,22,0,18,0,4,1,143,681,118,26|61,2,53,0,18,0,5,1,261,681,120,26|62,5,0,0,1,0,0,0,48,707,200,50|63,3,23,0,19,0,4,1,143,707,118,26|64,2,54,0,19,0,5,1,261,707,120,26|65,5,0,0,1,0,0,0,48,733,200,50|66,3,20,0,15,0,4,1,143,733,118,26|67,2,51,0,15,0,5,1,261,733,120,26|68,5,0,0,1,0,0,0,48,759,200,50|69,3,27,0,35,0,4,1,143,759,118,26|70,2,70,0,35,0,5,1,261,759,120,26|71,5,0,0,1,0,0,0,48,785,200,50|72,3,14,0,31,0,4,1,4,785,118,26|73,3,12,0,31,0,4,1,143,785,118,26|74,2,49,0,31,0,5,1,261,785,120,26|75,5,0,0,1,0,0,0,20,811,200,50|76,2,50,0,31,0,5,1,0,811,143,26|77,3,13,0,36,0,4,1,143,811,118,26|78,2,48,0,36,0,5,1,261,811,120,26|79,5,0,0,1,0,0,0,20,837,200,50|80,2,67,0,32,0,4,1,143,837,118,26|81,2,68,0,32,0,5,1,261,837,120,26|82,2,69,0,32,0,198,1,11,863,370,26|83,3,9,0,14,0,4,1,143,889,118,26|84,2,9,0,14,0,5,1,261,889,120,26|85,3,11,0,14,0,4,1,143,915,118,26|86,2,10,0,14,0,5,1,261,915,120,26|87,5,0,0,1,0,0,0,20,941,200,50|88,3,24,0,20,0,4,1,143,941,118,26|89,2,59,0,20,0,5,1,261,941,120,26|90,2,21,0,1,0,192,1,0,967,384,26|91,2,22,0,1,0,192,1,0,993,384,26|92,2,23,0,1,0,192,1,0,1019,384,26|93,2,24,0,1,0,192,1,0,1045,384,26\t\n" +
            "LAT\t9\tPF-9\t3,1,384,1072|6ZSA5ZSu5pe26Ze0OgktIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLSAtIC0gLQnllYblk4EJCeWNleS7twnph43ph48v5pWw6YePCemHkeminQnntK/orqE6CeWunuaUtumHkeminToJ5pS26ZO26YeR6aKdOgnmipjoiI3ph5Hpop06CeaJvumbtumHkeminToJ5Y2h5Y6f6aKdOgnljaHkvZnpop06CeWNoeWPtzoJ5Y2V5ZOB5pyN5Yqh6LS5CeacjeWKoei0uQnnqI7pop06CeWPsOWPtzoJ5ZCI6K6h6YeR6aKdOgnljaHmlK/ku5g6CeaUr+S7mDE6CeaUr+S7mDI6CeaUr+S7mDM6CeS8muWRmOenr+WIhjoJ5Y6f5Lu36YeR6aKdOgnoioLnnIHph5Hpop06CeWQieWNoeS6keaUr+S7mDoJCQkJ|0,6,1,0,1,0,192,1,0,0,384,26|1,2,0,0,1,0,192,1,0,26,384,26|2,2,17,0,1,0,192,1,0,52,384,26|3,2,18,0,1,0,192,1,0,78,384,26|4,2,19,0,1,0,192,1,0,104,384,26|5,2,20,0,1,0,192,1,0,130,384,26|6,2,2,0,1,0,4,1,0,156,84,26|7,2,47,0,1,0,4,1,84,156,30,26|8,2,31,0,1,0,5,1,128,156,125,26|9,2,26,0,1,0,5,1,259,156,125,26|10,5,0,0,1,0,0,0,20,182,200,50|11,3,0,0,1,0,4,1,0,182,114,26|12,2,3,0,1,0,0,1,115,182,140,26|13,2,4,0,1,0,6,1,270,182,112,26|14,3,1,0,1,0,192,0,0,208,384,16|15,3,2,0,1,0,4,1,0,224,104,26|16,3,3,0,1,0,5,1,181,224,160,26|17,3,4,0,1,0,4,1,14,250,76,26|18,3,5,0,1,0,5,1,99,250,172,26|19,3,6,0,1,0,5,1,280,250,104,26|20,3,1,0,1,0,192,0,0,276,384,15|21,5,0,0,1,0,0,0,50,291,200,50|22,1,0,0,1,0,4,1,0,291,180,26|23,1,0,38,1,0,6,1,238,291,146,26|24,1,0,31,1,0,4,1,96,317,96,26|25,1,0,4,1,0,5,1,0,317,96,26|26,1,0,1,1,0,4,1,192,317,96,26|27,1,0,26,1,0,6,1,288,317,96,26|28,5,2,0,1,0,0,0,20,343,200,50|29,5,2,0,1,0,0,0,21,395,200,50|30,1,0,19,1,0,4,1,0,395,128,26|31,1,0,20,1,0,5,1,128,395,128,26|32,1,0,21,1,0,6,1,256,395,128,26|33,5,2,0,1,0,0,0,50,421,200,50|34,3,17,0,13,0,4,1,15,421,140,26|35,1,0,29,13,0,5,1,170,421,50,26|36,1,0,27,13,0,6,1,220,421,150,26|37,5,2,0,1,0,0,0,50,447,200,50|38,3,15,0,11,0,4,1,15,447,140,26|39,1,0,28,11,0,6,1,220,447,150,26|40,5,0,0,1,0,0,0,50,473,200,50|41,3,1,0,1,0,192,0,0,473,384,18|42,3,16,0,12,0,4,1,15,491,140,26|43,2,44,0,12,0,6,1,220,491,150,26|44,5,0,0,1,0,0,0,38,517,200,50|45,3,25,0,34,0,4,1,151,517,118,26|46,2,71,0,34,0,5,1,269,517,112,26|47,3,26,0,34,0,4,1,151,543,118,26|48,2,72,0,34,0,5,1,269,543,112,26|49,5,0,0,1,0,0,0,38,569,200,50|50,3,19,0,16,0,4,1,151,569,118,26|51,2,28,0,16,0,5,1,269,569,112,26|52,3,10,0,16,0,4,1,151,595,118,26|53,2,29,0,16,0,5,1,269,595,112,26|54,5,0,0,1,0,0,0,38,621,200,50|55,3,8,0,1,0,5,2,4,621,200,34|56,2,27,0,1,0,5,2,221,621,160,34|57,5,0,0,1,0,0,0,20,655,200,50|58,3,21,0,17,0,4,1,143,655,118,26|59,2,52,0,17,0,5,1,261,655,120,26|60,5,0,0,1,0,0,0,48,681,200,50|61,3,22,0,18,0,4,1,143,681,118,26|62,2,53,0,18,0,5,1,261,681,120,26|63,5,0,0,1,0,0,0,48,707,200,50|64,3,23,0,19,0,4,1,143,707,118,26|65,2,54,0,19,0,5,1,261,707,120,26|66,5,0,0,1,0,0,0,48,733,200,50|67,3,20,0,15,0,4,1,143,733,118,26|68,2,51,0,15,0,5,1,261,733,120,26|69,5,0,0,1,0,0,0,48,759,200,50|70,3,27,0,35,0,4,1,143,759,118,26|71,2,70,0,35,0,5,1,261,759,120,26|72,5,0,0,1,0,0,0,48,785,200,50|73,3,14,0,31,0,4,1,4,785,118,26|74,3,12,0,31,0,4,1,143,785,118,26|75,2,49,0,31,0,5,1,261,785,120,26|76,5,0,0,1,0,0,0,20,811,200,50|77,2,50,0,31,0,5,1,0,811,143,26|78,3,13,0,36,0,4,1,143,811,118,26|79,2,48,0,36,0,5,1,261,811,120,26|80,5,0,0,1,0,0,0,20,837,200,50|81,2,67,0,32,0,4,1,143,837,118,26|82,2,68,0,32,0,5,1,261,837,120,26|83,2,69,0,32,0,198,1,11,863,370,26|84,3,9,0,14,0,4,1,143,889,118,26|85,2,9,0,14,0,5,1,261,889,120,26|86,3,11,0,14,0,4,1,143,915,118,26|87,2,10,0,14,0,5,1,261,915,120,26|88,5,0,0,1,0,0,0,20,941,200,50|89,3,24,0,20,0,4,1,143,941,118,26|90,2,59,0,20,0,5,1,261,941,120,26|91,2,21,0,1,0,192,1,0,967,384,26|92,2,22,0,1,0,192,1,0,993,384,26|93,2,23,0,1,0,192,1,0,1019,384,26|94,2,24,0,1,0,192,1,0,1045,384,26\t\n" +
            "END\tLAT\t\n" +
            "\n" +
            "#TMS_Max\t0\t999\t\n" +
            "#TMS_Max\t1\t999\t\n" +
            "#TMS_Max\t2\t9999999\t\n" +
            "#TMS_Max\t3\t99\t\n" +
            "#TMS_Max\t4\t1\t\n" +
            "#TMS_Max\t5\t999\t\n" +
            "#TMS_Max\t6\t999\t\n" +
            "#TMS_Max\t7\t9999999\t\n" +
            "#TMS_Max\t8\t99\t\n" +
            "#TMS_Max\t9\t1\t\n" +
            "#TMS_Max\t10\t999\t\n" +
            "#TMS_Max\t11\t999\t\n" +
            "#TMS_Max\t12\t9999999\t\n" +
            "#TMS_Max\t13\t99\t\n" +
            "#TMS_Max\t14\t1\t\n" +
            "#TMS_Max\t15\t999\t\n" +
            "#TMS_Max\t16\t999\t\n" +
            "#TMS_Max\t17\t9999999\t\n" +
            "#TMS_Max\t18\t99\t\n" +
            "#TMS_Max\t19\t1\t\n" +
            "#TMS_Max\t20\t999\t\n" +
            "#TMS_Max\t21\t1\t\n" +
            "#TMS_Max\t22\t15\t\n" +
            "#TMS_Max\t23\t16\t\n" +
            "#TMS_Max\t24\t99\t\n" +
            "#TMS_Max\t25\t99\t\n" +
            "#TMS_Max\t26\t1999\t\n" +
            "#TMS_Max\t27\t99\t\n" +
            "#TMS_Max\t28\t5\t\n" +
            "#TMS_Max\t29\t30\t\n" +
            "#TMS_Max\t30\t999\t\n" +
            "#TMS_Max\t31\t9\t\n" +
            "#TMS_Max\t32\t19\t\n" +
            "#TMS_Max\t33\t3\t\n" +
            "#TMS_Max\t34\t19\t\n" +
            "#TMS_Max\t35\t1\t\n" +
            "#TMS_Max\t36\t2\t\n" +
            "#TMS_Max\t37\t31\t\n" +
            "#TMS_Max\t38\t31\t\n" +
            "#TMS_Max\t39\t1999\t\n" +
            "#TMS_Max\t40\t9999999\t\n" +
            "#TMS_Max\t41\t9\t\n" +
            "#TMS_Max\t42\t2\t\n" +
            "#TMS_Max\t43\t2\t\n" +
            "#TMS_Max\t44\t65535\t\n" +
            "#TMS_Max\t45\t1\t\n" +
            "#TMS_Max\t46\t9999999\t\n" +
            "#TMS_Max\t47\t1\t\n" +
            "#TMS_Max\t48\t31\t\n" +
            "#TMS_Max\t49\t1\t\n" +
            "#TMS_Max\t50\t7\t\n" +
            "#TMS_Max\t51\t2\t\n" +
            "#TMS_Max\t52\t0\t\n" +
            "#TMS_Max\t53\t0\t\n" +
            "#TMS_Max\t54\t99\t\n" +
            "#TMS_Max\t55\t99\t\n" +
            "#TMS_Max\t56\t9\t\n" +
            "#TMS_Max\t57\t99\t\n" +
            "#TMS_Max\t58\t3\t\n" +
            "#TMS_Max\t59\t1\t\n" +
            "#TMS_Max\t60\t3\t\n" +
            "#TMS_Max\t61\t16777215\t\n" +
            "#TMS_Max\t62\t4\t\n" +
            "#TMS_Max\t63\t3\t\n" +
            "#TMS_Max\t64\t3\t\n" +
            "#TMS_Max\t65\t6\t\n" +
            "#TMS_Max\t66\t99\t\n" +
            "#TMS_Max\t67\t2\t\n" +
            "#TMS_Max\t68\t3\t\n" +
            "#TMS_Max\t69\t4\t\n" +
            "#TMS_Max\t70\t1\t\n" +
            "#TMS_Max\t71\t2\t\n" +
            "#TMS_Max\t72\t1\t\n" +
            "#TMS_Max\t73\t1\t\n" +
            "#TMS_Max\t74\t9999\t\n" +
            "#TMS_Max\t75\t3\t\n" +
            "#TMS_Max\t76\t3\t\n" +
            "#TMS_Max\t77\t3\t\n" +
            "#TMS_Max\t78\t4\t\n" +
            "#TMS_Max\t79\t1\t\n" +
            "#TMS_Max\t80\t1\t\n" +
            "#TMS_Max\t81\t3\t\n" +
            "#TMS_Max\t82\t2\t\n" +
            "#TMS_Max\t83\t4\t\n" +
            "#TMS_Max\t84\t1\t\n" +
            "#TMS_Max\t85\t99\t\n" +
            "#TMS_Max\t86\t99\t\n" +
            "#TMS_Max\t87\t0\t\n" +
            "#TMS_Max\t88\t9999999\t\n" +
            "#TMS_Max\t89\t1\t\n" +
            "#TMS_Max\t90\t1\t\n" +
            "#TMS_Max\t91\t2\t\n" +
            "#TMS_Max\t92\t3\t\n" +
            "#TMS_Max\t93\t9999999\t\n" +
            "#TMS_Max\t94\t9999999\t\n" +
            "#TMS_Max\t95\t9999999\t\n" +
            "#TMS_Max\t96\t2\t\n" +
            "#TMS_Max\t97\t1\t\n" +
            "#TMS_Max\t98\t5\t\n" +
            "#TMS_Max\t99\t5\t\n" +
            "#TMS_Max\t100\t11\t\n" +
            "#TMS_Max\t101\t11\t\n" +
            "#TMS_Max\t102\t1\t\n" +
            "#TMS_Max\t103\t3\t\n" +
            "#TMS_Max\t104\t255\t\n" +
            "#TMS_Max\t105\t7\t\n" +
            "#TMS_Max\t106\t999\t\n" +
            "#TMS_Max\t107\t99\t\n" +
            "#TMS_Max\t108\t65535\t\n" +
            "#TMS_Max\t109\t1\t\n" +
            "#TMS_Max\t110\t3\t\n" +
            "#TMS_Max\t111\t255\t\n" +
            "#TMS_Max\t112\t255\t\n" +
            "#TMS_Max\t113\t2\t\n" +
            "#TMS_Max\t114\t99\t\n" +
            "#TMS_Max\t115\t3\t\n" +
            "#TMS_Max\t116\t3\t\n" +
            "#TMS_Max\t117\t9999\t\n" +
            "#TMS_Max\t118\t4\t\n" +
            "#TMS_Max\t119\t2\t\n" +
            "#TMS_Max\t120\t3\t\n" +
            "#TMS_Max\t121\t2\t\n" +
            "#TMS_Max\t122\t99\t\n" +
            "#TMS_Max\t123\t9999999\t\n" +
            "#TMS_Max\t124\t99\t\n" +
            "#TMS_Max\t125\t9999999\t\n" +
            "#TMS_Max\t126\t99\t\n" +
            "#TMS_Max\t127\t9999999\t\n" +
            "#TMS_Max\t128\t99\t\n" +
            "#TMS_Max\t129\t9999999\t\n" +
            "#TMS_Max\t130\t99\t\n" +
            "#TMS_Max\t131\t8\t\n" +
            "#TMS_Max\t132\t2\t\n" +
            "#TMS_Max\t133\t2\t\n" +
            "#TMS_Max\t134\t2\t\n" +
            "#TMS_Max\t135\t6\t\n" +
            "#TMS_Max\t136\t2\t\n" +
            "#TMS_Max\t137\t2\t\n" +
            "#TMS_Max\t138\t65535\t\n" +
            "#TMS_Max\t139\t2\t\n" +
            "#TMS_Max\t140\t6\t\n" +
            "#TMS_Max\t141\t2\t\n" +
            "#TMS_Max\t142\t0\t\n" +
            "#TMS_Max\t143\t29\t\n" +
            "#TMS_Max\t144\t3\t\n" +
            "#TMS_Max\t145\t9999999\t\n" +
            "#TMS_Max\t146\t9999999\t\n" +
            "#TMS_Max\t147\t0\t\n" +
            "#TMS_Max\t148\t1\t\n" +
            "#TMS_Max\t149\t3\t\n" +
            "#TMS_Max\t150\t255\t\n" +
            "#TMS_Max\t151\t255\t\n" +
            "#TMS_Max\t152\t255\t\n" +
            "#TMS_Max\t153\t255\t\n" +
            "#TMS_Max\t154\t255\t\n" +
            "#TMS_Max\t155\t255\t\n" +
            "#TMS_Max\t156\t255\t\n" +
            "#TMS_Max\t157\t255\t\n" +
            "#TMS_Max\t158\t255\t\n" +
            "#TMS_Max\t159\t255\t\n" +
            "#TMS_Max\t160\t255\t\n" +
            "#TMS_Max\t161\t255\t\n" +
            "#TMS_Max\t162\t255\t\n" +
            "#TMS_Max\t163\t255\t\n" +
            "#TMS_Max\t164\t255\t\n" +
            "#TMS_Max\t165\t255\t\n" +
            "#TMS_Max\t166\t65535\t\n" +
            "#TMS_Max\t167\t65535\t\n" +
            "#TMS_Max\t168\t65535\t\n" +
            "#TMS_Max\t169\t65535\t\n" +
            "#TMS_Max\t170\t255\t\n" +
            "#TMS_Max\t171\t255\t\n" +
            "#TMS_Max\t172\t255\t\n" +
            "#TMS_Max\t173\t255\t\n" +
            "#TMS_Max\t174\t0\t\n" +
            "#TMS_Max\t175\t0\t\n" +
            "#TMS_Max\t176\t0\t\n" +
            "#TMS_Max\t177\t0\t\n" +
            "#TMS_Max\t178\t0\t\n" +
            "#TMS_Max\t179\t9\t\n" +
            "#TMS_Max\t180\t1\t\n" +
            "#TMS_Max\t181\t3\t\n" +
            "#TMS_Max\t182\t1\t\n" +
            "#TMS_Max\t183\t0\t\n" +
            "#TMS_Max\t184\t0\t\n" +
            "#TMS_Max\t185\t1\t\n" +
            "#TMS_Max\t186\t1\t\n" +
            "#TMS_Max\t187\t1\t\n" +
            "#TMS_Max\t188\t6\t\n" +
            "#TMS_Max\t189\t7\t\n" +
            "#TMS_Max\t190\t3\t\n" +
            "#TMS_Max\t191\t3\t\n" +
            "#TMS_Max\t192\t31\t\n" +
            "#TMS_Max\t193\t2\t\n" +
            "#TMS_Max\t194\t7\t\n" +
            "#TMS_Max\t195\t7\t\n" +
            "#TMS_Max\t196\t5\t\n" +
            "#TMS_Max\t197\t4\t\n" +
            "#TMS_Max\t198\t19\t\n" +
            "#TMS_Max\t199\t19\t\n" +
            "#TMS_Max\t200\t3\t\n" +
            "#TMS_Max\t201\t3\t\n" +
            "#TMS_Max\t202\t5\t\n" +
            "#TMS_Max\t203\t5\t\n" +
            "#TMS_Max\t204\t1\t\n" +
            "#TMS_Max\t205\t1\t\n" +
            "#TMS_Max\t206\t3\t\n" +
            "#TMS_Max\t207\t2\t\n" +
            "#TMS_Max\t208\t5\t\n" +
            "#TMS_Max\t209\t5\t\n" +
            "#TMS_Max\t210\t9\t\n" +
            "#TMS_Max\t211\t9\t\n" +
            "#TMS_Max\t212\t9\t\n" +
            "#TMS_Max\t213\t3\t\n" +
            "#TMS_Max\t214\t1\t\n" +
            "#TMS_Max\t215\t9999999\t\n" +
            "#TMS_Max\t216\t9999999\t\n" +
            "#TMS_Max\t217\t99\t\n" +
            "#TMS_Max\t218\t9999999\t\n" +
            "#TMS_Max\t219\t255\t\n" +
            "#TMS_Max\t220\t255\t\n" +
            "#TMS_Max\t221\t99\t\n" +
            "#TMS_Max\t222\t99\t\n" +
            "#TMS_Max\t223\t255\t\n" +
            "#TMS_Max\t224\t99\t\n" +
            "#TMS_Max\t225\t99\t\n" +
            "#TMS_Max\t226\t3\t\n" +
            "#TMS_Max\t227\t2\t\n" +
            "#TMS_Max\t228\t5\t\n" +
            "#TMS_Max\t229\t2\t\n" +
            "#TMS_Max\t230\t31\t\n" +
            "#TMS_Max\t231\t1\t\n" +
            "#TMS_Max\t232\t2\t\n" +
            "#TMS_Max\t233\t1\t\n" +
            "#TMS_Max\t234\t31\t\n" +
            "#TMS_Max\t235\t2\t\n" +
            "#TMS_Max\t236\t15\t\n" +
            "#TMS_Max\t237\t4\t\n" +
            "#TMS_Max\t238\t7\t\n" +
            "#TMS_Max\t239\t9999\t\n" +
            "#TMS_Max\t240\t64\t\n" +
            "#TMS_Max\t241\t1\t\n" +
            "#TMS_Max\t242\t31\t\n" +
            "#TMS_Max\t243\t3\t\n" +
            "#TMS_Max\t244\t1\t\n" +
            "#TMS_Max\t245\t3\t\n" +
            "#TMS_Max\t246\t255\t\n" +
            "#TMS_Max\t247\t3\t\n" +
            "#TMS_Max\t248\t255\t\n" +
            "#TMS_Max\t249\t4\t\n" +
            "#TMS_Max\t250\t2\t\n" +
            "#TMS_Max\t251\t4\t\n" +
            "#TMS_Max\t252\t4\t\n" +
            "#TMS_Max\t253\t1\t\n" +
            "#TMS_Max\t254\t3\t\n" +
            "#TMS_Max\t255\t11\t\n" +
            "#TMS_Max\t256\t6\t\n" +
            "#TMS_Max\t257\t7\t\n" +
            "#TMS_Max\t258\t31\t\n" +
            "#TMS_Max\t259\t15\t\n" +
            "#TMS_Max\t260\t31\t\n" +
            "#TMS_Max\t261\t15\t\n" +
            "#TMS_Max\t262\t15\t\n" +
            "#TMS_Max\t263\t9999999\t\n" +
            "#TMS_Max\t264\t15\t\n" +
            "#TMS_Max\t265\t1\t\n" +
            "#TMS_Max\t266\t1\t\n" +
            "#TMS_Max\t267\t1\t\n" +
            "#TMS_Max\t268\t1\t\n" +
            "#TMS_Max\t269\t255\t\n" +
            "#TMS_Max\t270\t5\t\n" +
            "#TMS_Max\t271\t1\t\n" +
            "#TMS_Max\t272\t31\t\n" +
            "#TMS_Max\t273\t5\t\n" +
            "#TMS_Max\t274\t9999999\t\n" +
            "#TMS_Max\t275\t2\t\n" +
            "#TMS_Max\t276\t31\t\n" +
            "#TMS_Max\t277\t4\t\n" +
            "#TMS_Max\t278\t99\t\n" +
            "#TMS_Max\t279\t3\t\n" +
            "#TMS_Max\t280\t1\t\n" +
            "#TMS_Max\t281\t31\t\n" +
            "#TMS_Max\t282\t65535\t\n" +
            "#TMS_Max\t283\t3\t\n" +
            "#TMS_Max\t284\t31\t\n" +
            "#TMS_Max\t285\t2\t\n" +
            "#TMS_Max\t286\t3\t\n" +
            "#TMS_Max\t287\t255\t\n" +
            "#TMS_Max\t288\t255\t\n" +
            "#TMS_Max\t289\t99\t\n" +
            "#TMS_Max\t290\t99\t\n" +
            "#TMS_Max\t291\t99\t\n" +
            "#TMS_Max\t292\t99\t\n" +
            "#TMS_Max\t293\t99\t\n" +
            "#TMS_Max\t294\t15\t\n" +
            "#TMS_Max\t295\t15\t\n" +
            "#TMS_Max\t296\t4\t\n" +
            "#TMS_Max\t297\t2147483647\t\n" +
            "#TMS_Max\t298\t5\t\n" +
            "#TMS_Max\t299\t0\t\n" +
            "#TMS_Max\t300\t2\t\n" +
            "#TMS_Max\t301\t2\t\n" +
            "#TMS_Max\t302\t5\t\n" +
            "#TMS_Max\t303\t9999\t\n" +
            "#TMS_Max\t304\t1\t\n" +
            "#TMS_Max\t305\t3\t\n" +
            "#TMS_Max\t306\t9999\t\n" +
            "#TMS_Max\t307\t1\t\n" +
            "#TMS_Max\t308\t1\t\n" +
            "#TMS_Max\t309\t0\t\n" +
            "#TMS_Max\t310\t0\t\n" +
            "#TMS_Max\t311\t0\t\n" +
            "#TMS_Max\t312\t0\t\n" +
            "#TMS_Max\t313\t0\t\n" +
            "#TMS_Max\t314\t0\t\n" +
            "#TMS_Max\t315\t0\t\n" +
            "#TMS_Max\t316\t0\t\n" +
            "#TMS_Max\t317\t0\t\n" +
            "#TMS_Max\t318\t9999999\t\n" +
            "#TMS_Max\t319\t9999999\t\n" +
            "#TMS_Max\t320\t1\t\n" +
            "#TMS_Max\t321\t15\t\n" +
            "#TMS_Max\t322\t0\t\n" +
            "#TMS_Max\t323\t0\t\n" +
            "#TMS_Max\t324\t0\t\n" +
            "#TMS_Max\t325\t0\t\n" +
            "#TMS_Max\t326\t0\t\n" +
            "#TMS_Max\t327\t0\t\n" +
            "#TMS_Max\t328\t0\t\n" +
            "#TMS_Max\t329\t0\t\n" +
            "#TMS_Max\t330\t255\t\n" +
            "#TMS_Max\t331\t255\t\n" +
            "#TMS_Max\t332\t255\t\n" +
            "#TMS_Max\t333\t255\t\n" +
            "#TMS_Max\t334\t255\t\n" +
            "#TMS_Max\t335\t255\t\n" +
            "#TMS_Max\t336\t65535\t\n" +
            "#TMS_Max\t337\t0\t\n" +
            "#TMS_Max\t338\t0\t\n" +
            "#TMS_Max\t339\t0\t\n" +
            "#TMS_Max\t340\t15\t\n" +
            "#TMS_Max\t341\t31\t\n" +
            "#TMS_Max\t342\t0\t\n" +
            "#TMS_Max\t343\t0\t\n" +
            "#TMS_Max\t344\t0\t\n" +
            "#TMS_Max\t345\t0\t\n" +
            "#TMS_Max\t346\t0\t\n" +
            "#TMS_Max\t347\t0\t\n" +
            "#TMS_Max\t348\t0\t\n" +
            "#TMS_Max\t349\t0\t\n" +
            "#TMS_Max\t350\t99\t\n" +
            "#TMS_Max\t351\t99\t\n" +
            "#TMS_Max\t352\t9999999\t\n" +
            "#TMS_Max\t353\t99\t\n" +
            "#TMS_Max\t354\t1\t\n" +
            "#TMS_Max\t355\t99\t\n" +
            "#TMS_Max\t356\t99\t\n" +
            "#TMS_Max\t357\t9999999\t\n" +
            "#TMS_Max\t358\t99\t\n" +
            "#TMS_Max\t359\t1\t\n" +
            "#TMS_Max\t360\t255\t\n" +
            "#TMS_Max\t361\t3\t\n" +
            "#TMS_Max\t362\t20\t\n" +
            "#TMS_Max\t363\t65535\t\n" +
            "#TMS_Max\t364\t255\t\n" +
            "#TMS_Max\t365\t255\t\n" +
            "#TMS_Max\t366\t255\t\n" +
            "#TMS_Max\t367\t255\t\n" +
            "#TMS_Max\t368\t255\t\n" +
            "#TMS_Max\t369\t255\t\n" +
            "#TMS_Max\t370\t255\t\n" +
            "#TMS_Max\t371\t255\t\n" +
            "#TMS_Max\t372\t255\t\n" +
            "#TMS_Max\t373\t255\t\n" +
            "#TMS_Max\t374\t255\t\n" +
            "#TMS_Max\t375\t255\t\n" +
            "#TMS_Max\t376\t65535\t\n" +
            "#TMS_Max\t377\t65535\t\n" +
            "#TMS_Max\t378\t65535\t\n" +
            "#TMS_Max\t379\t65535\t\n" +
            "#TMS_Max\t380\t0\t\n" +
            "#TMS_Max\t381\t0\t\n" +
            "#TMS_Max\t382\t0\t\n" +
            "#TMS_Max\t383\t0\t\n" +
            "#TMS_Max\t384\t0\t\n" +
            "#TMS_Max\t385\t0\t\n" +
            "#TMS_Max\t386\t0\t\n" +
            "#TMS_Max\t387\t0\t\n" +
            "#TMS_Max\t388\t0\t\n" +
            "#TMS_Max\t389\t0\t\n" +
            "#TMS_Max\t390\t0\t\n" +
            "#TMS_Max\t391\t0\t\n" +
            "#TMS_Max\t392\t0\t\n" +
            "#TMS_Max\t393\t0\t\n" +
            "#TMS_Max\t394\t0\t\n" +
            "#TMS_Max\t395\t0\t\n" +
            "#TMS_Max\t396\t0\t\n" +
            "#TMS_Max\t397\t0\t\n" +
            "#TMS_Max\t398\t0\t\n" +
            "#TMS_Max\t399\t0\t\n" +
            "#TMS_Max\t400\t99\t\n" +
            "#TMS_Max\t401\t1\t\n" +
            "#TMS_Max\t402\t15\t\n" +
            "#TMS_Max\t403\t15\t\n" +
            "#TMS_Max\t404\t99\t\n" +
            "#TMS_Max\t405\t99\t\n" +
            "#TMS_Max\t406\t99\t\n" +
            "#TMS_Max\t407\t99\t\n" +
            "#TMS_Max\t408\t5\t\n" +
            "#TMS_Max\t409\t30\t\n" +
            "#TMS_Max\t410\t999\t\n" +
            "#TMS_Max\t411\t9\t\n" +
            "#TMS_Max\t412\t19\t\n" +
            "#TMS_Max\t413\t2\t\n" +
            "#TMS_Max\t414\t0\t\n" +
            "#TMS_Max\t415\t1\t\n" +
            "#TMS_Max\t416\t2\t\n" +
            "#TMS_Max\t417\t31\t\n" +
            "#TMS_Max\t418\t31\t\n" +
            "#TMS_Max\t419\t1999\t\n" +
            "#TMS_Max\t420\t1\t\n" +
            "#TMS_Max\t421\t1\t\n" +
            "#TMS_Max\t422\t255\t\n" +
            "#TMS_Max\t423\t0\t\n" +
            "#TMS_Max\t424\t0\t\n" +
            "#TMS_Max\t425\t0\t\n" +
            "#TMS_Max\t426\t0\t\n" +
            "#TMS_Max\t427\t0\t\n" +
            "#TMS_Max\t428\t0\t\n" +
            "#TMS_Max\t429\t0\t\n" +
            "#TMS_Max\t430\t255\t\n" +
            "#TMS_Max\t431\t255\t\n" +
            "#TMS_Max\t432\t255\t\n" +
            "#TMS_Max\t433\t255\t\n" +
            "#TMS_Max\t434\t255\t\n" +
            "#TMS_Max\t435\t255\t\n" +
            "#TMS_Max\t436\t255\t\n" +
            "#TMS_Max\t437\t255\t\n" +
            "#TMS_Max\t438\t255\t\n" +
            "#TMS_Max\t439\t255\t\n" +
            "#TMS_Max\t440\t255\t\n" +
            "#TMS_Max\t441\t255\t\n" +
            "#TMS_Max\t442\t0\t\n" +
            "#TMS_Max\t443\t0\t\n" +
            "#TMS_Max\t444\t0\t\n" +
            "#TMS_Max\t445\t0\t\n" +
            "#TMS_Max\t446\t0\t\n" +
            "#TMS_Max\t447\t0\t\n" +
            "#TMS_Max\t448\t2147483647\t\n" +
            "#TMS_Max\t449\t3\t\n" +
            "#TMS_Max\t450\t9\t\n" +
            "#TMS_Max\t451\t30\t\n" +
            "#TMS_Max\t452\t99\t\n" +
            "#TMS_Max\t453\t6\t\n" +
            "#TMS_Max\t454\t18\t\n" +
            "#TMS_Max\t455\t3\t\n" +
            "#TMS_Max\t456\t31\t\n" +
            "#TMS_Max\t457\t6\t\n" +
            "#TMS_Max\t458\t0\t\n" +
            "#TMS_Max\t459\t0\t\n" +
            "#TMS_Max\t460\t0\t\n" +
            "#TMS_Max\t461\t0\t\n" +
            "#TMS_Max\t462\t0\t\n" +
            "#TMS_Max\t463\t0\t\n" +
            "#TMS_Max\t464\t0\t\n" +
            "#TMS_Max\t465\t0\t\n" +
            "#TMS_Max\t466\t0\t\n" +
            "#TMS_Max\t467\t0\t\n" +
            "#TMS_Max\t468\t0\t\n" +
            "#TMS_Max\t469\t0\t\n" +
            "#TMS_Max\t470\t0\t\n" +
            "#TMS_Max\t471\t0\t\n" +
            "#TMS_Max\t472\t0\t\n" +
            "#TMS_Max\t473\t0\t\n" +
            "#TMS_Max\t474\t0\t\n" +
            "#TMS_Max\t475\t0\t\n" +
            "#TMS_Max\t476\t0\t\n" +
            "#TMS_Max\t477\t2147483647\t\n" +
            "#TMS_Max\t478\t2147483647\t\n" +
            "#TMS_Max\t479\t2147483647\t\n" +
            "#TMS_Max\t480\t2147483647\t\n" +
            "#TMS_Max\t481\t2147483647\t\n" +
            "#TMS_Max\t482\t2147483647\t\n" +
            "#TMS_Max\t483\t2147483647\t\n" +
            "#TMS_Max\t484\t2147483647\t\n" +
            "#TMS_Max\t485\t2147483647\t\n" +
            "#TMS_Max\t486\t2147483647\t\n" +
            "#TMS_Max\t487\t2147483647\t\n" +
            "#TMS_Max\t488\t2147483647\t\n" +
            "#TMS_Max\t489\t2147483647\t\n" +
            "#TMS_Max\t490\t2147483647\t\n" +
            "#TMS_Max\t491\t2147483647\t\n" +
            "#TMS_Max\t492\t2147483647\t\n" +
            "#TMS_Max\t493\t2147483647\t\n" +
            "#TMS_Max\t494\t2147483647\t\n" +
            "#TMS_Max\t495\t2147483647\t\n" +
            "#TMS_Max\t496\t2147483647\t\n" +
            "#TMS_Max\t497\t2147483647\t\n" +
            "#TMS_Max\t498\t2147483647\t\n" +
            "#TMS_Max\t499\t2147483647\t\n" +
            "\n" +
            "#TMS_Access\t0\t0\t\n" +
            "#TMS_Access\t1\t0\t\n" +
            "#TMS_Access\t2\t0\t\n" +
            "#TMS_Access\t3\t1\t\n" +
            "#TMS_Access\t4\t1\t\n" +
            "#TMS_Access\t5\t0\t\n" +
            "#TMS_Access\t6\t0\t\n" +
            "#TMS_Access\t7\t0\t\n" +
            "#TMS_Access\t8\t1\t\n" +
            "#TMS_Access\t9\t1\t\n" +
            "#TMS_Access\t10\t1\t\n" +
            "#TMS_Access\t11\t1\t\n" +
            "#TMS_Access\t12\t1\t\n" +
            "#TMS_Access\t13\t1\t\n" +
            "#TMS_Access\t14\t1\t\n" +
            "#TMS_Access\t15\t1\t\n" +
            "#TMS_Access\t16\t1\t\n" +
            "#TMS_Access\t17\t1\t\n" +
            "#TMS_Access\t18\t1\t\n" +
            "#TMS_Access\t19\t1\t\n" +
            "#TMS_Access\t20\t1\t\n" +
            "#TMS_Access\t21\t0\t\n" +
            "#TMS_Access\t22\t0\t\n" +
            "#TMS_Access\t23\t0\t\n" +
            "#TMS_Access\t24\t0\t\n" +
            "#TMS_Access\t25\t0\t\n" +
            "#TMS_Access\t26\t1\t\n" +
            "#TMS_Access\t27\t0\t\n" +
            "#TMS_Access\t28\t1\t\n" +
            "#TMS_Access\t29\t1\t\n" +
            "#TMS_Access\t30\t1\t\n" +
            "#TMS_Access\t31\t1\t\n" +
            "#TMS_Access\t32\t1\t\n" +
            "#TMS_Access\t33\t1\t\n" +
            "#TMS_Access\t34\t1\t\n" +
            "#TMS_Access\t35\t1\t\n" +
            "#TMS_Access\t36\t1\t\n" +
            "#TMS_Access\t37\t1\t\n" +
            "#TMS_Access\t38\t1\t\n" +
            "#TMS_Access\t39\t1\t\n" +
            "#TMS_Access\t40\t0\t\n" +
            "#TMS_Access\t41\t0\t\n" +
            "#TMS_Access\t42\t0\t\n" +
            "#TMS_Access\t43\t0\t\n" +
            "#TMS_Access\t44\t0\t\n" +
            "#TMS_Access\t45\t1\t\n" +
            "#TMS_Access\t46\t1\t\n" +
            "#TMS_Access\t47\t1\t\n" +
            "#TMS_Access\t48\t1\t\n" +
            "#TMS_Access\t49\t1\t\n" +
            "#TMS_Access\t50\t1\t\n" +
            "#TMS_Access\t51\t1\t\n" +
            "#TMS_Access\t52\t1\t\n" +
            "#TMS_Access\t53\t3\t\n" +
            "#TMS_Access\t54\t1\t\n" +
            "#TMS_Access\t55\t1\t\n" +
            "#TMS_Access\t56\t1\t\n" +
            "#TMS_Access\t57\t1\t\n" +
            "#TMS_Access\t58\t1\t\n" +
            "#TMS_Access\t59\t0\t\n" +
            "#TMS_Access\t60\t0\t\n" +
            "#TMS_Access\t61\t0\t\n" +
            "#TMS_Access\t62\t0\t\n" +
            "#TMS_Access\t63\t0\t\n" +
            "#TMS_Access\t64\t0\t\n" +
            "#TMS_Access\t65\t1\t\n" +
            "#TMS_Access\t66\t0\t\n" +
            "#TMS_Access\t67\t0\t\n" +
            "#TMS_Access\t68\t0\t\n" +
            "#TMS_Access\t69\t0\t\n" +
            "#TMS_Access\t70\t1\t\n" +
            "#TMS_Access\t71\t0\t\n" +
            "#TMS_Access\t72\t1\t\n" +
            "#TMS_Access\t73\t0\t\n" +
            "#TMS_Access\t74\t0\t\n" +
            "#TMS_Access\t75\t1\t\n" +
            "#TMS_Access\t76\t1\t\n" +
            "#TMS_Access\t77\t0\t\n" +
            "#TMS_Access\t78\t0\t\n" +
            "#TMS_Access\t79\t0\t\n" +
            "#TMS_Access\t80\t0\t\n" +
            "#TMS_Access\t81\t0\t\n" +
            "#TMS_Access\t82\t0\t\n" +
            "#TMS_Access\t83\t0\t\n" +
            "#TMS_Access\t84\t0\t\n" +
            "#TMS_Access\t85\t0\t\n" +
            "#TMS_Access\t86\t0\t\n" +
            "#TMS_Access\t87\t3\t\n" +
            "#TMS_Access\t88\t1\t\n" +
            "#TMS_Access\t89\t1\t\n" +
            "#TMS_Access\t90\t1\t\n" +
            "#TMS_Access\t91\t1\t\n" +
            "#TMS_Access\t92\t1\t\n" +
            "#TMS_Access\t93\t1\t\n" +
            "#TMS_Access\t94\t1\t\n" +
            "#TMS_Access\t95\t1\t\n" +
            "#TMS_Access\t96\t1\t\n" +
            "#TMS_Access\t97\t1\t\n" +
            "#TMS_Access\t98\t1\t\n" +
            "#TMS_Access\t99\t1\t\n" +
            "#TMS_Access\t100\t0\t\n" +
            "#TMS_Access\t101\t0\t\n" +
            "#TMS_Access\t102\t1\t\n" +
            "#TMS_Access\t103\t1\t\n" +
            "#TMS_Access\t104\t1\t\n" +
            "#TMS_Access\t105\t0\t\n" +
            "#TMS_Access\t106\t0\t\n" +
            "#TMS_Access\t107\t1\t\n" +
            "#TMS_Access\t108\t1\t\n" +
            "#TMS_Access\t109\t3\t\n" +
            "#TMS_Access\t110\t1\t\n" +
            "#TMS_Access\t111\t0\t\n" +
            "#TMS_Access\t112\t0\t\n" +
            "#TMS_Access\t113\t0\t\n" +
            "#TMS_Access\t114\t0\t\n" +
            "#TMS_Access\t115\t1\t\n" +
            "#TMS_Access\t116\t1\t\n" +
            "#TMS_Access\t117\t1\t\n" +
            "#TMS_Access\t118\t1\t\n" +
            "#TMS_Access\t119\t1\t\n" +
            "#TMS_Access\t120\t1\t\n" +
            "#TMS_Access\t121\t1\t\n" +
            "#TMS_Access\t122\t0\t\n" +
            "#TMS_Access\t123\t0\t\n" +
            "#TMS_Access\t124\t1\t\n" +
            "#TMS_Access\t125\t1\t\n" +
            "#TMS_Access\t126\t1\t\n" +
            "#TMS_Access\t127\t1\t\n" +
            "#TMS_Access\t128\t1\t\n" +
            "#TMS_Access\t129\t1\t\n" +
            "#TMS_Access\t130\t1\t\n" +
            "#TMS_Access\t131\t1\t\n" +
            "#TMS_Access\t132\t1\t\n" +
            "#TMS_Access\t133\t1\t\n" +
            "#TMS_Access\t134\t1\t\n" +
            "#TMS_Access\t135\t1\t\n" +
            "#TMS_Access\t136\t1\t\n" +
            "#TMS_Access\t137\t1\t\n" +
            "#TMS_Access\t138\t1\t\n" +
            "#TMS_Access\t139\t1\t\n" +
            "#TMS_Access\t140\t1\t\n" +
            "#TMS_Access\t141\t1\t\n" +
            "#TMS_Access\t142\t1\t\n" +
            "#TMS_Access\t143\t1\t\n" +
            "#TMS_Access\t144\t1\t\n" +
            "#TMS_Access\t145\t1\t\n" +
            "#TMS_Access\t146\t1\t\n" +
            "#TMS_Access\t147\t3\t\n" +
            "#TMS_Access\t148\t1\t\n" +
            "#TMS_Access\t149\t1\t\n" +
            "#TMS_Access\t150\t0\t\n" +
            "#TMS_Access\t151\t0\t\n" +
            "#TMS_Access\t152\t0\t\n" +
            "#TMS_Access\t153\t0\t\n" +
            "#TMS_Access\t154\t0\t\n" +
            "#TMS_Access\t155\t0\t\n" +
            "#TMS_Access\t156\t0\t\n" +
            "#TMS_Access\t157\t0\t\n" +
            "#TMS_Access\t158\t0\t\n" +
            "#TMS_Access\t159\t0\t\n" +
            "#TMS_Access\t160\t0\t\n" +
            "#TMS_Access\t161\t0\t\n" +
            "#TMS_Access\t162\t0\t\n" +
            "#TMS_Access\t163\t0\t\n" +
            "#TMS_Access\t164\t0\t\n" +
            "#TMS_Access\t165\t0\t\n" +
            "#TMS_Access\t166\t1\t\n" +
            "#TMS_Access\t167\t1\t\n" +
            "#TMS_Access\t168\t1\t\n" +
            "#TMS_Access\t169\t1\t\n" +
            "#TMS_Access\t170\t0\t\n" +
            "#TMS_Access\t171\t0\t\n" +
            "#TMS_Access\t172\t0\t\n" +
            "#TMS_Access\t173\t0\t\n" +
            "#TMS_Access\t174\t3\t\n" +
            "#TMS_Access\t175\t3\t\n" +
            "#TMS_Access\t176\t3\t\n" +
            "#TMS_Access\t177\t3\t\n" +
            "#TMS_Access\t178\t3\t\n" +
            "#TMS_Access\t179\t1\t\n" +
            "#TMS_Access\t180\t1\t\n" +
            "#TMS_Access\t181\t1\t\n" +
            "#TMS_Access\t182\t2\t\n" +
            "#TMS_Access\t183\t3\t\n" +
            "#TMS_Access\t184\t3\t\n" +
            "#TMS_Access\t185\t1\t\n" +
            "#TMS_Access\t186\t1\t\n" +
            "#TMS_Access\t187\t1\t\n" +
            "#TMS_Access\t188\t1\t\n" +
            "#TMS_Access\t189\t1\t\n" +
            "#TMS_Access\t190\t1\t\n" +
            "#TMS_Access\t191\t1\t\n" +
            "#TMS_Access\t192\t1\t\n" +
            "#TMS_Access\t193\t1\t\n" +
            "#TMS_Access\t194\t1\t\n" +
            "#TMS_Access\t195\t1\t\n" +
            "#TMS_Access\t196\t1\t\n" +
            "#TMS_Access\t197\t1\t\n" +
            "#TMS_Access\t198\t1\t\n" +
            "#TMS_Access\t199\t1\t\n" +
            "#TMS_Access\t200\t1\t\n" +
            "#TMS_Access\t201\t1\t\n" +
            "#TMS_Access\t202\t1\t\n" +
            "#TMS_Access\t203\t1\t\n" +
            "#TMS_Access\t204\t1\t\n" +
            "#TMS_Access\t205\t1\t\n" +
            "#TMS_Access\t206\t1\t\n" +
            "#TMS_Access\t207\t1\t\n" +
            "#TMS_Access\t208\t1\t\n" +
            "#TMS_Access\t209\t1\t\n" +
            "#TMS_Access\t210\t1\t\n" +
            "#TMS_Access\t211\t1\t\n" +
            "#TMS_Access\t212\t1\t\n" +
            "#TMS_Access\t213\t2\t\n" +
            "#TMS_Access\t214\t1\t\n" +
            "#TMS_Access\t215\t2\t\n" +
            "#TMS_Access\t216\t1\t\n" +
            "#TMS_Access\t217\t1\t\n" +
            "#TMS_Access\t218\t2\t\n" +
            "#TMS_Access\t219\t2\t\n" +
            "#TMS_Access\t220\t2\t\n" +
            "#TMS_Access\t221\t2\t\n" +
            "#TMS_Access\t222\t2\t\n" +
            "#TMS_Access\t223\t1\t\n" +
            "#TMS_Access\t224\t1\t\n" +
            "#TMS_Access\t225\t1\t\n" +
            "#TMS_Access\t226\t1\t\n" +
            "#TMS_Access\t227\t1\t\n" +
            "#TMS_Access\t228\t1\t\n" +
            "#TMS_Access\t229\t1\t\n" +
            "#TMS_Access\t230\t1\t\n" +
            "#TMS_Access\t231\t1\t\n" +
            "#TMS_Access\t232\t1\t\n" +
            "#TMS_Access\t233\t1\t\n" +
            "#TMS_Access\t234\t1\t\n" +
            "#TMS_Access\t235\t1\t\n" +
            "#TMS_Access\t236\t1\t\n" +
            "#TMS_Access\t237\t1\t\n" +
            "#TMS_Access\t238\t1\t\n" +
            "#TMS_Access\t239\t1\t\n" +
            "#TMS_Access\t240\t1\t\n" +
            "#TMS_Access\t241\t3\t\n" +
            "#TMS_Access\t242\t1\t\n" +
            "#TMS_Access\t243\t1\t\n" +
            "#TMS_Access\t244\t1\t\n" +
            "#TMS_Access\t245\t1\t\n" +
            "#TMS_Access\t246\t1\t\n" +
            "#TMS_Access\t247\t1\t\n" +
            "#TMS_Access\t248\t1\t\n" +
            "#TMS_Access\t249\t1\t\n" +
            "#TMS_Access\t250\t1\t\n" +
            "#TMS_Access\t251\t1\t\n" +
            "#TMS_Access\t252\t1\t\n" +
            "#TMS_Access\t253\t1\t\n" +
            "#TMS_Access\t254\t1\t\n" +
            "#TMS_Access\t255\t1\t\n" +
            "#TMS_Access\t256\t1\t\n" +
            "#TMS_Access\t257\t1\t\n" +
            "#TMS_Access\t258\t1\t\n" +
            "#TMS_Access\t259\t1\t\n" +
            "#TMS_Access\t260\t1\t\n" +
            "#TMS_Access\t261\t1\t\n" +
            "#TMS_Access\t262\t1\t\n" +
            "#TMS_Access\t263\t1\t\n" +
            "#TMS_Access\t264\t1\t\n" +
            "#TMS_Access\t265\t1\t\n" +
            "#TMS_Access\t266\t1\t\n" +
            "#TMS_Access\t267\t1\t\n" +
            "#TMS_Access\t268\t1\t\n" +
            "#TMS_Access\t269\t1\t\n" +
            "#TMS_Access\t270\t1\t\n" +
            "#TMS_Access\t271\t1\t\n" +
            "#TMS_Access\t272\t1\t\n" +
            "#TMS_Access\t273\t1\t\n" +
            "#TMS_Access\t274\t1\t\n" +
            "#TMS_Access\t275\t1\t\n" +
            "#TMS_Access\t276\t1\t\n" +
            "#TMS_Access\t277\t1\t\n" +
            "#TMS_Access\t278\t1\t\n" +
            "#TMS_Access\t279\t1\t\n" +
            "#TMS_Access\t280\t1\t\n" +
            "#TMS_Access\t281\t1\t\n" +
            "#TMS_Access\t282\t1\t\n" +
            "#TMS_Access\t283\t1\t\n" +
            "#TMS_Access\t284\t1\t\n" +
            "#TMS_Access\t285\t1\t\n" +
            "#TMS_Access\t286\t1\t\n" +
            "#TMS_Access\t287\t1\t\n" +
            "#TMS_Access\t288\t1\t\n" +
            "#TMS_Access\t289\t1\t\n" +
            "#TMS_Access\t290\t1\t\n" +
            "#TMS_Access\t291\t1\t\n" +
            "#TMS_Access\t292\t1\t\n" +
            "#TMS_Access\t293\t1\t\n" +
            "#TMS_Access\t294\t1\t\n" +
            "#TMS_Access\t295\t1\t\n" +
            "#TMS_Access\t296\t1\t\n" +
            "#TMS_Access\t297\t1\t\n" +
            "#TMS_Access\t298\t1\t\n" +
            "#TMS_Access\t299\t3\t\n" +
            "#TMS_Access\t300\t1\t\n" +
            "#TMS_Access\t301\t1\t\n" +
            "#TMS_Access\t302\t1\t\n" +
            "#TMS_Access\t303\t1\t\n" +
            "#TMS_Access\t304\t1\t\n" +
            "#TMS_Access\t305\t1\t\n" +
            "#TMS_Access\t306\t1\t\n" +
            "#TMS_Access\t307\t1\t\n" +
            "#TMS_Access\t308\t1\t\n" +
            "#TMS_Access\t309\t3\t\n" +
            "#TMS_Access\t310\t3\t\n" +
            "#TMS_Access\t311\t3\t\n" +
            "#TMS_Access\t312\t3\t\n" +
            "#TMS_Access\t313\t3\t\n" +
            "#TMS_Access\t314\t3\t\n" +
            "#TMS_Access\t315\t3\t\n" +
            "#TMS_Access\t316\t3\t\n" +
            "#TMS_Access\t317\t3\t\n" +
            "#TMS_Access\t318\t1\t\n" +
            "#TMS_Access\t319\t1\t\n" +
            "#TMS_Access\t320\t1\t\n" +
            "#TMS_Access\t321\t1\t\n" +
            "#TMS_Access\t322\t3\t\n" +
            "#TMS_Access\t323\t3\t\n" +
            "#TMS_Access\t324\t3\t\n" +
            "#TMS_Access\t325\t3\t\n" +
            "#TMS_Access\t326\t3\t\n" +
            "#TMS_Access\t327\t3\t\n" +
            "#TMS_Access\t328\t3\t\n" +
            "#TMS_Access\t329\t3\t\n" +
            "#TMS_Access\t330\t1\t\n" +
            "#TMS_Access\t331\t3\t\n" +
            "#TMS_Access\t332\t0\t\n" +
            "#TMS_Access\t333\t0\t\n" +
            "#TMS_Access\t334\t0\t\n" +
            "#TMS_Access\t335\t0\t\n" +
            "#TMS_Access\t336\t0\t\n" +
            "#TMS_Access\t337\t3\t\n" +
            "#TMS_Access\t338\t3\t\n" +
            "#TMS_Access\t339\t3\t\n" +
            "#TMS_Access\t340\t1\t\n" +
            "#TMS_Access\t341\t1\t\n" +
            "#TMS_Access\t342\t3\t\n" +
            "#TMS_Access\t343\t3\t\n" +
            "#TMS_Access\t344\t3\t\n" +
            "#TMS_Access\t345\t3\t\n" +
            "#TMS_Access\t346\t3\t\n" +
            "#TMS_Access\t347\t3\t\n" +
            "#TMS_Access\t348\t3\t\n" +
            "#TMS_Access\t349\t3\t\n" +
            "#TMS_Access\t350\t0\t\n" +
            "#TMS_Access\t351\t0\t\n" +
            "#TMS_Access\t352\t0\t\n" +
            "#TMS_Access\t353\t1\t\n" +
            "#TMS_Access\t354\t1\t\n" +
            "#TMS_Access\t355\t0\t\n" +
            "#TMS_Access\t356\t0\t\n" +
            "#TMS_Access\t357\t0\t\n" +
            "#TMS_Access\t358\t1\t\n" +
            "#TMS_Access\t359\t1\t\n" +
            "#TMS_Access\t360\t0\t\n" +
            "#TMS_Access\t361\t1\t\n" +
            "#TMS_Access\t362\t1\t\n" +
            "#TMS_Access\t363\t1\t\n" +
            "#TMS_Access\t364\t0\t\n" +
            "#TMS_Access\t365\t0\t\n" +
            "#TMS_Access\t366\t0\t\n" +
            "#TMS_Access\t367\t0\t\n" +
            "#TMS_Access\t368\t0\t\n" +
            "#TMS_Access\t369\t0\t\n" +
            "#TMS_Access\t370\t0\t\n" +
            "#TMS_Access\t371\t0\t\n" +
            "#TMS_Access\t372\t0\t\n" +
            "#TMS_Access\t373\t0\t\n" +
            "#TMS_Access\t374\t0\t\n" +
            "#TMS_Access\t375\t0\t\n" +
            "#TMS_Access\t376\t1\t\n" +
            "#TMS_Access\t377\t1\t\n" +
            "#TMS_Access\t378\t1\t\n" +
            "#TMS_Access\t379\t1\t\n" +
            "#TMS_Access\t380\t3\t\n" +
            "#TMS_Access\t381\t3\t\n" +
            "#TMS_Access\t382\t3\t\n" +
            "#TMS_Access\t383\t3\t\n" +
            "#TMS_Access\t384\t3\t\n" +
            "#TMS_Access\t385\t3\t\n" +
            "#TMS_Access\t386\t3\t\n" +
            "#TMS_Access\t387\t3\t\n" +
            "#TMS_Access\t388\t3\t\n" +
            "#TMS_Access\t389\t3\t\n" +
            "#TMS_Access\t390\t3\t\n" +
            "#TMS_Access\t391\t3\t\n" +
            "#TMS_Access\t392\t3\t\n" +
            "#TMS_Access\t393\t3\t\n" +
            "#TMS_Access\t394\t3\t\n" +
            "#TMS_Access\t395\t3\t\n" +
            "#TMS_Access\t396\t3\t\n" +
            "#TMS_Access\t397\t3\t\n" +
            "#TMS_Access\t398\t3\t\n" +
            "#TMS_Access\t399\t3\t\n" +
            "#TMS_Access\t400\t1\t\n" +
            "#TMS_Access\t401\t1\t\n" +
            "#TMS_Access\t402\t1\t\n" +
            "#TMS_Access\t403\t1\t\n" +
            "#TMS_Access\t404\t1\t\n" +
            "#TMS_Access\t405\t1\t\n" +
            "#TMS_Access\t406\t1\t\n" +
            "#TMS_Access\t407\t1\t\n" +
            "#TMS_Access\t408\t1\t\n" +
            "#TMS_Access\t409\t1\t\n" +
            "#TMS_Access\t410\t1\t\n" +
            "#TMS_Access\t411\t1\t\n" +
            "#TMS_Access\t412\t1\t\n" +
            "#TMS_Access\t413\t1\t\n" +
            "#TMS_Access\t414\t3\t\n" +
            "#TMS_Access\t415\t1\t\n" +
            "#TMS_Access\t416\t1\t\n" +
            "#TMS_Access\t417\t1\t\n" +
            "#TMS_Access\t418\t1\t\n" +
            "#TMS_Access\t419\t1\t\n" +
            "#TMS_Access\t420\t1\t\n" +
            "#TMS_Access\t421\t1\t\n" +
            "#TMS_Access\t422\t1\t\n" +
            "#TMS_Access\t423\t3\t\n" +
            "#TMS_Access\t424\t3\t\n" +
            "#TMS_Access\t425\t3\t\n" +
            "#TMS_Access\t426\t3\t\n" +
            "#TMS_Access\t427\t3\t\n" +
            "#TMS_Access\t428\t3\t\n" +
            "#TMS_Access\t429\t3\t\n" +
            "#TMS_Access\t430\t0\t\n" +
            "#TMS_Access\t431\t0\t\n" +
            "#TMS_Access\t432\t0\t\n" +
            "#TMS_Access\t433\t0\t\n" +
            "#TMS_Access\t434\t0\t\n" +
            "#TMS_Access\t435\t0\t\n" +
            "#TMS_Access\t436\t0\t\n" +
            "#TMS_Access\t437\t0\t\n" +
            "#TMS_Access\t438\t0\t\n" +
            "#TMS_Access\t439\t0\t\n" +
            "#TMS_Access\t440\t0\t\n" +
            "#TMS_Access\t441\t0\t\n" +
            "#TMS_Access\t442\t3\t\n" +
            "#TMS_Access\t443\t3\t\n" +
            "#TMS_Access\t444\t3\t\n" +
            "#TMS_Access\t445\t3\t\n" +
            "#TMS_Access\t446\t3\t\n" +
            "#TMS_Access\t447\t3\t\n" +
            "#TMS_Access\t448\t1\t\n" +
            "#TMS_Access\t449\t1\t\n" +
            "#TMS_Access\t450\t1\t\n" +
            "#TMS_Access\t451\t1\t\n" +
            "#TMS_Access\t452\t1\t\n" +
            "#TMS_Access\t453\t1\t\n" +
            "#TMS_Access\t454\t1\t\n" +
            "#TMS_Access\t455\t1\t\n" +
            "#TMS_Access\t456\t1\t\n" +
            "#TMS_Access\t457\t1\t\n" +
            "#TMS_Access\t458\t3\t\n" +
            "#TMS_Access\t459\t3\t\n" +
            "#TMS_Access\t460\t3\t\n" +
            "#TMS_Access\t461\t3\t\n" +
            "#TMS_Access\t462\t3\t\n" +
            "#TMS_Access\t463\t3\t\n" +
            "#TMS_Access\t464\t3\t\n" +
            "#TMS_Access\t465\t3\t\n" +
            "#TMS_Access\t466\t3\t\n" +
            "#TMS_Access\t467\t3\t\n" +
            "#TMS_Access\t468\t3\t\n" +
            "#TMS_Access\t469\t3\t\n" +
            "#TMS_Access\t470\t3\t\n" +
            "#TMS_Access\t471\t3\t\n" +
            "#TMS_Access\t472\t3\t\n" +
            "#TMS_Access\t473\t3\t\n" +
            "#TMS_Access\t474\t3\t\n" +
            "#TMS_Access\t475\t3\t\n" +
            "#TMS_Access\t476\t3\t\n" +
            "#TMS_Access\t477\t1\t\n" +
            "#TMS_Access\t478\t1\t\n" +
            "#TMS_Access\t479\t1\t\n" +
            "#TMS_Access\t480\t1\t\n" +
            "#TMS_Access\t481\t1\t\n" +
            "#TMS_Access\t482\t1\t\n" +
            "#TMS_Access\t483\t1\t\n" +
            "#TMS_Access\t484\t1\t\n" +
            "#TMS_Access\t485\t1\t\n" +
            "#TMS_Access\t486\t1\t\n" +
            "#TMS_Access\t487\t1\t\n" +
            "#TMS_Access\t488\t1\t\n" +
            "#TMS_Access\t489\t1\t\n" +
            "#TMS_Access\t490\t1\t\n" +
            "#TMS_Access\t491\t1\t\n" +
            "#TMS_Access\t492\t1\t\n" +
            "#TMS_Access\t493\t1\t\n" +
            "#TMS_Access\t494\t1\t\n" +
            "#TMS_Access\t495\t1\t\n" +
            "#TMS_Access\t496\t1\t\n" +
            "#TMS_Access\t497\t1\t\n" +
            "#TMS_Access\t498\t1\t\n" +
            "#TMS_Access\t499\t3\t\n" +
            "\n" +
            "#SpVersion\t0\n" +
            "\n" +
            "#SpSegs\tAAA|BBB\n";

    public GlobalPara TMS_Receive_Default() {
        return this.TMS_Receive_MultiLine(DEFAULT_CONFIG, true);
    }

    /**
     * @description: 文件参数加载
     **/
    public GlobalPara TMS_Receive_MultiLine(String lines) {
        return TMS_Receive_MultiLine(lines, false);
    }

    /**
     * @description: TMS数据加载
     **/
    public GlobalPara TMS_Receive_MultiLine(String lines, boolean isDefault) {
        if (StringUtils.isBlank(lines)) return this;
        String[] sls = lines.split("\r|\n");
        for (String line : sls) {
            String[] Seg = line.split("\t", -1);
            DataJSONModel jsonModel = DDataUtils.Public_UnPackage(Seg);
            if (jsonModel != null) {
                if (jsonModel instanceof DDataParameter) {
                    this.Init_SetTMS(jsonModel.no(), ((DDataParameter) jsonModel).getValue(), isDefault);
                } else if (jsonModel instanceof DTextParameter) {
                    this.setTMT(jsonModel.no(), ((DTextParameter) jsonModel).getValue());
                } else if (jsonModel instanceof DBarcodeFormat) {
                    this.SetBarcode((DBarcodeFormat) jsonModel, isDefault);
                } else if (jsonModel instanceof DLabelFormat) {
                    this.SetLabelFormat((DLabelFormat) jsonModel, isDefault);
                }
            } else {
                if (!isDefault) {
                    //什么都不做，剩下部分仅对Default文件生效
                } else {
                    switch (Seg[0]) {
                        case "#TMS_Max":
                            tms_Max.put(tryParseInt(Seg[1]), tryParseInt(Seg[2]));
                            break;
                        case "#TMS_Access":
                            tms_Access.put(tryParseInt(Seg[1]), tryParseInt(Seg[2]));
                            break;
                        case "#SpFNT":
                            tms_SpFNT = tryParseInt(Seg[1], 23);
                            break;
                        case "#SpDWL":
                            tms_SpDWL.put(Seg[1], tryParseInt(Seg[2]));
                            if (StringUtils.isNotBlank(Seg[3])) {
                                String[] SpDWL_Arr = Seg[3].split("\\|");
                                Map<Integer, DSpDWL> spDWLMap = new HashMap<>();
                                for (String spDWL_str : SpDWL_Arr) {
                                    try {
                                        String[] sl = spDWL_str.split(",");
                                        DSpDWL spDWL = new DSpDWLV1();
                                        spDWL.setKey(Seg[1]);
                                        spDWL.sno(Integer.parseInt(sl[0]));
                                        spDWL.setName(sl[1]);
                                        spDWL.setKid(String.format("%s\t%s", spDWL.getKey(), spDWL.no()));
                                        spDWL.setContent(String.format("%s\t", spDWL.getName()));
                                        spDWLMap.put(spDWL.no(), spDWL);
                                    } catch (Exception e) {
                                        System.err.printf("SpDWL:[%s] Error:[%s]%n", spDWL_str, e.getMessage());
                                    }
                                }
                                if (!spDWLMap.isEmpty()) this.df_sds.put(Seg[1], spDWLMap);
                            }
                            break;
                        case "#SpTare":
                            try {
                                BigDecimal tareLimit = new BigDecimal(Seg[1]);
                                WeightCal.getInstance().setTareLimit(tareLimit);
                            } catch (Exception exp) {
                            }
                            break;
                        case "#SpWMN":
                            try {
                                BigDecimal kgCap = new BigDecimal(Seg[1]);
                                int spec213 = Integer.parseInt(Seg[2], 10);
                                int unitWeight = Integer.parseInt(Seg[3], 10);
                                int dot = Integer.parseInt(Seg[4], 10);
                                int capacity_0 = Integer.parseInt(Seg[5], 10);
                                int capacity_1 = Integer.parseInt(Seg[6], 10);
                                int capacity_2 = Integer.parseInt(Seg[7], 10);
                                int division_0 = Integer.parseInt(Seg[8], 10);
                                int division_1 = Integer.parseInt(Seg[9], 10);
                                int division_2 = Integer.parseInt(Seg[10], 10);

                                sp_WeightMN.put(title_WeightMN(kgCap, spec213, unitWeight), new WeightMN(dot, capacity_0, capacity_1, capacity_2, division_0, division_1, division_2));
                            } catch (Exception exp) {
                                ;
                            }
                            break;
                        case "#SpWMUnit":
                            for (int loop = 1; loop < Seg.length; loop++) {
                                String[] SpWM = Seg[loop].split(",");
                                boolean value;
                                if (SpWM[0].equals("T"))
                                    value = true;
                                else if (SpWM[0].equals("F"))
                                    value = false;
                                else
                                    continue;

                                if (SpWM.length == 2) {
                                    int o1 = tryParseInt(SpWM[1], -1);
                                    if ((o1 >= 0) && (o1 <= weightUnit_Size))
                                        weightUNIT_Allowed[o1] = value;
                                }
                                if (SpWM.length == 3) {
                                    int o1 = tryParseInt(SpWM[1], -1);
                                    int o2 = tryParseInt(SpWM[2], -2);
                                    if ((o1 >= 0) && (o1 <= weightUnit_Size) && (o2 >= 0) && (o2 <= weightUnit_Size))
                                        moneyUnit_Allowed[o1][o2] = value;
                                }
                            }
                            break;
                        // case "#SpVersion":
                        //     spVersion = tryParseInt(Seg[1]);
                        //     break;
                        // case "#SpSegs":
                        //     spContentSegs = Arrays.asList(Seg[1].split("\\|"));
                        //     break;
                        default:
                            break;
                    }
                }

                // if (Seg.length >= 2 && spContentSegs.contains(Seg[0])) {
                //     int id = tryParseInt(Seg[1]);
                //     String content = line.substring(line.indexOf("\t", Seg[0].length() + 1) + 1);
                //     if (!spContentBuf.containsKey(Seg[0])) {
                //         spContentBuf.put(Seg[0], new HashMap<Integer, String>());
                //     }
                //     spContentBuf.get(Seg[0]).put(id, content);
                // } else if (!isDefault) {
                //     //什么都不做，剩下部分仅对Default文件生效
                // } else {
                //     switch (Seg[0]) {
                //         case "#TMS_Max":
                //             tms_Max.put(tryParseInt(Seg[1]), tryParseInt(Seg[2]));
                //             break;
                //         case "#TMS_Access":
                //             tms_Access.put(tryParseInt(Seg[1]), tryParseInt(Seg[2]));
                //             break;
                //         case "#SpVersion":
                //             spVersion = tryParseInt(Seg[1]);
                //             break;
                //         case "#SpSegs":
                //             spContentSegs = Arrays.asList(Seg[1].split("\\|"));
                //             break;
                //         default:
                //             break;
                //     }
                // }
            }
        }
        return this;
    }

    public Integer getSpDWL(String key) {
        //if(!tms_SpDWL.containsKey(key))
        //    return null;
        return tms_SpDWL.get(key);
    }

    public Integer getTms_SpFNT() {
        return tms_SpFNT;
    }

    /**
     * @description: 解析Int
     **/
    private int tryParseInt(String toParse) {
        return tryParseInt(toParse, 0);
    }

    /**
     * @description: 解析 Int 默认值
     **/
    private int tryParseInt(String toParse, int defaultValue) {
        try {
            return Integer.parseInt(toParse, 10);
        } catch (Exception e) {
            return defaultValue;
        }
    }

    /**
     * @description: 解析字符串（特殊字符替换）
     **/
    private String tryParseFromTMSString(String toParse) {
        return toParse.replace('\013', '\n');
    }

    /**
     * @description: 生成内容 特殊字符串替换
     **/
    private String tryParseToTMSString(String toParse) {
        return toParse.replace('\n', '\013');
    }

    /*************************************************** 属性 get set *******************************************************************/

    public Map<Integer, Integer> getTms() {
        return tms;
    }

    public void setTms(Map<Integer, Integer> tms) {
        this.tms = tms;
    }

    public Map<Integer, Integer> getTms_Max() {
        return tms_Max;
    }

    public void setTms_Max(Map<Integer, Integer> tms_Max) {
        this.tms_Max = tms_Max;
    }

    public Map<Integer, Integer> getTms_Access() {
        return tms_Access;
    }

    public void setTms_Access(Map<Integer, Integer> tms_Access) {
        this.tms_Access = tms_Access;
    }

    public Map<Integer, Integer> getTms_Update() {
        return tms_Update;
    }

    public void setTms_Update(Map<Integer, Integer> tms_Update) {
        this.tms_Update = tms_Update;
    }

    public Map<Integer, String> getTmt() {
        return tmt;
    }

    public void setTmt(Map<Integer, String> tmt) {
        this.tmt = tmt;
    }
}
