package com.jhscale.meter.protocol.model;

import com.jhscale.common.model.device.log.module.DGoods;
import com.jhscale.common.model.device.plu.DPLUV5;
import com.jhscale.common.model.device.plu.inner.DAutoDiscountV2;
import com.jhscale.common.model.device.plu.inner.DManualDiscount;
import com.jhscale.common.model.device.plu.module.DPriceV2;
import com.jhscale.common.model.inter.GJSONModel;
import com.jhscale.common.utils.BigDecimalUtils;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.exp.RuntimeMeterException;
import com.jhscale.meter.protocol.constant.TMS;
import com.jhscale.meter.utils.AConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.*;

import static com.jhscale.meter.protocol.constant.TMS.*;

/**
 * @author lie_w
 * @title: ItemContent
 * @projectName meter-jar
 * @description: TODO
 * @date 2022/9/2112:47
 */
@ApiModel("明细参数")
public class ItemContent implements GJSONModel {

    @ApiModelProperty(value = "PLU", name = "plu")
    private DPLUV5 plu;

    @ApiModelProperty(value = "负交易标志", name = "negativeFlag")
    private boolean negativeFlag = false;

    @ApiModelProperty(value = "单计来源不详，不参与任何独立折扣", name = "fixedSingle")
    private boolean fixedSingle = false;

    @ApiModelProperty(value = "皮重", name = "tare")
    private BigDecimal tare = BigDecimal.ZERO;
    @ApiModelProperty(value = "包装部分皮重", name = "packageTare")
    private BigDecimal packageTare = BigDecimal.ZERO;
    @ApiModelProperty(value = "百分比部分皮重", name = "percentTare")
    private BigDecimal percentedTare = BigDecimal.ZERO;
    @ApiModelProperty(value = "原始皮重", name = "preTare")
    private BigDecimal preTare = BigDecimal.ZERO;
    @ApiModelProperty(value = "单价", name = "price")
    private BigDecimal price = BigDecimal.ZERO;
    @ApiModelProperty(value = "单价为手动输入", name = "priceIsManual")
    private boolean priceIsManual = false;
    @ApiModelProperty(value = "输入数重量", name = "amountInput")        //无实际意义，仅记录调用进来的amount
    private BigDecimal amountInput = BigDecimal.ZERO;
    @ApiModelProperty(value = "数重量", name = "amount")
    private BigDecimal amount = BigDecimal.ZERO;
    @ApiModelProperty(value = "重量单位", name = "unit")
    private int unit_weight = 2;
    @ApiModelProperty(value = "单位名称", name = "unitName")            //Only for pcs unit
    private String unitName = "";

    @ApiModelProperty(value = "未确认数重量", name = "amount_Unconfirmed")
    private BigDecimal amount_Unconfirmed = BigDecimal.ZERO;

    @ApiModelProperty(value = "未确认单价", name = "price_Unconfirmed")
    private BigDecimal price_Unconfirmed = BigDecimal.ZERO;

    @ApiModelProperty(value = "有效性_已使用的重量", name = "valid_UsedGross")
    private BigDecimal valid_UsedGross = BigDecimal.ZERO;

    @ApiModelProperty(value = "有效性_数重量", name = "valid_Amount")
    private boolean valid_Amount = false;
    @ApiModelProperty(value = "有效性_单计算", name = "valid_Single")
    private boolean valid_Single = false;

    @ApiModelProperty(value = "税种", name = "taxType")
    private int taxType = 0;
    @ApiModelProperty(value = "税率", name = "taxRate")
    private BigDecimal taxRate = BigDecimal.ZERO;

    @ApiModelProperty(value = "单价单位", name = "unit")
    private Integer unit_price = 2;
    @ApiModelProperty(value = "原始单价", name = "price_FromPLU")
    private BigDecimal price_Original = BigDecimal.ZERO;
    @ApiModelProperty(value = "原始小计含税", name = "singleWtax_Original")
    private BigDecimal singleWtax_Original = BigDecimal.ZERO;

    @ApiModelProperty(value = "原始单价上限", name = "price_UpperLimit")
    private BigDecimal price_UpperLimit = BigDecimal.ZERO;
    @ApiModelProperty(value = "原始单价下限", name = "price_LowerLimit")
    private BigDecimal price_LowerLimit = BigDecimal.ZERO;

    @ApiModelProperty(value = "库存数重量", name = "amount_Stock")
    private BigDecimal amount_Stock = BigDecimal.ZERO;
    @ApiModelProperty(value = "库存单位", name = "unit_Stock")
    private int unit_Stock = 0;

    @ApiModelProperty(value = "税额", name = "tax")
    private BigDecimal tax = BigDecimal.ZERO;

    @ApiModelProperty(value = "小计无税", name = "singleNtax")
    private BigDecimal singleNtax = BigDecimal.ZERO;
    @ApiModelProperty(value = "小计含税", name = "singleWtax")
    private BigDecimal singleWtax = BigDecimal.ZERO;

    @ApiModelProperty(value = "服务费", name = "serviceFee")
    private BigDecimal serviceFee = BigDecimal.ZERO;

    @ApiModelProperty(value = "商品图片", name = "pics")
    private List<String> pics;

    @ApiModelProperty(value = "退货标志", name = "reject")
    private int reject = AConstant.UN_REJECT;

    @ApiModelProperty(value = "商品添加来源 132-键盘调用 133-外部条码调用 134-内部条码调用", name = "spec")
    private Integer spec;

    @ApiModelProperty(value = "POS打印内容", name = "posOnlyString")
    private Map<Integer, String> posOnlyString = new HashMap<>();

    public ItemContent() {
    }

    public boolean AddValid() throws RuntimeMeterException {
        if (!this.valid_Amount)
            throw new RuntimeMeterException(MeterStateEnum.数重量无效不允许添加);
        if (!this.valid_Single)
            throw new RuntimeMeterException(MeterStateEnum.单计计算错误不允许添加);
        return true;
        // return this.valid_Single && this.valid_Amount;
    }

    /**
     * @description: 显示单价
     **/
    public static BigDecimal GetDisplay_Price(DPLUV5 inputPLU, TradeContent tradeContent) {
        if (tradeContent == null) {
            return GlobalPara.getInstance().CalPLU_Price_wUnit(inputPLU.price(GlobalPara.getInstance().getDeviceLevel()).getPrice(), inputPLU.unit());
        } else if (tradeContent.VIP_LOGIN()) {
            return GlobalPara.getInstance().CalPLU_Price_wUnit(tradeContent.CalPLU_UPrice_VIPed(inputPLU), inputPLU.unit());
        } else {
            DPriceV2 price = inputPLU.price(GlobalPara.getInstance().getDeviceLevel());
            int mpd = GlobalPara.getInstance().getTMS(Member_Price_Display);
            DAutoDiscountV2 discount = null;
            switch (mpd) {
                case Member_Price_Display_A:
                    discount = Optional.ofNullable(price.getAutoDiscounts())
                            .orElse(Collections.emptyList())
                            .stream().filter(value -> 4 == value.getType())
                            .findFirst().orElse(null);
                    break;
                case Member_Price_Display_B:
                    discount = Optional.ofNullable(price.getAutoDiscounts())
                            .orElse(Collections.emptyList())
                            .stream().filter(value -> 5 == value.getType())
                            .findFirst().orElse(null);
                    break;
                case Member_Price_Display_C:
                    discount = Optional.ofNullable(price.getAutoDiscounts())
                            .orElse(Collections.emptyList())
                            .stream().filter(value -> 6 == value.getType())
                            .findFirst().orElse(null);
                    break;
                case Member_Price_Display_D:
                    discount = Optional.ofNullable(price.getAutoDiscounts())
                            .orElse(Collections.emptyList())
                            .stream().filter(value -> 7 == value.getType())
                            .findFirst().orElse(null);
                    break;
                case Member_Price_Display_NONE:
                default:
            }
            if (discount != null) {
                return GlobalPara.getInstance().CalPLU_Price_wUnit(discount.getDiscount(), inputPLU.unit());
            } else {
                return null;
            }
        }
    }

    /**
     * @description: 显示单位
     **/
    public static int GetDisplay_MoneyUnit(DPLUV5 inputPLU) {
        if (inputPLU.unit() == 2) {
            return 2;
        } else {
            return GlobalPara.getInstance().CalPLU_PriceUnit_wUnit(inputPLU.unit());
        }
    }

    public static int GetDisplay_MoneyUnit(int price_unit) {
        if (price_unit == 2) {
            return 2;
        } else {
            return GlobalPara.getInstance().CalPLU_PriceUnit_wUnit(price_unit);
        }
    }

    /**
     * @description: 创建商品明细
     **/
    public ItemContent(DPLUV5 plu, TradeContent tradeContent) {
        this.plu = plu;

        int tradeType = tradeContent.getTradeType();
        if ((tradeType == 1)          //如果是退货
                || (tradeType == 10)       //如果是入库
        )
            negativeFlag = true;
        else
            negativeFlag = false;

        BigDecimal price = this.plu.price(GlobalPara.getInstance().getDeviceLevel()).getPrice();
        this.setPrice_Original(GlobalPara.getInstance().CalPLU_Price_wUnit(price, plu.unit()));
        BigDecimal priceZero = GlobalPara.getInstance().CalPLU_Price_wUnit(BigDecimal.ZERO, plu.unit());

        if (this.getPrice_Original().compareTo(BigDecimal.ZERO) == 0) {
            this.setPrice_LowerLimit(priceZero);
            this.setPrice_UpperLimit(priceZero);
        } else if ((GlobalPara.getInstance().getTMS(TMS.Discount_Manual_Disable) & 0x01) != 0) {
            this.setPrice_LowerLimit(this.getPrice_Original());
            this.setPrice_UpperLimit(this.getPrice_Original());
        } else {
            DManualDiscount dm;
            int type;
            dm = this.plu.price(GlobalPara.getInstance().getDeviceLevel()).manualDiscount(1);     //下限
            type = dm.type();
            if (type == 0) {
                this.setPrice_LowerLimit(GlobalPara.getInstance().CalPLU_Price_wUnit(new BigDecimal(Math.min(100, GlobalPara.getInstance().getTMS(TMS.Discount_Manual_LowLimit))).movePointLeft(2).multiply(price), plu.unit()));
            } else if (type == 2) {
                this.setPrice_LowerLimit(this.getPrice_Original());
            } else if (type == 3) {
                this.setPrice_LowerLimit(GlobalPara.getInstance().CalPLU_Price_wUnit(dm.getDiscount(), plu.unit()));
            } else {
                this.setPrice_LowerLimit(priceZero);
            }
            dm = this.plu.price(GlobalPara.getInstance().getDeviceLevel()).manualDiscount(0);     //下限
            type = dm.type();
            if (type == 0) {
                int hl = GlobalPara.getInstance().getTMS(TMS.Discount_Manual_HighLimit);
                if (hl != 0)
                    hl = Math.max(100, hl);
                this.setPrice_UpperLimit(GlobalPara.getInstance().CalPLU_Price_wUnit(new BigDecimal(hl).movePointLeft(2).multiply(price), plu.unit()));
            } else if (type == 2) {
                this.setPrice_UpperLimit(this.getPrice_Original());
            } else if (type == 3) {
                this.setPrice_UpperLimit(GlobalPara.getInstance().CalPLU_Price_wUnit(dm.getDiscount(), plu.unit()));
            } else {
                this.setPrice_UpperLimit(priceZero);
            }
        }

        this.setPrice(GlobalPara.getInstance().CalPLU_Price_wUnit(tradeContent.CalPLU_UPrice_VIPed(plu), plu.unit()));

        if (plu.unit() == 2) {
            this.setUnit_weight(2);
            this.setUnit_price(2);
            this.setPreTare(BigDecimal.ZERO);
        } else {
            this.setUnit_weight(GlobalPara.getInstance().getWeightUNIT());
            this.setUnit_price(GlobalPara.getInstance().CalPLU_PriceUnit_wUnit(GlobalPara.getInstance().getPriceUNIT()));
            this.setPreTare(GlobalPara.getInstance().EcsCal_Unit_WeightConvertSystem(plu.tare(), plu.unit()));
        }

        this.setTaxType(plu.taxType());
        this.setTaxRate(BigDecimal.valueOf(plu.taxRate()));
        if (this.getTaxType() == 0) {
            this.setTaxType(GlobalPara.getInstance().getTMS(TMS.Arith_Tax_Sort));
            this.setTaxRate(new BigDecimal(GlobalPara.getInstance().getTMS(TMS.Arith_Tax_Rate)).divide(new BigDecimal(10000)));
        }
    }

    /**
     * @description: 添加商品
     **/
    public ItemContent Item_Set_Good(DGoods good) {
        if (Objects.nonNull(good.getAmountStock())) this.amount_Stock = good.getAmountStock();
        if (Objects.nonNull(good.getUnitStock())) this.unit_Stock = good.getUnitStock();
        if (Objects.nonNull(good.getAmount())) this.amount = good.getAmount();
        if (Objects.nonNull(good.getUnit())) this.unit_weight = good.getUnit();
        if (this.unit_weight != GlobalPara.getInstance().getWeightUNIT()) {
            this.unit_price = this.unit_weight;
            this.price = good.getPrice();
        } else {
            this.unit_price = GlobalPara.getInstance().getPriceUNIT();
            this.price = GlobalPara.getInstance().EcsCal_Unit_PriceConvertTo(good.getPrice(), this.unit_weight, this.unit_price);
        }

        this.singleWtax = good.getItemTotal();
        if (Objects.nonNull(good.getTax())) this.tax = good.getTax();
        this.singleNtax = this.singleWtax.subtract(this.tax);

        this.valid_Single = this.valid_Amount = true;

        return this;
    }

    /**
     * @description: 设置重量
     **/
    public ItemContent Item_Set_Weight(BigDecimal net, boolean valid) {
        this.setAmount(net);
        this.setValid_Amount(valid);
        return this;
    }

    public ItemContent Item_Set_Weight(WeightResult result) {
        boolean valid = false;
        BigDecimal net = result.getNetWeight();
        amountInput = net;
        if (result.getValidType() >= 2)
            net = WeightCal.getInstance().weightZero;
        else if (net.compareTo(BigDecimal.ZERO) <= 0)
            net = WeightCal.getInstance().weightZero;
        else if ((result.getValidType() == 0) && (result.isStable()))
            valid = true;


        this.packageTare = result.getTare();
        if (!GlobalPara.getInstance().EcsCal_Unit_isWeight(this.getUnit_weight()))
            return this;
        if (this.getPlu().percentTare().compareTo(BigDecimal.ZERO) > 0)
            percentedTare = net.multiply(this.getPlu().getPercentTare()).setScale(GlobalPara.getInstance().getPointOfWeight(), BigDecimal.ROUND_HALF_DOWN);
        else
            percentedTare = BigDecimal.ZERO.setScale(GlobalPara.getInstance().getPointOfWeight());

        net = net.subtract(percentedTare);
        if (negativeFlag)
            net = net.negate();
        this.setAmount(net);
        this.setTare(result.getTare());
        this.setValid_Amount(valid, result.getGross());
        return this;
    }

    /**
     * @description: 设置数量
     **/
    public ItemContent Item_Set_Count(BigDecimal pcs) {
        if (GlobalPara.getInstance().EcsCal_Unit_isWeight(this.getUnit_weight()))
            return this;
        amountInput = pcs;
        boolean valid = pcs.compareTo(BigDecimal.ZERO) > 0;
        if (!valid)
            pcs = BigDecimal.ZERO;
        if (negativeFlag)
            pcs = pcs.negate();
        this.setAmount(pcs);
        this.setValid_Amount(valid);
        return this;
    }

    /**
     * @description: 设置数量
     **/
    public ItemContent Item_Set_Count_Negate(BigDecimal pcs) {
        if (GlobalPara.getInstance().EcsCal_Unit_isWeight(this.getUnit_weight()))
            return this;
        amountInput = pcs;
        boolean valid = pcs.compareTo(BigDecimal.ZERO) < 0;
        if (!valid)
            pcs = BigDecimal.ZERO;
        if (negativeFlag)
            pcs = pcs.negate();
        this.setAmount(pcs);
        this.setValid_Amount(valid);
        return this;
    }

    /**
     * @description: 计件取重
     **/
    public ItemContent Item_Set_Amount_Stock(WeightResult result) {
        if (GlobalPara.getInstance().EcsCal_Unit_isWeight(this.getUnit_weight()))
            return this;
        this.setAmount_Stock(result.getNetWeight());
        this.setUnit_Stock(GlobalPara.getInstance().getWeightUNIT());
        return this;
    }

    /**
     * @description: 计件取重
     **/
    public ItemContent Item_Set_Amount_Stock(BigDecimal net) {
        if (GlobalPara.getInstance().EcsCal_Unit_isWeight(this.getUnit_weight()))
            return this;
        this.setAmount_Stock(net);
        this.setUnit_Stock(GlobalPara.getInstance().getWeightUNIT());
        return this;
    }

    /**
     * @description: 设置单价
     **/
    public ItemContent Item_Set_UPrice(BigDecimal price) {
        this.setPrice(GlobalPara.getInstance().EcsCal_Rounding(price, GlobalPara.getInstance().getPointOfPrice(), 0));
        this.setPriceIsManual(true);
        return this;
    }

    public ItemContent Item_Set_UPrice_WithUnit(BigDecimal price, int unitPrice) {
        return Item_Set_UPrice(GlobalPara.getInstance().EcsCal_Unit_PriceConvertTo(price, unitPrice, this.unit_price));
    }

    public boolean Item_Check_UPrice() {
        if (this.getPrice_Original().compareTo(BigDecimal.ZERO) == 0) {
            return true;
        } else if ((GlobalPara.getInstance().getTMS(TMS.Discount_Manual_Disable) & 0x01) != 0) {
            return false;
        } else {
            return true;
        }
    }

    public boolean Item_Check_UPrice(BigDecimal price) {
        if (!Item_Check_UPrice())
            return false;
        BigDecimal toBe = GlobalPara.getInstance().EcsCal_Rounding(price, GlobalPara.getInstance().getPointOfPrice(), 0);
        if ((price_UpperLimit.compareTo(BigDecimal.ZERO) != 0) && (toBe.compareTo(price_UpperLimit) > 0))
            return false;
        if ((price_LowerLimit.compareTo(BigDecimal.ZERO) != 0) && (toBe.compareTo(price_LowerLimit) < 0))
            return false;
        return true;
    }

    /**
     * @description: 单条明细重算
     **/
    public ItemContent Item_ReCal(TradeContent tradeContent) {
        BigDecimal purTax, tax;
        BigDecimal purTax_Orignal;
        this.Item_GetUPrice_Track(tradeContent); // 单价追踪重算

        purTax = GlobalPara.getInstance().EcsCal_Unit_ValueConvert(this.getPrice().multiply(this.getAmount()), this.getUnit_weight(), this.getUnit_price());
        purTax_Orignal = GlobalPara.getInstance().EcsCal_Unit_ValueConvert(this.getPrice_Original().multiply(this.getAmount()), this.getUnit_weight(), this.getUnit_price());
        if (this.getTaxType() == 1) {
            tax = purTax.multiply(this.getTaxRate());
            purTax = purTax.add(tax);

            purTax_Orignal = purTax_Orignal.add(purTax_Orignal.multiply(this.getTaxRate()));
        } else if (this.getTaxType() == 2) {
            tax = purTax.multiply(this.getTaxRate()).divide(this.getTaxRate().add(BigDecimal.ONE), 7, BigDecimal.ROUND_HALF_UP);
        } else if (this.getTaxType() == 3) {
            tax = purTax.multiply(this.getTaxRate());
        } else
            tax = BigDecimal.ZERO;

        this.setTax(GlobalPara.getInstance().EcsCal_Rounding_Single(tax));
        this.setSingleWtax(GlobalPara.getInstance().EcsCal_Rounding_Single(purTax));
        this.setSingleNtax(this.getSingleWtax().subtract(this.getTax()));
        this.setSingleWtax_Original(GlobalPara.getInstance().EcsCal_Rounding_Single(purTax_Orignal));
        this.setValid_Single((this.getSingleWtax().compareTo(BigDecimal.ZERO) != 0) || (GlobalPara.getInstance().getTMS(TMS.Fuc_ZeroSale) == 1));

        // if (GlobalPara.getInstance().EcsCal_Unit_isWeight(this.getUnit_weight()) && this.isValid_Amount()) {
        //     int spu = GlobalPara.getInstance().getTMS(TMS.SP_Unconfirmed);
        //     if ((spu == 2) || ((spu >= 1) && (this.getSingleWtax().compareTo(BigDecimal.ZERO) > 0))) {
        //         amount_Unconfirmed = amount;
        //         price_Unconfirmed = price;
        //     }
        // }

        if (GlobalPara.getInstance().EcsCal_Unit_isWeight(this.getUnit_weight())) {
            if (WeightCal.getInstance().getUsedGross().compareTo(BigDecimal.ZERO) > 0) {
                amount_Unconfirmed = price_Unconfirmed = BigDecimal.ZERO;
            } else if (this.isValid_Amount()) {
                int spu = GlobalPara.getInstance().getTMS(TMS.SP_Unconfirmed);
                if ((spu == 2) || ((spu >= 1) && (this.getSingleWtax().compareTo(BigDecimal.ZERO) > 0))) {
                    amount_Unconfirmed = amount;
                    price_Unconfirmed = price;
                }
            }
        } else {
            if (this.isValid_Amount()) {
                int spu = GlobalPara.getInstance().getTMS(TMS.SP_Unconfirmed);
                if ((spu == 2) || ((spu >= 1) && (this.getSingleWtax().compareTo(BigDecimal.ZERO) > 0))) {
                    amount_Unconfirmed = amount;
                    price_Unconfirmed = price;
                }
            }
        }

        return this;
    }

    /**
     * @description: 是否产生Unconfirmed信息
     **/
    public boolean ItemHasUnconfirmed(WeightResult wr) {
        if (wr.getGross().compareTo(BigDecimal.ZERO) <= 0)
            return amount_Unconfirmed.compareTo(BigDecimal.ZERO) > 0;
        return false;
    }

    public BigDecimal getAmount_Unconfirmed() {
        return amount_Unconfirmed;
    }

    public void setAmount_Unconfirmed(BigDecimal amount_Unconfirmed) {
        this.amount_Unconfirmed = amount_Unconfirmed;
    }

    public BigDecimal getPrice_Unconfirmed() {
        return price_Unconfirmed;
    }

    public void setPrice_Unconfirmed(BigDecimal price_Unconfirmed) {
        this.price_Unconfirmed = price_Unconfirmed;
    }

    /**
     * @param tradeContent
     * @description: 单价追踪重算
     */
    private boolean Item_GetUPrice_Track(TradeContent tradeContent)           //cal price with VIP-Level && Amount discount. before unit convert
    {
        if ((GlobalPara.getInstance().getTMS(TMS.Discount_Auto_PriceTrack) <= 0)
                || GlobalPara.getInstance().getTMS(TMS.Discount_Auto_PriceTrack) > 3)
            return false;
        if (this.isPriceIsManual())
            return false;

        BigDecimal price = tradeContent.CalPLU_UPrice_VIPed(this.getPlu());
        boolean update = GlobalPara.getInstance().getTMS(TMS.Discount_Auto_PriceTrack) == 3;

        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int day_week = calendar.get(Calendar.DAY_OF_WEEK);
        if (calendar.getFirstDayOfWeek() == Calendar.SUNDAY)
            day_week--;
        else if (day_week == 7)
            day_week = 0;
        day_week = 1 << day_week;

        if (GlobalPara.getInstance().isDiscountAuto_InTime()) {
            DPriceV2 dPrice = this.plu.price(GlobalPara.getInstance().getDeviceLevel());
            if (dPrice.getAutoDiscounts() != null && !dPrice.getAutoDiscounts().isEmpty()) {
                for (DAutoDiscountV2 autoDiscount : dPrice.getAutoDiscounts()) {
                    if ((autoDiscount.date() & day_week) != 0) {
                        switch (autoDiscount.type()) {
                            case 1:
                                if ((this.getAmount().compareTo(GlobalPara.getInstance().EcsCal_Unit_WeightConvertSystem(autoDiscount.lower(), this.getPlu().getUnit())) >= 0)
                                        && (this.getAmount().compareTo(GlobalPara.getInstance().EcsCal_Unit_WeightConvertSystem(autoDiscount.upper(), this.getPlu().getUnit())) <= 0)) {
                                    if (autoDiscount.getDiscount().compareTo(BigDecimal.ZERO) >= 0)
                                        price = autoDiscount.discount();
                                    else
                                        price = price.add(autoDiscount.discount());
                                }
                                update = true;
                                break;
                            case 2:
                                int hhmm = calendar.get(Calendar.HOUR_OF_DAY) * 100 + calendar.get(Calendar.MINUTE);
                                if ((hhmm >= autoDiscount.lower().intValue()) && (hhmm <= autoDiscount.upper().intValue())) {
                                    if (BigDecimalUtils.compareMoreZeroValue(autoDiscount.discount()))
                                        price = autoDiscount.discount();
                                    else
                                        price = price.add(autoDiscount.discount());
                                    update = true;
                                } else if (GlobalPara.getInstance().getTMS(TMS.Discount_Auto_PriceTrack) == 2)
                                    update = true;
                                break;
                            case 11:
                                if (BigDecimalUtils.compareMoreZeroValue(autoDiscount.discount()))
                                    this.setServiceFee(autoDiscount.discount());
                                break;
                            default:
                                break;
                        }
                    }
                }
            }

            // for (int loop = 0; loop < this.getPlu().getDa_sort().length; loop++) {
            //     if ((this.getPlu().getDa_wDay()[loop] & day_week) != 0) {
            //         if (this.getPlu().getDa_sort()[loop] == 1) {
            //             if ((this.getAmount().compareTo(GlobalPara.getInstance().EcsCal_Unit_WeightConvertSystem(this.getPlu().getDa_dLimit()[loop], this.getPlu().getUnit())) >= 0)
            //                     && (this.getAmount().compareTo(GlobalPara.getInstance().EcsCal_Unit_WeightConvertSystem(this.getPlu().getDa_uLimit()[loop], this.getPlu().getUnit())) <= 0)) {
            //                 if (this.getPlu().getDa_tarValue()[loop].compareTo(BigDecimal.ZERO) >= 0)
            //                     price = this.getPlu().getDa_tarValue()[loop];
            //                 else
            //                     price = price.add(this.getPlu().getDa_tarValue()[loop]);
            //             }
            //             update = true;
            //         } else if (this.getPlu().getDa_sort()[loop] == 2) {
            //             int hhmm = calendar.get(Calendar.HOUR_OF_DAY) * 100 + calendar.get(Calendar.MINUTE);
            //             if ((hhmm >= this.getPlu().getDa_dLimit()[loop].intValue())
            //                     && (hhmm <= this.getPlu().getDa_uLimit()[loop].intValue())) {
            //                 if (this.getPlu().getDa_tarValue()[loop].compareTo(BigDecimal.ZERO) >= 0)
            //                     price = this.getPlu().getDa_tarValue()[loop];
            //                 else
            //                     price = price.add(this.getPlu().getDa_tarValue()[loop]);
            //                 update = true;
            //             } else if (GlobalPara.getInstance().getTMS(TMS.Discount_Auto_PriceTrack) == 2)
            //                 update = true;
            //         } else if (this.getPlu().getDa_sort()[loop] == 11) {
            //             if (this.getPlu().getDa_tarValue()[loop].compareTo(BigDecimal.ZERO) >= 0)
            //                 this.setServiceFee(this.getPlu().getDa_tarValue()[loop]);
            //         }
            //     }
            // }
        }
        if (update) {
            this.setPrice(GlobalPara.getInstance().CalPLU_Price_wUnit(price, this.getPlu().getUnit()));
            this.setUnit_price(GlobalPara.getInstance().CalPLU_PriceUnit_wUnit(this.getPlu().getUnit()));
        }
        return update;
    }

    /**
     * @description: 添加商品图片
     **/
    public ItemContent addPics(String... pics) {
        if (pics == null || pics.length == 0) return this;
        if (this.pics == null) this.pics = new ArrayList<>();
        this.pics.addAll(Arrays.asList(pics));
        return this;
    }

    /**
     * @description: 获取商品图片
     **/
    public List<String> pics() {
        if (this.pics != null && !this.pics.isEmpty()) return this.pics;
        return this.plu.getPictures();
    }

    /**
     * @description: 切换当前ItemContent的单位
     * <p>
     * 切换为重量时，返回true
     * 切换为数量时，返回false
     **/
    public boolean SwitchUnit() {
        if (unit_weight == 2) {
            this.setUnit_weight(GlobalPara.getInstance().getWeightUNIT());
            this.setUnit_price(GlobalPara.getInstance().getPriceUNIT());
            if (plu.unit() != 2)
                this.setPreTare(GlobalPara.getInstance().EcsCal_Unit_WeightConvertSystem(plu.tare(), plu.unit()));
            return true;
        } else {
            this.setUnit_weight(2);
            this.setUnit_price(2);
            this.setPreTare(BigDecimal.ZERO);
            return false;
        }
    }

    /*************************************************** 属性 get set *******************************************************************/

    public DPLUV5 getPlu() {
        return plu;
    }

    public void setPlu(DPLUV5 plu) {
        this.plu = plu;
    }

    public BigDecimal getTare() {
        return tare;
    }

    public void setTare(BigDecimal tare) {
        this.tare = tare;
    }

    public BigDecimal getPackageTare() {
        return packageTare;
    }

    public BigDecimal getPercentedTare() {
        return percentedTare;
    }

    public boolean isFixedSingle() {
        return fixedSingle;
    }

    public void setFixedSingle(boolean fixedSingle) {
        this.fixedSingle = fixedSingle;
    }

    public BigDecimal getPreTare() {
        return preTare;
    }

    public void setPreTare(BigDecimal preTare) {
        this.preTare = preTare;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public boolean isPriceIsManual() {
        return priceIsManual;
    }

    public void setPriceIsManual(boolean priceIsManual) {
        this.priceIsManual = priceIsManual;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public int getUnit_weight() {
        return unit_weight;
    }

    public void setUnit_weight(int unit_weight) {
        this.unit_weight = unit_weight;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public boolean isValid_Amount() {
        return valid_Amount;
    }

    public void setValid_Amount(boolean valid_Amount) {
        this.valid_Amount = valid_Amount;
        this.valid_UsedGross = BigDecimal.ZERO;
    }

    public void setValid_Amount(boolean valid_Amount, BigDecimal usedGross) {
        this.valid_Amount = valid_Amount;
        this.valid_UsedGross = usedGross;
    }

    public BigDecimal getValid_UsedGross() {
        return valid_UsedGross;
    }

    public boolean isValid_Single() {
        return valid_Single;
    }

    public void setValid_Single(boolean valid_Single) {
        this.valid_Single = valid_Single;
    }

    public int getTaxType() {
        return taxType;
    }

    public void setTaxType(int taxType) {
        this.taxType = taxType;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public Integer getUnit_price() {
        return unit_price;
    }

    public void setUnit_price(Integer unit_price) {
        this.unit_price = unit_price;
    }

    public BigDecimal getPrice_Original() {
        return price_Original;
    }

    public ItemContent setPrice_Original(BigDecimal price_Original) {
        this.price_Original = price_Original;
        return this;
    }

    public BigDecimal getPrice_UpperLimit() {
        return price_UpperLimit;
    }

    public void setPrice_UpperLimit(BigDecimal price_UpperLimit) {
        this.price_UpperLimit = price_UpperLimit;
    }

    public BigDecimal getPrice_LowerLimit() {
        return price_LowerLimit;
    }

    public void setPrice_LowerLimit(BigDecimal price_LowerLimit) {
        this.price_LowerLimit = price_LowerLimit;
    }

    public BigDecimal getSingleWtax_Original() {
        return singleWtax_Original;
    }

    public void setSingleWtax_Original(BigDecimal singleWtax_Original) {
        this.singleWtax_Original = singleWtax_Original;
    }

    public BigDecimal getAmount_Stock() {
        return amount_Stock;
    }

    public void setAmount_Stock(BigDecimal amount_Stock) {
        this.amount_Stock = amount_Stock;
    }

    public int getUnit_Stock() {
        return unit_Stock;
    }

    public void setUnit_Stock(int unit_Stock) {
        this.unit_Stock = unit_Stock;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public BigDecimal getSingleNtax() {
        return singleNtax;
    }

    public void setSingleNtax(BigDecimal singleNtax) {
        this.singleNtax = singleNtax;
    }

    public BigDecimal getSingleWtax() {
        return singleWtax;
    }

    public void setSingleWtax(BigDecimal singleWtax) {
        this.singleWtax = singleWtax;
    }

    public BigDecimal getServiceFee() {
        return serviceFee;
    }

    public void setServiceFee(BigDecimal serviceFee) {
        this.serviceFee = serviceFee;
    }

    public boolean isNegativeFlag() {
        return negativeFlag;
    }

    public void setNegativeFlag(boolean negativeFlag) {
        this.negativeFlag = negativeFlag;
    }

    public List<String> getPics() {
        return pics;
    }

    public void setPics(List<String> pics) {
        this.pics = pics;
    }

    public int getReject() {
        return reject;
    }

    public void setReject(int reject) {
        this.reject = reject;
    }

    public boolean reject() {
        return this.reject == AConstant.REJECT;
    }

    public Integer getSpec() {
        return spec;
    }

    public void setSpec(Integer spec) {
        this.spec = spec;
    }

    public int spec() {
        return Objects.nonNull(this.spec) ? this.spec : SP_Sale_Acc_C_Key;
    }

    public void putPosOnlyString(Integer number, String value) {
        posOnlyString.put(number, value);
    }

    public String getPosOnlyString(Integer number) {
        return posOnlyString.get(number);
    }

    public Map<Integer, String> getPosOnlyString() {
        return posOnlyString;
    }

    /*************************************************** 属性 get set *******************************************************************/
}
