package com.jhscale.meter.protocol.model;

import com.jhscale.common.model.device._inner.PublicExecute;
import com.jhscale.meter.io.PortManager;
import com.jhscale.meter.io.entity.TCPServerEntity;
import io.netty.channel.ChannelHandlerContext;

import java.util.Objects;

/**
 * @author lie_w
 * @title: TCPCall
 * @projectName meter-jar
 * @description: TODO
 * @date 2023/2/2214:31
 */
public class JHTCPAccept extends TCPServerEntity {

    // 数据包
    private PublicExecute accept;

    // 数据内容包
    private String acceptStr;

    private JHTCPAnswer answer;

    public JHTCPAccept() {
    }

    public JHTCPAccept(PortManager portManager) {
        super(portManager);
    }

    public JHTCPAccept(PortManager portManager, PublicExecute accept) {
        super(portManager);
        this.accept = accept;
    }

    public JHTCPAccept(ChannelHandlerContext ctx, PublicExecute accept) {
        super(ctx);
        this.accept = accept;
    }

    /**
     * @description: 获取回调对象
     **/
    public JHTCPAnswer callBack() {
        if(this.answer == null){
            this.answer = Objects.nonNull(this.getPortManager()) ? new JHTCPAnswer(this.getPortManager(), this.accept) : new JHTCPAnswer(this.getCtx(), this.accept);
        }
        return this.answer;
    }

    /**
     * @description: 获取回调异步对象
     **/
    public JHTCPAnswer callBack_async() {
        return this.callBack().setAsync(true);
    }

    public PublicExecute getAccept() {
        return accept;
    }

    public JHTCPAccept setAccept(PublicExecute accept) {
        this.accept = accept;
        return this;
    }

    public String getAcceptStr() {
        return acceptStr;
    }

    public JHTCPAccept setAcceptStr(String acceptStr) {
        this.acceptStr = acceptStr;
        return this;
    }
}
