package com.jhscale.meter.protocol.model;

import com.jhscale.common.model.device._inner.PublicExecute;
import com.jhscale.common.model.device._inner.PublicExecuteModify;
import com.jhscale.meter.io.PortManager;
import com.jhscale.meter.utils.MeterUtils;
import io.netty.channel.ChannelHandlerContext;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @author lie_w
 * @title: TCPCall
 * @projectName meter-jar
 * @description: TODO
 * @date 2023/2/2214:31
 */
public class JHTCPAnswer extends JHTCPAccept {

    private int limit = 50;

    // private int lastNo;

    // 同步 异步
    private boolean async = false;

    // 数据包
    private List<PublicExecute> answers;

    // 响应数据包
    private String answerStr;

    public JHTCPAnswer() {
    }

    public JHTCPAnswer(PortManager portManager, PublicExecute accept) {
        super(portManager, accept);
    }

    public JHTCPAnswer(ChannelHandlerContext ctx, PublicExecute accept) {
        super(ctx, accept);
    }

    /**
     * @description: 添加数据包
     **/
    public JHTCPAnswer addAnswer(PublicExecute... answers) {
        if (answers != null && answers.length > 0)
            this.addAnswerList(Arrays.asList(answers));
        return this;
    }

    /**
     * @description: 添加数据包
     **/
    public JHTCPAnswer addAnswerOnce(PublicExecute execute) {
        if (execute != null) this.addAnswer(execute);
        return this;
    }

    /**
     * @description: 添加数据包
     **/
    public JHTCPAnswer addAnswerList(List<PublicExecute> executes) {
        if (executes != null && !executes.isEmpty()) {
            if (this.answers == null) this.answers = new ArrayList<>();
            this.answers.addAll(executes);
            // if (executes.get(executes.size() - 1) instanceof PublicExecuteModify) {
            //     this.lastNo = ((PublicExecuteModify) executes.get(executes.size() - 1)).getLastNo();
            // }
        }
        return this;
    }

    /**
     * @description: 响应结果信息
     **/
    public boolean resultExecute() {
        if (StringUtils.isNotBlank(this.answerStr)) {
            return this.writeData(this.answerStr);
        } else if (this.answers != null && !this.answers.isEmpty()) {
            boolean result = true;
            for (PublicExecute answer : this.answers) {
                if (answer instanceof PublicExecuteModify) {
                    int page = ((PublicExecuteModify) answer).getModels().size() / this.limit;
                    page = (((PublicExecuteModify) answer).getModels().size() % this.limit == 0) ? page : (page + 1);
                    for (int i = 0; i < page; i++) {
                        if (i == page) {
                            System.out.println(1);
                        }
                        int end = Math.min(((PublicExecuteModify) answer).getModels().size(), (i + 1) * this.limit);
                        int start = i * this.limit;
                        String part = answer.Package_No_Reflex(start, end);
                        result = this.writeData(part);
                    }
                } else {
                    String response = MeterUtils.public_response_package(this.getAccept(), Arrays.asList(answer));
                    result = this.writeData(response);
                }

                if (!result) break;
            }
            return result;
        } else {
            String response = MeterUtils.public_response_package(this.getAccept(), null);
            return this.writeData(response);
        }
    }

    /**
     * @description: 单次发送 0-第一页 1-中间页 2-最后页 3-全部
     **/
    public boolean onceResultExecute(int status) {
        if (StringUtils.isNotBlank(this.answerStr)) {
            return this.writeData(this.answerStr);
        } else if (this.answers == null || this.answers.isEmpty()) {
            String response = MeterUtils.public_response_package(this.getAccept(), null);
            return this.writeData(response);
        } else {
            boolean result = true;
            for (PublicExecute answer : answers) {
                long t1 = System.currentTimeMillis();
                StringBuilder builder = new StringBuilder();
                if (status == 0 || status == 3) {
                    builder.append(answer.Package_No_Reflex_Top());
                }

                builder.append(answer.Package_No_Reflex_Body());

                if (status == 2 || status == 3) {
                    builder.append(answer.Package_No_Reflex_Tail());
                }
                long t2 = System.currentTimeMillis();
                result = this.writeData(builder.toString());
                long t3 = System.currentTimeMillis();
                answer.clear();
                if (!result) break;
                System.out.printf("Length:[%s], Total:[%s], Package:[%s], Write_Send:[%s]%n", builder.length(), (t3 - t1), (t2 - t1), (t3 - t2));
            }
            if (this.answers != null && !this.answers.isEmpty()) this.answers.clear();
            return result;
        }
    }

    public int getLimit() {
        return limit;
    }

    public JHTCPAnswer setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public boolean isAsync() {
        return async;
    }

    public JHTCPAnswer setAsync(boolean async) {
        this.async = async;
        return this;
    }

    public List<PublicExecute> getAnswers() {
        return answers;
    }

    public JHTCPAnswer setAnswers(List<PublicExecute> answers) {
        this.answers = answers;
        return this;
    }

    public String getAnswerStr() {
        return answerStr;
    }

    public JHTCPAnswer setAnswerStr(String answerStr) {
        this.answerStr = answerStr;
        return this;
    }

    // public int getLastNo() {
    //     return lastNo;
    // }

    // public void setLastNo(int lastNo) {
    //     this.lastNo = lastNo;
    // }
}
