package com.jhscale.meter.protocol.model;

import com.jhscale.common.model.device._inner.PublicExecute;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.io.PortManager;
import com.jhscale.meter.utils.MeterUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @author lie_w
 * @title: TCPCall
 * @projectName meter-jar
 * @description: TODO
 * @date 2023/2/2214:31
 */
@Deprecated
public class JHTCPCallBack extends JHTCPCall {

    // 同步 异步
    private boolean async = false;

    // 数据包
    private List<PublicExecute> callBackExecutes;

    public JHTCPCallBack() {
    }

    public JHTCPCallBack(PortManager portManager) {
        super(portManager);
    }

    public JHTCPCallBack(PortManager portManager, List<PublicExecute> callExecutes) {
        super(portManager, callExecutes);
    }


    /**
     * @description: 添加数据包
     **/
    public JHTCPCallBack addExecute(PublicExecute... executes) {
        if (executes != null && executes.length > 0) {
            if (this.callBackExecutes == null) this.callBackExecutes = new ArrayList<>();
            this.callBackExecutes.addAll(Arrays.asList(executes));
        }
        return this;
    }

    /**
     * @description: 响应结果信息
     **/
    public boolean resultExecute() {
        String response = MeterUtils.public_response_package(this.getCallExecutes(), this.callBackExecutes);
        try {
            this.getPortManager().writeDataImmediately(response.getBytes());
            return true;
        } catch (MeterException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean isAsync() {
        return async;
    }

    public JHTCPCallBack setAsync(boolean async) {
        this.async = async;
        return this;
    }

    public List<PublicExecute> getCallBackExecutes() {
        return callBackExecutes;
    }

    public JHTCPCallBack setCallBackExecutes(List<PublicExecute> callBackExecutes) {
        this.callBackExecutes = callBackExecutes;
        return this;
    }
}
