package com.jhscale.meter.protocol.model;

import com.jhscale.common.model.inter.GJSONModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * @author lie_w
 * @title: PLUContent
 * @projectName meter-jar
 * @description: TODO
 * @date 2022/9/2112:46
 */
@ApiModel("PLU信息")
public class PLUContent implements GJSONModel {

    @ApiModelProperty(value = "PLU编号", name = "number")
    private int number;
    @ApiModelProperty(value = "PLU名称", name = "name")
    private String name;

    @ApiModelProperty(value = "库存类型", name = "inventory", example = "0|NULL-库存商品 1-非库存商品")
    private Integer inventory;
    @ApiModelProperty(value = "库存编号", name = "pluCode")
    private Long pluCode;
    @ApiModelProperty(value = "库存单位", name = "pluUnit")
    private int pluUnit;

    @ApiModelProperty(value = "单价", name = "price")
    private BigDecimal price;
    @ApiModelProperty(value = "单位", name = "unit")
    private int unit;
    @ApiModelProperty(value = "自定义量词", name = "unitText")
    private String unitText;

    @ApiModelProperty(value = "皮重", name = "tare")
    private BigDecimal tare = BigDecimal.ZERO;
    @ApiModelProperty(value = "条码标志", name = "barFlag")
    private int barFlag = 0;
    @ApiModelProperty(value = "PLU索引条码", name = "barcodeIndex")
    private String barcodeIndex = "";
    @ApiModelProperty(value = "货号", name = "itemCode")
    private int itemCode = 0;

    @ApiModelProperty(value = "Class编号", name = "classNo")
    private int classNo = 9;
    @ApiModelProperty(value = "Dept编号", name = "deptNo")
    private int deptNo = 9;

    @ApiModelProperty(value = "打印出售日期", name = "ps_SaleDate")
    private int ps_SaleDate = 0;
    @ApiModelProperty(value = "打印出售时间", name = "ps_SaleTime")
    private int ps_SaleTime = 0;
    @ApiModelProperty(value = "打印包装日期", name = "ps_PackDate")
    private int ps_PackDate = 0;
    @ApiModelProperty(value = "打印包装时间", name = "ps_PackTime")
    private int ps_PackTime = 0;
    @ApiModelProperty(value = "打印出售日期", name = "ps_UserDate")
    private int ps_UserDate = 0;
    @ApiModelProperty(value = "出售日期", name = "pc_SaleDate")
    private int pc_SaleDate = 0;
    @ApiModelProperty(value = "出售时间", name = "pc_SaleTime")
    private int pc_SaleTime = 0;
    @ApiModelProperty(value = "包装日期", name = "pc_PackDate")
    private int pc_PackDate = 0;
    @ApiModelProperty(value = "包装时间", name = "pc_PackTime")
    private int pc_PackTime = 0;
    @ApiModelProperty(value = "出售日期", name = "pc_UserDate")
    private int pc_UserDate = 0;

    @ApiModelProperty(value = "文本1", name = "text1")
    private String text1 = "";
    @ApiModelProperty(value = "文本2", name = "text2")
    private String text2 = "";
    @ApiModelProperty(value = "文本3", name = "text3")
    private String text3 = "";
    @ApiModelProperty(value = "文本4", name = "text4")
    private String text4 = "";
    @ApiModelProperty(value = "文本5", name = "text5")
    private String text5 = "";
    @ApiModelProperty(value = "文本6", name = "text6")
    private String text6 = "";
    @ApiModelProperty(value = "文本7", name = "text7")
    private String text7 = "";

    @ApiModelProperty(value = "税种", name = "taxType")
    private int taxType = 0;
    @ApiModelProperty(value = "税率", name = "taxRate")
    private int taxRate = 0;

    @ApiModelProperty(value = "位图", name = "bitmap")
    private int bitmap = 0;

    @ApiModelProperty(value = "百分比去皮", name = "percentTare")
    private BigDecimal tarePercent = BigDecimal.ZERO;
    //    @ApiModelProperty(value = "标志", name = "flag")
    //    private int flag=0;
    //    @ApiModelProperty(value = "标志值", name = "flag_Value")
    //    private int flag_Value=0;

    @ApiModelProperty(value = "自动折扣种类", name = "sort")
    private int[] da_sort = new int[]{0, 0, 0, 0};
    @ApiModelProperty(value = "自动折扣有效日", name = "wDay")
    private int[] da_wDay = new int[]{0, 0, 0, 0};
    @ApiModelProperty(value = "自动折扣上限值", name = "uLimit")
    private BigDecimal[] da_uLimit = new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO};
    @ApiModelProperty(value = "自动折扣下限值", name = "dLimit")
    private BigDecimal[] da_dLimit = new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO};
    @ApiModelProperty(value = "自动折扣目标值", name = "tarValue")
    private BigDecimal[] da_tarValue = new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO};

    /*************************************************** 属性 get set *******************************************************************/

    public int getNumber() {
        return number;
    }

    public PLUContent setNumber(int number) {
        this.number = number;
        return this;
    }

    public String getName() {
        return name;
    }

    public PLUContent setName(String name) {
        this.name = name;
        return this;
    }

    public Integer getInventory() {
        return inventory;
    }

    public PLUContent setInventory(Integer inventory) {
        this.inventory = inventory;
        return this;
    }

    public Long getPluCode() {
        return pluCode;
    }

    public PLUContent setPluCode(Long pluCode) {
        this.pluCode = pluCode;
        return this;
    }

    public int getPluUnit() {
        return pluUnit;
    }

    public PLUContent setPluUnit(int pluUnit) {
        this.pluUnit = pluUnit;
        return this;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public PLUContent setPrice(BigDecimal price) {
        this.price = price;
        return this;
    }

    public int getUnit() {
        return unit;
    }

    public PLUContent setUnit(int unit) {
        this.unit = unit;
        return this;
    }

    public String getUnitText() {
        return unitText;
    }

    public PLUContent setUnitText(String unitText) {
        this.unitText = unitText;
        return this;
    }

    public BigDecimal getTare() {
        return tare;
    }

    public PLUContent setTare(BigDecimal tare) {
        this.tare = tare;
        return this;
    }

    public int getBarFlag() {
        return barFlag;
    }

    public PLUContent setBarFlag(int barFlag) {
        this.barFlag = barFlag;
        return this;
    }

    public String getBarcodeIndex() {
        return barcodeIndex;
    }

    public PLUContent setBarcodeIndex(String barcodeIndex) {
        this.barcodeIndex = barcodeIndex;
        return this;
    }

    public int getItemCode() {
        return itemCode;
    }

    public PLUContent setItemCode(int itemCode) {
        this.itemCode = itemCode;
        return this;
    }

    public int getClassNo() {
        return classNo;
    }

    public PLUContent setClassNo(int classNo) {
        this.classNo = classNo;
        return this;
    }

    public int getDeptNo() {
        return deptNo;
    }

    public PLUContent setDeptNo(int deptNo) {
        this.deptNo = deptNo;
        return this;
    }

    public int getPs_SaleDate() {
        return ps_SaleDate;
    }

    public PLUContent setPs_SaleDate(int ps_SaleDate) {
        this.ps_SaleDate = ps_SaleDate;
        return this;
    }

    public int getPs_SaleTime() {
        return ps_SaleTime;
    }

    public PLUContent setPs_SaleTime(int ps_SaleTime) {
        this.ps_SaleTime = ps_SaleTime;
        return this;
    }

    public int getPs_PackDate() {
        return ps_PackDate;
    }

    public PLUContent setPs_PackDate(int ps_PackDate) {
        this.ps_PackDate = ps_PackDate;
        return this;
    }

    public int getPs_PackTime() {
        return ps_PackTime;
    }

    public PLUContent setPs_PackTime(int ps_PackTime) {
        this.ps_PackTime = ps_PackTime;
        return this;
    }

    public int getPs_UserDate() {
        return ps_UserDate;
    }

    public PLUContent setPs_UserDate(int ps_UserDate) {
        this.ps_UserDate = ps_UserDate;
        return this;
    }

    public int getPc_SaleDate() {
        return pc_SaleDate;
    }

    public PLUContent setPc_SaleDate(int pc_SaleDate) {
        this.pc_SaleDate = pc_SaleDate;
        return this;
    }

    public int getPc_SaleTime() {
        return pc_SaleTime;
    }

    public PLUContent setPc_SaleTime(int pc_SaleTime) {
        this.pc_SaleTime = pc_SaleTime;
        return this;
    }

    public int getPc_PackDate() {
        return pc_PackDate;
    }

    public PLUContent setPc_PackDate(int pc_PackDate) {
        this.pc_PackDate = pc_PackDate;
        return this;
    }

    public int getPc_PackTime() {
        return pc_PackTime;
    }

    public PLUContent setPc_PackTime(int pc_PackTime) {
        this.pc_PackTime = pc_PackTime;
        return this;
    }

    public int getPc_UserDate() {
        return pc_UserDate;
    }

    public PLUContent setPc_UserDate(int pc_UserDate) {
        this.pc_UserDate = pc_UserDate;
        return this;
    }

    public String getText1() {
        return text1;
    }

    public PLUContent setText1(String text1) {
        this.text1 = text1;
        return this;
    }

    public String getText2() {
        return text2;
    }

    public PLUContent setText2(String text2) {
        this.text2 = text2;
        return this;
    }

    public String getText3() {
        return text3;
    }

    public PLUContent setText3(String text3) {
        this.text3 = text3;
        return this;
    }

    public String getText4() {
        return text4;
    }

    public PLUContent setText4(String text4) {
        this.text4 = text4;
        return this;
    }

    public String getText5() {
        return text5;
    }

    public PLUContent setText5(String text5) {
        this.text5 = text5;
        return this;
    }

    public String getText6() {
        return text6;
    }

    public PLUContent setText6(String text6) {
        this.text6 = text6;
        return this;
    }

    public String getText7() {
        return text7;
    }

    public PLUContent setText7(String text7) {
        this.text7 = text7;
        return this;
    }

    public int getTaxType() {
        return taxType;
    }

    public PLUContent setTaxType(int taxType) {
        this.taxType = taxType;
        return this;
    }

    public int getTaxRate() {
        return taxRate;
    }

    public PLUContent setTaxRate(int taxRate) {
        this.taxRate = taxRate;
        return this;
    }

    public int getBitmap() {
        return bitmap;
    }

    public PLUContent setBitmap(int bitmap) {
        this.bitmap = bitmap;
        return this;
    }

    public BigDecimal getTarePercent() {
        return tarePercent;
    }

    public PLUContent setTarePercent(BigDecimal tarePercent) {
        this.tarePercent = tarePercent;
        return this;
    }

    public int[] getDa_sort() {
        return da_sort;
    }

    public PLUContent setDa_sort(int[] da_sort) {
        this.da_sort = da_sort;
        return this;
    }

    public int[] getDa_wDay() {
        return da_wDay;
    }

    public PLUContent setDa_wDay(int[] da_wDay) {
        this.da_wDay = da_wDay;
        return this;
    }

    public BigDecimal[] getDa_uLimit() {
        return da_uLimit;
    }

    public PLUContent setDa_uLimit(BigDecimal[] da_uLimit) {
        this.da_uLimit = da_uLimit;
        return this;
    }

    public BigDecimal[] getDa_dLimit() {
        return da_dLimit;
    }

    public PLUContent setDa_dLimit(BigDecimal[] da_dLimit) {
        this.da_dLimit = da_dLimit;
        return this;
    }

    public BigDecimal[] getDa_tarValue() {
        return da_tarValue;
    }

    public PLUContent setDa_tarValue(BigDecimal[] da_tarValue) {
        this.da_tarValue = da_tarValue;
        return this;
    }
    /*************************************************** 属性 get set *******************************************************************/
}
