package com.jhscale.meter.protocol.model;

import com.jhscale.common.model.device.category.DCategory;
import com.jhscale.common.model.inter.GJSONModel;
import com.jhscale.meter.protocol.constant.TMS;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;

/**
 * @author lie_w
 * @title: PrintCalculate_BarcodeCal
 * @projectName meter-jar
 * @description: TODO
 * @date 2022/9/2114:15
 */
public class PrintCalculate_BarcodeCal implements GJSONModel {

    //Quit=1;
    boolean isOK = true;
    //Target=PrintAppVP_Pcs->Barcode.Info;
    int targetPos = 0;
    //X_Init=X_Init_Ori;
    int x_Init;
    //Target_Loop=0;
    int targetLoopPos = -1;
    //QuitString=-1;
    int quitString = -1;
    //HoldString=0;
    int holdString = 0;
    //X_Init_Plus=0;
    int x_Init_Plus = 0;
    //CalBuf.B32=0;
    int calBuf_lng = 0;

    byte[] outputBuf = new byte[1024];
    Integer outputLng = 0;

//    private int barcodeFlag;
//
//    public PrintCalculate_BarcodeCal(int ctbarcodeFlag)
//    {
//        barcodeFlag=ctbarcodeFlag;
//    }

    private void loopCheck(int itemSize) {
        if (targetLoopPos >= 0) {
            if ((x_Init == 0) || (x_Init >= itemSize)) {
                targetLoopPos = -1;
                if (quitString >= 0) {
                    outputLng = quitString;
                    quitString = -1;
                }
            } else {
                x_Init++;
                targetPos = targetLoopPos;
            }
        }
    }

    private void pushByte(byte input) {
        if (outputLng < outputBuf.length) {
            outputBuf[outputLng] = input;
            outputLng++;
        } else {
            outputBuf[outputBuf.length - 1] = input;
        }
    }

    private void pushBytes(byte[] input, int offset, int size) {
        if (size + outputLng >= outputBuf.length)
            size = outputBuf.length - outputLng;
        System.arraycopy(input, offset, outputBuf, outputLng, size);
        outputLng += size;
    }

    private void pushString(String input) {
        byte[] sb = input.getBytes();
        pushBytes(sb, 0, sb.length);
    }

    private boolean pushBstring(String rs, byte[] input, int offset) {
        int cut = input[offset + 2] - 0x30;
        if ((cut < 0) || (cut > 9))
            return false;

        if (rs.length() <= cut)
            rs = "0";
        else
            rs = rs.substring(0, rs.length() - cut);

        int lng = input[offset + 1] - 0x30;
        if ((lng < 0) || (lng > 9))
            return false;

        if ((rs.length() > lng) && (input[offset + 3] != '1')) {
            if (input[offset + 3] == '0')
                return false;
            else if (input[offset + 3] == '2')
                pushString("000000000".substring(0, lng));
            else if (input[offset + 3] == '3')
                pushString("111111111".substring(0, lng));
            else if (input[offset + 3] == '4')
                pushString(rs);
        } else {
            rs = "000000000" + rs;
            pushString(rs.substring(rs.length() - lng, rs.length()));
        }

        return true;
    }

    private boolean pushBcode(Integer number, byte[] input, int offset) {
        return pushBstring(number.toString(), input, offset);
    }

    private byte Cal_CheckSum_EAN(byte[] input, int offset, int size, int euc) {
        int loop;
        int check;
        int temp;

        if (euc >= 2)
            return '0';

        for (loop = 0, check = 0; loop < size; loop++) {
            temp = input[offset + loop] - 0x30;
            check = (check + temp * (1 + 2 * ((size - loop + euc) & 0x01))) % 10;
        }

        return (byte) ((10 - check) % 10 + 0x30);
    }

    private byte[] Cal_CheckSum_PCDV_Digit_2_Sub = new byte[]
            {
                    0, 2, 4, 6, 8, 9, 1, 3, 5, 7,
            };
    private byte[] Cal_CheckSum_PCDV_Digit_3_Nom = new byte[]
            {
                    0, 3, 6, 9, 2, 5, 8, 1, 4, 7,
            };
    private byte[] Cal_CheckSum_PCDV_Digit_5_Sub = new byte[]
            {
                    0, 5, 9, 4, 8, 3, 7, 2, 6, 1,
            };
    private byte[] Cal_CheckSum_PCDV_Digit_5_Sub_Reversed = new byte[]
            {
                    0, 9, 7, 5, 3, 1, 8, 6, 4, 2,
            };
    private byte[] Cal_CheckSum_PCDV_Digit_5_Add = new byte[]
            {
                    0, 5, 1, 6, 2, 7, 3, 8, 4, 9,
            };

    private byte Cal_CheckSum_PCDV_In4(byte[] input, int offset) {
        return (byte)
                (0x30 +
                        ((Cal_CheckSum_PCDV_Digit_2_Sub[input[offset + 0] - 0x30]
                                + Cal_CheckSum_PCDV_Digit_2_Sub[input[offset + 1] - 0x30]
                                + Cal_CheckSum_PCDV_Digit_3_Nom[input[offset + 2] - 0x30]
                                + Cal_CheckSum_PCDV_Digit_5_Sub[input[offset + 3] - 0x30]
                        ) * 3
                        ) % 10);
    }

    private byte Cal_CheckSum_PCDV_In5(byte[] input, int offset) {
        return (byte)
                (0x30 + Cal_CheckSum_PCDV_Digit_5_Sub_Reversed[
                        (50 -
                                (Cal_CheckSum_PCDV_Digit_5_Add[input[offset + 0] - 0x30]
                                        + Cal_CheckSum_PCDV_Digit_2_Sub[input[offset + 1] - 0x30]
                                        + Cal_CheckSum_PCDV_Digit_5_Sub[input[offset + 2] - 0x30]
                                        + Cal_CheckSum_PCDV_Digit_5_Add[input[offset + 3] - 0x30]
                                        + Cal_CheckSum_PCDV_Digit_2_Sub[input[offset + 4] - 0x30]
                                )
                        ) % 10]);
    }

    private int EcsCal_Convert_T_ABS32(BigDecimal input, int dot) {
        int ABS;
        ABS = input.movePointRight(dot).intValue();
        if (ABS < 0)
            ABS = -ABS;
        return ABS;
    }

    public byte[] GetContent(byte[] input, int barcodeFlag, int x_Init_Ori, int billType, TradeContent tradeContent) {            //return "123456789012".getBytes();
        isOK = true;
        targetPos = 0;
        x_Init = x_Init_Ori;
        targetLoopPos = -1;
        quitString = -1;
        holdString = 0;
        x_Init_Plus = 0;
        outputLng = 0;

        ItemContent itemC = tradeContent.getItem().get((x_Init > 0) ? (x_Init - 1) : 0);

        while (true) {
            boolean gxTest;
            gxTest = false;

            if (targetPos >= input.length) {
                loopCheck(tradeContent.getItem().size());
                if (targetLoopPos < 0) {
                    if (isOK)
                        return Arrays.copyOfRange(outputBuf, 0, outputLng);
                    else
                        return null;
                }
                //break;
                itemC = tradeContent.getItem().get((x_Init > 0) ? (x_Init - 1) : 0);
                targetPos += 4;
            } else if (input[targetPos] == '=')      //	DatabaseC_Barcode_DisNo_Sort_Special	(-4)	//'='
            {
                int ctl = (input[targetPos + 2] - '0') * 10 + (input[targetPos + 3] - '0');
                if (input[targetPos + 1] == '0') {
                    if (ctl == 0) {
                        holdString = outputLng;
                        loopCheck(tradeContent.getItem().size());
                        if (targetLoopPos < 0)
                            x_Init = x_Init_Ori;
                        itemC = tradeContent.getItem().get((x_Init > 0) ? (x_Init - 1) : 0);
                    } else if (ctl == 1) {
                        holdString = outputLng;
                        loopCheck(tradeContent.getItem().size());
                        if (targetLoopPos < 0) {
                            x_Init = 0;
                            targetLoopPos = targetPos;
                        }
                        itemC = tradeContent.getItem().get((x_Init > 0) ? (x_Init - 1) : 0);
                    } else if (ctl == 5) {
                        holdString = outputLng;
                        if (targetLoopPos >= 0) {
                            if (x_Init == 0) {
                                targetLoopPos = -1;
                                if (quitString >= 0) {
                                    outputLng = quitString;
                                    quitString = -1;
                                }
                            } else {
                                itemC = tradeContent.getItem().get((x_Init > 0) ? (x_Init - 1) : 0);
                                if (!GlobalPara.getInstance().EcsCal_Unit_isWeight(itemC.getUnit_weight())) {
                                    x_Init_Plus++;
                                    if (new BigDecimal(x_Init_Plus).compareTo(itemC.getAmount()) >= 0) {
                                        x_Init++;
                                        x_Init_Plus = 0;
                                    }
                                } else {
                                    x_Init++;
                                    x_Init_Plus = 0;
                                }
                                if (x_Init > tradeContent.getItem().size()) {
                                    targetLoopPos = -1;
                                    if (quitString >= 0) {
                                        outputLng = quitString;
                                        quitString = -1;
                                    }
                                } else {
                                    targetPos = targetLoopPos;
                                }
                            }
                        }
                        if (targetLoopPos < 0) {
                            x_Init = x_Init_Plus = 0;
                            targetLoopPos = targetPos;
                        }
                        itemC = tradeContent.getItem().get((x_Init > 0) ? (x_Init - 1) : 0);
                    } else if (ctl == 2) {
                        if (targetLoopPos >= 0) {
                            if (x_Init >= tradeContent.getItem().size()) {
                                if (quitString < 0)
                                    quitString = outputLng;
                            }
                        }
                    } else if (ctl == 6) {
                        if (targetLoopPos >= 0) {
                            if (x_Init >= tradeContent.getItem().size()) {
                                itemC = tradeContent.getItem().get((x_Init > 0) ? (x_Init - 1) : 0);
                                if (!GlobalPara.getInstance().EcsCal_Unit_isWeight(itemC.getUnit_weight())) {
                                    if (new BigDecimal(x_Init_Plus + 1).compareTo(itemC.getAmount()) >= 0) {
                                        if (quitString < 0)
                                            quitString = outputLng;
                                    }
                                } else {
                                    if (quitString < 0)
                                        quitString = outputLng;
                                }
                            }
                        }
                    } else if (ctl == 3) {
                        if (!GlobalPara.getInstance().EcsCal_Unit_isWeight(itemC.getUnit_weight()))
                            outputLng = holdString;
                        else
                            holdString = outputLng;
                    } else if (ctl == 4) {
                        if (GlobalPara.getInstance().EcsCal_Unit_isWeight(itemC.getUnit_weight()))
                            outputLng = holdString;
                        else
                            holdString = outputLng;
                    } else if (ctl == 7) {
                        pushByte((byte) 0);
                        calBuf_lng = outputLng;
                    } else if (ctl == 8) {
                        if (calBuf_lng > 0)
                            outputBuf[calBuf_lng - 1] = (byte) (outputLng - calBuf_lng);
                    }
                } else if (input[targetPos + 1] == '1') {
                    if (ctl < 32) {
                        int digisize;
                        for (digisize = 0; digisize < outputLng; digisize++) {
                            byte digi;
                            digi = outputBuf[outputLng - 1 - digisize];
                            if ((digi >= '0') && (digi <= '9'))
                                continue;
                            else
                                break;
                        }
                        if (ctl == 0)
                            ctl = digisize;
                        else if (ctl > digisize)
                            ctl = digisize;
                        if (ctl > 0)
                            pushByte(Cal_CheckSum_EAN(outputBuf, outputLng - ctl, ctl, GlobalPara.getInstance().getTMS(TMS.SP_Barcode_EUC_Reversed)));
                    } else if (ctl == 50) {
                        pushByte((byte) 0);
                        outputBuf[outputLng - 1] = outputBuf[outputLng - 2];
                        outputBuf[outputLng - 2] = outputBuf[outputLng - 3];
                        outputBuf[outputLng - 3] = outputBuf[outputLng - 4];
                        outputBuf[outputLng - 4] = outputBuf[outputLng - 5];
                        outputBuf[outputLng - 5] = Cal_CheckSum_PCDV_In4(outputBuf, outputLng - 4);
                    } else if (ctl == 51) {
                        if (outputLng >= 4)
                            pushByte(Cal_CheckSum_PCDV_In4(outputBuf, outputLng - 4));
                    } else if (ctl == 52) {
                        pushByte((byte) 0);
                        outputBuf[outputLng - 1] = outputBuf[outputLng - 2];
                        outputBuf[outputLng - 2] = outputBuf[outputLng - 3];
                        outputBuf[outputLng - 3] = outputBuf[outputLng - 4];
                        outputBuf[outputLng - 4] = outputBuf[outputLng - 5];
                        outputBuf[outputLng - 5] = outputBuf[outputLng - 6];
                        outputBuf[outputLng - 6] = Cal_CheckSum_PCDV_In5(outputBuf, outputLng - 5);
                    } else if (ctl == 53) {
                        if (outputLng >= 5)
                            pushByte(Cal_CheckSum_PCDV_In5(outputBuf, outputLng - 5));
                    } else if (ctl == 99) {
                        Base64.Encoder encoder = Base64.getEncoder();
                        byte[] s = encoder.encode(Arrays.copyOfRange(outputBuf, 0, outputLng));
                        outputLng = s.length;
                        if (outputLng > outputBuf.length)
                            outputLng = outputBuf.length;
                        System.arraycopy(s, 0, outputBuf, 0, outputLng);
                    }
                } else if (input[targetPos + 1] == '2') {
                    if (ctl == 0) {
                        pushByte((byte) '\r');
                        pushByte((byte) '\n');
                    } else if (ctl == 1) {
                        pushByte((byte) '\r');
                    } else if (ctl == 2) {
                        pushByte((byte) '\n');
                    } else if (ctl < 8) {
                        ;
                    } else if (ctl < 40) {
                        pushByte((byte) (ctl - 8));
                    }
                }
                targetPos += 4;
            } else if (input[targetPos] == '@')      //	DatabaseC_Barcode_DisNo_Sort_Text	(-1)	//'@'
            {
                int ctl = (input[targetPos + 2] - '0') * 10 + (input[targetPos + 3] - '0');
                if (input[targetPos + 1] == '0') {
                    if (ctl == 0)
                        pushString(itemC.getPlu().getName());
                    else if (ctl == 1)
                        pushString(itemC.getPlu().getText().text(0));
                    else if (ctl == 2)
                        pushString(itemC.getPlu().getText().text(1));
                    else if (ctl == 3)
                        pushString(itemC.getPlu().getText().text(2));
                    else if (ctl == 4)
                        pushString(itemC.getPlu().getText().text(3));
                    else if (ctl == 5)
                        pushString(itemC.getPlu().getText().text(4));
                    else if (ctl == 6)
                        pushString(itemC.getPlu().getText().text(5));
                    else if (ctl == 7)
                        pushString(itemC.getPlu().getText().text(6));
                    else if (ctl == 8)
                        pushString(itemC.getPlu().getIndexBar());
                    gxTest = true;
                } else if (input[targetPos + 1] == '1') {
                    pushString(GlobalPara.getInstance().getTMT(ctl));
                } else if (input[targetPos + 1] == '2') {
                    ;
                } else if (input[targetPos + 1] == '3') {
                    if (ctl == 0)
                        pushString(tradeContent.getSalesman_Name());
                    else if (ctl == 1)
                        pushString(tradeContent.getServiceman_Name());
                    else if (ctl == 6)
                        pushString(GlobalPara.getInstance().getSystemID());
                }
                targetPos += 4;
            } else if (input[targetPos] == '?')      //	DatabaseC_Barcode_DisNo_Sort_Custom	(-2)	//'?'
            {
                String bCustom = "B" + input[targetPos + 1] + input[targetPos + 2] + input[targetPos + 3];
                int itemNo = (x_Init > 0) ? x_Init : 1;     //input range: 1 to itemsize
                String caled;
                caled = tradeContent.getCustomInfo().get(bCustom + '-' + Integer.toString(itemNo));
                if (caled == null)
                    caled = tradeContent.getCustomInfo().get(bCustom);
                if (caled == null)
                    pushString(caled);
                //Need some check
                targetPos += 4;
                gxTest = true;
            } else if (input[targetPos] == '>')      //	DatabaseC_Barcode_DisNo_Sort_CText	(-3)	//'>'
            {
                int vPos;
                for (vPos = 1; (targetPos + vPos < input.length) && input[targetPos + vPos] != 11; vPos++)
                    ;
                pushBytes(input, targetPos + 1, vPos - 1);
                targetPos += vPos + 1;
            } else if (input[targetPos] == ' ')      //	SPACE
            {
                targetPos++;
            } else {
                int lvl = 0;
                int no = 0;
                while ((input[targetPos + lvl] >= 'A') && (input[targetPos + lvl] <= 'Z')) {
                    no = no * 26 + (input[targetPos + lvl] - 'A');
                    lvl++;
                }
                if (lvl == 0) {
                    isOK = false;
                } else {
                    targetPos += lvl - 1;
                    if (no == 0)    //	DatabaseC_Barcode_DisNo_Sort_None	0	'A'
                    {            //	DatabaseC_Barcode_DisNo_Sort_None	0	'A'
                    }            //	DatabaseC_Barcode_DisNo_Sort_None	0	'A'
                    else if ((no == 1)    //	DatabaseC_Barcode_DisNo_Sort_FullSign	1	'B'
                            || (no == 7)    //	DatabaseC_Barcode_DisNo_Sort_G1_Flag	7	'H'
                            ) {            //	DatabaseC_Barcode_DisNo_Sort_FullSign	1	'B'
                        int value = barcodeFlag;
                        if ((value == 0) || (no == 7)) {
                            int buse = (GlobalPara.getInstance().getTMS(TMS.Print_Item_UseBL) / 10) % 10;
                            if (buse == 1)
                                ;
                            else if (buse == 2) {
                                DCategory dCategory = GlobalPara.getInstance().GetCategory(tradeContent.getItem().get(x_Init - 1).getPlu().getCategory());
                                if (dCategory != null) {
                                    if (billType == 1)
                                        value = dCategory.getPrint().getSign1();
                                    else
                                        value = dCategory.getPrint().getSign2();
                                }
                            } else {
                                if (billType == 1)
                                    value = tradeContent.getItem().get(x_Init - 1).getPlu().getPrint().getSign1();
                                else
                                    value = tradeContent.getItem().get(x_Init - 1).getPlu().getPrint().getSign2();
                            }
                        }
                        isOK = pushBcode(value, input, targetPos);
                    }            //	DatabaseC_Barcode_DisNo_Sort_FullSign	1	'B'
                    else if (no == 2)    //	DatabaseC_Barcode_DisNo_Sort_NConst1	2	'C'
                    {            //	DatabaseC_Barcode_DisNo_Sort_NConst1	2	'C'
                        ;
                    }            //	DatabaseC_Barcode_DisNo_Sort_NConst1	2	'C'
                    else if (no == 3)    //	DatabaseC_Barcode_DisNo_Sort_NConst2	3	'D'
                    {            //	DatabaseC_Barcode_DisNo_Sort_NConst2	3	'D'
                        ;
                    }            //	DatabaseC_Barcode_DisNo_Sort_NConst2	3	'D'
                    else if (no == 4)    //	DatabaseC_Barcode_DisNo_Sort_G1_PLU	4	'E'
                    {            //	DatabaseC_Barcode_DisNo_Sort_G1_PLU	4	'E'
                        gxTest = true;
                        isOK = pushBcode(itemC.getPlu().getNo(), input, targetPos);
                    }            //	DatabaseC_Barcode_DisNo_Sort_G1_PLU	4	'E'
                    else if (no == 5)    //	DatabaseC_Barcode_DisNo_Sort_G1_Note	5	'F'
                    {            //	DatabaseC_Barcode_DisNo_Sort_G1_Note	5	'F'
                        gxTest = true;
                        isOK = pushBcode(itemC.getPlu().getItemCode(), input, targetPos);
                    }            //	DatabaseC_Barcode_DisNo_Sort_G1_Note	5	'F'
                    else if (no == 6)    //	DatabaseC_Barcode_DisNo_Sort_G1_Index	6	'G'
                    {            //	DatabaseC_Barcode_DisNo_Sort_G1_Index	6	'G'
                        gxTest = true;
                        isOK = pushBstring(itemC.getPlu().getIndexBar(), input, targetPos);
                    }            //	DatabaseC_Barcode_DisNo_Sort_G1_Index	6	'G'
                    else if (no == 8)    //	DatabaseC_Barcode_DisNo_Sort_G1_Price	8	'I'
                    {            //	DatabaseC_Barcode_DisNo_Sort_G1_Price	8	'I'
                        gxTest = true;
                        isOK = pushBcode(EcsCal_Convert_T_ABS32(itemC.getPrice(), GlobalPara.getInstance().getTMS(TMS.DotBcode_Money)), input, targetPos);
                    }            //	DatabaseC_Barcode_DisNo_Sort_G1_Price	8	'I'
                    else if (no == 9)    //	DatabaseC_Barcode_DisNo_Sort_G1_Amount	9	'J'
                    {            //	DatabaseC_Barcode_DisNo_Sort_G1_Amount	9	'J'
                        gxTest = true;
                        if (GlobalPara.getInstance().EcsCal_Unit_isWeight(itemC.getUnit_weight()))
                            isOK = pushBcode(EcsCal_Convert_T_ABS32(itemC.getAmount(), GlobalPara.getInstance().getTMS(TMS.DotBcode_Weight)), input, targetPos);
                        else
                            isOK = pushBcode(EcsCal_Convert_T_ABS32(itemC.getAmount(), GlobalPara.getInstance().getTMS(TMS.DotBcode_Count)), input, targetPos);
                    }            //	DatabaseC_Barcode_DisNo_Sort_G1_Amount	9	'J'
                    else if (no == 10)    //	DatabaseC_Barcode_DisNo_Sort_G1_Purchase	10	'K'
                    {            //	DatabaseC_Barcode_DisNo_Sort_G1_Purchase	10	'K'
                        gxTest = true;
                        isOK = pushBcode(EcsCal_Convert_T_ABS32(itemC.getSingleWtax(), GlobalPara.getInstance().getTMS(TMS.DotBcode_Money)), input, targetPos);
                    }            //	DatabaseC_Barcode_DisNo_Sort_G1_Purchase	10	'K'
                    else if (no == 11)    //	DatabaseC_Barcode_DisNo_Sort_PurRound	11	'L'
                    {            //	DatabaseC_Barcode_DisNo_Sort_PurRound	11	'L'
                        isOK = pushBcode(EcsCal_Convert_T_ABS32(tradeContent.getPurTax_Final(), GlobalPara.getInstance().getTMS(TMS.DotBcode_Money)), input, targetPos);
                    }            //	DatabaseC_Barcode_DisNo_Sort_PurRound	11	'L'
                    else if (no == 12)    //	DatabaseC_Barcode_DisNo_Sort_Count	12	'M'
                    {            //	DatabaseC_Barcode_DisNo_Sort_Count	12	'M'
                        isOK = pushBcode(EcsCal_Convert_T_ABS32(tradeContent.gettCount(), 0), input, targetPos);
                    }            //	DatabaseC_Barcode_DisNo_Sort_Count	12	'M'
                    else if (no == 13)    //	DatabaseC_Barcode_DisNo_Sort_Weight	13	'N'
                    {            //	DatabaseC_Barcode_DisNo_Sort_Weight	13	'N'
                        isOK = pushBcode(EcsCal_Convert_T_ABS32(tradeContent.gettWeight(), GlobalPara.getInstance().getTMS(TMS.DotBcode_Weight)), input, targetPos);
                    }            //	DatabaseC_Barcode_DisNo_Sort_Weight	13	'N'
                    else if (no == 14)    //	DatabaseC_Barcode_DisNo_Sort_LogLng	14	'O'
                    {            //	DatabaseC_Barcode_DisNo_Sort_LogLng	14	'O'
                        isOK = pushBcode(tradeContent.getItem().size(), input, targetPos);
                    }            //	DatabaseC_Barcode_DisNo_Sort_LogLng	14	'O'
                    else if (no == 15)    //	DatabaseC_Barcode_DisNo_Sort_Salesman	15	'P'
                    {            //	DatabaseC_Barcode_DisNo_Sort_Salesman	15	'P'
                        isOK = pushBcode(tradeContent.getSalesman_Number(), input, targetPos);
                    }            //	DatabaseC_Barcode_DisNo_Sort_Salesman	15	'P'
                    else if (no == 16)    //	DatabaseC_Barcode_DisNo_Sort_Time_Year	16	'Q'
                    {            //	DatabaseC_Barcode_DisNo_Sort_Time_Year	16	'Q'
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(tradeContent.getTradeTime());
                        isOK = pushBcode(calendar.get(Calendar.YEAR), input, targetPos);
                    }            //	DatabaseC_Barcode_DisNo_Sort_Time_Year	16	'Q'
                    else if (no == 17)    //	DatabaseC_Barcode_DisNo_Sort_Time_Month	17	'R'
                    {            //	DatabaseC_Barcode_DisNo_Sort_Time_Month	17	'R'
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(tradeContent.getTradeTime());
                        isOK = pushBcode(calendar.get(Calendar.MONTH) + 1, input, targetPos);
                    }            //	DatabaseC_Barcode_DisNo_Sort_Time_Month	17	'R'
                    else if (no == 18)    //	DatabaseC_Barcode_DisNo_Sort_Time_Day	18	'S'
                    {            //	DatabaseC_Barcode_DisNo_Sort_Time_Day	18	'S'
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(tradeContent.getTradeTime());
                        isOK = pushBcode(calendar.get(Calendar.DAY_OF_MONTH), input, targetPos);
                    }            //	DatabaseC_Barcode_DisNo_Sort_Time_Day	18	'S'
                    else if (no == 19)    //	DatabaseC_Barcode_DisNo_Sort_Time_Hour	19	'T'
                    {            //	DatabaseC_Barcode_DisNo_Sort_Time_Hour	19	'T'
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(tradeContent.getTradeTime());
                        isOK = pushBcode(calendar.get(Calendar.HOUR_OF_DAY), input, targetPos);
                    }            //	DatabaseC_Barcode_DisNo_Sort_Time_Hour	19	'T'
                    else if (no == 20)    //	DatabaseC_Barcode_DisNo_Sort_Time_Minute	20	'U'
                    {            //	DatabaseC_Barcode_DisNo_Sort_Time_Minute	20	'U'
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(tradeContent.getTradeTime());
                        isOK = pushBcode(calendar.get(Calendar.MINUTE), input, targetPos);
                    }            //	DatabaseC_Barcode_DisNo_Sort_Time_Minute	20	'U'
                    else if (no == 21)    //	DatabaseC_Barcode_DisNo_Sort_Time_Second	21	'V'
                    {            //	DatabaseC_Barcode_DisNo_Sort_Time_Second	21	'V'
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(tradeContent.getTradeTime());
                        isOK = pushBcode(calendar.get(Calendar.SECOND), input, targetPos);
                    }            //	DatabaseC_Barcode_DisNo_Sort_Time_Second	21	'V'
                    else if (no == 22)    //	DatabaseC_Barcode_DisNo_Sort_SID	22	'W'
                    {            //	DatabaseC_Barcode_DisNo_Sort_SID	22	'W'
                        isOK = pushBcode(tradeContent.getSid(), input, targetPos);
                    }            //	DatabaseC_Barcode_DisNo_Sort_SID	22	'W'
                    else if (no == 23)    //	DatabaseC_Barcode_DisNo_Sort_DeviceNo	23	'X'
                    {            //	DatabaseC_Barcode_DisNo_Sort_DeviceNo	23	'X'
                        isOK = pushBcode(GlobalPara.getInstance().getDeviceNumber(), input, targetPos);
                    }            //	DatabaseC_Barcode_DisNo_Sort_DeviceNo	23	'X'
                    else if (no == 24)    //	DatabaseC_Barcode_DisNo_Sort_G1_Tax	24	'Y'
                    {            //	DatabaseC_Barcode_DisNo_Sort_G1_Tax	24	'Y'
                        gxTest = true;
                        isOK = pushBcode(EcsCal_Convert_T_ABS32(itemC.getTax(), GlobalPara.getInstance().getTMS(TMS.DotBcode_Money)), input, targetPos);
                    }            //	DatabaseC_Barcode_DisNo_Sort_G1_Tax	24	'Y'
                    else if (no == 25)    //	DatabaseC_Barcode_DisNo_Sort_Tax	25	'Z'
                    {            //	DatabaseC_Barcode_DisNo_Sort_Tax	25	'Z'
                        isOK = pushBcode(EcsCal_Convert_T_ABS32(tradeContent.getTax_Discounted(), GlobalPara.getInstance().getTMS(TMS.DotBcode_Money)), input, targetPos);
                    }            //	DatabaseC_Barcode_DisNo_Sort_Tax	25	'Z'
                    else if (no == 26)    //	DatabaseC_Barcode_DisNo_Sort_G1_Shelf	26	"BA"
                    {            //	DatabaseC_Barcode_DisNo_Sort_G1_Shelf	26	"BA"
                        gxTest = true;
                        CalPLU_ShelfDate shelfdate = new CalPLU_ShelfDate(itemC, tradeContent.getTradeTime());
                        if (!shelfdate.isPrintable())
                            isOK = false;
                        isOK = pushBcode(shelfdate.getDirectValue(), input, targetPos);
                    }            //	DatabaseC_Barcode_DisNo_Sort_G1_Shelf	26	"BA"
                    else if (no == 27)    //	DatabaseC_Barcode_DisNo_Sort_G1_Shelf_Year	27	"BB"
                    {            //	DatabaseC_Barcode_DisNo_Sort_G1_Shelf_Year	27	"BB"
                        gxTest = true;
                        CalPLU_ShelfDate shelfdate = new CalPLU_ShelfDate(itemC, tradeContent.getTradeTime());
                        if (!shelfdate.isPrintable())
                            isOK = false;
                        isOK = pushBcode(shelfdate.getCalendar().get(Calendar.YEAR), input, targetPos);
                    }            //	DatabaseC_Barcode_DisNo_Sort_G1_Shelf_YearType&0x04;	27	"BB"
                    else if (no == 28)    //	DatabaseC_Barcode_DisNo_Sort_G1_Shelf_Month	28	"BC"
                    {            //	DatabaseC_Barcode_DisNo_Sort_G1_Shelf_Month	28	"BC"
                        gxTest = true;
                        CalPLU_ShelfDate shelfdate = new CalPLU_ShelfDate(itemC, tradeContent.getTradeTime());
                        if (!shelfdate.isPrintable())
                            isOK = false;
                        isOK = pushBcode(shelfdate.getCalendar().get(Calendar.MONTH) + 1, input, targetPos);
                    }            //	DatabaseC_Barcode_DisNo_Sort_G1_Shelf_Month	28	"BC"
                    else if (no == 29)    //	DatabaseC_Barcode_DisNo_Sort_G1_Shelf_Day	29	"BD"
                    {            //	DatabaseC_Barcode_DisNo_Sort_G1_Shelf_Day	29	"BD"
                        gxTest = true;
                        CalPLU_ShelfDate shelfdate = new CalPLU_ShelfDate(itemC, tradeContent.getTradeTime());
                        if (!shelfdate.isPrintable())
                            isOK = false;
                        isOK = pushBcode(shelfdate.getCalendar().get(Calendar.DAY_OF_MONTH), input, targetPos);
                    }            //	DatabaseC_Barcode_DisNo_Sort_G1_Shelf_Day	29	"BD"
                    else if (no == 30)    //	DatabaseC_Barcode_DisNo_Sort_D_G1_Price	30	'BE'
                    {            //	DatabaseC_Barcode_DisNo_Sort_D_G1_Price	30	'BE'
                        gxTest = true;
                        pushString(GlobalPara.getInstance().GetStringDigit(itemC.getPrice()));
                    }            //	DatabaseC_Barcode_DisNo_Sort_D_G1_Price	30	'BE'
                    else if (no == 31)    //	DatabaseC_Barcode_DisNo_Sort_D_G1_Amount	31	'BF'
                    {            //	DatabaseC_Barcode_DisNo_Sort_D_G1_Amount	31	'BF'
                        gxTest = true;
                        pushString(GlobalPara.getInstance().GetStringDigit(itemC.getAmount()));
                    }            //	DatabaseC_Barcode_DisNo_Sort_D_G1_Amount	31	'BF'
                    else if (no == 32)    //	DatabaseC_Barcode_DisNo_Sort_D_G1_Purchase	32	'BG'
                    {            //	DatabaseC_Barcode_DisNo_Sort_D_G1_Purchase	32	'BG'
                        gxTest = true;
                        pushString(GlobalPara.getInstance().GetStringDigit(itemC.getSingleWtax()));
                    }            //	DatabaseC_Barcode_DisNo_Sort_D_G1_Purchase	32	'BG'
                    else if (no == 33)    //	DatabaseC_Barcode_DisNo_Sort_D_PurRound	33	'BH'
                    {            //	DatabaseC_Barcode_DisNo_Sort_D_PurRound	33	'BH'
                        pushString(GlobalPara.getInstance().GetStringDigit(tradeContent.getPurTax_Final()));
                    }            //	DatabaseC_Barcode_DisNo_Sort_D_PurRound	33	'BH'
                    else if (no == 34)    //	DatabaseC_Barcode_DisNo_Sort_D_Count	34	'BI'
                    {            //	DatabaseC_Barcode_DisNo_Sort_D_Count	34	'BI'
                        pushString(GlobalPara.getInstance().GetStringDigit(tradeContent.gettCount()));
                    }            //	DatabaseC_Barcode_DisNo_Sort_D_Count	34	'BI'
                    else if (no == 35)    //	DatabaseC_Barcode_DisNo_Sort_D_Weight	35	'BJ'
                    {            //	DatabaseC_Barcode_DisNo_Sort_D_Weight	35	'BJ'
                        pushString(GlobalPara.getInstance().GetStringDigit(tradeContent.gettWeight()));
                    }            //	DatabaseC_Barcode_DisNo_Sort_D_Weight	35	'BJ'
                    else if (no == 36)    //	DatabaseC_Barcode_DisNo_Sort_D_G1_Tax	36	'BK'
                    {            //	DatabaseC_Barcode_DisNo_Sort_D_G1_Tax	36	'BK'
                        gxTest = true;
                        pushString(GlobalPara.getInstance().GetStringDigit(itemC.getTax()));
                    }            //	DatabaseC_Barcode_DisNo_Sort_D_G1_Tax	36	'BK'
                    else if (no == 37)    //	DatabaseC_Barcode_DisNo_Sort_D_Tax	37	'BL'
                    {            //	DatabaseC_Barcode_DisNo_Sort_D_Tax	37	'BL'
                        pushString(GlobalPara.getInstance().GetStringDigit(tradeContent.getTax_Discounted()));
                    }            //	DatabaseC_Barcode_DisNo_Sort_D_Tax	37	'BL'
                    else if (no == 38)    //	DatabaseC_Barcode_DisNo_Sort_FID	38	'BM'
                    {            //	DatabaseC_Barcode_DisNo_Sort_FID	38	'BM'
                        isOK = pushBcode(tradeContent.getFid(), input, targetPos);
                    }            //	DatabaseC_Barcode_DisNo_Sort_FID	38	'BM'
                    else if (no == 39)    //	DatabaseC_Barcode_DisNo_Sort_Measure_WxCy	39	'BN'
                    {            //	DatabaseC_Barcode_DisNo_Sort_Measure_WxCy	39	'BN'
                        gxTest = true;
                        byte pcs, weight;
                        if (input[targetPos + 1] == '-') {
                            pcs = input[targetPos + 2];
                            weight = input[targetPos + 3];
                        } else {
                            pcs = input[targetPos + 1];
                            weight = input[targetPos + 2];
                            if (pcs == weight)
                                pcs++;
                        }
                        if (GlobalPara.getInstance().EcsCal_Unit_isWeight(itemC.getUnit_weight()))
                            pushByte(weight);
                        else
                            pushByte(pcs);
                    }            //	DatabaseC_Barcode_DisNo_Sort_Measure_WxCy	39	'BN'
                    else if (no == 40)    //	DatabaseC_Barcode_DisNo_Sort_G1_PurNoTax	40	'BO'
                    {            //	DatabaseC_Barcode_DisNo_Sort_G1_PurNoTax	40	'BO'
                        gxTest = true;
                        pushString(GlobalPara.getInstance().GetStringDigit(itemC.getSingleNtax()));
                    }            //	DatabaseC_Barcode_DisNo_Sort_G1_PurNoTax	40	'BO'
                    else if (no == 41)    //	DatabaseC_Barcode_DisNo_Sort_PurNoTax	41	'BP'`
                    {            //	DatabaseC_Barcode_DisNo_Sort_PurNoTax	41	'BP'
                        pushString(GlobalPara.getInstance().GetStringDigit(tradeContent.getPurTax_Discounted().subtract(tradeContent.getTax_Discounted())));
                    }            //	DatabaseC_Barcode_DisNo_Sort_PurNoTax	41	'BP'
                    else
                        isOK = false;

                    targetPos += 4;
                }
            }
            if ((targetLoopPos >= 0) && gxTest && (x_Init == 0)) {
                x_Init = 1;
            }

            if (!isOK)
                return null;
        }
    }
}