package com.jhscale.meter.protocol.model;

import com.jhscale.common.model.inter.GJSONModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @author lie_w
 * @title: TradeResult
 * @projectName meter-jar
 * @description: TODO
 * @date 2022/10/2415:06
 */
@ApiModel("打印内容")
public class PrintContent implements GJSONModel {

    @ApiModelProperty(value = "打印内容", name = "hex")
    private String hex;

    @ApiModelProperty(value = "打印机宽度（width==48?普通打印机：其余打印机）", name = "hex")
    private Integer width;

    @ApiModelProperty(value = "打印次数", name = "pcs")
    private Integer pcs;

    public PrintContent() {
    }

    public PrintContent(String hex, Integer width, Integer pcs) {
        this.hex = hex;
        this.width = width;
        this.pcs = pcs;
    }

    /**
     * @description: 存在打印内容
     **/
    public boolean exist() {
        return Objects.nonNull(this.pcs) && pcs > 0 && StringUtils.isNotBlank(this.hex);
    }

    public String getHex() {
        return hex;
    }

    public void setHex(String hex) {
        this.hex = hex;
    }

    public Integer getWidth() {
        return width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getPcs() {
        return pcs;
    }

    public void setPcs(Integer pcs) {
        this.pcs = pcs;
    }
}
