package com.jhscale.meter.protocol.model;

import com.jhscale.common.model.inter.GJSONModel;

/**
 * @author wang lie
 * @version 1.0
 * @projectName meter-jar
 * @title PrintState
 * @description 打印机状态
 * @create 2023/11/10 8:56
 */
public class PrintState implements GJSONModel {

    /**
     * @description: 打印机 寄存器信息
     * 0 - 预留
     * 1 - 空闲/工作
     * 2 - 无缓冲/有缓冲
     * 3 - 预留
     * 4 - 预留
     * 5 - 预留
     * 6 - 预留
     * 7 - 预留
     **/
    private String state1;

    /**
     * @description: 打印机状态信息
     * 0 - 预留
     * 1  - 正常/连续缺纸
     * 2 - 正常/过热保护
     * 3 - 正常/即将缺纸
     * 4 - 正常/未找到标签纸
     * 5 - 正常/纸张未拿走
     * 6 - 正常/打印头 未关闭
     * 7 - 预留
     **/
    private String state2;

    public PrintState() {
    }

    public PrintState(String state1, String state2) {
        this.state1 = state1;
        this.state2 = state2;
    }

    public String getState1() {
        return state1;
    }

    public void setState1(String state1) {
        this.state1 = state1;
    }

    public String getState2() {
        return state2;
    }

    public void setState2(String state2) {
        this.state2 = state2;
    }
}
