package com.jhscale.meter.protocol.model;

import com.jhscale.common.model.inter.GJSONModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Arrays;

/**
 * @author wang lie
 * @title: UDPReadResponse
 * @projectName meter-jar
 * @description: TODO
 * @date 2023/1/199:29
 */
public class ReadResponse implements GJSONModel {

    @ApiModelProperty(value = "读取长度", name = "length")
    private int length;

    @ApiModelProperty(value = "数据包", name = "bytes")
    private byte[] bytes;

    public ReadResponse() {
    }

    public ReadResponse(int length) {
        this.length = length;
    }

    public ReadResponse(int length, byte[] bytes) {
        this.length = length;
        this.bytes = bytes;
    }

    /**
     * @description: 有效数据包
     **/
    public byte[] invalidBytes() {
        try {
            return Arrays.copyOf(bytes, length);
        } catch (Exception e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    public int getLength() {
        return length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public byte[] getBytes() {
        return bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }
}
