package com.jhscale.meter.protocol.model;

import com.jhscale.common.model.device.plu.FDPLU;
import com.jhscale.common.model.inter.GJSONModel;

import java.math.BigDecimal;

/**
 * @author wang lie
 * @version 1.0
 * @projectName meter-jar
 * @title RealContent
 * @description
 * @create 2024/1/15 13:32
 */
public class RealContent implements GJSONModel {

    // 商品信息
    private FDPLU plu;

    // 数重量
    private BigDecimal amount;

    // 单价
    private BigDecimal price;

    // 小计
    private BigDecimal item;

    public RealContent() {
        this.amount = GlobalPara.getInstance().EcsCal_Rounding_Single(BigDecimal.ZERO);
        this.price = GlobalPara.getInstance().EcsCal_Rounding_Single(BigDecimal.ZERO);
        this.item = GlobalPara.getInstance().EcsCal_Rounding_Total(BigDecimal.ZERO);
    }

    public RealContent(BigDecimal amount) {
        this();
        this.amount = amount;
    }

    public RealContent(FDPLU plu, BigDecimal amount, BigDecimal price, BigDecimal item) {
        this();
        this.plu = plu;
        this.amount = amount;
        this.price = price;
        this.item = item;
    }

    /**
     * @description: 数重量单价小计信息 转化发送
     **/
    public String toSerialPortContent() {
        return "";
    }

    public FDPLU getPlu() {
        return plu;
    }

    public void setPlu(FDPLU plu) {
        this.plu = plu;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getItem() {
        return item;
    }

    public void setItem(BigDecimal item) {
        this.item = item;
    }
}
