package com.jhscale.meter.protocol.model;

import java.math.BigDecimal;

/**
 * @author lie_w
 * @title: ScaleRule
 * @projectName meter-jar
 * @description: 数据处理规则
 * @date 2021/6/1623:41
 */
public class ScaleRuound {

    /**
     * @description: 保留小数长度 默认保留2位
     **/
    private int scale = 2;

    /**
     * @description: 保留方式
     * BigDecimal.ROUND_DOWN        直接删除多余的小数位 2.35会变成2.3
     * BigDecimal.ROUND_UP          进位处理 2.35变成2.4
     * BigDecimal.ROUND_HALF_DOWN   四舍五入 2.35变成2.4
     * BigDecimal.ROUND_HALF_DOWN   四舍五入 2.35变成2.3,如果是5则向下舍
     **/
    private int round = BigDecimal.ROUND_HALF_DOWN;

    public ScaleRuound() {
    }

    public ScaleRuound(int scale, int round) {
        this.scale = scale;
        this.round = round;
    }

    public int getScale() {
        return scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public int getRound() {
        return round;
    }

    public void setRound(int round) {
        this.round = round;
    }
}
