package com.jhscale.meter.protocol.model;

import com.jhscale.common.model.device.plu.FDPLU;
import com.jhscale.common.utils.SystemtUtils;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.io.PortManager;
import com.jhscale.meter.io.control.DeviceControl;
import com.jhscale.meter.io.listener.DeviceClientEventListener;
import com.jhscale.meter.model.device.Device;
import com.jhscale.meter.protocol.constant.TMS;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * @author wang lie
 * @version 1.0
 * @projectName meter-jar
 * @title RealContent
 * @description
 * @create 2024/1/15 13:32
 */

public class SerialDisplay {

    static final int itemContentValidDelay = 2;
    // 商品信息
    private FDPLU plu = null;
    private int inputUnit = 3;
    // 数重量
    private BigDecimal inputAmount = BigDecimal.ZERO;
    // 单价
    private BigDecimal inputPrice = BigDecimal.ZERO;
    // 小计
    private BigDecimal inputItem = BigDecimal.ZERO;
    //重量原始数据
    private WeightResult wr = new WeightResult();
    private int itemContentValid = 0;

    // 实时交易商品信息
    private PortManager portManager = null;

    private boolean serialDisplayPause = false;
    private boolean serialDisplayAction = true;

    private boolean hasPLU = false;

    /**
     * @description: 串口停止
     **/
    public void serialDisplayStop() {
        try {
            this.serialDisplayAction = false;
            SystemtUtils.sleep(1);
            this.portManager.closePort();
            this.portManager = null;
        } catch (MeterException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * @description: 串口停止
     **/
    public void serialDisplayPause(boolean pause) {
        this.serialDisplayPause = pause;
    }

    /**
     * @description: 退出商品界面
     **/
    public void quitItemContent() {
        this.hasPLU = false;
    }

    /**
     * @description: 商品信息添加
     **/
    public void setItemContentWR(ItemContent itemContent, WeightResult inputWR) {
        this.hasPLU = true;
        if (inputWR != null)
            this.wr = inputWR;
        this.inputAmount = itemContent.getAmount();
        this.inputUnit = itemContent.getUnit_weight();

        this.plu = itemContent.getPlu();
        this.inputPrice = itemContent.getPrice();
        this.inputItem = itemContent.getSingleWtax();

        itemContentValid = itemContentValidDelay;
    }

    /**
     * @description: 商品信息
     **/
    public void setItemContentWR(ItemContent itemContent) {
        this.setItemContentWR(itemContent, null);
    }

    /**
     * @description: 添加重量
     **/
    public void setWeightResult(WeightResult inputWR) {
        if (this.hasPLU) return;

        if (itemContentValid >= 0)
            itemContentValid--;
        else {
            this.wr = inputWR;
            this.inputAmount = inputWR.getNetWeight();
            this.inputUnit = inputWR.getUnit();

            this.plu = null;
            this.inputPrice = BigDecimal.ZERO;
            this.inputItem = BigDecimal.ZERO;
        }
    }

    /**
     * @description: 初始化通讯控制器
     **/
    public void Init_Port(DeviceControl control, Device device) throws MeterException {
        if (Objects.isNull(control))
            throw new MeterException(MeterStateEnum.控制器不存在);
        if (Objects.isNull(device))
            throw new MeterException(MeterStateEnum.通讯设备不存在);
        int spec = GlobalPara.getInstance().getTMS(TMS.Device_POS_Send);
        if (spec == 0)
            throw new MeterException(MeterStateEnum.AD_显示通讯协议未配置);

        this.portManager = new PortManager<>(control, device, new DeviceClientEventListener() {

            /**
             * @param bytes
             * @description: 连接监听
             */
            @Override
            public void onClientEvent(byte[] bytes) throws MeterException {
                if (!serialDisplayPause) {
                    byte[] output = toSerialPortContent_ACK(bytes);
                    if (output != null)
                        portManager.writeDataImmediately(output);
                }
                // System.out.printf("监听到内容：%s%n", str);
            }

            /**
             * @param e
             * @description: 连接异常监听
             */
            @Override
            public void onClientEventExp(MeterException e) {

            }
        });
        this.portManager.openPort();

        new Thread("SerialDisplay") {
            @Override
            public void run() {
                // int count = 0;
                while (serialDisplayAction) {
                    try {
                        if (!serialDisplayPause) {
                            // todo realItemContent =》 转换内容发送串口
                            byte[] output = toSerialPortContent_100ms();
                            if (output != null)
                                portManager.writeDataImmediately(output);
                        }
                        Thread.sleep(100);
                        // if (count % 100 == 0)
                        //     System.out.printf("Real_Content: %s%n", realContent.toJSON());
                        // count++;
                    } catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }.start();
    }

    private static class SingleSerialDisplay {
        private static final SerialDisplay SINGLETON = new SerialDisplay();
    }

    public static SerialDisplay getInstance() {
        return SingleSerialDisplay.SINGLETON;
    }


    private String nums32_New_Fill(BigDecimal net, int digit, char fill) {
        String rv = net.toString();
        if (rv.length() >= digit)
            return rv.substring(0, digit - 1);
        else {
            while (rv.length() < digit)
                rv = fill + rv;
            return rv;
        }
    }

    private String unit_B4() {
        int unit = wr.getUnit() - 3;
        if (unit == 1)
            return "   g";
        else if (unit == 2)
            return " ton";
        else if (unit == 3)
            return "  lb";
        else if (unit == 4)
            return "500g";
        else if (unit == 5)
            return "100g";
        else if (unit == 6)
            return "lb/4";
        else
            return "  kg";
    }


    byte Formula_HexToBCD(int Hex)                            //Convert Hex code to BCD code
    {
        return (byte) ((((Hex / 10) % 10) << 4) | (Hex % 10));
    }

    private static final byte[] HexValue = new byte[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private byte[] Protocol_A() {
        byte[] temp = new byte[14];
        temp[0] = (byte) 0xff;

        BigDecimal weight = inputAmount;
        temp[1] = (byte) ((weight.scale() + 1) & 0x07);
        int weightUS = weight.unscaledValue().intValue();
        if (weightUS < 0) {
            weightUS = -weightUS;
            temp[1] |= 0x08;
        }
        if (wr.isStable())
            temp[1] |= 0x10;
        if (wr.getValidType() >= 4)
            temp[1] |= 0x20;
        if (plu == null)
            temp[1] |= 0x40;
        if ((plu != null) && (GlobalPara.getInstance().EcsCal_Unit_isWeight((inputUnit))) && (inputUnit == 3))
            ;
        else
            temp[1] |= 0x80;
        temp[2] = Formula_HexToBCD(weightUS);
        temp[3] = Formula_HexToBCD(weightUS / 100);
        temp[4] = Formula_HexToBCD(weightUS / 10000);

        temp[5] = (byte) ((inputPrice.scale() + 1) & 0x07);
        if (plu == null)
            temp[5] |= 0x08;
        int priceUS = inputPrice.unscaledValue().intValue();
        temp[6] = Formula_HexToBCD(priceUS);
        temp[7] = Formula_HexToBCD(priceUS / 100);
        temp[8] = Formula_HexToBCD(priceUS / 10000);

        temp[9] = (byte) ((inputItem.scale() + 1) & 0x07);
        if (plu == null)
            temp[9] |= 0x08;
        int itemUS = inputItem.unscaledValue().intValue();
        if (itemUS > 999999)
            temp[9] |= 0x10;
        if (itemUS < 999999)
            temp[9] |= 0x20;
        temp[10] = Formula_HexToBCD(itemUS);
        temp[11] = Formula_HexToBCD(itemUS / 100);
        temp[12] = Formula_HexToBCD(itemUS / 10000);
        temp[13] = (byte) GlobalPara.getInstance().getTMS(TMS.Device_No);

        return temp;
    }

    private byte[] Protocol_B() {
        byte[] temp = new byte[6];
        temp[0] = (byte) 0xff;

        BigDecimal weight = wr.getNetWeight();
        temp[1] = (byte) ((weight.scale() + 1) & 0x07);
        int weightUS = weight.unscaledValue().intValue();
        if (weightUS < 0) {
            weightUS = -weightUS;
            temp[1] |= 0x20;
        }
        if (wr.isStable())
            temp[1] |= 0x40;
        if (wr.getValidType() >= 4)
            temp[1] |= 0x80;
        temp[2] = Formula_HexToBCD(weightUS);
        temp[3] = Formula_HexToBCD(weightUS / 100);
        temp[4] = Formula_HexToBCD(weightUS / 10000);
        temp[5] = (byte) ((wr.getUnit() != 3) ? 1 : 0);

        return temp;
    }

    private byte[] Protocol_C() {
        String rv = "WT";
        if (wr.getValidType() >= 4) {       //3 if include under flow
            rv += "OL";
        } else if (wr.isStable()) {
            rv += "ST";
        } else {
            rv += "US";
        }
        BigDecimal weight = wr.getNetWeight();
        if (weight.compareTo(BigDecimal.ZERO) < 0) {
            rv += '-';
            weight = weight.negate();
        } else
            rv += '+';

        rv += nums32_New_Fill(weight, 7, ' ') + unit_B4() + "\r\n";
        return rv.getBytes();
    }

    private byte[] Protocol_D() {
        byte[] temp = new byte[8];
        temp[0] = '=';
        byte[] weightChar = wr.getNetWeight().toString().getBytes();
        int pos = weightChar.length;
        int out = 1;
        while (out < 8) {
            if (pos > 0) {
                pos--;
                temp[out] = weightChar[pos];
            } else {
                temp[out] = ' ';
            }
            out++;
        }
        return temp;
    }

    private byte[] Protocol_E() {
        byte[] temp = new byte[12];
        temp[0] = 0x02;
        temp[11] = 0x03;

        BigDecimal weight = wr.getNetWeight();
        Integer weightUS = weight.unscaledValue().intValue();

        if (weightUS < 0) {
            weightUS = -weightUS;
            temp[1] = '-';
        } else
            temp[1] = '+';

        byte[] weightChar = weightUS.toString().getBytes();
        int pos = weightChar.length;
        int out = 7;
        while (out > 1) {
            if (pos > 0) {
                pos--;
                temp[out] = weightChar[pos];
            } else {
                temp[out] = '0';
            }
            out--;
        }

        temp[8] = (byte) (weight.scale() + '0');

        int crc = temp[1] ^ temp[2] ^ temp[3] ^ temp[4] ^ temp[5] ^ temp[6] ^ temp[7] ^ temp[8];
        temp[9] = HexValue[(crc >> 4) & 0x0f];
        temp[10] = HexValue[crc & 0x0f];

        return temp;
    }

    private byte[] Protocol_F() {
        byte[] temp = new byte[]{0x0a, 0x0d, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20};
        if (inputAmount.compareTo(BigDecimal.ZERO) >= 0) {
            Integer ctAmount = inputAmount.movePointRight(3).intValue();
            Integer ctPrice = inputPrice.movePointRight(2).intValue();
            Integer ctItem = inputItem.movePointRight(2).intValue();

            byte[] weightChar;
            int pos;
            int out;

            weightChar = ctAmount.toString().getBytes();
            pos = weightChar.length;
            out = 6;
            while (out >= 2) {
                if (pos > 0) {
                    pos--;
                    temp[out] = weightChar[pos];
                } else
                    break;
                out--;
            }
            weightChar = ctPrice.toString().getBytes();
            pos = weightChar.length;
            out = 13;
            while (out >= 9) {
                if (pos > 0) {
                    pos--;
                    temp[out] = weightChar[pos];
                } else
                    break;
                out--;
            }
            weightChar = ctItem.toString().getBytes();
            pos = weightChar.length;
            out = 21;
            while (out >= 16) {
                if (pos > 0) {
                    pos--;
                    temp[out] = weightChar[pos];
                } else
                    break;
                out--;
            }
        }
        return temp;
    }

    private byte[] Protocol_G() {
        byte[] temp = new byte[]{0x0a, 0x0d, 0x20, 0x20, 0x20, 0x20, 0x20};
        Integer ctWeight = wr.getNetWeight().movePointRight(3).intValue();
        int endpos = 2;
        if (ctWeight < 0) {
            temp[endpos] = '-';
            endpos++;
            ctWeight = -ctWeight;
        }

        byte[] weightChar = ctWeight.toString().getBytes();
        int pos = weightChar.length;
        int out = 6;
        while (out >= endpos) {
            if (pos > 0) {
                pos--;
                temp[out] = weightChar[pos];
            } else if (endpos > 2)
                temp[out] = '0';
            out--;
        }
        return temp;
    }

    private byte[] Protocol_H() {
        BigDecimal weight = wr.getNetWeight();
        if ((!wr.isStable()) || (weight.compareTo(BigDecimal.ZERO) < 0)) {
            byte[] temp = new byte[]{0x3f, 0x3f, 0x3f, 0x3f, 0x3f};
            return temp;
        } else {
            byte[] temp = new byte[]{0x02, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 'K', 'G'};

            byte[] weightChar = weight.toString().getBytes();
            int pos = weightChar.length;
            int out = 7;
            while (out >= 1) {
                if (pos > 0) {
                    pos--;
                    temp[out] = weightChar[pos];
                } else
                    break;
                out--;
            }

            int unit = wr.getUnit();
            if (unit == 4) {
                temp[9] = ' ';
                temp[10] = 'G';
            } else if (unit == 5) {
                temp[9] = ' ';
                temp[10] = 'T';
            } else if (unit == 6) {
                temp[9] = 'L';
                temp[10] = 'B';
            } else {
                temp[9] = 'K';
                temp[10] = 'G';
            }

            return temp;
        }
    }

    /**
     * @description: 数重量单价小计信息 转化发送
     **/
    public byte[] toSerialPortContent_100ms() {
        int spec = GlobalPara.getInstance().getTMS(TMS.Device_POS_Send);
        if (spec == 1)
            return Protocol_A();
        else if (spec == 2)
            return Protocol_B();
        else if (spec == 3)
            return Protocol_C();
        else if (spec == 4)
            return Protocol_D();
        else if (spec == 5) {
            if (wr.isStable())
                return Protocol_D();
        } else if (spec == 6)
            return Protocol_E();
        else if (spec == 7) {
            if (wr.isStable())
                return Protocol_E();
        } else if (spec == 8)
            return Protocol_F();
        else if (spec == 9) {
            if (wr.isStable())
                return Protocol_F();
        } else if (spec == 10)
            return Protocol_G();
        else if (spec == 11) {
            if (wr.isStable())
                return Protocol_G();
        } else if (spec == 12)
            ;
        return null;
    }

    public byte[] toSerialPortContent_ACK(byte[] input) {
        if (input == null)
            return null;

        int spec = GlobalPara.getInstance().getTMS(TMS.Device_POS_Send);
        if (spec == 12) {
            for (int loop = 0; loop < input.length; loop++) {
                if (input[loop] == 'P') {
                    return Protocol_H();
                }
            }
        }
        return null;
    }

    public void setPlu(FDPLU plu) {
        this.plu = plu;
    }

    public void setAmount(BigDecimal amount) {
        this.inputAmount = amount;
    }

    public void setPrice(BigDecimal price) {
        this.inputPrice = price;
    }

    public void setItem(BigDecimal item) {
        this.inputItem = item;
    }

    public void setSerialDisplayPause(boolean pause) {
        this.serialDisplayPause = pause;
    }
}
