package com.jhscale.meter.protocol.model;

import com.jhscale.common.model.device._inner.*;
import com.jhscale.common.model.device.info.DTIM;
import com.jhscale.common.utils.DDataUtils;
import com.jhscale.common.utils.SystemtUtils;
import com.jhscale.meter.entity.TCPCacheChannel;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.io.PortManager;
import com.jhscale.meter.io.TCPClient;
import com.jhscale.meter.io.TCPServer;
import com.jhscale.meter.io.UDPLink;
import com.jhscale.meter.io.control.SocketControl;
import com.jhscale.meter.io.listener.SocketClientEventListener;
import com.jhscale.meter.model.device.TCPClientDevice;
import com.jhscale.meter.model.device.TCPServerDevice;
import com.jhscale.meter.model.device.UDPDevice;
import com.jhscale.meter.protocol.other.CMPT;
import com.jhscale.meter.protocol.other.cmpt.CMPTAction;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.*;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import org.apache.commons.lang3.StringUtils;

import java.net.InetAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

import static com.jhscale.common.model.device.DConstant.*;
import static com.jhscale.meter.protocol.constant.TMS.*;
import static com.jhscale.meter.utils.AConstant.*;

/**
 * @author wang lie
 * @title: SocketCommunication
 * @projectName meter-jar
 * @description: TODO
 * @date 2023/1/1822:46
 */
public class SocketCommunication implements GlobalPara.GlobalParaRefresh {

    private SocketCommunication() {
        GlobalPara.getInstance().addRefresh(this);
    }

    private static class SingleSocketCommunication {
        private static final SocketCommunication SINGLETON = new SocketCommunication();
    }

    public static SocketCommunication getInstance() {
        return SingleSocketCommunication.SINGLETON;
    }

    // 回调通知
    private SocketNotify notify;

    // 当前版本号
    private static final int version = 251;
    // tcp 服务模式端口号
    private int tcp_server_port = 33581;
    // TCP Link状态
    private boolean tcp_link_status = false;

    /**
     * @description: 回调通知
     **/
    public SocketCommunication Init_Notify(SocketNotify notify) {
        this.notify = notify;
        return this;
    }

    /********************************** TCP Server ******************************************/

    // TCP 服务端
    private TCPServer TCPServer;

    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;

    // 指令缓冲区
    private TCPServerCache serverCache;

    // Netty 缓冲区
    private Map<String, TCPCacheChannel> cacheChannelMap;

    /**
     * @description: TCP Server 消息缓冲区 信息合并
     **/
    protected synchronized String tcp_server_msg_merge(ChannelHandlerContext ctx, String acceptMsg) {
        String cache = "";
        if (this.cacheChannelMap != null) {
            TCPCacheChannel cacheChannel = this.cacheChannelMap.get(ctx.channel().remoteAddress().toString());
            if (cacheChannel != null) cache = cacheChannel.getTcp_server_msg_cache();
        }
        return cache + acceptMsg;
    }

    /**
     * @description: TCP Server 消息缓冲区 信息缓冲
     **/
    protected synchronized void tcp_server_msg_cache(ChannelHandlerContext ctx, String surplus) {
        if (this.cacheChannelMap == null) this.cacheChannelMap = new HashMap<>();
        String address_key = ctx.channel().remoteAddress().toString();
        TCPCacheChannel channel = this.cacheChannelMap.get(address_key);
        if (channel == null) {
            channel = new TCPCacheChannel(ctx);
            this.cacheChannelMap.put(ctx.channel().toString(), channel);
        }
        channel.setTcp_server_msg_cache(surplus);
    }

    /**
     * @description: Fid 更新发送TCP
     */
    public boolean tcp_server_ask(PublicExecuteAsk ask) {
        boolean result = false;
        if (this.cacheChannelMap != null && !this.cacheChannelMap.isEmpty()) {
            result = true;
            String ask_str = ask.Package_No_Reflex_Body();
            for (TCPCacheChannel value : this.cacheChannelMap.values()) {
                try {
                    value.getCtx().writeAndFlush(ask_str);
                    result = result;
                } catch (Exception e) {
                    result = false;
                }
            }
        }
        return result;
    }

    /**
     * @description: 初始化 TCP 服务端模式
     **/
    public boolean Init_TCP_Server(TCPServerDevice device) {
        int tms = GlobalPara.getInstance().getTMS(Device_Ethernet_Online);
        if (tms == TCP_Server) {

            this.cacheChannelMap = new HashMap<>();

            new Thread() {
                @Override
                public void run() {
                    bossGroup = new NioEventLoopGroup();
                    workerGroup = new NioEventLoopGroup();

                    try {
                        ServerBootstrap serverBootstrap = new ServerBootstrap();
                        serverBootstrap.group(bossGroup, workerGroup)
                                .channel(NioServerSocketChannel.class)
                                .childHandler(new ChannelInitializer<SocketChannel>() {
                                    @Override
                                    public void initChannel(SocketChannel ch) throws Exception {
                                        ChannelPipeline pipeline = ch.pipeline();
                                        pipeline.addLast(new StringDecoder(GlobalPara.getInstance().getProgram_encoding()));
                                        pipeline.addLast(new StringEncoder(GlobalPara.getInstance().getProgram_encoding()));
                                        pipeline.addLast(new ChannelInboundHandlerAdapter() {

                                            @Override
                                            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                                                cacheChannelMap.put(ctx.channel().remoteAddress().toString(), new TCPCacheChannel(ctx));
                                            }

                                            @Override
                                            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                                                cacheChannelMap.remove(ctx.channel().remoteAddress().toString());
                                            }

                                            @Override
                                            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                                                String content = msg.toString();
                                                //boolean print = StringUtils.isNotBlank(content) && content.contains("PLU");
                                                // if (print) {
                                                //     // System.out.printf("接收到内容：[ %n%s ]%n", content);
                                                //     FileUtils.writer(msg.toString(), new File("E:\\JHScale\\Resources\\Netty.txt"), true);
                                                // }

                                                // 获取缓冲区数据
                                                String acceptStr = tcp_server_msg_merge(ctx, content);
                                                if (GlobalPara.getInstance().isRunLog())
                                                    System.out.printf("Accept Content: %s%n", acceptStr);

                                                // if (print) {
                                                //     System.out.printf("组装后内容：[ %n%s ]%n", acceptStr);
                                                //     System.out.println();
                                                // }


                                                long un_package_start = System.currentTimeMillis();
                                                UnPackageResponse un_package_response = DDataUtils.Public_UnPackage_Lines_Distribute(acceptStr, GlobalPara.getInstance().isRunLog());
                                                long un_package_end = System.currentTimeMillis();
                                                // System.out.printf("Accept UnPackage Str_Length:[%s] Size:[%s] Time:[%s]%n",
                                                //         acceptStr.length(), un_package_response.size(), (un_package_end - un_package_start));
                                                if (GlobalPara.getInstance().isRunLog()) {
                                                    System.out.printf("Accept UnPackage Str_Length:[%s] Size:[%s] Time:[%s] Un_Package_Response: %s%n",
                                                            acceptStr.length(), un_package_response.size(), (un_package_end - un_package_start), un_package_response.toJSON());
                                                }

                                                // if (print || StringUtils.isNotBlank(un_package_response.getSurplus())) {
                                                //     System.out.printf("解析后剩余：[ %n%s ]%n", un_package_response.getSurplus());
                                                // }

                                                // 加入缓冲区数据
                                                tcp_server_msg_cache(ctx, un_package_response.getSurplus());

                                                if (un_package_response.size() > 0) {
                                                    for (PublicExecute acceptExecute : un_package_response.getExecutes()) {
                                                        JHTCPAnswer answer = null;

                                                        if (acceptExecute instanceof PublicExecuteRecovery) {
                                                            JHTCPAccept accept = new JHTCPAccept(ctx, acceptExecute);
                                                            switch (acceptExecute.getType()) {
                                                                case INF:
                                                                    answer = accept.callBack()
                                                                            .addAnswer(new PublicExecuteModify(INF)
                                                                                    .add(GlobalPara.getInstance().deviceInfo()));
                                                                    break;
                                                                case MAC:
                                                                    answer = accept.callBack()
                                                                            .addAnswer(new PublicExecuteModify(MAC)
                                                                                    .add(GlobalPara.getInstance().deviceMac()));
                                                                    break;
                                                                case TIM:
                                                                    answer = accept.callBack()
                                                                            .addAnswer(new PublicExecuteModify(TIM)
                                                                                    .add(new DTIM().setTime(new Date())));
                                                                    break;
                                                                default:
                                                                    new TCPServerThread(ctx, new TCPServerCache(acceptExecute)).start();
                                                                    break;
                                                            }
                                                        } else if (acceptExecute instanceof PublicExecuteModify) {
                                                            if (serverCache != null && serverCache.getExecute() instanceof PublicExecuteModify) {
                                                                ((PublicExecuteModify) serverCache.getExecute()).add(((PublicExecuteModify) acceptExecute).getModels());
                                                            } else {
                                                                serverCache = new TCPServerCache(acceptExecute);
                                                            }
                                                        } else if (acceptExecute instanceof PublicExecuteModifyCache) {
                                                            if (serverCache != null && serverCache.getExecute() instanceof PublicExecuteModifyCache) {
                                                                ((PublicExecuteModifyCache) serverCache.getExecute()).add(((PublicExecuteModifyCache) acceptExecute).getLines());
                                                            } else {
                                                                serverCache = new TCPServerCache(acceptExecute);
                                                            }
                                                        } else if (acceptExecute instanceof PublicExecuteDelete) {
                                                            if (serverCache != null && serverCache.getExecute() instanceof PublicExecuteDelete) {
                                                                ((PublicExecuteDelete) serverCache.getExecute()).add(((PublicExecuteDelete) acceptExecute).getIds());
                                                            } else {
                                                                serverCache = new TCPServerCache(acceptExecute);
                                                            }
                                                        } else if (acceptExecute instanceof PublicExecuteEnd) {
                                                            if (serverCache != null) {
                                                                new TCPServerThread(ctx, serverCache.clone()).start();
                                                                serverCache = null;
                                                            }
                                                        } else if (acceptExecute instanceof PublicExecuteAsk) {
                                                            System.err.printf("Accept Ask: %s%n", acceptExecute.toJSON());
                                                            new TCPServerThread(ctx, new TCPServerCache(acceptExecute)).start();
                                                        }

                                                        if (answer != null && !answer.isAsync()) {
                                                            answer.resultExecute();
                                                        }
                                                    }
                                                }

                                            }

                                            @Override
                                            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                                                cause.printStackTrace();
                                                ctx.close();
                                            }
                                        });
                                    }
                                });

                        ChannelFuture future = serverBootstrap.bind(Objects.isNull(device) || device.getPort() <= 0 ? tcp_server_port : device.getPort()).sync();
                        System.out.println("TCP Server Start Success");
                        future.channel().closeFuture().sync();
                        System.out.println("TCP Server Close Success");
                    } catch (Exception e) {
                        e.printStackTrace();
                    } finally {
                        try {
                            if (bossGroup != null)
                                bossGroup.shutdownGracefully();
                            if (workerGroup != null)
                                workerGroup.shutdownGracefully();
                        } catch (Exception e) {
                        }
                    }
                }
            }.start();
            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
            }
            return true;
        }
        return false;
    }

    // TCP消息包缓冲
    @Deprecated
    private String tcp_server_msg_cache;

    /**
     * @description: TCP Server 消息缓冲区
     **/
    @Deprecated
    protected synchronized String tcp_server_msg_cache(String acceptMsg) {
        return (StringUtils.isNotBlank(this.tcp_server_msg_cache) ? this.tcp_server_msg_cache : "") + acceptMsg;
    }

    /**
     * @description: 初始化 TCP 服务端模式
     **/
    @Deprecated
    public boolean Init_TCP_Server(SocketControl control, TCPServerDevice device) {
        int tms = GlobalPara.getInstance().getTMS(Device_Ethernet_Online);
        // 支持服务端模式
        if (tms == TCP_Server) try {
            device = device == null ? new TCPServerDevice() : device;
            tcp_server_port = device.getPort();
            this.TCPServer = new TCPServer(control,
                    device,
                    new SocketClientEventListener() {
                        /**
                         * @param address
                         * @param port
                         * @description: TCP Server 连接监听
                         */
                        @Override
                        public void onClientLink(InetAddress address, int port) {
                            UDP_Terminal_Pause_Resume();
                            tcp_link_status = true;
                            tcp_server_msg_cache = "";
                        }

                        /**
                         * @param address
                         * @param port
                         * @description: TCP Server断开监听
                         */
                        @Override
                        public void onClientBreak(InetAddress address, int port) {
                            UDP_Terminal_Pause_Resume();
                            tcp_link_status = false;
                            tcp_server_msg_cache = "";
                        }

                        /**
                         * @param portManager
                         * @param bytes
                         * @description: 连接监听
                         */
                        @Override
                        public byte[] onClientEventResponse(PortManager portManager, byte[] bytes) throws MeterException {
                            if (bytes != null && bytes.length > 0) {

                                String acceptStr = tcp_server_msg_cache(new String(bytes, GlobalPara.getInstance().getProgram_encoding()));
                                if (GlobalPara.getInstance().isRunLog())
                                    System.out.printf("Accept Content: %s%n", acceptStr);

                                long un_package_start = System.currentTimeMillis();
                                UnPackageResponse un_package_response = DDataUtils.Public_UnPackage_Lines_Distribute(acceptStr, GlobalPara.getInstance().isRunLog());
                                long un_package_end = System.currentTimeMillis();
                                // System.out.printf("Accept UnPackage Str_Length:[%s] Size:[%s] Time:[%s]%n",
                                //         acceptStr.length(), un_package_response.size(), (un_package_end - un_package_start));
                                if (GlobalPara.getInstance().isRunLog()) {
                                    System.out.printf("Accept UnPackage Str_Length:[%s] Size:[%s] Time:[%s] Un_Package_Response: %s%n",
                                            acceptStr.length(), un_package_response.size(), (un_package_end - un_package_start), un_package_response.toJSON());
                                }

                                tcp_server_msg_cache = un_package_response.getSurplus();

                                if (un_package_response.size() > 0) {
                                    for (PublicExecute acceptExecute : un_package_response.getExecutes()) {
                                        JHTCPAnswer answer = null;

                                        if (acceptExecute instanceof PublicExecuteRecovery) {
                                            JHTCPAccept accept = new JHTCPAccept(portManager, acceptExecute);
                                            switch (acceptExecute.getType()) {
                                                case INF:
                                                    answer = accept.callBack()
                                                            .addAnswer(new PublicExecuteModify(INF)
                                                                    .add(GlobalPara.getInstance().deviceInfo()));
                                                    break;
                                                case MAC:
                                                    answer = accept.callBack()
                                                            .addAnswer(new PublicExecuteModify(MAC)
                                                                    .add(GlobalPara.getInstance().deviceMac()));
                                                    break;
                                                case TIM:
                                                    answer = accept.callBack()
                                                            .addAnswer(new PublicExecuteModify(TIM)
                                                                    .add(new DTIM().setTime(new Date())));
                                                    break;
                                                default:
                                                    new TCPServerThread(portManager, new TCPServerCache(acceptExecute)).start();
                                                    break;
                                            }
                                        } else if (acceptExecute instanceof PublicExecuteModify) {
                                            if (serverCache != null && serverCache.getExecute() instanceof PublicExecuteModify) {
                                                ((PublicExecuteModify) serverCache.getExecute()).add(((PublicExecuteModify) acceptExecute).getModels());
                                            } else {
                                                serverCache = new TCPServerCache(acceptExecute);
                                            }
                                        } else if (acceptExecute instanceof PublicExecuteModifyCache) {
                                            if (serverCache != null && serverCache.getExecute() instanceof PublicExecuteModifyCache) {
                                                ((PublicExecuteModifyCache) serverCache.getExecute()).add(((PublicExecuteModifyCache) acceptExecute).getLines());
                                            } else {
                                                serverCache = new TCPServerCache(acceptExecute);
                                            }
                                        } else if (acceptExecute instanceof PublicExecuteDelete) {
                                            if (serverCache != null && serverCache.getExecute() instanceof PublicExecuteDelete) {
                                                ((PublicExecuteDelete) serverCache.getExecute()).add(((PublicExecuteDelete) acceptExecute).getIds());
                                            } else {
                                                serverCache = new TCPServerCache(acceptExecute);
                                            }
                                        } else if (acceptExecute instanceof PublicExecuteEnd) {
                                            if (serverCache != null) {
                                                new TCPServerThread(portManager, serverCache.clone()).start();
                                                serverCache = null;
                                            }
                                        } else if (acceptExecute instanceof PublicExecuteAsk) {
                                            System.err.printf("Accept Ask: %s%n", acceptExecute.toJSON());
                                            new TCPServerThread(portManager, new TCPServerCache(acceptExecute)).start();
                                        }

                                        if (answer != null && !answer.isAsync()) {
                                            answer.resultExecute();
                                        }
                                    }
                                }
                            }
                            return new byte[0];
                        }

                        /**
                         * @param e
                         * @description: 连接异常监听
                         */
                        @Override
                        public void onClientEventExp(MeterException e) {
                            if (notify != null)
                                notify.onClientEventExp(e);
                        }
                    });
            return this.TCPServer.openPort();
        } catch (MeterException e) {
            e.printStackTrace();
        }
        return false;
    }

    /**
     * @description: TCP 服务模式停止
     **/
    public boolean Stop_TCP_Server() {
        try {
            if (this.TCPServer == null && this.workerGroup == null && this.bossGroup == null) return true;
            boolean result = false;
            if (this.TCPServer != null) {
                result = this.TCPServer.closePort();
            } else {
                if (this.workerGroup != null) this.workerGroup.shutdownGracefully();
                if (this.bossGroup != null) this.bossGroup.shutdownGracefully();
                result = true;
            }
            this.TCPServer = null;
            this.workerGroup = null;
            this.bossGroup = null;
            this.tcp_server_port = 33581;
            return result;
        } catch (MeterException e) {
            e.printStackTrace();
            return false;
        }
    }

    /********************************** TCP Server ******************************************/


    /********************************** TCP Client ******************************************/

    // TCP 客户端
    private TCPClient TCPClient;

    /**
     * @description: 初始化 TCP 客户端
     **/
    public boolean Init_TCP_Client(SocketControl control) {
        int tms = GlobalPara.getInstance().getTMS(Device_Ethernet_Online);
        if (tms == TCP_Client) {// 配置支持客户端模式
            try {
                this.TCPClient = new TCPClient(control,
                        new TCPClientDevice(
                                String.format("%s.%s.%s.%s",
                                        GlobalPara.getInstance().getTMS(Ethernet_PC_IP_S1),
                                        GlobalPara.getInstance().getTMS(Ethernet_PC_IP_S2),
                                        GlobalPara.getInstance().getTMS(Ethernet_PC_IP_S3),
                                        GlobalPara.getInstance().getTMS(Ethernet_PC_IP_S4)
                                )
                        ));
                return this.TCPClient.openPort();
            } catch (MeterException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    /**
     * @description: TCP 客户端 停止
     **/
    public boolean Stop_TCP_Client() {
        try {
            if (this.TCPClient == null) return true;
            boolean result = this.TCPClient.closePort();
            this.TCPClient = null;
            return result;
        } catch (MeterException e) {
            e.printStackTrace();
            return false;
        }
    }

    /**
     * @description: TCP Client NetWork 请求
     **/
    public TCPClientResponse network(byte[] request) {
        if (request == null || request.length == 0)
            return TCPClientResponse.fail(MeterStateEnum.TCP_Client发送数据包不存在);
        if (this.TCPClient == null) return TCPClientResponse.fail(MeterStateEnum.TCP_Client未打开);
        try {
            return TCPClientResponse.success(this.TCPClient.sendWithAccept(request));
        } catch (MeterException e) {
            e.printStackTrace();
            return TCPClientResponse.fail(e.getMeterState());
        } catch (Exception e) {
            e.printStackTrace();
            return TCPClientResponse.fail();
        }
    }

    /**
     * @description: TCP Client NetWork 请求
     **/
    public TCPClientResponse network(String request) {
        if (StringUtils.isBlank(request)) return TCPClientResponse.fail(MeterStateEnum.TCP_Client发送数据包不存在);
        return this.network(request.getBytes());
    }

    /********************************** TCP Client ******************************************/


    /************************************** UDP *********************************************/

    // UDP终端模式
    private UDPLink UDP_Link;
    private UDP_Thread UDP_Thread;
    private int UDP_Type;
    private static final String Send_33583 = "UDP\t\r\n";
    private static final String Send_33584 = "UDP\t%s\t%s\r\n";
    private Long executeTime = null;

    /**
     * @param control UDP控制器
     * @param type    0-不启动 1-作为PC 2-作为终端
     * @description: UDP 初始化
     **/
    public boolean Init_UDP_Link(SocketControl control, int type) {
        if (type == UDP_PC || type == UDP_Terminal) {
            this.UDP_Type = type;
            try {
                this.UDP_Link = new UDPLink(control,
                        type == UDP_PC ? UDPDevice.UDP_PC() : UDPDevice.UDP_Terminal(),
                        new SocketClientEventListener() {
                            /**
                             * @param address 来源地址
                             * @param port    来源端口
                             * @param bytes   数据包
                             * @description: 连接监听（IP PORT）
                             **/
                            @Override
                            public byte[] onClientEvent(PortManager portManager, InetAddress address, int port, byte[] bytes) throws MeterException {
                                String accept = new String(bytes);
                                if (GlobalPara.getInstance().isRunLog())
                                    System.out.printf("收到来自:%s,对方端口号为:%s,消息内容：%s%n", address, port, accept);
                                if (StringUtils.isNotBlank(accept)) {
                                    if (UDP_Type == UDP_Terminal && Send_33583.equals(accept)) {
                                        // 终端发送广播响应
                                        UDP_Terminal();
                                    }
                                } else {
                                    if (notify != null) {
                                        notify.udpFoundEvent(address, port, accept);
                                    }
                                }
                                return new byte[0];
                            }

                            /**
                             * @param e
                             * @description: 连接异常监听
                             */
                            @Override
                            public void onClientEventExp(MeterException e) {
                                if (notify != null) {
                                    notify.onClientEventExp(e);
                                }
                            }
                        });
                boolean result = this.UDP_Link.openPort();

                if (this.UDP_Type == UDP_PC) {
                    // 开机主动搜索 PC广播 4 次
                    this.UDP_PC(4);
                } else if (this.UDP_Type == UDP_Terminal) {
                    // 间隔每30秒执行一次终端广播
                    this.UDP_Thread = new UDP_Thread(new UDP_Execute() {
                        /**
                         * @description: 执行内容
                         **/
                        @Override
                        public void execute() {
                            UDP_Terminal();
                        }
                    }, 30);
                    this.UDP_Thread.start();
                }

                return result;
            } catch (MeterException e) {
                e.printStackTrace();
                this.UDP_Link = null;
            }
        }
        return false;
    }

    /**
     * @description: 停止UDP连接
     **/
    public boolean Stop_UDP_Link() {
        try {
            if (this.UDP_Thread != null) {
                this.UDP_Thread.close();
                this.UDP_Thread = null;
            }
            if (this.UDP_Link == null) return true;
            boolean result = this.UDP_Link.closePort();
            this.UDP_Link = null;
            return result;
        } catch (MeterException e) {
            e.printStackTrace();
            return false;
        }
    }

    /**
     * @description: PC UDP 发送内容
     **/
    public boolean UDP_PC() {
        return this.UDP_PC(1);
    }

    /**
     * @description: PC UDP发送搜索
     **/
    public boolean UDP_PC(int count) {
        if (this.UDP_Link != null && UDP_Type == UDP_PC) {
            count = count <= 0 ? 1 : count;
            for (int i = 0; i < count; i++) {
                try {
                    this.UDP_Link.writeDataImmediately(Send_33583.getBytes());
                } catch (MeterException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    /**
     * @description: 暂停终端广播线程
     **/
    private boolean UDP_Terminal_Pause_Resume() {
        if (this.UDP_Thread != null) {
            this.UDP_Thread.pause = !this.UDP_Thread.pause;
            return true;
        }
        return false;
    }

    /**
     * @description: 终端 UDP 发送内容
     **/
    public boolean UDP_Terminal() {
        return this.UDP_Terminal(1);
    }

    /**
     * @description: 终端 UDP 响应内容
     **/
    public boolean UDP_Terminal(int count) {
        if (this.UDP_Link != null && this.UDP_Terminal_Broadcast_Check() && UDP_Type == UDP_Terminal) {
            count = count <= 0 ? 1 : count;
            for (int i = 0; i < count; i++) {
                if (this.executeTime != null && System.currentTimeMillis() - this.executeTime < 5000) return true;
                try {
                    this.UDP_Link.writeDataImmediately(
                            String.format(Send_33584, this.tcp_server_port, version).getBytes());
                    this.executeTime = System.currentTimeMillis();
                } catch (MeterException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    /**
     * @description: 检查UDP响应广播
     **/
    private boolean UDP_Terminal_Broadcast_Check() {
        return (this.TCPServer != null || (this.workerGroup != null && this.bossGroup != null))
                && (!this.tcp_link_status && (this.cacheChannelMap == null || this.cacheChannelMap.isEmpty()));
    }

    /**
     * @description: UDP 线程
     **/
    private class UDP_Thread extends Thread {

        private final UDP_Execute execute;
        private int time = 30;
        private boolean run;// 运行状态
        private boolean pause;// 暂停状态

        UDP_Thread(UDP_Execute execute, int time) {
            this.run = true;
            this.pause = false;
            this.execute = execute;
            this.time = time;
        }

        @Override
        public void run() {
            while (!isInterrupted() && run) {
                if (!pause)
                    execute.execute();
                SystemtUtils.sleep(this.time);
            }
        }

        /**
         * @description: 停止线程
         **/
        void close() {
            this.interrupt();
            this.run = false;
        }
    }

    /**
     * @description: UDP内容
     **/
    private interface UDP_Execute {
        /**
         * @description: 执行内容
         **/
        void execute();
    }

    /************************************** UDP *********************************************/

    /**
     * @description: TCP 服务线程
     **/
    private class TCPServerThread extends Thread {

        private PortManager portManager;

        private ChannelHandlerContext ctx;

        private final TCPServerCache cache;

        TCPServerThread(PortManager portManager, TCPServerCache cache) {
            this.portManager = portManager;
            this.cache = cache;
        }

        /**
         * Allocates a new {@code Thread} object. This constructor has the same
         * {@code (null, null, gname)}, where {@code gname} is a newly generated
         * name. Automatically generated names are of the form
         * {@code "Thread-"+}<i>n</i>, where <i>n</i> is an integer.
         */
        public TCPServerThread(ChannelHandlerContext ctx, TCPServerCache cache) {
            this.ctx = ctx;
            this.cache = cache;
        }

        @Override
        public void run() {
            long start = System.currentTimeMillis();
            PublicExecute execute = cache.getExecute();
            if (execute instanceof PublicExecuteModifyCache) {
                // todo 二次解析处理减少反射Map排序
                execute = DDataUtils.Public_UnPackage_ModifyCache_To_Modify_No_Reflex((PublicExecuteModifyCache) cache.getExecute(), GlobalPara.getInstance().isRunLog());
            }
            long end = System.currentTimeMillis();

            if (GlobalPara.getInstance().isRunLog()) {
                System.out.printf("Accept End Execute [%s] Type: [%s] Size: [%s] Total_Time: [%s] Cache_Time: [%s]%n",
                        execute.getExecute(), execute.getType(), execute.size(),
                        (System.currentTimeMillis() - cache.getStart()), (end - start));
            }

            long t1 = System.currentTimeMillis();
            JHTCPAnswer answer_thread = notify.acceptEvent(execute, portManager != null ? new JHTCPAccept(portManager, execute) : new JHTCPAccept(ctx, execute));
            if (answer_thread != null && !answer_thread.isAsync()) {
                answer_thread.resultExecute();
            }
            long t2 = System.currentTimeMillis();
            if (GlobalPara.getInstance().isRunLog())
                System.out.printf("耗时：[%s]%n", (t2 - t1));
        }
    }

    /************************************** 其他协议 *********************************************/

    // 执行器
    private CMPTAction cmptAction;

    // TCP 控制器
    private SocketControl tcp_server_control;

    // udp 控制器
    private SocketControl udp_control;

    /**
     * @description: 添加控制器
     **/
    public SocketCommunication Init_CMPT_Control(SocketControl tcp_server_control, SocketControl udp_control) {
        this.tcp_server_control = tcp_server_control;
        this.udp_control = udp_control;
        return this;
    }

    /**
     * @description: 获取执行器
     **/
    public CMPTAction cmptAction() {
        return this.cmptAction;
    }

    /**
     * @description: 检查id 是否存在此刷新器中
     **/
    @Override
    public int[] refreshIds() {
        return new int[]{Ethernet_CustomProtocol};
    }

    /**
     * @param no
     * @param value
     * @description: 执行内容
     */
    @Override
    public void refreshAction(int no, int value) {
        switch (no) {
            case Ethernet_CustomProtocol:
                this.Init_CMPT();
                break;
        }
    }

    /**
     * @description: 初始化协议
     **/
    public boolean Init_CMPT() {
        if (this.tcp_server_control != null && this.udp_control != null) {
            int custom_protocol = GlobalPara.getInstance().getTMS(com.jhscale.meter.protocol.constant.TMS.Ethernet_CustomProtocol);
            CMPT cmpt = CMPT.serial(custom_protocol);
            if (cmpt == null) return false;
            try {
                if (cmptAction != null) {
                    if (cmptAction.CMPT().equals(cmpt)) {
                        return true;
                    } else {
                        cmptAction.Stop_Action();
                        this.cmptAction = null;
                    }
                }
                this.cmptAction = (CMPTAction) cmpt.getClazz().newInstance();
                this.cmptAction.Init_CMPT_Action(cmpt, this.tcp_server_control, this.udp_control, this.notify);
                return this.cmptAction.Init_Action();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}
