package com.jhscale.meter.protocol.model;

import com.jhscale.common.model.device._inner.PublicExecute;
import com.jhscale.meter.exp.MeterException;

import java.net.InetAddress;
import java.util.List;

/**
 * @author wang lie
 * @title: SocketNotify
 * @projectName meter-jar
 * @description: TODO
 * @date 2023/1/1822:53
 */
public interface SocketNotify {

    /**
     * @description: 异常信息回调
     **/
    void onClientEventExp(MeterException e);

    /**
     * @description: 接受数据处理
     **/
    @Deprecated
    default JHTCPCallBack acceptEvent(List<PublicExecute> executes, JHTCPCall jhtcpCall) {
        return null;
    }

    /**
     * @description: 接受数据处理
     **/
    JHTCPAnswer acceptEvent(PublicExecute acceptExecute, JHTCPAccept accept);

    /**
     * @description: 接受数据处理
     **/
    void acceptEvent(PublicExecute execute);

    /**
     * @param address 发现地址
     * @param port    连接端口
     * @param accept  接受数据
     * @description: UDP 发现
     **/
    default void udpFoundEvent(InetAddress address, int port, String accept) {
    }
}
