package com.jhscale.meter.protocol.model;

import com.jhscale.common.model.inter.GJSONModel;
import com.jhscale.meter.exp.MeterStateEnum;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author wang lie
 * @title: TCPClientResponse
 * @projectName meter-jar
 * @description: TODO
 * @date 2023/1/190:41
 */
public class TCPClientResponse implements GJSONModel {

    @ApiModelProperty(value = "请求状态结果", name = "result")
    private boolean result;

    @ApiModelProperty(value = "失败错误信息", name = "state")
    private MeterStateEnum state;

    @ApiModelProperty(value = "响应字节流", name = "response")
    private byte[] response;

    public TCPClientResponse() {
    }

    public TCPClientResponse(byte[] response) {
        this.result = true;
        this.response = response;
    }

    public TCPClientResponse(MeterStateEnum state) {
        this.result = false;
        this.state = state;
    }

    /**
     * @description: 响应成功
     **/
    public static TCPClientResponse success(byte[] response) {
        return new TCPClientResponse(response);
    }

    /**
     * @description: 默认响应失败
     **/
    public static TCPClientResponse fail() {
        return fail(MeterStateEnum.TCP_Client通讯失败);
    }

    /**
     * @description: 响应失败
     **/
    public static TCPClientResponse fail(MeterStateEnum state) {
        return new TCPClientResponse(state);
    }

    /**
     * @description: 成功响应信息
     **/
    public String response() {
        return this.result ? new String(this.response) : "";
    }

    public boolean isResult() {
        return result;
    }

    public void setResult(boolean result) {
        this.result = result;
    }

    public MeterStateEnum getState() {
        return state;
    }

    public void setState(MeterStateEnum state) {
        this.state = state;
    }

    public byte[] getResponse() {
        return response;
    }

    public void setResponse(byte[] response) {
        this.response = response;
    }
}
