package com.jhscale.meter.protocol.model;

import com.jhscale.common.model.device._inner.PublicExecute;
import com.jhscale.common.model.inter.JSONModel;

/**
 * @author lie_w
 * @title: TCPCache
 * @projectName meter-jar
 * @description: TODO
 * @date 2023/3/714:47
 */
public class TCPServerCache implements JSONModel {

    private long start = System.currentTimeMillis();

    private PublicExecute execute;

    public TCPServerCache() {
    }

    public TCPServerCache(PublicExecute execute) {
        this.execute = execute;
    }

    public TCPServerCache(long start, PublicExecute execute) {
        this.start = start;
        this.execute = execute;
    }

    @Override
    protected TCPServerCache clone() {
        return new TCPServerCache(this.start, this.execute);
    }

    public long getStart() {
        return start;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public PublicExecute getExecute() {
        return execute;
    }

    public void setExecute(PublicExecute execute) {
        this.execute = execute;
    }
}
