package com.jhscale.meter.protocol.model;

import com.jhscale.common.em.PayType;
import com.jhscale.common.em.PayWay;
import com.jhscale.common.em.TradeType;
import com.jhscale.common.em.Version;
import com.jhscale.common.model.device._inner.DLOGContent;
import com.jhscale.common.model.device._inner.PublicExecuteAsk;
import com.jhscale.common.model.device.barcode_format.DBarcodeFormat;
import com.jhscale.common.model.device.category.DCategory;
import com.jhscale.common.model.device.log.DLOGV1;
import com.jhscale.common.model.device.log.module.DGoods;
import com.jhscale.common.model.device.log.module.DSource;
import com.jhscale.common.model.device.plu.DPLUV5;
import com.jhscale.common.model.device.plu.inner.DAutoDiscountV2;
import com.jhscale.common.model.device.plu.module.DPriceV2;
import com.jhscale.common.model.device.plu.module.DTimeV2;
import com.jhscale.common.model.inter.GJSONModel;
import com.jhscale.common.utils.BigDecimalUtils;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.RuntimeMeterException;
import com.jhscale.meter.protocol.model.sp.TradeSpOut;
import com.jhscale.meter.protocol.model.sp.TradeSpecial;
import com.jhscale.meter.protocol.print.PrintGeneralFactory;
import com.jhscale.meter.protocol.print.link.IPrintBack;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.*;

import static com.jhscale.common.model.device.DConstant.REP;
import static com.jhscale.meter.protocol.constant.TMS.*;
import static com.jhscale.meter.protocol.constant.TMT.*;

/**
 * @author lie_w
 * @title: PrintContent
 * @projectName hardware-core
 * @description: TODO
 * @date 2022/8/820:06
 */
@ApiModel("交易内容")
public class TradeContent implements GJSONModel {

    // todo 1. 交易总额
    // todo 2. 退货 原单号 原设备号 原单交易时间
    // todo 3. 税额
    // todo 4. 成本
    // todo 5. 错误码 错误文本
    // todo 6. 吉卡云 消费/赠送金额 储值/储值赠送金额

    @ApiModelProperty(value = "商品明细", name = "item")
    private List<ItemContent> item;

    @ApiModelProperty(value = "是否预打印", name = "isPrePrint")
    private boolean isPrePrint = false;
    @ApiModelProperty(value = "是否重复打印", name = "isRePrint")
    private boolean isRePrint = false;

    @ApiModelProperty(value = "交易时间", name = "tradeTime")
    private Date tradeTime;
    @ApiModelProperty(value = "永久日志编号", name = "fid")
    private int fid;
    @ApiModelProperty(value = "临时日志编号", name = "sid")
    private int sid = 0;
    @ApiModelProperty(value = "桌号", name = "vid")
    private int vid = 1;
    @ApiModelProperty(value = "营业员编号", name = "salesman_Number")
    private int salesman_Number = 0;
    @ApiModelProperty(value = "营业员名称", name = "salesman_Name")
    private String salesman_Name = "";
    @ApiModelProperty(value = "服务员编号", name = "serviceman_Number")
    private int serviceman_Number = 0;
    @ApiModelProperty(value = "服务员编号", name = "serviceman_Name")
    private String serviceman_Name = "";

    @ApiModelProperty(value = "日志类型", name = "tradeType")
    private int tradeType = 0;
    @ApiModelProperty(value = "日志类型名称", name = "tradeTypeName")
    private String tradeTypeName = "销售";

    @ApiModelProperty(value = "总数量", name = "tCount")
    private BigDecimal tCount = BigDecimal.ZERO;
    @ApiModelProperty(value = "总重量", name = "tWeight")
    private BigDecimal tWeight = BigDecimal.ZERO;
    @ApiModelProperty(value = "总重量单位", name = "tUnitWeight")
    private int tUnitWeight = 0;
    @ApiModelProperty(value = "重量单位", name = "unit_Weight")
    private int unit_Weight = 0;

    @ApiModelProperty(value = "原始价税合计", name = "purTax_FromPLU")
    private BigDecimal purTax_FromPLU = BigDecimal.ZERO;
    @ApiModelProperty(value = "商品价税合计", name = "purTax_Addup")
    private BigDecimal purTax_Addup = BigDecimal.ZERO;
    @ApiModelProperty(value = "商品税额合计", name = "tax_Addup")
    private BigDecimal tax_Addup = BigDecimal.ZERO;
    @ApiModelProperty(value = "服务费价税合计", name = "purTax_ServiceFee")
    private BigDecimal purTax_ServiceFee = BigDecimal.ZERO;
    @ApiModelProperty(value = "服务费税额合计", name = "tax_ServiceFee")
    private BigDecimal tax_ServiceFee = BigDecimal.ZERO;

    @ApiModelProperty(value = "总服务费类型", name = "total_ServiceFee_Type")
    private int total_ServiceFee_Type = 0;
    @ApiModelProperty(value = "总服务费额度", name = "total_ServiceFee_Rate")
    private BigDecimal total_ServiceFee_Rate = BigDecimal.ZERO;

    @ApiModelProperty(value = "折扣后价税合计", name = "purTax_Discounted")        //purTax_Addup+purTax_ServiceFee
    private BigDecimal purTax_Discounted = BigDecimal.ZERO;
    @ApiModelProperty(value = "折扣后税额合计", name = "tax_Discounted")
    private BigDecimal tax_Discounted = BigDecimal.ZERO;
    @ApiModelProperty(value = "总价税合计", name = "purTax_Final")          //最终，purTax_Discounted进行舍位操作后
    private BigDecimal purTax_Final = BigDecimal.ZERO;
    // @ApiModelProperty(value = "总价税合计_第二货币", name = "purTax_Final_2ndCurrency")          //如果不用，维持0即可
    // private BigDecimal purTax_Final_2ndCurrency = BigDecimal.ZERO;
    @ApiModelProperty(value = "总价税合计 == 剩余退款金额", name = "surplus_Reject")
    //最终，purTax_Discounted进行舍位操作后
    private BigDecimal surplus_Reject;

    @ApiModelProperty(value = "舍入金额", name = "rounding")            //舍入金额=总价税合计-总价税合计无舍
    private BigDecimal rounding = BigDecimal.ZERO;
    @ApiModelProperty(value = "找零", name = "change")            //找零=所有支付总额-总价税合计
    private BigDecimal change = BigDecimal.ZERO;
    @ApiModelProperty(value = "现金支付额", name = "pay_Cash")
    private BigDecimal pay_Cash = BigDecimal.ZERO;
    @ApiModelProperty(value = "其他1支付额", name = "pay_Other1")
    private BigDecimal pay_Other1 = BigDecimal.ZERO;
    @ApiModelProperty(value = "其他2支付额", name = "pay_Other2")
    private BigDecimal pay_Other2 = BigDecimal.ZERO;
    @ApiModelProperty(value = "其他2支付额", name = "pay_Other3")
    private BigDecimal pay_Other3 = BigDecimal.ZERO;

    @ApiModelProperty(value = "吉卡云支付额总值", name = "pay_JKY_All")
    private BigDecimal pay_JKY_All = BigDecimal.ZERO;
    @ApiModelProperty(value = "吉卡云支付额赠送部分", name = "pay_JKY_Gift")
    private BigDecimal pay_JKY_Gift = BigDecimal.ZERO;
    @ApiModelProperty(value = "卡支付额", name = "pay_Card")
    private BigDecimal pay_Card = BigDecimal.ZERO;

    //Used by pay_JKY or pay_Card
    @ApiModelProperty(value = "会员卡原余额", name = "pay_VIP_Balance_Old")
    //Keep 0 if do not want print these two
    private BigDecimal pay_VIP_Balance_Old = BigDecimal.ZERO;
    @ApiModelProperty(value = "会员卡现余额", name = "pay_VIP_Balance_New")
    private BigDecimal pay_VIP_Balance_New = BigDecimal.ZERO;
    @ApiModelProperty(value = "会员卡号", name = "pay_VIP_Number")         //用于对外展示的卡号，如果是吉卡云展示手机
    private String pay_VIP_ID = "";
    @ApiModelProperty(value = "会员主识别码", name = "pay_VIP_ID1")       //实际卡号，如果是吉卡云则暂不使用
    private String pay_VIP_ID_Plus1 = "";
    @ApiModelProperty(value = "会员副识别码", name = "pay_VIP_ID2")       //实际副卡号，如果是吉卡云则暂不使用
    private String pay_VIP_ID_Plus2 = "";
    @ApiModelProperty(value = "会员优惠等级", name = "pay_VIP_Level")
    //0 for no VIP, ' ' for no-level VIP or 'A'-'D' for Level 1-4
    private char pay_VIP_Level = 0;
    @ApiModelProperty(value = "会员优惠率", name = "pay_VIP_DiscountP1W")       //比如9500=95折扣
    private int pay_VIP_DiscountP1W = 10000;
    @ApiModelProperty(value = "会员卡积分", name = "pay_VIP_Point")
    private BigDecimal pay_VIP_Point = BigDecimal.ZERO;

    @ApiModelProperty(value = "原交易信息", name = "source")
    private DSource source;

    @ApiModelProperty(value = "云支付额", name = "pay_Cloud")
    private BigDecimal pay_Cloud = BigDecimal.ZERO;
    @ApiModelProperty(value = "云支付交易渠道", name = "pay_Cloud_TypeName")
    private Integer pay_Cloud_Way = 0;
    @ApiModelProperty(value = "云支付支付方式", name = "pay_Cloud_TypeName")
    private Integer pay_Cloud_Type = 0;
    @ApiModelProperty(value = "云支付类型名", name = "pay_Cloud_TypeName")
    private String pay_Cloud_TypeName = "";
    @ApiModelProperty(value = "云支付单号", name = "pay_Cloud_Bill")
    private String pay_Cloud_Bill = "";

    @ApiModelProperty(value = "错误码", name = "error_code")
    private String error_code = "";
    @ApiModelProperty(value = "错误内容", name = "error_text1")
    private String error_text1 = "";

    @ApiModelProperty(value = "客制信息", name = "customInfo")
    private Map<String, String> customInfo;

    @ApiModelProperty(value = "打印内容", name = "printContents")
    private List<PrintContent> printContents;

    @ApiModelProperty(value = "日志内容", name = "logContent")
    private DLOGContent logContent;

    @ApiModelProperty(value = "特殊信息", name = "spInfo")
    private Map<String, Object> spInfo = new HashMap<>();

    @ApiModelProperty(value = "POS打印内容", name = "posOnlyString")
    private Map<Integer, String> posOnlyString = new HashMap<>();

    public TradeContent() {
        this.item = new ArrayList<>();
        this.customInfo = new HashMap<>();
    }

    public TradeContent(int type) {
        this();
        this.Total_TradeType_Set(type);
    }

    /**
     * @description: 添加营业员
     **/
    public TradeContent Total_Salesman_Set(int number, String name) {
        salesman_Number = number;
        salesman_Name = name;
        return this;
    }

    /**
     * @description: 设置服务员，通常不使用
     **/
    public TradeContent Total_Serviceman_Set(int number, String name) {
        serviceman_Number = number;
        serviceman_Name = name;
        return this;
    }

    /**
     * @description: 设置桌号，通常不使用，打印重以Vxx的方式打印
     **/
    public TradeContent Total_VID_Set(int number) {
        vid = number;
        return this;
    }

    /**
     * @description: 添加日志类型
     **/
    public TradeContent Total_TradeType_Set(int type) {
        this.tradeType = type;
        this.tradeTypeName = GlobalPara.getInstance().getTradeTypeName(type);
        return this;
    }

    /**
     * @description: VIP单价换算
     **/
    public BigDecimal CalPLU_UPrice_VIPed(DPLUV5 plu)           //cal price with VIP-Level discount. before amount and unit convert
    {
        int p1w;
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int day_week = calendar.get(Calendar.DAY_OF_WEEK);
        if (calendar.getFirstDayOfWeek() == Calendar.SUNDAY)
            day_week--;
        else if (day_week == 7)
            day_week = 0;
        day_week = 1 << day_week;

        DPriceV2 price = plu.price(GlobalPara.getInstance().getDeviceLevel());

        if (pay_VIP_Level != 0) {
            if (GlobalPara.getInstance().isDiscountAuto_InTime()) {
                int level = pay_VIP_Level - 'A';
                while ((level >= 0) && (level < 4)) {
                    if (price.getAutoDiscounts() != null && !price.getAutoDiscounts().isEmpty()) {
                        for (DAutoDiscountV2 autoDiscount : price.getAutoDiscounts()) {
                            if ((autoDiscount.date() & day_week) != 0) {
                                int ctSort = autoDiscount.type() - 4;
                                if ((ctSort < 0) || (ctSort >= 4))
                                    continue;
                                if (level == ctSort) {
                                    if (BigDecimalUtils.compareMoreZeroValue(autoDiscount.discount()))
                                        return autoDiscount.discount();
                                    else
                                        return price.getPrice().add(autoDiscount.discount());
                                }
                            }
                        }
                    }

                    // for (int loop = 0; loop < plu.getDa_sort().length; loop++) {
                    //     if ((plu.getDa_wDay()[loop] & day_week) != 0) {
                    //         int ctSort = plu.getDa_sort()[loop] - 4;
                    //         if ((ctSort < 0) || (ctSort >= 4))
                    //             continue;
                    //         if (level == ctSort) {
                    //             if (plu.getDa_tarValue()[loop].compareTo(BigDecimal.ZERO) >= 0)
                    //                 return plu.getDa_tarValue()[loop];
                    //             else
                    //                 return plu.getPrice().add(plu.getDa_tarValue()[loop]);
                    //         }
                    //     }
                    // }
                    level--;
                }
            }
            p1w = this.pay_VIP_DiscountP1W;
        } else
            p1w = 10000 - GlobalPara.getInstance().getTMS(Discount_Always) * 100;
        if ((p1w == 0) || (p1w >= 10000))
            return price.getPrice();
        else
            return price.getPrice().multiply(new BigDecimal(p1w)).divide(new BigDecimal(10000));
    }

    /**
     * @description: 集中收银 内部条码商品添加
     **/
    public ItemContent Item_Set_Note(ItemContent itemC, BigDecimal amount, BigDecimal price) {
        if (price == null) {
            if (amount == null) {
                return null;
            } else {
                itemC.setAmount(amount);
                if (amount.compareTo(BigDecimal.ZERO) > 0)
                    itemC.setValid_Amount(true);
                itemC.Item_ReCal(this);
            }
        } else {
            if (amount == null) {
                BigDecimal mayAmount = null;
                BigDecimal mayUprice = null;

                try {
                    mayUprice = GlobalPara.getInstance().EcsCal_Unit_ValueConvert(itemC.getPlu().price(GlobalPara.getInstance().getDeviceLevel()).getPrice(), itemC.getUnit_weight(), itemC.getUnit_price());
                    mayAmount = price.divide(mayUprice, GlobalPara.getInstance().getPointOfWeight(), RoundingMode.HALF_UP);
                } catch (Exception e) {
                    mayAmount = BigDecimal.ONE;
                    mayUprice = price;
                }

                itemC.setFixedSingle(true);

                if (GlobalPara.getInstance().EcsCal_Unit_isWeight(itemC.getUnit_weight())) {
                    //商品本来是计重的
                    itemC.setUnit_weight(2);
                    itemC.setUnit_price(2);
                    itemC.setAmount(BigDecimal.ONE);
                    itemC.setPrice(price);

                    itemC.setAmount_Stock(mayAmount);
                    itemC.setUnit_Stock(GlobalPara.getInstance().getWeightUNIT());
                } else {
                    itemC.setAmount(mayAmount.stripTrailingZeros());
                    itemC.setPrice(mayUprice);
                }
            } else
                itemC.setAmount(amount);

            BigDecimal tax;
            if (itemC.getTaxType() == 1) {
                tax = price.multiply(itemC.getTaxRate());
                price = price.add(tax);
            } else if (itemC.getTaxType() == 2) {
                tax = price.multiply(itemC.getTaxRate()).divide(itemC.getTaxRate().add(BigDecimal.ONE), 7, BigDecimal.ROUND_HALF_UP);
            } else if (itemC.getTaxType() == 3) {
                tax = price.multiply(itemC.getTaxRate());
            } else
                tax = BigDecimal.ZERO;

            itemC.setTax(GlobalPara.getInstance().EcsCal_Rounding_Single(tax));
            itemC.setSingleWtax(GlobalPara.getInstance().EcsCal_Rounding_Single(price));
            itemC.setSingleNtax(itemC.getSingleWtax().subtract(itemC.getTax()));
            boolean valid = itemC.getSingleWtax().compareTo(BigDecimal.ZERO) != 0 || GlobalPara.getInstance().getTMS(Fuc_ZeroSale) == 1;
            itemC.setValid_Amount(valid);
            itemC.setValid_Single(valid);
            return itemC;
        }
        return itemC;
    }

    /**
     * @description: 集中收银累加
     **/
    public ItemContent Item_Set_Note(ItemContent itemC, BarCodeItemResult barCIR) {
        BigDecimal amount = null;
        BigDecimal price = null;
        if (barCIR.getPrice() != null)
            price = new BigDecimal(barCIR.getPrice()).movePointLeft(GlobalPara.getInstance().getTMS(DotBcode_Money));
        if (barCIR.getAmount() != null)
            amount = new BigDecimal(barCIR.getAmount()).movePointLeft(GlobalPara.getInstance().getTMS(GlobalPara.getInstance().EcsCal_Unit_isWeight(itemC.getPlu().unit()) ? DotBcode_Weight : DotBcode_Count));
        return Item_Set_Note(itemC, amount, price);
    }

    /**
     * @description: 移除明细
     **/
    @Deprecated
    public void Total_RemoveItem(ItemContent itemC) {
        this.item.remove(itemC);
        this.Total_NoExtraDiscount();
    }

    /**
     * @description: 移除明细
     **/
    public List<ItemContent> Total_RemoveItem(Integer... indexes) {
        return (indexes != null && indexes.length > 0) ? this.Total_RemoveItem(Arrays.asList(indexes)) : new ArrayList<>();
    }

    /**
     * @description: 移除明细
     **/
    public List<ItemContent> Total_RemoveItem(List<Integer> indexes) {
        List<ItemContent> item = new ArrayList<>();
        if (indexes != null && !indexes.isEmpty()) {
            for (int index : indexes) {
                if (index < this.item.size()) {
                    item.add(this.item.get(index));
                    this.item.set(index, null);
                }
            }

            Iterator<ItemContent> iterator = this.item.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() == null) iterator.remove();
            }
        }
        this.Total_NoExtraDiscount();
        return item;
    }

    /**
     * @description: 添加交易列表
     **/
    public boolean Total_AddItem(ItemContent itemC) throws RuntimeMeterException {
        if (!itemC.AddValid())
            return false;

        //标记已经被使用的重量
        WeightCal.getInstance().update_UsedGross(itemC.getValid_UsedGross(), itemC.getPlu().no());

        this.item.add(itemC);
        this.Total_NoExtraDiscount();
        return true;
    }

    /**
     * @description: 添加交易列表
     **/
    public TradeContent Total_AddItem(List<ItemContent> itemCs) {
        if (itemCs != null && !itemCs.isEmpty()) {
            for (ItemContent itemC : itemCs) {
                if (itemC.AddValid())
                    this.item.add(itemC);
            }
            this.Total_NoExtraDiscount();
        }
        return this;
    }

    /**
     * @description: VIP 是否登录
     **/
    public boolean VIP_LOGIN() {
        return this.pay_VIP_Level != 0;
    }

    /**
     * @description: 会员 卡付 等级|折扣 设置
     **/
    public void Total_VIP_Set(char level, int p1w)          //JKY 和 Card通用
    {
        pay_VIP_Level = level;
        if (level == 0)
            pay_VIP_DiscountP1W = 10000;
        else
            pay_VIP_DiscountP1W = p1w;
        this.Total_VIP_Calculate();
    }

    /**
     * @description: 会员 卡付 等级|折扣 重置
     **/
    public TradeContent Total_VIP_Clear() {
        pay_VIP_Level = 0;
        pay_VIP_DiscountP1W = 10000;
        this.Total_VIP_Calculate();
        return this;
    }

    /**
     * @description: 会员 卡付 重算
     **/
    private void Total_VIP_Calculate() {
        if (item.isEmpty())
            return;

        for (ItemContent itemContent : item) {
            if (itemContent.isPriceIsManual())
                continue;
            if (!itemContent.isFixedSingle()) {
                itemContent.setPrice(GlobalPara.getInstance().CalPLU_Price_wUnit(CalPLU_UPrice_VIPed(itemContent.getPlu()), itemContent.getPlu().getUnit()));
                itemContent.setUnit_price(GlobalPara.getInstance().CalPLU_PriceUnit_wUnit(itemContent.getPlu().getUnit()));
                itemContent.Item_ReCal(this);
            }
        }
        this.Total_NoExtraDiscount();
    }

    /**
     * @description: 无额外折扣
     **/
    private void Total_NoExtraDiscount() {
        Total_InfoCheck_O();
        Total_Set_Discount(purTax_Addup.add(purTax_ServiceFee));
        Total_InfoCheck_E();
    }

    /**
     * @description: 交易完结
     **/
    public TradeContent Total_Close(int inputFID, int inputSID) {
        this.tradeTime = new Date();
        BigDecimal needcash = Total_Cal_LeftPay();
        if (pay_Cash.compareTo(needcash) >= 0) {
            change = pay_Cash.subtract(needcash);
        } else {
            pay_Cash = needcash;
            change = GlobalPara.getInstance().EcsCal_Rounding_Total(BigDecimal.ZERO);
        }

        this.isPrePrint = false;

        this.fid = inputFID;
        this.sid = inputSID;
        return this;
    }

    /**
     * @description: 交易完结
     **/
    public TradeContent Total_Close(FID_SID fid_sid) {
        return this.Total_Close(fid_sid.getFid(), fid_sid.getSid());
    }

    /**
     * @description: 交易完结（错误）
     **/
    public TradeContent Total_Close(int inputFID, int inputSID, String error) {
        this.tradeTime = new Date();

        this.isPrePrint = false;

        this.fid = inputFID;
        this.sid = inputSID;
        this.error_code = error;
        return this;
    }

    /**
     * @description: 交易完结（错误）
     **/
    public TradeContent Total_Close(int inputFID, int inputSID, String error_code, String error_msg) {
        if (StringUtils.isNotBlank(error_msg)) {
            this.error_text1 = error_msg.length() > 1024 ? error_msg.substring(0, 1024) : error_msg;
        }
        return this.Total_Close(inputFID, inputSID, error_code);
    }

    /**
     * @description: 交易完结（错误）
     **/
    public TradeContent Total_Close(FID_SID fid_sid, String error) {
        this.tradeTime = new Date();

        this.isPrePrint = false;

        this.fid = fid_sid.getFid();
        this.sid = fid_sid.getSid();
        this.error_code = error;
        return this;
    }

    /**
     * @description: 交易日志
     **/
    private String Total_Log_Text(int spec, DPLUV5 plu) {
        if (spec <= 0)
            return null;
        else if (spec == 1)
            return plu.getName();
        else if (spec <= 8)
            // return plu.text(GlobalPara.getInstance().getDeviceLevel()).text(spec - 1);
            return plu.getText().text(spec - 1);
        else if (spec == 9)
            return plu.getItemCode().toString();
        else if (spec == 10)
            return plu.getIndexBar();
        else if (spec <= 14)
            return null;
        else if (spec == 15)
            return this.pay_VIP_ID;
        else if (spec == 16)
            return this.pay_VIP_ID_Plus1;
        else
            return null;
    }

    /**
     * @description: 日志反转解析
     * @date: 2024-11-11 15:05:48
     */
    public TradeContent Total_Log(DLOGContent content) {
        if (content != null) {
            this.logContent = content;
            DLOGV1 dlogv1 = (DLOGV1) new DLOGV1<>().Server_UnPackage(this.logContent.getLog()).getObj();

            this.Total_TradeType_Set(dlogv1.getType());
            this.Total_Salesman_Set(dlogv1.getSaleMan(), "");

            if (dlogv1.getGoodsList() != null && !dlogv1.getGoodsList().isEmpty()) {
                for (Object o : dlogv1.getGoodsList()) {
                    DGoods goods = (DGoods) o;

                    DPLUV5 plu = new DPLUV5();
                    plu.setNo(goods.getNo());
                    plu.setName(goods.getName());
                    plu.setUnit(goods.getUnit());
                    plu.setUnitText(goods.getUnitText());
                    plu.setCategory(goods.getCategory());
                    plu.setPrice(new DPriceV2().setPrice(goods.getPrice()));

                    ItemContent itemContent = new ItemContent(plu, this);
                    itemContent.Item_Set_Good(goods);
                    this.Total_AddItem(itemContent);
                }
            }

            if (StringUtils.isNotBlank(dlogv1.getErrMsg4())) {
                String[] split = dlogv1.getErrMsg4().split("\t");
                for (String str : split) {
                    try {
                        if (StringUtils.isNotBlank(str)) {
                            String[] ss = str.split(":");
                            this.putPosOnlyString(Integer.parseInt(ss[0]), ss[1]);
                        }
                    } catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }

            if (Objects.nonNull(dlogv1.getJkyPay()) || Objects.nonNull(dlogv1.getJkyGiftPay())) {
                this.Total_Pay_JKY(
                        (Objects.nonNull(dlogv1.getJkyPay()) ? dlogv1.getJkyPay() : BigDecimal.ZERO)
                                .add(Objects.nonNull(dlogv1.getJkyGiftPay()) ? dlogv1.getJkyGiftPay() : BigDecimal.ZERO),
                        Objects.nonNull(dlogv1.getJkyGiftPay()) ? dlogv1.getJkyGiftPay() : BigDecimal.ZERO,
                        BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, ""
                );
            }

            if (Objects.nonNull(dlogv1.getCardPay())) {
                this.Total_Pay_Card(dlogv1.getCardPay(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, "", "", "");
            }

            if (Objects.nonNull(dlogv1.getOtherPay1())) {
                this.Total_Pay_Other1(dlogv1.getOtherPay1());
            }

            if (Objects.nonNull(dlogv1.getOtherPay2())) {
                this.Total_Pay_Other2(dlogv1.getOtherPay2());
            }

            if (Objects.nonNull(dlogv1.getOtherPay3())) {
                this.Total_Pay_Other3(dlogv1.getOtherPay2());
            }

            if (Objects.nonNull(dlogv1.getCloudPay())) {
                this.Total_Pay_Cloud(dlogv1.getCloudPay(), dlogv1.getPayWay(), dlogv1.getPayType(), PayType.type(dlogv1.getType()).getDescription(), "");
            }

            if (Objects.nonNull(dlogv1.getCash())) {
                this.Total_Pay_Cash(dlogv1.getCash());
            }

            if (Objects.nonNull(dlogv1.getTradeVal())) {
                this.Total_Set_Discount(dlogv1.getTradeVal());
            }

            this.Total_Close(dlogv1.getFid(), dlogv1.getSid(),
                    StringUtils.isNotBlank(dlogv1.getErrCode()) ? dlogv1.getErrCode() : "",
                    StringUtils.isNotBlank(dlogv1.getErrMsg4()) ? dlogv1.getErrMsg4() : "");

            this.tradeTime = new Date(content.getTradeDate());
        }
        return this;
    }

    /**
     * @description: 生成日志
     **/
    public TradeContent Total_Log() {
        if (this.logContent == null) {
            // 生成日志 最大 退款金额
            this.surplus_Reject = this.purTax_Final;

            Integer cloudPay = this.defaultNull(this.pay_Cloud_Way);
            BigDecimal jkp = this.defaultNull(this.pay_JKY_All);
            PayWay payway = Objects.nonNull(cloudPay) ? PayWay.Aggregate_PAY
                    : (Objects.nonNull(jkp) ? PayWay.JK_PAY : PayWay.CASH_PAY);

            DLOGV1 dlogv1 = new DLOGV1()
                    .setFid(this.fid)
                    .setKind(GlobalPara.getInstance().getDeviceType())
                    .setTradeTime(this.tradeTime)
                    .setSid(this.sid)
                    .setTradeVal(this.purTax_Final)// todo 交易总额
                    .setType(this.tradeType)
                    .setSaleMan(this.salesman_Number)
                    .setRoundingDiscount(this.defaultNull(this.rounding))
                    .setTax(this.defaultNull(this.tax_Discounted)) // todo 税额
                    // .setCost(null) // todo 成本
                    .setCash(purTax_Final.subtract(pay_Card).subtract(pay_Other1).subtract(pay_Other2).subtract(pay_Other3).subtract(pay_JKY_All).subtract(pay_Cloud))
                    .setCardPay(this.defaultNull(this.pay_Card))
                    .setOtherPay1(this.defaultNull(this.pay_Other1))
                    .setOtherPay2(this.defaultNull(this.pay_Other2))
                    .setOtherPay3(this.defaultNull(this.pay_Other3))
                    .setServiceCharge(this.defaultNull(this.purTax_ServiceFee))
                    .setPayWay(payway.getType())
                    .setPayType(this.defaultNull(this.pay_Cloud_Type))
                    .setCloudPay(this.defaultNull(this.pay_Cloud))
                    .setSource(this.source)
                    .setErrCode(this.error_code)
                    .setErrMsg1(this.error_text1)
                    .setJkyPay(this.defaultNullBigDecimalSubtract(this.pay_JKY_All, this.pay_JKY_Gift))
                    .setJkyGiftPay(this.defaultNull(this.pay_JKY_Gift));

            if (this.posOnlyString != null && !this.posOnlyString.isEmpty()) {
                StringBuilder builder = new StringBuilder();
                for (Map.Entry<Integer, String> entry : this.posOnlyString.entrySet()) {
                    builder.append(entry.getKey()).append(":").append(entry.getValue()).append("\t");
                }
                // 作废内容
                // for (String value : this.posOnlyString.values()) {
                //     builder.append(value).append("\t");
                // }
                dlogv1.setErrMsg4(builder.toString());
            }

            if (this.item != null && !this.item.isEmpty()) {
                for (int i = 0; i < this.item.size(); i++) {
                    ItemContent itemContent = this.item.get(i);
                    DCategory category = GlobalPara.getInstance().GetCategory(itemContent.getPlu().getCategory());
                    Integer dept = Objects.nonNull(category) ? category.getDept() : null;
                    DGoods goods = new DGoods()
                            // 本地日志填充数据
                            .setNo(itemContent.getPlu().getNo())
                            .setUnit(itemContent.getUnit_weight())
                            .setName(itemContent.getPlu().getName())
                            .setAmount(this.defaultNull(itemContent.getAmount()))
                            .setPrice(this.defaultNull(GlobalPara.getInstance().EcsCal_Unit_PriceConvertTo(itemContent.getPrice(), itemContent.getUnit_price(), itemContent.getUnit_weight())))
                            .setItemTotal(this.defaultNull(itemContent.getSingleWtax()))

                            .setUnitText(itemContent.getPlu().getUnitText())
                            .setAmountStock(this.defaultNull(itemContent.getAmount_Stock()))// 计件取重 取重库存
                            .setUnitStock(this.defaultNull(itemContent.getUnit_Stock()))// 计件取重 取重库存
                            .setTax(this.defaultNull(itemContent.getTax()))
                            .setCategory(itemContent.getPlu().getCategory())
                            .setDept(dept)
                            .setText1(this.defaultNull(Total_Log_Text(GlobalPara.getInstance().getTMS(LogText_1), itemContent.getPlu())))
                            .setText2(this.defaultNull(Total_Log_Text(GlobalPara.getInstance().getTMS(LogText_2), itemContent.getPlu())))
                            .setText3(this.defaultNull(Total_Log_Text(GlobalPara.getInstance().getTMS(LogText_3), itemContent.getPlu())))
                            .setText4(this.defaultNull(Total_Log_Text(GlobalPara.getInstance().getTMS(LogText_4), itemContent.getPlu())))
                            .setPics(itemContent.pics());

                    if (itemContent.getPosOnlyString() != null && !itemContent.getPosOnlyString().isEmpty()) {
                        StringBuilder builder = new StringBuilder();
                        for (String value : itemContent.getPosOnlyString().values()) {
                            builder.append(value).append("\t");
                        }
                        goods.setText4(builder.toString());
                    }
                    dlogv1.addGoods(goods);
                }
            }
            this.logContent = new DLOGContent()
                    .setEdition(Version.VERSION03.getVersion())
                    .setFid(dlogv1.getFid())
                    .setSid(dlogv1.getSid())
                    .setLog(dlogv1.Server_Package())
                    .setLogType(dlogv1.getType())
                    .setTradeDate(dlogv1.getTradeTime().getTime());
        }
        return this;
    }

    /**
     * @description: 局域网记录上报  结果无所谓
     **/
    public boolean network_ask() {
        int tms = GlobalPara.getInstance().getTMS(Device_Ethernet_ASK);
        if (tms == 1 || tms == 3) {
            // 发送记录申请信息
            PublicExecuteAsk ask = new PublicExecuteAsk(REP);
            ask.add(String.valueOf(fid));
            return SocketCommunication.getInstance().tcp_server_ask(ask);
        }
        return false;
    }

    private BigDecimal defaultNullBigDecimalSubtract(BigDecimal b1, BigDecimal b2) {
        if (b1 == null) return null;
        if (b2 == null) b2 = BigDecimal.ZERO;
        return b1.subtract(b2);
    }

    /**
     * @description: 字符串不为空 使用字符
     **/
    private String defaultNull(String inStr) {
        return StringUtils.isNotBlank(inStr) ? inStr : null;
    }

    /**
     * @description: BigDecimal == 0 ? null : BigDecimal
     **/
    private BigDecimal defaultNull(BigDecimal bigDecimal) {
        return Objects.nonNull(bigDecimal) && !BigDecimalUtils.compareZeroValue(bigDecimal) ? bigDecimal : null;
    }

    /**
     * @description: Integer == 0 ? null : Integer
     **/
    private Integer defaultNull(Integer integer) {
        return Objects.nonNull(integer) && integer != 0 ? integer : null;
    }

    /**
     * @description: 现金支付 (返回找零)
     **/
    public TradeContent Total_Pay_Cash(BigDecimal cash) {
        BigDecimal needcash = Total_Cal_LeftPay();
        if (cash.compareTo(needcash) >= 0) {
            pay_Cash = cash;
            change = pay_Cash.subtract(needcash);
        } else {
            pay_Cash = needcash;
            change = GlobalPara.getInstance().EcsCal_Rounding_Total(BigDecimal.ZERO);
        }
        return this;
    }

    /**
     * @description: 吉卡云支付
     **/
    public TradeContent Total_Pay_JKY(BigDecimal jky_all, BigDecimal jky_Gift, BigDecimal point, BigDecimal balance_Old, BigDecimal balance_new, String id) {
        pay_JKY_All = jky_all;
        pay_JKY_Gift = jky_Gift;
        pay_VIP_Point = point;
        pay_VIP_Balance_Old = balance_Old;
        pay_VIP_Balance_New = balance_new;
        pay_VIP_ID = id;
        pay_VIP_ID_Plus1 = "";
        pay_VIP_ID_Plus2 = "";
        return this;
    }

    /**
     * @description: 第三方卡付
     **/
    public TradeContent Total_Pay_Card(BigDecimal pay, BigDecimal point, BigDecimal balance_Old, BigDecimal balance_new, String id, String id_p1, String id_p2) {
        pay_Card = pay;
        pay_VIP_Point = point;
        pay_VIP_Balance_Old = balance_Old;
        pay_VIP_Balance_New = balance_new;
        pay_VIP_ID = id;
        pay_VIP_ID_Plus1 = id_p1;
        pay_VIP_ID_Plus2 = id_p2;
        return this;
    }

    /**
     * @description: 其他支付1
     **/
    public TradeContent Total_Pay_Other1(BigDecimal pay) {
        pay_Other1 = pay;
        return this;
    }

    /**
     * @description: 其他支付2
     **/
    public TradeContent Total_Pay_Other2(BigDecimal pay) {
        pay_Other2 = pay;
        return this;
    }

    /**
     * @description: 其他支付3
     **/
    public TradeContent Total_Pay_Other3(BigDecimal pay) {
        pay_Other3 = pay;
        return this;
    }

    /**
     * @description: 聚合云支付
     **/
    public TradeContent Total_Pay_Cloud(BigDecimal pay, Integer payWay, Integer payType, String typeName, String billID) {
        this.pay_Cloud = pay;
        this.pay_Cloud_Way = payWay;
        this.pay_Cloud_Type = payType;
        this.pay_Cloud_TypeName = typeName;
        this.pay_Cloud_Bill = billID;
        return this;
    }

    private void Total_InfoCheck_O() {
        if (total_ServiceFee_Type == 0) {
            if (GlobalPara.getInstance().getTMS(Service_Fee_Total_Input) >= 4) {
                total_ServiceFee_Type = GlobalPara.getInstance().getTMS(Service_Fee_Total_Input) - 3;
                total_ServiceFee_Rate = new BigDecimal(GlobalPara.getInstance().getTMS(Service_Fee_Total_Number)).divide(new BigDecimal(10000));
            }
        }

        // tCount
        // tWeight
        // tUnitWeight
        // purTax_FromPLU
        // purTax_Addup
        // tax_Addup
        tCount = BigDecimal.ZERO;
        tWeight = BigDecimal.ZERO.setScale(GlobalPara.getInstance().getPointOfWeight());
        purTax_Addup = tax_Addup = purTax_FromPLU = BigDecimal.ZERO;
        tUnitWeight = 0;

        if (total_ServiceFee_Type == 1)
            purTax_ServiceFee = total_ServiceFee_Rate;
        else
            purTax_ServiceFee = BigDecimal.ZERO;

        for (ItemContent itemContent : item) {
            if (GlobalPara.getInstance().EcsCal_Unit_isWeight((itemContent.getUnit_weight()))) {
                if (tUnitWeight == 0) {
                    tWeight = itemContent.getAmount();
                    tUnitWeight = itemContent.getUnit_weight();
                    if ((tUnitWeight < 2) || (tUnitWeight > 9))
                        tUnitWeight = GlobalPara.getInstance().getWeightUNIT();
                } else {
                    tWeight = GlobalPara.getInstance().EcsCal_Unit_WeightConvertTo(itemContent.getAmount(), itemContent.getUnit_weight(), tUnitWeight).add(tWeight);
                }
                tCount = tCount.add(BigDecimal.ONE);
            } else {
                tCount = tCount.add(itemContent.getAmount());
            }
            purTax_ServiceFee = purTax_ServiceFee.add(itemContent.getServiceFee());
            tax_Addup = tax_Addup.add(itemContent.getTax());
            purTax_Addup = purTax_Addup.add(itemContent.getSingleWtax());
            if (itemContent.getSingleWtax_Original().compareTo(BigDecimal.ZERO) == 0)
                purTax_FromPLU = purTax_FromPLU.add(itemContent.getSingleWtax());
            else
                purTax_FromPLU = purTax_FromPLU.add(itemContent.getSingleWtax_Original());

            if (total_ServiceFee_Type == 2) {
                if ((itemContent.getServiceFee().compareTo(BigDecimal.ZERO) == 0) || (GlobalPara.getInstance().getTMS(Service_Fee_Item_Input) == 2)) {
                    BigDecimal perbase;
                    if (GlobalPara.getInstance().getTMS(Service_Fee_PerBase) == 0)
                        perbase = itemContent.getSingleNtax();
                    else
                        perbase = itemContent.getSingleWtax();

                    purTax_ServiceFee = purTax_ServiceFee.add(GlobalPara.getInstance().EcsCal_Rounding_Single(perbase.multiply(total_ServiceFee_Rate)));
                }

            }
        }

        if (unit_Weight == 0)
            unit_Weight = tUnitWeight;

        BigDecimal serviceFeeRate_TaxRate = new BigDecimal(GlobalPara.getInstance().getTMS(Service_Fee_Tax_Rate)).divide(new BigDecimal(10000));
        if (GlobalPara.getInstance().getTMS(Service_Fee_Tax_Sort) == 1) {
            tax_ServiceFee = purTax_ServiceFee.multiply(serviceFeeRate_TaxRate);
            purTax_ServiceFee = purTax_ServiceFee.add(tax_ServiceFee);
        } else if (GlobalPara.getInstance().getTMS(Service_Fee_Tax_Sort) == 2) {
            tax_ServiceFee = purTax_ServiceFee.multiply(serviceFeeRate_TaxRate).divide(serviceFeeRate_TaxRate.add(BigDecimal.ONE), 7, BigDecimal.ROUND_HALF_UP);
        } else if (GlobalPara.getInstance().getTMS(Service_Fee_Tax_Sort) == 3) {
            tax_ServiceFee = purTax_ServiceFee.multiply(serviceFeeRate_TaxRate);
        } else
            tax_ServiceFee = BigDecimal.ZERO;
    }

    /**
     * @description: 手动改价金额
     **/
    public TradeContent Total_Set_Discount(BigDecimal total) {
        // 手动改价计算折舍金额
        purTax_Discounted = total;
        Total_InfoCheck_E();
        return this;
    }

    /**
     * @description: 手动折扣 获取折扣后价格
     **/
    public BigDecimal Total_Set_Discount(int discount) {
        // 手动改价计算折舍金额
        return GlobalPara.getInstance().EcsCal_Rounding_Total(purTax_Final.multiply(BigDecimal.valueOf(discount)).divide(BigDecimal.valueOf(10000)));
    }

    public BigDecimal Total_Get_Discount_U0L1(int U0L1) {
        BigDecimal ct = BigDecimal.ZERO;
        for (ItemContent itemContent : item) {
            BigDecimal itemLimit = (U0L1 == 0) ? itemContent.getPrice_UpperLimit() : itemContent.getPrice_LowerLimit();
            if (itemLimit.compareTo(BigDecimal.ZERO) == 0)
                return BigDecimal.ZERO;

            BigDecimal purTax = GlobalPara.getInstance()
                    .EcsCal_Unit_ValueConvert(
                            itemLimit.multiply(itemContent.getAmount()),
                            itemContent.getUnit_weight(), itemContent.getUnit_price()
                    );
            if (itemContent.getTaxType() == 1) {
                BigDecimal tax = purTax.multiply(itemContent.getTaxRate());
                purTax = purTax.add(tax);
            }
            ct = ct.add(purTax);
        }
        return ct;
    }

    public boolean Total_Check_Discount() {
        if (item.size() == 0) {
            return false;
        } else if ((GlobalPara.getInstance().getTMS(Discount_Manual_Disable) & 0x02) != 0) {
            return false;
        } else {
            return true;
        }
    }

    public boolean Total_Check_Discount(BigDecimal total) {
        if (Total_Check_Discount() == false)
            return false;

        BigDecimal limit;
        limit = Total_Get_Discount_U0L1(0);
        if ((limit.compareTo(BigDecimal.ZERO) != 0) && (total.compareTo(limit) > 0))
            return false;
        limit = Total_Get_Discount_U0L1(1);
        if ((limit.compareTo(BigDecimal.ZERO) != 0) && (total.compareTo(limit) < 0))
            return false;
        return true;
    }

    private void Total_InfoCheck_E() {
        // BigDecimal payC;
        purTax_Final = GlobalPara.getInstance().EcsCal_Rounding_Total(purTax_Discounted);
        rounding = purTax_Final.subtract(purTax_Discounted);
    }

    /**
     * @description: 剩余支付金额
     **/
    public BigDecimal Total_Cal_LeftPay(BigDecimal pay_Available) {
        return purTax_Final.subtract(pay_Card).subtract(pay_Other1).subtract(pay_Other2).subtract(pay_Other3).subtract(pay_JKY_All).subtract(pay_Cloud).subtract(pay_Available);
    }

    public BigDecimal Total_Cal_LeftPay() {
        return Total_Cal_LeftPay(BigDecimal.ZERO);
    }

    /**
     * @description: 内容打印
     **/

    public boolean printCalculate_HasItem(int[][] items, int start) {
        for (; start < items.length; start++) {
            if (items[start][1] == 5)
                break;
            if ((items[start][1] == 1) && (items[start][2] == 0))
                return true;
        }
        return false;
    }

    /**
     * @description: 打印内容组装
     **/
    public TradeContent printCalculate(int tms, Integer val) {
        if (this.printContents == null) this.printContents = new ArrayList<>();
        this.printContents.clear();// 重置空间
        PrintContent printContent1 = printCalculate_BillType(1, tms, val);
        // printContent1.setPcs(2);
        if (printContent1.exist()) this.printContents.add(printContent1);
        PrintContent printContent2 = printCalculate_BillType(2, tms, val);
        // printContent2.setHex(printContent1.getHex());
        // printContent2.setPcs(2);
        if (printContent2.exist()) this.printContents.add(printContent2);
        return this;
    }

    /**
     * @description: 打印内容
     * @date: 2024-10-22 10:44:16
     **/
    public TradeContent printCalculate() {
        return printCalculate(Fuc_Print, null);
    }

    /**
     * @description: 打印
     * @date: 2024-10-22 11:05:08
     **/
    public TradeContent print(IPrintBack printBack) throws MeterException {
        TradeContent tradeContent = this.printCalculate();
        PrintGeneralFactory.getInstance().print_answer(tradeContent.getPrintContents(), printBack);
        return tradeContent;
    }

    /**
     * @description: 重复打印内容
     * @date: 2024-10-22 10:44:23
     **/
    public TradeContent rePrintCalculate() {
        return printCalculate(Fuc_Reprint, null);
    }

    /**
     * @description: 打印
     * @date: 2024-10-22 11:05:08
     **/
    public TradeContent rePrintCalculate(IPrintBack printBack) throws MeterException {
        TradeContent tradeContent = this.rePrintCalculate();
        PrintGeneralFactory.getInstance().print_answer(tradeContent.getPrintContents(), printBack);
        return tradeContent;
    }

    /**
     * @description: 打印格式
     **/

    private int printCalculate_getOffset_X(int width, int height, int dir) {
        if (dir == 0)
            return width;
        else if (dir == 1)
            return -height;
        else if (dir == 2)
            return -width;
        else if (dir == 3)
            return height;
        return 0;
    }

    private int printCalculate_getOffset_Y(int width, int height, int dir) {
        if (dir == 0)
            return height;
        else if (dir == 1)
            return width;
        else if (dir == 2)
            return -height;
        else if (dir == 3)
            return -width;
        return 0;
    }

    public static String printCalculate_MapInfo(int angle, int addition, int grid, int font, int sx, int sy, int lx, int ly) {
        return printCalculate_getX2(angle)
                + printCalculate_getX2(addition)
                + printCalculate_getX2(grid)
                + printCalculate_getX2(font)
                + printCalculate_getX4(sx)
                + printCalculate_getX4(sy)
                + printCalculate_getX4(lx)
                + printCalculate_getX4(ly);
    }

    private PrintContent printCalculate_BillType(int billType, int tms, Integer val) {            //1 or 2
        int label;
        int barcode;
        int barcode_Flag;
        int pcs = 0;
        int reverse;
        int width = 48;
        String result = "";
        int version = 0;

        if (GlobalPara.getInstance().getTMS(HW_PrinterDisable) == 1)
            return new PrintContent("", 48, 0);

        int puse = GlobalPara.getInstance().getTMS(Print_Item_UseBL) % 10;
        boolean isSingle = (item.size() == 1);

        if (billType != 2) billType = 1;

        if (Objects.nonNull(val)) {
            // todo 外部直接打印
            int fucPrint = val;
            if (fucPrint == 1) {
                pcs = (billType == 1) ? 1 : 0;
            } else if (fucPrint == 2) {
                pcs = (billType == 2) ? 1 : 0;
            } else if (fucPrint == 4) {
                pcs = 0;
            } else if (fucPrint == 5) {
                if (GlobalPara.getInstance().getTMS(Print_GapPaper) != 0) {
                    pcs = (billType == 1) ? 1 : 0;
                } else {
                    pcs = (billType == 2) ? 1 : 0;
                }
            } else if (fucPrint == 6) {
                if (GlobalPara.getInstance().getTMS(Print_GapPaper) != 0) {
                    pcs = (billType == 2) ? 1 : 0;
                } else {
                    pcs = (billType == 1) ? 1 : 0;
                }
            } else {
                if ((fucPrint == 7) || (fucPrint == 8))
                    isSingle = false;

                if (isSingle) {
                    if (billType == 1)
                        pcs = GlobalPara.getInstance().getTMS(Print_Item1_Labelpcs);
                    else
                        pcs = GlobalPara.getInstance().getTMS(Print_Item2_Labelpcs);
                } else {
                    if (billType == 1)
                        pcs = GlobalPara.getInstance().getTMS(Print_Sum1_Labelpcs);
                    else
                        pcs = GlobalPara.getInstance().getTMS(Print_Sum2_Labelpcs);
                }
            }
        } else if (tms == Fuc_Print) {
            int fucPrint = GlobalPara.getInstance().getTMS(tms);
            if (fucPrint == 1) {
                pcs = (billType == 1) ? 1 : 0;
            } else if (fucPrint == 2) {
                pcs = (billType == 2) ? 1 : 0;
            } else if (fucPrint == 4) {
                pcs = 0;
            } else if (fucPrint == 5) {
                if (GlobalPara.getInstance().getTMS(Print_GapPaper) != 0) {
                    pcs = (billType == 1) ? 1 : 0;
                } else {
                    pcs = (billType == 2) ? 1 : 0;
                }
            } else if (fucPrint == 6) {
                if (GlobalPara.getInstance().getTMS(Print_GapPaper) != 0) {
                    pcs = (billType == 2) ? 1 : 0;
                } else {
                    pcs = (billType == 1) ? 1 : 0;
                }
            } else {
                if ((fucPrint == 7) || (fucPrint == 8))
                    isSingle = false;

                if (isSingle) {
                    if (billType == 1)
                        pcs = GlobalPara.getInstance().getTMS(Print_Item1_Labelpcs);
                    else
                        pcs = GlobalPara.getInstance().getTMS(Print_Item2_Labelpcs);
                } else {
                    if (billType == 1)
                        pcs = GlobalPara.getInstance().getTMS(Print_Sum1_Labelpcs);
                    else
                        pcs = GlobalPara.getInstance().getTMS(Print_Sum2_Labelpcs);
                }
            }
        } else if (tms == Fuc_Reprint) {
            int fucPrint = GlobalPara.getInstance().getTMS(tms);
            if (fucPrint == 0) {
                pcs = 0;
            } else if (fucPrint == 1) {
                pcs = (billType == 1) ? 1 : 0;
            } else if (fucPrint == 2) {
                pcs = (billType == 2) ? 1 : 0;
            } /*else if (fucPrint == 4) {
                pcs = 0;
            }*/ else if (fucPrint == 5) {
                if (GlobalPara.getInstance().getTMS(Print_GapPaper) != 0) {
                    pcs = (billType == 1) ? 1 : 0;
                } else {
                    pcs = (billType == 2) ? 1 : 0;
                }
            } else if (fucPrint == 6) {
                if (GlobalPara.getInstance().getTMS(Print_GapPaper) != 0) {
                    pcs = (billType == 2) ? 1 : 0;
                } else {
                    pcs = (billType == 1) ? 1 : 0;
                }
            } else {
                if ((fucPrint == 7))
                    isSingle = false;

                if (isSingle) {
                    if (billType == 1)
                        pcs = GlobalPara.getInstance().getTMS(Print_Item1_Labelpcs);
                    else
                        pcs = GlobalPara.getInstance().getTMS(Print_Item2_Labelpcs);
                } else {
                    if (billType == 1)
                        pcs = GlobalPara.getInstance().getTMS(Print_Sum1_Labelpcs);
                    else
                        pcs = GlobalPara.getInstance().getTMS(Print_Sum2_Labelpcs);
                }
            }
        }


        if (pcs == 0)
            return new PrintContent("", 48, 0);

        if (isSingle) {
            if (billType == 1) {
                label = GlobalPara.getInstance().getTMS(Print_Item1_Label);
                barcode = GlobalPara.getInstance().getTMS(Print_Item1_Barcode);
                barcode_Flag = GlobalPara.getInstance().getTMS(Print_Item1_Barcode_Flag);
                reverse = GlobalPara.getInstance().getTMS(Print_Item1_LabelReverse);
            } else {
                label = GlobalPara.getInstance().getTMS(Print_Item2_Label);
                barcode = GlobalPara.getInstance().getTMS(Print_Item2_Barcode);
                barcode_Flag = GlobalPara.getInstance().getTMS(Print_Item2_Barcode_Flag);
                reverse = GlobalPara.getInstance().getTMS(Print_Item2_LabelReverse);
            }
            try {
                if (puse == 0) {
                    int tv;
                    if (billType == 1)
                        tv = item.get(0).getPlu().getPrint().getType1();
                    else
                        tv = item.get(0).getPlu().getPrint().getType2();
                    if (tv != 0)
                        label = tv;
                } else if (puse == 2) {
                    DCategory dCategory = GlobalPara.getInstance().GetCategory(item.get(0).getPlu().getCategory());
                    if (dCategory != null) {
                        int tv;
                        if (billType == 1)
                            tv = dCategory.getPrint().getType1();
                        else
                            tv = dCategory.getPrint().getType2();
                        if (tv != 0)
                            label = tv;
                    }
                }
            } catch (Exception exp) {
            }
        } else {
            if (billType == 1) {
                label = GlobalPara.getInstance().getTMS(Print_Sum1_Label);
                barcode = GlobalPara.getInstance().getTMS(Print_Sum1_Barcode);
                barcode_Flag = GlobalPara.getInstance().getTMS(Print_Sum1_Barcode_Flag);
                reverse = GlobalPara.getInstance().getTMS(Print_Sum1_LabelReverse);
            } else {
                label = GlobalPara.getInstance().getTMS(Print_Sum2_Label);
                barcode = GlobalPara.getInstance().getTMS(Print_Sum2_Barcode);
                barcode_Flag = GlobalPara.getInstance().getTMS(Print_Sum2_Barcode_Flag);
                reverse = GlobalPara.getInstance().getTMS(Print_Sum2_LabelReverse);
            }
        }

        if (label == 0)
            return new PrintContent("", 48, 0);

        try {
            String format = GlobalPara.getInstance().GetLabelFormat(label).getPf();
            String[] subs = format.split("\\|");
            String textInBase64 = new String(GlobalPara.getInstance().getEncryptDecrypt().decode(subs[1]));
            String[] texts = textInBase64.split("\t");

            String[] infos = subs[0].split(",");
            int sort = tryParseInt(infos[0]);
            version = tryParseInt(infos[1]);
            int labelwidth = tryParseInt(infos[2]);
            int labelwidthMM = labelwidth / 8;
            width = labelwidthMM;
            int labelheigth = tryParseInt(infos[3]);
            boolean can04 = false;
            int subY = 0;
            int itemsize = subs.length - 1;
            int[][] items = new int[itemsize][12];       //one more for FlagEnd
            for (int loop = 0; loop < itemsize - 1; loop++) {
                String[] itemParts = subs[loop + 2].split(",");
                if (itemParts.length >= 12) {
                    int pos;
                    if (reverse != 0)
                        pos = itemsize - 2 - loop;
                    else
                        pos = loop;
                    items[pos][0] = tryParseInt(itemParts[0]);
                    items[pos][1] = tryParseInt(itemParts[1]);
                    items[pos][2] = tryParseInt(itemParts[2]);
                    items[pos][3] = tryParseInt(itemParts[3]);
                    items[pos][4] = tryParseInt(itemParts[4]);
                    items[pos][5] = tryParseInt(itemParts[5]);
                    items[pos][6] = tryParseInt(itemParts[6]);
                    items[pos][7] = tryParseInt(itemParts[7]);
                    items[pos][8] = tryParseInt(itemParts[8]);
                    items[pos][9] = tryParseInt(itemParts[9]);
                    items[pos][10] = tryParseInt(itemParts[10]);
                    items[pos][11] = tryParseInt(itemParts[11]);
                    if (reverse != 0) {
                        items[pos][8] = labelwidth - 1 - items[pos][8];
                        items[pos][9] = labelheigth - 1 - items[pos][9];
                        items[pos][5] ^= 0x02;
                        int gridPrint = items[pos][6];
                        if (gridPrint == 0x40)
                            gridPrint = 0x80;
                        else if (gridPrint == 0x80)
                            gridPrint = 0x40;
                        items[pos][6] = (items[pos][6] & 0x3f) | gridPrint;
                    }
                } else
                    new PrintContent("", 48, 0);
            }
//0:Number
//1:Flag0
//2:Flag1
//3:Flag2
//4:Print
//5:Angle
//6:Grid
//7:CFont
//8:X
//9:Y
//10:Width
//11:Height
            items[itemsize - 1][0] = 100;
            items[itemsize - 1][1] = 5;
            items[itemsize - 1][2] = 1;
            items[itemsize - 1][3] = 0;
            items[itemsize - 1][4] = 1;
            items[itemsize - 1][5] = 0;
            items[itemsize - 1][6] = 0;
            items[itemsize - 1][7] = 0;
            items[itemsize - 1][8] = 0;
            items[itemsize - 1][9] = labelheigth;
            items[itemsize - 1][10] = 0;
            items[itemsize - 1][11] = 0;

            result = "03" + printCalculate_getX2(labelwidthMM);

            int ctPos = 0;
            int x_Init;
            int cyclePos = -1;

            if (printCalculate_HasItem(items, 0))
                x_Init = 1;
            else
                x_Init = 0;

            boolean[] condition = printCalculate_GetCondition(0);
            for (; ; ctPos++) {
                if (ctPos >= itemsize) {
                    result += "08"; //Do by added area flag. No need here
                    break;
                }
                int[] itemValue = items[ctPos];
                if (itemValue[1] == 5)     //area
                {
                    if (can04) {
                        result += "04";
                        can04 = false;
                    }
                    if (itemValue[2] == 1) {
                        result += "06";
                    }
                    if (itemValue[3] > 0)
                        result += "05" + printCalculate_getX4(itemValue[3]);

                    subY = itemValue[9];

                    if ((itemValue[2] == 0) || (ctPos == itemsize - 1)) {
                        if (x_Init > 0) {
                            x_Init++;
                            if (x_Init <= this.item.size()) {
                                condition = printCalculate_GetCondition(x_Init - 1);
                                ctPos = cyclePos;
                                if (ctPos < 0)
                                    subY = 0;
                                else
                                    subY = items[ctPos][9];
                                continue;
                            }
                        }
                        if (printCalculate_HasItem(items, ctPos + 1))
                            x_Init = 1;
                        else
                            x_Init = 0;
                        cyclePos = ctPos;
                        condition = printCalculate_GetCondition(0);
                    }
                } else {
                    int pos1 = itemValue[9];
                    int pos2 = itemValue[9] + printCalculate_getOffset_Y(itemValue[10], itemValue[11], itemValue[5]);

                    if ((itemValue[6] & 0x80) != 0) {
                        if (can04) {
                            result += "04";
                            can04 = false;
                        }
                        subY = Math.min(pos1, pos2);
                    }

                    if ((itemValue[4] < condition.length) && (condition[itemValue[4]])) {
                        int Addition = 0;
                        if (GlobalPara.getInstance().getTMS(Print_NewLineMode) > 0)
                            Addition = 0x20;
                        else if ((itemValue[6] & 0x20) != 0)
                            Addition = 0x20;

                        String mapInfo = printCalculate_MapInfo(itemValue[5], Addition, itemValue[6] & 0x0f, itemValue[7], itemValue[8], itemValue[9] - subY, itemValue[10], itemValue[11]);
                        // printCalculate_getX2(itemValue[5]) + printCalculate_getX2(Addition) + printCalculate_getX2(itemValue[6] & 0x0f) + printCalculate_getX2(itemValue[7]) + printCalculate_getX4(itemValue[8]) + printCalculate_getX4(itemValue[9] - subY) + printCalculate_getX4(itemValue[10]) + printCalculate_getX4(itemValue[11]);

                        String out = "";
                        if (itemValue[1] == 2)          //Sale Information
                        {
                            out = printCalculate_Sale(mapInfo, itemValue[2], itemValue[3]);
                        } else if (itemValue[1] == 1)          //Item Information
                        {
                            out = printCalculate_Item(mapInfo, itemValue[2], itemValue[3], (x_Init > 0) ? (x_Init - 1) : 0);     //input range: 0 to itemsize-1
                        } else if (itemValue[1] == 0)          //Barcode
                        {
                            int ctbar = itemValue[3];
                            if (ctbar == 0) {
                                if (x_Init > 0) {
                                    int buse = (GlobalPara.getInstance().getTMS(Print_Item_UseBL) / 10) % 10;
                                    if (buse == 1)
                                        ctbar = barcode;
                                    else if (buse == 2) {
                                        DCategory dCategory = GlobalPara.getInstance().GetCategory(item.get(x_Init - 1).getPlu().getCategory());
                                        if (dCategory != null) {
                                            if (billType == 1)
                                                ctbar = dCategory.getPrint().getBarcode1();
                                            else
                                                ctbar = dCategory.getPrint().getBarcode2();
                                        } else
                                            ctbar = barcode;
                                    } else {
                                        try {
                                            if (billType == 1)
                                                ctbar = item.get(x_Init - 1).getPlu().getPrint().getBarcode1();
                                            else
                                                ctbar = item.get(x_Init - 1).getPlu().getPrint().getBarcode2();
                                        } catch (Exception exp) {
                                            ctbar = 0;
                                        }
                                    }
                                    if (ctbar == 0)
                                        ctbar = barcode;
                                } else
                                    ctbar = barcode;
                            }

                            try {
                                DBarcodeFormat barFormat = GlobalPara.getInstance().GetBarcode(ctbar);
                                PrintCalculate_BarcodeCal bcc = new PrintCalculate_BarcodeCal();

                                int bformat = barFormat.getFormat();
                                int bcheck = barFormat.getCheck();
                                int[] exBytes = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
                                exBytes[0] = bformat;
                                if (bformat == 11) {
                                    if ((bcheck & 0x80) == 0) {
                                        exBytes[1] = 1;
                                    } else {
                                        exBytes[1] = ((bcheck >> 2) & 0x0f);
                                        exBytes[2] = ((bcheck >> 8) & 0x1f);
                                        exBytes[3] = ((bcheck >> 13) & 0x07);
                                    }
                                } else if (bformat == 8) {
                                    if ((bcheck & 0x80) == 0) {
                                        exBytes[1] = 9;
                                    } else {
                                        exBytes[1] = (byte) ((bcheck >> 2) & 0x0f);
                                        exBytes[2] = (byte) ((bcheck >> 8) & 0x1f);
                                        exBytes[3] = (byte) ((bcheck >> 16) & 0x7f);
                                        exBytes[4] = (byte) ((bcheck >> 24) & 0x07);
                                        exBytes[5] = (byte) ((bcheck >> 27) & 0x07);
                                    }
                                } else {
                                    if ((bcheck & 0x80) == 0) {
                                        ;
                                    } else {
                                        exBytes[1] = ((bcheck >> 2) & 0x1f);
                                        if (exBytes[1] == 0x1f)
                                            exBytes[1] = 0xff;
                                        exBytes[2] = ((bcheck >> 9) & 0x07);
                                        exBytes[3] = ((bcheck >> 12) & 0x0f);
                                        exBytes[4] = (bcheck & 0x03);
                                        exBytes[5] = ((bcheck >> 16) & 0x03);
                                        exBytes[6] = ((bcheck >> 18) & 0x1f);
                                        exBytes[7] = ((bcheck >> 23) & 0x1f);
                                    }
                                }
                                String barcodeType = printCalculate_getX2(exBytes[0]) + printCalculate_getX2(exBytes[1]) + printCalculate_getX2(exBytes[2]) + printCalculate_getX2(exBytes[3]) +
                                        printCalculate_getX2(exBytes[4]) + printCalculate_getX2(exBytes[5]) + printCalculate_getX2(exBytes[6]) + printCalculate_getX2(exBytes[7]);

                                out = printCalculate_DrawBarcode(mapInfo, barcodeType, bcc.GetContent(barFormat.getDis().getBytes(), barcode_Flag, x_Init, billType, this));
                            } catch (Exception exp) {
                                out = "";
                            }
                        } else if (itemValue[1] == 3)          //Const Text
                        {
                            String cttext = "";
                            if (itemValue[2] >= 0 && itemValue[2] < texts.length)
                                cttext = texts[itemValue[2]];
                            out = printCalculate_CommandText(mapInfo, cttext);
                        } else if (itemValue[1] == 4)          //Border
                        {
                            out = "0A" + mapInfo.substring(0, 2) + "00" + printCalculate_getX2(itemValue[2]) + mapInfo.substring(8);
                        } else if (itemValue[1] == 6)          //Bitmap
                        {
                            out = printCalculate_Bitmap(mapInfo, itemValue[2]);
                        } else if (itemValue[1] == 7)          //Special
                        {
                            Object ob = TradeSpecial.printCalculte_Special(this, itemValue, mapInfo, x_Init, subY, labelwidth);
                            if (ob != null) {
                                if (ob instanceof String) {
                                    out = (String) ob;
                                } else if (ob instanceof TradeSpOut) {
                                    out = ((TradeSpOut) ob).getOut();
                                    subY = ((TradeSpOut) ob).getSubY();
                                }
                            }
                            // out = "";
                            // try {
                            //     int itemNo = (x_Init > 0) ? x_Init : 1;     //input range: 1 to itemsize
                            //     String caled;
                            //     caled = this.customInfo.get('P' + Integer.toString(itemValue[2]) + '-' + Integer.toString(itemValue[3]) + '-' + Integer.toString(itemNo));
                            //     if (caled == null)
                            //         caled = this.customInfo.get('P' + Integer.toString(itemValue[2]) + '-' + Integer.toString(itemValue[3]));
                            //     if (caled != null) {
                            //         int barPos = caled.indexOf(':');
                            //         if ((barPos == 18) && (caled.startsWith("#B")))
                            //             out = printCalculate_DrawBarcode(mapInfo, caled.substring(2, 18), caled.substring(19).getBytes());
                            //         else
                            //             out = printCalculate_CommandText(mapInfo, caled);
                            //     }
                            // } catch (Exception e) {
                            //     out = "";
                            // }
                        } else if (itemValue[1] == 8)           //Pos Only Item
                        {
                            ItemContent itemC = this.item.get((itemValue[2] == 0) ? ((x_Init > 0) ? (x_Init - 1) : 0) : (itemValue[2] - 1));
                            String cttext = itemC.getPosOnlyString(itemValue[3]);
                            if ((cttext != null) && (cttext.length() > 0))
                                out = printCalculate_CommandText(mapInfo, cttext);
                        } else if (itemValue[1] == 9)           //Pos Only Sale
                        {
                            Integer value = itemValue[2];
                            String cttext = this.getPosOnlyString(value);
                            if ((cttext != null) && (cttext.length() > 0))
                                out = printCalculate_CommandText(mapInfo, cttext);
                        } else
                            out = "";

                        if (out.length() > 0) {
                            result += out;
                            can04 = true;
                        }
                    }

                    if ((itemValue[6] & 0x40) != 0) {
                        if (can04) {
                            result += "04";
                            can04 = false;
                        }
                        subY = Math.max(pos1, pos2);
                    }

                }
            }
        } catch (Exception exp) {
            // exp.printStackTrace();
            width = 48;
            result = "";
            pcs = 0;
        }
        return new PrintContent(result, width, pcs);
        // if (billType == 1) {
        //     result1_Hex = result;
        //     result1_pcs = pcs;
        //     result1_Width = width;
        // } else {
        //     result2_Hex = result;
        //     result2_pcs = pcs;
        //     result2_Width = width;
        // }
    }

    private boolean[] printCalculate_GetCondition(int itemPos) {
        ItemContent itemC = this.item.get(itemPos);

        boolean[] condition = new boolean[]       //37
                {
                        false, false, false, false, false, false, false, false, false, false,
                        false, false, false, false, false, false, false, false, false, false,
                        false, false, false, false, false, false, false, false, false, false,
                        false, false, false, false, false, false, false
                };
        //	PrintAppC_Con_None	0
        //condition[0]=false;
        //	PrintAppC_Con_Always	1
        condition[1] = true;

        if (this.tradeType <= 1)           //sale or buyBack
        {
            //	PrintAppC_Con_PayCard	15
            if (this.pay_Card.compareTo(BigDecimal.ZERO) != 0)
                condition[15] = true;
            //	PrintAppC_Con_PayCash	14
            if (this.pay_Cash.compareTo(BigDecimal.ZERO) != 0)
                condition[14] = true;
            //	PrintAppC_Con_PayOther_0	17
            if (this.pay_Other1.compareTo(BigDecimal.ZERO) != 0)
                condition[17] = true;
            //	PrintAppC_Con_PayOther_1	18
            if (this.pay_Other2.compareTo(BigDecimal.ZERO) != 0)
                condition[18] = true;
            //	PrintAppC_Con_PayOther_2	19
            if (this.pay_Other3.compareTo(BigDecimal.ZERO) != 0)
                condition[19] = true;
            //	PrintAppC_Con_PayCloud	32
            if (this.pay_Cloud.compareTo(BigDecimal.ZERO) != 0)
                condition[32] = true;
            //	PrintAppC_Con_PayJKY	35
            if (this.pay_JKY_All.compareTo(BigDecimal.ZERO) != 0)
                condition[35] = true;

            //	PrintAppC_Con_VIP	20
            //	PrintAppC_Con_VIP_None	29
            //	PrintAppC_Con_Card_Info	31
            //	PrintAppC_Con_PrePaidInfo	36
            if ((this.pay_VIP_ID != null) && (!this.pay_VIP_ID.isEmpty()))
                condition[31] = true;
            if (this.pay_VIP_Point.compareTo(BigDecimal.ZERO) != 0)
                condition[20] = true;
            else
                condition[29] = true;
            if ((this.pay_JKY_All.compareTo(BigDecimal.ZERO) != 0) || (this.pay_Card.compareTo(BigDecimal.ZERO) != 0))
                condition[36] = true;

            //	PrintAppC_Con_Discounted_Total	16
            if (this.purTax_Final.compareTo(this.purTax_Addup.add(this.purTax_ServiceFee)) != 0)
                condition[16] = true;
            //	PrintAppC_Con_Discounted_Single	34
            if (this.purTax_Addup.compareTo(this.purTax_FromPLU) != 0)
                condition[34] = true;
        }

        //	PrintAppC_Con_NormalPrint	21
        condition[21] = ((!this.isRePrint) && (!this.isPrePrint));
        //	PrintAppC_Con_RePrint	22
        condition[22] = this.isRePrint;
        //	PrintAppC_Con_TryPrint	23
        condition[23] = this.isPrePrint;

        //	PrintAppC_Con_Tax	13
        //	PrintAppC_Con_Tax_None	28
        if (itemC.getTaxRate().compareTo(BigDecimal.ZERO) == 0)
            condition[28] = true;
        else
            condition[13] = true;

        //	PrintAppC_Con_Weight	2
        //	PrintAppC_Con_Count	3
        //	PrintAppC_Con_Tare	5标志值
        //	PrintAppC_Con_Not1pcs	10
        //	PrintAppC_Con_Only1pcs	24
        //	PrintAppC_Con_Tare_None	26
        //	PrintAppC_Con_Tare_isTP	30
        //	PrintAppC_Con_Tare_NoTP	33
        if (GlobalPara.getInstance().EcsCal_Unit_isWeight(itemC.getUnit_weight())) {
            condition[2] = true;
            condition[10] = true;
            if (itemC.getTare().compareTo(BigDecimal.ZERO) > 0) {
                condition[5] = true;
                if ((itemC.getTare().compareTo(itemC.getPreTare()) != 0) && (itemC.getPreTare().compareTo(itemC.getTare()) == 0))
                    condition[33] = true;
                else
                    condition[30] = true;
            } else
                condition[26] = true;
        } else {
            condition[3] = true;
            condition[26] = true;
            if (itemC.getAmount().compareTo(BigDecimal.ONE) == 0)
                condition[24] = true;
            else
                condition[10] = true;
        }

        //	PrintAppC_Con_Free	6
        //	PrintAppC_Con_Free_None	27
        if (itemC.getPrice().compareTo(BigDecimal.ZERO) == 0)
            condition[6] = true;
        else
            condition[27] = true;

        //	PrintAppC_Con_Temp	4
        //	PrintAppC_Con_Temp_None	25
        if ((itemC.getPlu().getNo() == 9999999) || (itemC.getPlu().getNo() == 9999998))
            condition[4] = true;
        else
            condition[25] = true;

        //	PrintAppC_Con_SaleData	7
        // if (itemC.getPlu().time(GlobalPara.getInstance().getDeviceLevel()).saleDatePS() != 0)
        //     condition[7] = true;
        // //	PrintAppC_Con_PackData	8
        // if (itemC.getPlu().time(GlobalPara.getInstance().getDeviceLevel()).packDatePS() != 0)
        //     condition[8] = true;
        // //	PrintAppC_Con_UserData	9
        // if (itemC.getPlu().time(GlobalPara.getInstance().getDeviceLevel()).useDatePS() != 0)
        //     condition[9] = true;

        if (itemC.getPlu().time().saleDatePS() != 0)
            condition[7] = true;
        //	PrintAppC_Con_PackData	8
        if (itemC.getPlu().time().packDatePS() != 0)
            condition[8] = true;
        //	PrintAppC_Con_UserData	9
        if (itemC.getPlu().time().useDatePS() != 0)
            condition[9] = true;
        Integer sdt = GlobalPara.getInstance().getTMS(Arith_SpecShelfDay_Type) & 0x03;
        if (sdt == 3)
            condition[9] = false;
        else if (sdt != 0)
            condition[9] = true;

        //	PrintAppC_Con_Sfee_Item	11
        if (itemC.getServiceFee().compareTo(BigDecimal.ZERO) != 0)
            condition[11] = true;
        //	PrintAppC_Con_Sfee_Total	12
        if (this.purTax_ServiceFee.compareTo(BigDecimal.ZERO) != 0)
            condition[12] = true;

        return condition;
    }

    private String printCalculate_DrawFont_AddDeletedLine(String mapInfo) {
        if (mapInfo.length() != 24)
            return "";
        try {
            Integer addition = Integer.parseInt(mapInfo.substring(2, 4), 16);
            addition |= 0x40;
            String ka = Integer.toHexString(addition);
            return mapInfo.substring(0, 2) + ka + mapInfo.substring(4);
        } catch (Exception e) {
            return "";
        }
    }

    private String printCalculate_Item(String mapInfo, int Flag1, int Flag2, int itemPos) {
        try {
            ItemContent itemC = this.item.get((Flag1 == 0) ? itemPos : (Flag1 - 1));
            String result = "";
            if (Flag2 == 0)    //	PrintAppC_Flag2_Item_Name
            {//	0	)    //	PrintAppC_Flag2_Item_Name
                String name = itemC.getPlu().getName();
                if ((this.tradeType != TradeType.销售.getType()) && (this.tradeType != TradeType.自动模式.getType()))
                    name = this.tradeTypeName + ":" + name;
                return printCalculate_CommandText(mapInfo, name);
            }//	0	)    //	PrintAppC_Flag2_Item_Name
            else if (Flag2 == 1)    //	PrintAppC_Flag2_Item_Amount
            {//	1	)    //	PrintAppC_Flag2_Item_Amount
                result = GlobalPara.getInstance().GetStringTMS(itemC.getAmount());
                if (GlobalPara.getInstance().getTMS(Display_PrintUnit_Amount) != 0)
                    result += GlobalPara.getInstance().EcsCal_Unit_LoadName(itemC.getUnit_weight(), itemC.getUnitName());
                return printCalculate_CommandText(mapInfo, result);
            }//	1	)    //	PrintAppC_Flag2_Item_Amount
            else if (Flag2 == 2)    //	PrintAppC_Flag2_Item_Tare
            {//	2	)    //	PrintAppC_Flag2_Item_Tare
                if (GlobalPara.getInstance().EcsCal_Unit_isWeight(itemC.getUnit_weight())) {
                    result = GlobalPara.getInstance().GetStringTMS(itemC.getTare());
                    if (GlobalPara.getInstance().getTMS(Display_PrintUnit_Amount) != 0)
                        result += GlobalPara.getInstance().EcsCal_Unit_LoadName(itemC.getUnit_weight(), itemC.getUnitName());
                    return printCalculate_CommandText(mapInfo, result);
                }
            }//	2	)    //	PrintAppC_Flag2_Item_Tare
            else if (Flag2 == 3)    //	PrintAppC_Flag2_Item_UPrice_Ori
            {//	3	)    //	PrintAppC_Flag2_Item_UPrice_Ori
                if ((itemC.getPrice_Original().compareTo(new BigDecimal(0)) > 0) && (itemC.getPrice_Original().compareTo(itemC.getPrice()) != 0)) {
                    if (GlobalPara.getInstance().getTMS(Display_PrintUnit_UPrice) != 0)
                        result = GlobalPara.getInstance().getMoneyPrefix();
                    result += GlobalPara.getInstance().GetStringTMS(itemC.getPrice_Original());
                    if (GlobalPara.getInstance().getTMS(Display_PrintUnit_UPrice) != 0)
                        result += GlobalPara.getInstance().getMoneySuffix() + "/" + GlobalPara.getInstance().EcsCal_Unit_LoadName(itemC.getUnit_price(), itemC.getUnitName());
                    return printCalculate_CommandText(mapInfo, result);
                }
            }//	3	)    //	PrintAppC_Flag2_Item_UPrice_Ori
            else if (Flag2 == 4)    //	PrintAppC_Flag2_Item_UPrice_Pre
            {//	4	)    //	PrintAppC_Flag2_Item_UPrice_Pre
                if (GlobalPara.getInstance().getTMS(Display_PrintUnit_UPrice) != 0)
                    result = GlobalPara.getInstance().getMoneyPrefix();
                result += GlobalPara.getInstance().GetStringTMS(itemC.getPrice());
                if (GlobalPara.getInstance().getTMS(Display_PrintUnit_UPrice) != 0)
                    result += GlobalPara.getInstance().getMoneySuffix() + "/" + GlobalPara.getInstance().EcsCal_Unit_LoadName(itemC.getUnit_price(), itemC.getUnitName());
                return printCalculate_CommandText(mapInfo, result);
            }//	4	)    //	PrintAppC_Flag2_Item_UPrice_Pre
            else if (Flag2 == 5)    //	PrintAppC_Flag2_Item_PurTax
            {//	5	)    //	PrintAppC_Flag2_Item_PurTax
                if (GlobalPara.getInstance().getTMS(Display_PrintUnit_Money) != 0)
                    result = GlobalPara.getInstance().getMoneyPrefix();
                result += GlobalPara.getInstance().GetStringTMS(itemC.getSingleWtax());
                if (GlobalPara.getInstance().getTMS(Display_PrintUnit_Money) != 0)
                    result += GlobalPara.getInstance().getMoneySuffix();
                return printCalculate_CommandText(mapInfo, result);
            }//	5	)    //	PrintAppC_Flag2_Item_PurTax
            else if (Flag2 == 6)    //	PrintAppC_Flag2_Item_PLU
            {//	6	)    //	PrintAppC_Flag2_Item_PLU
                return printCalculate_CommandText(mapInfo, Integer.toString(itemC.getPlu().getNo()));
            }//	6	)    //	PrintAppC_Flag2_Item_PLU
            else if (Flag2 == 7)    //	PrintAppC_Flag2_Item_Class
            {//	7	)    //	PrintAppC_Flag2_Item_Class
                return printCalculate_CommandText(mapInfo, Integer.toString(itemC.getPlu().getCategory()));
            }//	7	)    //	PrintAppC_Flag2_Item_Class
            else if (Flag2 == 8)    //	PrintAppC_Flag2_Item_Dept
            {//	8	)    //	PrintAppC_Flag2_Item_Dept
                // todo 部门编号 return printCalculate_CommandText(mapInfo, Integer.toString(itemC.getPlu().getDeptNo()));
                return printCalculate_CommandText(mapInfo, Integer.toString(itemC.getPlu().getCategory()));
            }//	8	)    //	PrintAppC_Flag2_Item_Dept
            else if (Flag2 == 9)    //	PrintAppC_Flag2_Item_Index
            {//	9	)    //	PrintAppC_Flag2_Item_Index
                return printCalculate_CommandText(mapInfo, itemC.getPlu().getIndexBar());
            }//	9	)    //	PrintAppC_Flag2_Item_Index
            else if (Flag2 == 10)    //	PrintAppC_Flag2_Item_Note
            {//	10	)    //	PrintAppC_Flag2_Item_Note
                return printCalculate_CommandText(mapInfo, Integer.toString(itemC.getPlu().getItemCode()));
            }//	10	)    //	PrintAppC_Flag2_Item_Note
            else if (Flag2 == 11)    //	PrintAppC_Flag2_Item_SaleData
            {//	11	)    //	PrintAppC_Flag2_Item_SaleData
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(this.tradeTime);
                // DTimeV2 dTime = itemC.getPlu().time(GlobalPara.getInstance().getDeviceLevel());
                DTimeV2 dTime = itemC.getPlu().time();
                if (dTime.saleDatePS() != 3) {
                    calendar.add(calendar.DATE, (dTime.saleDatePS() == 2) ? -dTime.saleDatePC() : dTime.saleDatePC());
                } else {
                    Integer minute = dTime.saleDatePC() * 24 * 60 + dTime.saleTimePC() / 100 * 60 + dTime.saleTimePC() % 100;
                    calendar.add(calendar.MINUTE, (dTime.saleDatePS() == 2) ? -minute : minute);
                }
                return printCalculate_CommandText(mapInfo, GlobalPara.getInstance().EcsCal_PrintDate(calendar));
            }//	11	)    //	PrintAppC_Flag2_Item_SaleData
            else if (Flag2 == 12)    //	PrintAppC_Flag2_Item_SaleTime
            {//	12	)    //	PrintAppC_Flag2_Item_SaleTime
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(this.tradeTime);
                // DTimeV2 dTime = itemC.getPlu().time(GlobalPara.getInstance().getDeviceLevel());
                DTimeV2 dTime = itemC.getPlu().time();
                if (dTime.saleTimePS() == 1)
                    calendar.set(calendar.get(Calendar.YEAR), calendar.get(Calendar.MONTH), calendar.get(Calendar.DAY_OF_MONTH), dTime.saleTimePC() / 100 % 24, dTime.saleTimePC() % 100 % 60);
                else if (dTime.saleTimePS() == 2)
                    ;
                else if (dTime.saleTimePS() == 3) {
                    Integer minute = dTime.saleDatePC() * 24 * 60 + dTime.saleTimePC() / 100 * 60 + dTime.saleTimePC() % 100;
                    calendar.add(calendar.MINUTE, (dTime.saleDatePS() == 2) ? -minute : minute);
                } else
                    return "";
                return printCalculate_CommandText(mapInfo, GlobalPara.getInstance().EcsCal_PrintTime(calendar));
            }//	12	)    //	PrintAppC_Flag2_Item_SaleTime
            else if (Flag2 == 13)    //	PrintAppC_Flag2_Item_PackData
            {//	13	)    //	PrintAppC_Flag2_Item_PackData
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(this.tradeTime);
                // DTimeV2 dTime = itemC.getPlu().time(GlobalPara.getInstance().getDeviceLevel());
                DTimeV2 dTime = itemC.getPlu().time();
                if (dTime.packTimePS() != 3) {
                    calendar.add(calendar.DATE, (dTime.packDatePS() == 2) ? -dTime.packDatePC() : dTime.packDatePC());
                } else {
                    Integer minute = dTime.packDatePC() * 24 * 60 + dTime.packTimePC() / 100 * 60 + dTime.packTimePC() % 100;
                    calendar.add(calendar.MINUTE, (dTime.packDatePS() == 2) ? -minute : minute);
                }
                return printCalculate_CommandText(mapInfo, GlobalPara.getInstance().EcsCal_PrintDate(calendar));
            }//	13	)    //	PrintAppC_Flag2_Item_PackData
            else if (Flag2 == 14)    //	PrintAppC_Flag2_Item_PackTime
            {//	14	)    //	PrintAppC_Flag2_Item_PackTime
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(this.tradeTime);
                // DTimeV2 dTime = itemC.getPlu().time(GlobalPara.getInstance().getDeviceLevel());
                DTimeV2 dTime = itemC.getPlu().time();
                if (dTime.packTimePS() == 1)
                    calendar.set(calendar.get(Calendar.YEAR), calendar.get(Calendar.MONTH), calendar.get(Calendar.DAY_OF_MONTH), dTime.packTimePC() / 100 % 24, dTime.packTimePC() % 100 % 60);
                else if (dTime.packTimePS() == 2)
                    ;
                else if (dTime.packTimePS() == 3) {
                    Integer minute = dTime.packDatePC() * 24 * 60 + dTime.packTimePC() / 100 * 60 + dTime.packTimePC() % 100;
                    calendar.add(calendar.MINUTE, (dTime.packDatePS() == 2) ? -minute : minute);
                } else
                    return "";
                return printCalculate_CommandText(mapInfo, GlobalPara.getInstance().EcsCal_PrintTime(calendar));
            }//	14	)    //	PrintAppC_Flag2_Item_PackTime
            else if (Flag2 == 15)    //	PrintAppC_Flag2_Item_UserData
            {//	15	)    //	PrintAppC_Flag2_Item_UserData
                CalPLU_ShelfDate shelfdate = new CalPLU_ShelfDate(itemC, this.tradeTime);
                if (!shelfdate.isPrintable())
                    return "";
                else if (shelfdate.isByHour()) {
                    if (shelfdate.getInType() >= 4)
                        return printCalculate_CommandText(mapInfo, shelfdate.getDirectValue().toString() + GlobalPara.getInstance().getLang("Hours"));
                    else {
                        Calendar calendar = shelfdate.getCalendar();
                        return printCalculate_CommandText(mapInfo, GlobalPara.getInstance().EcsCal_PrintDate(calendar) + "\n " + GlobalPara.getInstance().EcsCal_PrintTime(calendar) + " ");
                    }
                } else {
                    if (shelfdate.getInType() >= 4)
                        return printCalculate_CommandText(mapInfo, shelfdate.getDirectValue().toString() + GlobalPara.getInstance().getLang("Days"));
                    else {
                        return printCalculate_CommandText(mapInfo, GlobalPara.getInstance().EcsCal_PrintDate(shelfdate.getCalendar()));
                    }
                }
            }//	15	)    //	PrintAppC_Flag2_Item_UserData
            else if (Flag2 == 16)    //	PrintAppC_Flag2_Item_Txt1
            {//	16	)    //	PrintAppC_Flag2_Item_Txt1
                // return printCalculate_CommandText(mapInfo, itemC.getPlu().text(GlobalPara.getInstance().getDeviceLevel()).text(0));
                return printCalculate_CommandText(mapInfo, itemC.getPlu().getText().text(0));
            }//	16	)    //	PrintAppC_Flag2_Item_Txt1
            else if (Flag2 == 17)    //	PrintAppC_Flag2_Item_Txt2
            {//	17	)    //	PrintAppC_Flag2_Item_Txt2
                // return printCalculate_CommandText(mapInfo, itemC.getPlu().text(GlobalPara.getInstance().getDeviceLevel()).text(1));
                return printCalculate_CommandText(mapInfo, itemC.getPlu().getText().text(1));
            }//	17	)    //	PrintAppC_Flag2_Item_Txt2
            else if (Flag2 == 18)    //	PrintAppC_Flag2_Item_Txt3
            {//	18	)    //	PrintAppC_Flag2_Item_Txt3
                // return printCalculate_CommandText(mapInfo, itemC.getPlu().text(GlobalPara.getInstance().getDeviceLevel()).text(2));
                return printCalculate_CommandText(mapInfo, itemC.getPlu().getText().text(2));
            }//	18	)    //	PrintAppC_Flag2_Item_Txt3
            else if (Flag2 == 19)    //	PrintAppC_Flag2_Item_Txt4
            {//	19	)    //	PrintAppC_Flag2_Item_Txt4
                // return printCalculate_CommandText(mapInfo, itemC.getPlu().text(GlobalPara.getInstance().getDeviceLevel()).text(3));
                return printCalculate_CommandText(mapInfo, itemC.getPlu().getText().text(3));
            }//	19	)    //	PrintAppC_Flag2_Item_Txt4
            else if (Flag2 == 20)    //	PrintAppC_Flag2_Item_Txt5
            {//	20	)    //	PrintAppC_Flag2_Item_Txt5
                // return printCalculate_CommandText(mapInfo, itemC.getPlu().text(GlobalPara.getInstance().getDeviceLevel()).text(4));
                return printCalculate_CommandText(mapInfo, itemC.getPlu().getText().text(4));
            }//	20	)    //	PrintAppC_Flag2_Item_Txt5
            else if (Flag2 == 21)    //	PrintAppC_Flag2_Item_Txt6
            {//	21	)    //	PrintAppC_Flag2_Item_Txt6
                // return printCalculate_CommandText(mapInfo, itemC.getPlu().text(GlobalPara.getInstance().getDeviceLevel()).text(5));
                return printCalculate_CommandText(mapInfo, itemC.getPlu().getText().text(5));
            }//	21	)    //	PrintAppC_Flag2_Item_Txt6
            else if (Flag2 == 22)    //	PrintAppC_Flag2_Item_Txt7
            {//	22	)    //	PrintAppC_Flag2_Item_Txt7
                // return printCalculate_CommandText(mapInfo, itemC.getPlu().text(GlobalPara.getInstance().getDeviceLevel()).text(6));
                return printCalculate_CommandText(mapInfo, itemC.getPlu().getText().text(6));
            }//	22	)    //	PrintAppC_Flag2_Item_Txt7
            else if (Flag2 == 23)    //	PrintAppC_Flag2_Item_Gross
            {//	23	)    //	PrintAppC_Flag2_Item_Gross
                if (GlobalPara.getInstance().EcsCal_Unit_isWeight(itemC.getUnit_weight())) {
                    result = GlobalPara.getInstance().GetStringTMS(itemC.getAmount().add((itemC.getTare())));
                    if (GlobalPara.getInstance().getTMS(Display_PrintUnit_Amount) != 0)
                        result += GlobalPara.getInstance().EcsCal_Unit_LoadName(itemC.getUnit_weight(), itemC.getUnitName());
                    return printCalculate_CommandText(mapInfo, result);
                }
            }//	23	)    //	PrintAppC_Flag2_Item_Gross
            else if (Flag2 == 24)    //	PrintAppC_Flag2_Item_Unit_Amount
            {//	24	)    //	PrintAppC_Flag2_Item_Unit_Amount
                return printCalculate_CommandText(mapInfo, GlobalPara.getInstance().EcsCal_Unit_LoadName(itemC.getUnit_weight(), itemC.getUnitName()));
            }//	24	)    //	PrintAppC_Flag2_Item_Unit_Amount
            else if (Flag2 == 25)    //	PrintAppC_Flag2_Item_Unit_UPriceAmount
            {//	25	)    //	PrintAppC_Flag2_Item_Unit_UPriceAmount
                return printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getMoneyPrefix() + GlobalPara.getInstance().getMoneySuffix() + "/" + GlobalPara.getInstance().EcsCal_Unit_LoadName(itemC.getUnit_price(), itemC.getUnitName()));
            }//	25	)    //	PrintAppC_Flag2_Item_Unit_UPriceAmount
            else if (Flag2 == 26)    //	PrintAppC_Flag2_Item_PurNoTax
            {//	26	)    //	PrintAppC_Flag2_Item_PurNoTax
                if (GlobalPara.getInstance().getTMS(Display_PrintUnit_Money) != 0)
                    result = GlobalPara.getInstance().getMoneyPrefix();
                result += GlobalPara.getInstance().GetStringTMS(itemC.getSingleNtax());
                if (GlobalPara.getInstance().getTMS(Display_PrintUnit_Money) != 0)
                    result += GlobalPara.getInstance().getMoneySuffix();
                return printCalculate_CommandText(mapInfo, result);
            }//	26	)    //	PrintAppC_Flag2_Item_PurNoTax
            else if (Flag2 == 27)    //	PrintAppC_Flag2_Item_Tax
            {//	27	)    //	PrintAppC_Flag2_Item_Tax
                if (GlobalPara.getInstance().getTMS(Display_PrintUnit_Money) != 0)
                    result = GlobalPara.getInstance().getMoneyPrefix();
                result += GlobalPara.getInstance().GetStringTMS(itemC.getTax());
                if (GlobalPara.getInstance().getTMS(Display_PrintUnit_Money) != 0)
                    result += GlobalPara.getInstance().getMoneySuffix();
                return printCalculate_CommandText(mapInfo, result);
            }//	27	)    //	PrintAppC_Flag2_Item_Tax
            else if (Flag2 == 28)    //	PrintAppC_Flag2_Item_Sfee
            {//	28	)    //	PrintAppC_Flag2_Item_Sfee
                if (GlobalPara.getInstance().getTMS(Display_PrintUnit_Money) != 0)
                    result = GlobalPara.getInstance().getMoneyPrefix();
                result += GlobalPara.getInstance().GetStringTMS(itemC.getServiceFee());
                if (GlobalPara.getInstance().getTMS(Display_PrintUnit_Money) != 0)
                    result += GlobalPara.getInstance().getMoneySuffix();
                return printCalculate_CommandText(mapInfo, result);
            }//	28	)    //	PrintAppC_Flag2_Item_Sfee
            else if (Flag2 == 29)    //	PrintAppC_Flag2_Item_TaxRate
            {//	29	)    //	PrintAppC_Flag2_Item_TaxRate
                return printCalculate_CommandText(mapInfo, itemC.getTaxRate().movePointRight(2).toString() + "%");
            }//	29	)    //	PrintAppC_Flag2_Item_TaxRate
            else if (Flag2 == 30)    //	PrintAppC_Flag2_Item_No__Name
            {//	30	)    //	PrintAppC_Flag2_Item_No__Name
                return printCalculate_CommandText(mapInfo, Integer.toString(itemC.getPlu().getNo()) + ": " + itemC.getPlu().getName());
            }//	30	)    //	PrintAppC_Flag2_Item_No__Name
            else if (Flag2 == 31)    //	PrintAppC_Flag2_Item_UPrice_Discounted
            {//	31	)    //	PrintAppC_Flag2_Item_UPrice_Discounted
                if ((itemC.getPrice_Original().compareTo(BigDecimal.ZERO) != 0) && (itemC.getPrice_Original().compareTo(itemC.getPrice()) != 0)) {
                    if (GlobalPara.getInstance().getTMS(Display_PrintUnit_UPrice) != 0)
                        result = GlobalPara.getInstance().getMoneyPrefix();
                    result += GlobalPara.getInstance().GetStringTMS(itemC.getPrice_Original());
                    if (GlobalPara.getInstance().getTMS(Display_PrintUnit_UPrice) != 0)
                        result += GlobalPara.getInstance().getMoneySuffix() + "/" + GlobalPara.getInstance().EcsCal_Unit_LoadName(itemC.getUnit_price(), itemC.getUnitName());
                    mapInfo = printCalculate_DrawFont_AddDeletedLine(mapInfo);
                    return printCalculate_CommandText(mapInfo, result);
                }
            }//	31	)    //	PrintAppC_Flag2_Item_UPrice_Discounted
            else if (Flag2 == 32)    //	PrintAppC_Flag2_Item_WeightOfByCount
            {//	32	)    //	PrintAppC_Flag2_Item_WeightOfByCount
                if (GlobalPara.getInstance().EcsCal_Unit_isWeight(itemC.getUnit_Stock())) {
                    result = GlobalPara.getInstance().GetStringTMS(itemC.getAmount_Stock());
                    if (GlobalPara.getInstance().getTMS(Display_PrintUnit_Amount) != 0)
                        result += GlobalPara.getInstance().EcsCal_Unit_LoadName(itemC.getUnit_Stock(), "");
                    return printCalculate_CommandText(mapInfo, result);
                }
            }//	32	)    //	PrintAppC_Flag2_Item_WeightOfByCount
            else if (Flag2 == 33)    //	PrintAppC_Flag2_Item_Bitmap
            {//	33	)    //	PrintAppC_Flag2_Item_Bitmap
                // return printCalculate_Bitmap(mapInfo, itemC.getPlu().print(GlobalPara.getInstance().getDeviceLevel()).getBitmap());
                return printCalculate_Bitmap(mapInfo, itemC.getPlu().getPrint().getBitmap());
            }//	33	)    //	PrintAppC_Flag2_Item_Bitmap
            else if (Flag2 == 34)    //	PrintAppC_Flag2_Item_Tare_FromPackage
            {//	34	)    //	PrintAppC_Flag2_Item_Tare_FromPackage
                if (((itemC.getPlu().percentTare().compareTo(BigDecimal.ZERO)) > 0) && ((itemC.getPlu().percentTare().compareTo(BigDecimal.ONE)) < 0) && (itemC.getPercentedTare().compareTo(BigDecimal.ZERO) >= 0)) {
                    result = GlobalPara.getInstance().GetStringTMS(itemC.getTare());
                    if (GlobalPara.getInstance().getTMS(Display_PrintUnit_Amount) != 0)
                        result += GlobalPara.getInstance().EcsCal_Unit_LoadName(itemC.getPlu().getUnit(), "");
                    return printCalculate_CommandText(mapInfo, result);
                }
            }//	34	)    //	PrintAppC_Flag2_Item_Tare_FromPackage
            else if (Flag2 == 35)    //	PrintAppC_Flag2_Item_Tare_FromPercent
            {//	35	)    //	PrintAppC_Flag2_Item_Tare_FromPercent
                if (((itemC.getPlu().percentTare().compareTo(BigDecimal.ZERO)) > 0) && ((itemC.getPlu().percentTare().compareTo(BigDecimal.ONE)) < 0) && (itemC.getPercentedTare().compareTo(BigDecimal.ZERO) >= 0)) {
                    result = GlobalPara.getInstance().GetStringTMS(itemC.getPercentedTare());
                    if (GlobalPara.getInstance().getTMS(Display_PrintUnit_Amount) != 0)
                        result += GlobalPara.getInstance().EcsCal_Unit_LoadName(itemC.getPlu().getUnit(), "");
                    return printCalculate_CommandText(mapInfo, result);
                }
            }//	35	)    //	PrintAppC_Flag2_Item_Tare_FromPercent
            else if (Flag2 == 36)    //	PrintAppC_Flag2_Item_Tare_PercentNo
            {//	36	)    //	PrintAppC_Flag2_Item_Tare_PercentNo
                if (((itemC.getPlu().percentTare().compareTo(BigDecimal.ZERO)) > 0) && ((itemC.getPlu().percentTare().compareTo(BigDecimal.ONE)) < 0) && (itemC.getPercentedTare().compareTo(BigDecimal.ZERO) >= 0)) {
                    return printCalculate_CommandText(mapInfo, itemC.getPlu().percentTare().movePointRight(2).toString() + "%");
                }
            }//	36	)    //	PrintAppC_Flag2_Item_Tare_PercentNo
            else if ((Flag2 == 37)    //	PrintAppC_Flag2_Item_SPrice_Ori
                    || (Flag2 == 38))    //	PrintAppC_Flag2_Item_SPrice_Discounted
            {//	37	)    //	PrintAppC_Flag2_Item_SPrice_Ori
                if ((itemC.getPrice_Original().compareTo(BigDecimal.ZERO) != 0) && (itemC.getPrice_Original().compareTo(itemC.getPrice()) != 0)) {
                    if (GlobalPara.getInstance().getTMS(Display_PrintUnit_Money) != 0)
                        result = GlobalPara.getInstance().getMoneyPrefix();
                    result += GlobalPara.getInstance().GetStringTMS(itemC.getSingleWtax_Original());
                    if (GlobalPara.getInstance().getTMS(Display_PrintUnit_Money) != 0)
                        result += GlobalPara.getInstance().getMoneySuffix();
                    if (Flag2 == 38)
                        mapInfo = printCalculate_DrawFont_AddDeletedLine(mapInfo);
                    return printCalculate_CommandText(mapInfo, result);
                }
            }//	37	)    //	PrintAppC_Flag2_Item_SPrice_Ori
            else if (Flag2 == 39)    //	PrintAppC_Flag2_Item_SubID
            {//	39	)    //	PrintAppC_Flag2_Item_SubID
                return printCalculate_CommandText(mapInfo, Integer.toString(itemPos));
            }//	39	)    //	PrintAppC_Flag2_Item_SubID

            return "";
        } catch (Exception e) {
            return "";
        }
    }

    private String printCalculate_Sale_xID(Integer id, Integer lng) {
        if (id == 0)
            return "";
        lng = lng % 10;
        if (lng >= 0)
            return "#" + String.format("%0" + lng + "d", id);
        else
            return id.toString();
    }

    private String printCalculate_Sale(String mapInfo, int Flag1, int Flag2) {
        try {
            String result = "";
            if (Flag1 == 0)    //	PrintAppC_Flag1_Sale_StoreName
            {//	0	)    //	PrintAppC_Flag1_Sale_StoreName
                return printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getStoreName());
            }//	0	)    //	PrintAppC_Flag1_Sale_StoreName
            else if (Flag1 == 1)    //	PrintAppC_Flag1_Sale_MachineName
            {//	1	)    //	PrintAppC_Flag1_Sale_MachineName
                return printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getDeviceName());
            }//	1	)    //	PrintAppC_Flag1_Sale_MachineName
            else if (Flag1 == 2)    //	PrintAppC_Flag1_Sale_MachineNo
            {//	2	)    //	PrintAppC_Flag1_Sale_MachineNo
                return printCalculate_CommandText(mapInfo, "D" + Integer.toString(GlobalPara.getInstance().getDeviceNumber()));
            }//	2	)    //	PrintAppC_Flag1_Sale_MachineNo
            else if (Flag1 == 3)    //	PrintAppC_Flag1_Sale_PrintAppData
            {//	3	)    //	PrintAppC_Flag1_Sale_PrintAppData
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(this.tradeTime);
                return printCalculate_CommandText(mapInfo, GlobalPara.getInstance().EcsCal_PrintDate(calendar));
            }//	3	)    //	PrintAppC_Flag1_Sale_PrintAppData
            else if (Flag1 == 4)    //	PrintAppC_Flag1_Sale_PrintAppTime
            {//	4	)    //	PrintAppC_Flag1_Sale_PrintAppTime
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(this.tradeTime);
                return printCalculate_CommandText(mapInfo, GlobalPara.getInstance().EcsCal_PrintTime(calendar));
            }//	4	)    //	PrintAppC_Flag1_Sale_PrintAppTime
            else if (Flag1 == 5)    //	PrintAppC_Flag1_Sale_LogLng
            {//	5	)    //	PrintAppC_Flag1_Sale_LogLng
                Integer LogLng = this.item.size();
                return printCalculate_CommandText(mapInfo, LogLng.toString());
            }//	5	)    //	PrintAppC_Flag1_Sale_LogLng
            else if (Flag1 == 6)    //	PrintAppC_Flag1_Sale_Count
            {//	6	)    //	PrintAppC_Flag1_Sale_Count
                return printCalculate_CommandText(mapInfo, this.tCount.toString());
            }//	6	)    //	PrintAppC_Flag1_Sale_Count
            else if (Flag1 == 7)    //	PrintAppC_Flag1_Sale_Weight
            {//	7	)    //	PrintAppC_Flag1_Sale_Weight
                return printCalculate_CommandText(mapInfo, this.tWeight.toString());
            }//	7	)    //	PrintAppC_Flag1_Sale_Weight
            else if (Flag1 == 8)    //	PrintAppC_Flag1_Sale_T_PurTax
            {//	8	)    //	PrintAppC_Flag1_Sale_T_PurTax
                if (GlobalPara.getInstance().getTMS(Display_PrintUnit_Money) != 0)
                    result = GlobalPara.getInstance().getMoneyPrefix();
                result += GlobalPara.getInstance().GetStringTMS(this.purTax_Discounted);
                if (GlobalPara.getInstance().getTMS(Display_PrintUnit_Money) != 0)
                    result += GlobalPara.getInstance().getMoneySuffix();
                return printCalculate_CommandText(mapInfo, result);
            }//	8	)    //	PrintAppC_Flag1_Sale_T_PurTax
            else if (Flag1 == 9)    //	PrintAppC_Flag1_Sale_PayCash
            {//	9	)    //	PrintAppC_Flag1_Sale_PayCash
                if (!this.isPrePrint) {
                    if (GlobalPara.getInstance().getTMS(Display_PrintUnit_Money) != 0)
                        result = GlobalPara.getInstance().getMoneyPrefix();
                    result += GlobalPara.getInstance().GetStringTMS(this.pay_Cash);
                    if (GlobalPara.getInstance().getTMS(Display_PrintUnit_Money) != 0)
                        result += GlobalPara.getInstance().getMoneySuffix();
                    return printCalculate_CommandText(mapInfo, result);
                }
            }//	9	)    //	PrintAppC_Flag1_Sale_PayCash
            else if (Flag1 == 10)    //	PrintAppC_Flag1_Sale_Change
            {//	10	)    //	PrintAppC_Flag1_Sale_Change
                if (!this.isPrePrint) {
                    if (GlobalPara.getInstance().getTMS(Display_PrintUnit_Money) != 0)
                        result = GlobalPara.getInstance().getMoneyPrefix();
                    result += GlobalPara.getInstance().GetStringTMS(this.change);
                    if (GlobalPara.getInstance().getTMS(Display_PrintUnit_Money) != 0)
                        result += GlobalPara.getInstance().getMoneySuffix();
                    return printCalculate_CommandText(mapInfo, result);
                }
            }//	10	)    //	PrintAppC_Flag1_Sale_Change
            else if (Flag1 == 11)    //	PrintAppC_Flag1_Sale_Rounding
            {//	11	)    //	PrintAppC_Flag1_Sale_Rounding
                if (GlobalPara.getInstance().getTMS(Display_PrintUnit_Money) != 0)
                    result = GlobalPara.getInstance().getMoneyPrefix();
                result += GlobalPara.getInstance().GetStringTMS(this.rounding);
                if (GlobalPara.getInstance().getTMS(Display_PrintUnit_Money) != 0)
                    result += GlobalPara.getInstance().getMoneySuffix();
                return printCalculate_CommandText(mapInfo, result);
            }//	11	)    //	PrintAppC_Flag1_Sale_Rounding
            else if (Flag1 == 12)    //	PrintAppC_Flag1_Sale_Unit_Weight
            {//	12	)    //	PrintAppC_Flag1_Sale_Unit_Weight
                return printCalculate_CommandText(mapInfo, GlobalPara.getInstance().EcsCal_Unit_LoadName(this.unit_Weight, ""));
            }//	12	)    //	PrintAppC_Flag1_Sale_Unit_Weight
            else if (Flag1 == 13)    //	PrintAppC_Flag1_Sale_Unit_UPriceWeight
            {//	13	)    //	PrintAppC_Flag1_Sale_Unit_UPriceWeight
                return printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getMoneyPrefix() + GlobalPara.getInstance().getMoneySuffix() + "/" + GlobalPara.getInstance().EcsCal_Unit_LoadName(this.unit_Weight, ""));
            }//	13	)    //	PrintAppC_Flag1_Sale_Unit_UPriceWeight
            else if (Flag1 == 14)    //	PrintAppC_Flag1_Sale_Unit_Count
            {//	14	)    //	PrintAppC_Flag1_Sale_Unit_Count
                return printCalculate_CommandText(mapInfo, GlobalPara.getInstance().EcsCal_Unit_LoadName(2, ""));
            }//	14	)    //	PrintAppC_Flag1_Sale_Unit_Count
            else if (Flag1 == 15)    //	PrintAppC_Flag1_Sale_Unit_UPriceCount
            {//	15	)    //	PrintAppC_Flag1_Sale_Unit_UPriceCount
                return printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getMoneyPrefix() + GlobalPara.getInstance().getMoneySuffix() + "/" + GlobalPara.getInstance().EcsCal_Unit_LoadName(2, ""));
            }//	15	)    //	PrintAppC_Flag1_Sale_Unit_UPriceCount
            else if (Flag1 == 16)    //	PrintAppC_Flag1_Sale_Unit_Money
            {//	16	)    //	PrintAppC_Flag1_Sale_Unit_Money
                return printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getMoneyPrefix() + GlobalPara.getInstance().getMoneySuffix());
            }//	16	)    //	PrintAppC_Flag1_Sale_Unit_Money
            else if (Flag1 == 17)    //	PrintAppC_Flag1_Sale_String1
            {//	17	)    //	PrintAppC_Flag1_Sale_String1
                return printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getTMT(Postil_1));
            }//	17	)    //	PrintAppC_Flag1_Sale_String1
            else if (Flag1 == 18)    //	PrintAppC_Flag1_Sale_String2
            {//	18	)    //	PrintAppC_Flag1_Sale_String2
                return printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getTMT(Postil_2));
            }//	18	)    //	PrintAppC_Flag1_Sale_String2
            else if (Flag1 == 19)    //	PrintAppC_Flag1_Sale_String3
            {//	19	)    //	PrintAppC_Flag1_Sale_String3
                return printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getTMT(Postil_3));
            }//	19	)    //	PrintAppC_Flag1_Sale_String3
            else if (Flag1 == 20)    //	PrintAppC_Flag1_Sale_String4
            {//	20	)    //	PrintAppC_Flag1_Sale_String4
                return printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getTMT(Postil_4));
            }//	20	)    //	PrintAppC_Flag1_Sale_String4
            else if (Flag1 == 21)    //	PrintAppC_Flag1_Sale_String5
            {//	21	)    //	PrintAppC_Flag1_Sale_String5
                return printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getTMT(Postil_5));
            }//	21	)    //	PrintAppC_Flag1_Sale_String5
            else if (Flag1 == 22)    //	PrintAppC_Flag1_Sale_String6
            {//	22	)    //	PrintAppC_Flag1_Sale_String6
                return printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getTMT(Postil_6));
            }//	22	)    //	PrintAppC_Flag1_Sale_String6
            else if (Flag1 == 23)    //	PrintAppC_Flag1_Sale_String7
            {//	23	)    //	PrintAppC_Flag1_Sale_String7
                return printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getTMT(Postil_7));
            }//	23	)    //	PrintAppC_Flag1_Sale_String7
            else if (Flag1 == 24)    //	PrintAppC_Flag1_Sale_String8
            {//	24	)    //	PrintAppC_Flag1_Sale_String8
                return printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getTMT(Postil_8));
            }//	24	)    //	PrintAppC_Flag1_Sale_String8
            else if (Flag1 == 25)    //	PrintAppC_Flag1_Sale_FID
            {//	25	)    //	PrintAppC_Flag1_Sale_FID
                if (!this.isPrePrint) {
                    int fsid_LLng = GlobalPara.getInstance().getTMS(Account_FSID_LLng);
                    if (fsid_LLng / 10 == 2)
                        return printCalculate_CommandText(mapInfo, printCalculate_Sale_xID(this.sid, fsid_LLng));
                    else
                        return printCalculate_CommandText(mapInfo, printCalculate_Sale_xID(this.fid, fsid_LLng));
                }
            }//	25	)    //	PrintAppC_Flag1_Sale_FID
            else if (Flag1 == 26)    //	PrintAppC_Flag1_Sale_SID
            {//	26	)    //	PrintAppC_Flag1_Sale_SID
                if (!this.isPrePrint) {
                    int fsid_LLng = GlobalPara.getInstance().getTMS(Account_FSID_LLng);
                    if (fsid_LLng / 10 == 1)
                        return printCalculate_CommandText(mapInfo, printCalculate_Sale_xID(this.fid, fsid_LLng));
                    else
                        return printCalculate_CommandText(mapInfo, printCalculate_Sale_xID(this.sid, fsid_LLng));
                }
            }//	26	)    //	PrintAppC_Flag1_Sale_SID
            else if (Flag1 == 27)    //	PrintAppC_Flag1_Sale_E_PurTax
            {//	27	)    //	PrintAppC_Flag1_Sale_E_PurTax
                if (GlobalPara.getInstance().getTMS(Display_PrintUnit_Money) != 0)
                    result = GlobalPara.getInstance().getMoneyPrefix();
                result += GlobalPara.getInstance().GetStringTMS(this.purTax_Final);
                if (GlobalPara.getInstance().getTMS(Display_PrintUnit_Money) != 0)
                    result += GlobalPara.getInstance().getMoneySuffix();
                return printCalculate_CommandText(mapInfo, result);
            }//	27	)    //	PrintAppC_Flag1_Sale_E_PurTax
            else if (Flag1 == 28)    //	PrintAppC_Flag1_Sale_OS_PurTax
            {//	28	)    //	PrintAppC_Flag1_Sale_OS_PurTax
                if (GlobalPara.getInstance().getTMS(Display_PrintUnit_Money) != 0)
                    result = GlobalPara.getInstance().getMoneyPrefix();
                result += GlobalPara.getInstance().GetStringTMS(this.purTax_Addup.add(this.purTax_ServiceFee));
                if (GlobalPara.getInstance().getTMS(Display_PrintUnit_Money) != 0)
                    result += GlobalPara.getInstance().getMoneySuffix();
                return printCalculate_CommandText(mapInfo, result);
            }//	28	)    //	PrintAppC_Flag1_Sale_OS_PurTax
            else if (Flag1 == 29)    //	PrintAppC_Flag1_Sale_PurDiff
            {//	29	)    //	PrintAppC_Flag1_Sale_PurDiff
                if (GlobalPara.getInstance().getTMS(Display_PrintUnit_Money) != 0)
                    result = GlobalPara.getInstance().getMoneyPrefix();
                result += GlobalPara.getInstance().GetStringTMS(getPur_Diff());
                if (GlobalPara.getInstance().getTMS(Display_PrintUnit_Money) != 0)
                    result += GlobalPara.getInstance().getMoneySuffix();
                return printCalculate_CommandText(mapInfo, result);
            }//	29	)    //	PrintAppC_Flag1_Sale_PurDiff
            else if (Flag1 == 30)    //	PrintAppC_Flag1_Sale_SalesmanNo
            {//	30	)    //	PrintAppC_Flag1_Sale_SalesmanNo
                return printCalculate_CommandText(mapInfo, Integer.toString(this.salesman_Number));
            }//	30	)    //	PrintAppC_Flag1_Sale_SalesmanNo
            else if (Flag1 == 31)    //	PrintAppC_Flag1_Sale_SalesmanName
            {//	31	)    //	PrintAppC_Flag1_Sale_SalesmanName
                return printCalculate_CommandText(mapInfo, this.salesman_Name);
            }//	31	)    //	PrintAppC_Flag1_Sale_SalesmanName
            else if (Flag1 == 32)    //	PrintAppC_Flag1_Sale_PurNoTax
            {//	32	)    //	PrintAppC_Flag1_Sale_PurNoTax
                return printCalculate_CommandText(mapInfo, this.purTax_Discounted.subtract(this.tax_Discounted).toString());
            }//	32	)    //	PrintAppC_Flag1_Sale_PurNoTax
            else if (Flag1 == 33)    //	PrintAppC_Flag1_Sale_Tax
            {//	33	)    //	PrintAppC_Flag1_Sale_Tax
                return printCalculate_CommandText(mapInfo, this.tax_Discounted.toString());
            }//	33	)    //	PrintAppC_Flag1_Sale_Tax
            else if (Flag1 == 34)    //	PrintAppC_Flag1_Sale_ServicemanNo
            {//	34	)    //	PrintAppC_Flag1_Sale_ServicemanNo
                return printCalculate_CommandText(mapInfo, Integer.toString(this.serviceman_Number));
            }//	34	)    //	PrintAppC_Flag1_Sale_ServicemanNo
            else if (Flag1 == 35)    //	PrintAppC_Flag1_Sale_ServicemanName
            {//	35	)    //	PrintAppC_Flag1_Sale_ServicemanName
                return printCalculate_CommandText(mapInfo, this.serviceman_Name);
            }//	35	)    //	PrintAppC_Flag1_Sale_ServicemanName
            else if (Flag1 == 36)    //	PrintAppC_Flag1_Sale_SpString01
            {//	36	)    //	PrintAppC_Flag1_Sale_SpString01
                return printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getTMT(Reserved_1));
            }//	36	)    //	PrintAppC_Flag1_Sale_SpString01
            else if (Flag1 == 37)    //	PrintAppC_Flag1_Sale_SpString02
            {//	37	)    //	PrintAppC_Flag1_Sale_SpString02
                return printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getTMT(Reserved_2));
            }//	37	)    //	PrintAppC_Flag1_Sale_SpString02
            else if (Flag1 == 38)    //	PrintAppC_Flag1_Sale_SpString03
            {//	38	)    //	PrintAppC_Flag1_Sale_SpString03
                return printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getTMT(Reserved_3));
            }//	38	)    //	PrintAppC_Flag1_Sale_SpString03
            else if (Flag1 == 39)    //	PrintAppC_Flag1_Sale_SpString04
            {//	39	)    //	PrintAppC_Flag1_Sale_SpString04
                return printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getTMT(Wireless_SSID));
            }//	39	)    //	PrintAppC_Flag1_Sale_SpString04
            else if (Flag1 == 40)    //	PrintAppC_Flag1_Sale_SpString05
            {//	40	)    //	PrintAppC_Flag1_Sale_SpString05
                return printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getTMT(Wireless_PASS));
            }//	40	)    //	PrintAppC_Flag1_Sale_SpString05
            else if (Flag1 == 41)    //	PrintAppC_Flag1_Sale_SpString06
            {//	41	)    //	PrintAppC_Flag1_Sale_SpString06
                return printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getTMT(Reserved_6));
            }//	41	)    //	PrintAppC_Flag1_Sale_SpString06
            else if (Flag1 == 42)    //	PrintAppC_Flag1_Sale_SpString07
            {//	42	)    //	PrintAppC_Flag1_Sale_SpString07
                return printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getTMT(Reserved_7));
            }//	42	)    //	PrintAppC_Flag1_Sale_SpString07
            else if (Flag1 == 43)    //	PrintAppC_Flag1_Sale_SpString08
            {//	43	)    //	PrintAppC_Flag1_Sale_SpString08
                return printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getTMT(Domain));
            }//	43	)    //	PrintAppC_Flag1_Sale_SpString08
            else if (Flag1 == 44)    //	PrintAppC_Flag1_Sale_S_PurTax
            {//	44	)    //	PrintAppC_Flag1_Sale_S_PurTax
                return printCalculate_CommandText(mapInfo, this.purTax_ServiceFee.toString());
            }//	44	)    //	PrintAppC_Flag1_Sale_S_PurTax
            else if (Flag1 == 45)    //	PrintAppC_Flag1_Sale_S_Tax
            {//	45	)    //	PrintAppC_Flag1_Sale_S_Tax
                return printCalculate_CommandText(mapInfo, this.tax_ServiceFee.toString());
            }//	45	)    //	PrintAppC_Flag1_Sale_S_Tax
            else if (Flag1 == 46)    //	PrintAppC_Flag1_Sale_S_PurNoTax
            {//	46	)    //	PrintAppC_Flag1_Sale_S_PurNoTax
                return printCalculate_CommandText(mapInfo, this.purTax_ServiceFee.subtract(this.tax_ServiceFee).toString());
            }//	46	)    //	PrintAppC_Flag1_Sale_S_PurNoTax
            else if (Flag1 == 47)    //	PrintAppC_Flag1_Sale_V_Number
            {//	47	)    //	PrintAppC_Flag1_Sale_V_Number
                return printCalculate_CommandText(mapInfo, "V" + Integer.toString(this.vid));
            }//	47	)    //	PrintAppC_Flag1_Sale_V_Number
            else if (Flag1 == 48)    //	PrintAppC_Flag1_Sale_Card_Left
            {//	48	)    //	PrintAppC_Flag1_Sale_Card_Left
                if ((!this.isPrePrint) && (this.pay_VIP_Balance_Old.compareTo(BigDecimal.ZERO) > 0))
                    return printCalculate_CommandText(mapInfo, this.pay_VIP_Balance_New.toString());
            }//	48	)    //	PrintAppC_Flag1_Sale_Card_Left
            else if (Flag1 == 49)    //	PrintAppC_Flag1_Sale_Card_Old
            {//	49	)    //	PrintAppC_Flag1_Sale_Card_Old
                if ((!this.isPrePrint) && (this.pay_VIP_Balance_Old.compareTo(BigDecimal.ZERO) > 0))
                    return printCalculate_CommandText(mapInfo, this.pay_VIP_Balance_Old.toString());
            }//	49	)    //	PrintAppC_Flag1_Sale_Card_Old
            else if (Flag1 == 50)    //	PrintAppC_Flag1_Sale_Card_Number
            {//	50	)    //	PrintAppC_Flag1_Sale_Card_Number
                if (!this.isPrePrint)
                    return printCalculate_CommandText(mapInfo, this.pay_VIP_ID);
            }//	50	)    //	PrintAppC_Flag1_Sale_Card_Number
            else if (Flag1 == 51)    //	PrintAppC_Flag1_Sale_PayCard
            {//	51	)    //	PrintAppC_Flag1_Sale_PayCard
                if (!this.isPrePrint)
                    return printCalculate_CommandText(mapInfo, this.pay_Card.toString());
            }//	51	)    //	PrintAppC_Flag1_Sale_PayCard
            else if (Flag1 == 52)    //	PrintAppC_Flag1_Sale_PayOther_0
            {//	52	)    //	PrintAppC_Flag1_Sale_PayOther_0
                if (!this.isPrePrint)
                    return printCalculate_CommandText(mapInfo, this.pay_Other1.toString());
            }//	52	)    //	PrintAppC_Flag1_Sale_PayOther_0
            else if (Flag1 == 53)    //	PrintAppC_Flag1_Sale_PayOther_1
            {//	53	)    //	PrintAppC_Flag1_Sale_PayOther_1
                if (!this.isPrePrint)
                    return printCalculate_CommandText(mapInfo, this.pay_Other2.toString());
            }//	53	)    //	PrintAppC_Flag1_Sale_PayOther_1
            else if (Flag1 == 54)    //	PrintAppC_Flag1_Sale_PayOther_2
            {//	54	)    //	PrintAppC_Flag1_Sale_PayOther_2
                if (!this.isPrePrint)
                    return printCalculate_CommandText(mapInfo, this.pay_Other3.toString());
            }//	54	)    //	PrintAppC_Flag1_Sale_PayOther_2
            else if (Flag1 == 55)    //	PrintAppC_Flag1_Sale_Type_Name
            {//	55	)    //	PrintAppC_Flag1_Sale_Type_Name
                return printCalculate_CommandText(mapInfo, this.tradeTypeName);
            }//	55	)    //	PrintAppC_Flag1_Sale_Type_Name
            else if (Flag1 == 56)    //	PrintAppC_Flag1_Sale_VIP_ID1
            {//	56	)    //	PrintAppC_Flag1_Sale_VIP_ID1
                if (!this.isPrePrint)
                    return printCalculate_CommandText(mapInfo, this.pay_VIP_ID_Plus1);
            }//	56	)    //	PrintAppC_Flag1_Sale_VIP_ID1
            else if (Flag1 == 57)    //	PrintAppC_Flag1_Sale_VIP_ID2
            {//	57	)    //	PrintAppC_Flag1_Sale_VIP_ID2
                if (!this.isPrePrint)
                    return printCalculate_CommandText(mapInfo, this.pay_VIP_ID_Plus2);
            }//	57	)    //	PrintAppC_Flag1_Sale_VIP_ID2
            else if (Flag1 == 58)    //	PrintAppC_Flag1_Sale_VIP_Discount
            {//	58	)    //	PrintAppC_Flag1_Sale_VIP_Discount
                if (!this.isPrePrint)
                    return printCalculate_CommandText(mapInfo, "-" + (new BigDecimal(10000 - this.pay_VIP_DiscountP1W).movePointLeft(2).toString()) + "%");
            }//	58	)    //	PrintAppC_Flag1_Sale_VIP_Discount
            else if (Flag1 == 59)    //	PrintAppC_Flag1_Sale_VIP_Point
            {//	59	)    //	PrintAppC_Flag1_Sale_VIP_Point
                if (!this.isPrePrint)
                    return printCalculate_CommandText(mapInfo, this.pay_VIP_Point.toString());
            }//	59	)    //	PrintAppC_Flag1_Sale_VIP_Point
            else if (Flag1 == 60)    //	PrintAppC_Flag1_Sale_E_PurTax_2ndCurrency
            {//	60	)    //	PrintAppC_Flag1_Sale_E_PurTax_2ndCurrency
                try {
                    int exchange = GlobalPara.getInstance().getTMS(SecondCurrency_Exchange);
                    BigDecimal rate = GlobalPara.ecsCal_getNumS32(exchange);
                    if (rate.compareTo(BigDecimal.ZERO) != 0) {
                        rate = this.purTax_Final.divide(rate, GlobalPara.getInstance().getTMS(SecondCurrency_DecimalDot), BigDecimal.ROUND_HALF_UP);
                        return printCalculate_CommandText(mapInfo, rate.toString());
                    }
                } catch (Exception exp) {
                    return "";
                }
            }//	60	)    //	PrintAppC_Flag1_Sale_E_PurTax_2ndCurrency
            else if (Flag1 == 61)    //	PrintAppC_Flag1_Sale_Info_1
            {//	61	)    //	PrintAppC_Flag1_Sale_Info_1
                ;
            }//	61	)    //	PrintAppC_Flag1_Sale_Info_1
            else if (Flag1 == 62)    //	PrintAppC_Flag1_Sale_Info_2
            {//	62	)    //	PrintAppC_Flag1_Sale_Info_2
                ;
            }//	62	)    //	PrintAppC_Flag1_Sale_Info_2
            else if (Flag1 == 63)    //	PrintAppC_Flag1_Sale_Info_3
            {//	63	)    //	PrintAppC_Flag1_Sale_Info_3
                ;
            }//	63	)    //	PrintAppC_Flag1_Sale_Info_3
            else if (Flag1 == 64)    //	PrintAppC_Flag1_Sale_Info_4
            {//	64	)    //	PrintAppC_Flag1_Sale_Info_4
                ;
            }//	64	)    //	PrintAppC_Flag1_Sale_Info_4
            else if (Flag1 == 65)    //	PrintAppC_Flag1_Sale_MAC
            {//	65	)    //	PrintAppC_Flag1_Sale_MAC
                return printCalculate_CommandText(mapInfo, GlobalPara.getInstance().getSystemID());
            }//	65	)    //	PrintAppC_Flag1_Sale_MAC
            else if (Flag1 == 66)    //	PrintAppC_Flag1_Sale_PurTaxDiff
            {//	66	)    //	PrintAppC_Flag1_Sale_PurTaxDiff
                if (GlobalPara.getInstance().getTMS(Display_PrintUnit_Money) != 0)
                    result = GlobalPara.getInstance().getMoneyPrefix();
                result += GlobalPara.getInstance().GetStringTMS(getPurTax_Diff());
                if (GlobalPara.getInstance().getTMS(Display_PrintUnit_Money) != 0)
                    result += GlobalPara.getInstance().getMoneySuffix();
                return printCalculate_CommandText(mapInfo, result);
            }//	66	)    //	PrintAppC_Flag1_Sale_PurTaxDiff
            else if (Flag1 == 67)    //	PrintAppC_Flag1_Sale_PayCloud_Type
            {//	67	)    //	PrintAppC_Flag1_Sale_PayCloud_Type
                if (!this.isPrePrint)
                    return printCalculate_CommandText(mapInfo, this.pay_Cloud_TypeName);
            }//	67	)    //	PrintAppC_Flag1_Sale_PayCloud_Type
            else if (Flag1 == 68)    //	PrintAppC_Flag1_Sale_PayCloud_Value
            {//	68	)    //	PrintAppC_Flag1_Sale_PayCloud_Value
                if (!this.isPrePrint) {
                    if (GlobalPara.getInstance().getTMS(Display_PrintUnit_Money) != 0)
                        result = GlobalPara.getInstance().getMoneyPrefix();
                    result += GlobalPara.getInstance().GetStringTMS(this.pay_Cloud);
                    if (GlobalPara.getInstance().getTMS(Display_PrintUnit_Money) != 0)
                        result += GlobalPara.getInstance().getMoneySuffix();
                    return printCalculate_CommandText(mapInfo, result);
                }
            }//	68	)    //	PrintAppC_Flag1_Sale_PayCloud_Value
            else if (Flag1 == 69)    //	PrintAppC_Flag1_Sale_PayCloud_IDString
            {//	69	)    //	PrintAppC_Flag1_Sale_PayCloud_IDString
                if (!this.isPrePrint)
                    return printCalculate_CommandText(mapInfo, this.pay_Cloud_Bill);
            }//	69	)    //	PrintAppC_Flag1_Sale_PayCloud_IDString
            else if (Flag1 == 70)    //	PrintAppC_Flag1_Sale_PayJKY
            {//	70	)    //	PrintAppC_Flag1_Sale_PayJKY
                if (!this.isPrePrint) {
                    if (GlobalPara.getInstance().getTMS(Display_PrintUnit_Money) != 0)
                        result = GlobalPara.getInstance().getMoneyPrefix();
                    result += GlobalPara.getInstance().GetStringTMS(this.pay_JKY_All);
                    if (GlobalPara.getInstance().getTMS(Display_PrintUnit_Money) != 0)
                        result += GlobalPara.getInstance().getMoneySuffix();
                    return printCalculate_CommandText(mapInfo, result);
                }
            }//	70	)    //	PrintAppC_Flag1_Sale_PayJKY
            else if (Flag1 == 71)    //	PrintAppC_Flag1_Sale_PurTax_NoUPD
            {//	71	)    //	PrintAppC_Flag1_Sale_PurTax_NoUPD
                if (this.purTax_FromPLU.compareTo(this.purTax_Addup) != 0) {
                    if (GlobalPara.getInstance().getTMS(Display_PrintUnit_Money) != 0)
                        result = GlobalPara.getInstance().getMoneyPrefix();
                    result += GlobalPara.getInstance().GetStringTMS(this.purTax_FromPLU);
                    if (GlobalPara.getInstance().getTMS(Display_PrintUnit_Money) != 0)
                        result += GlobalPara.getInstance().getMoneySuffix();
                    mapInfo = printCalculate_DrawFont_AddDeletedLine(mapInfo);
                    return printCalculate_CommandText(mapInfo, result);
                }
            }//	71	)    //	PrintAppC_Flag1_Sale_PurTax_NoUPD
            else if (Flag1 == 72)    //	PrintAppC_Flag1_Sale_Saved_FromNoUPD
            {//	72	)    //	PrintAppC_Flag1_Sale_Saved_FromNoUPD
                BigDecimal saved = this.purTax_FromPLU.add(this.purTax_ServiceFee).subtract(this.purTax_Discounted);
                if (saved.compareTo(BigDecimal.ZERO) > 0) {
                    if (GlobalPara.getInstance().getTMS(Display_PrintUnit_Money) != 0)
                        result = GlobalPara.getInstance().getMoneyPrefix();
                    result += GlobalPara.getInstance().GetStringTMS(saved);
                    if (GlobalPara.getInstance().getTMS(Display_PrintUnit_Money) != 0)
                        result += GlobalPara.getInstance().getMoneySuffix();
                    return printCalculate_CommandText(mapInfo, result);
                }
            }//	72	)    //	PrintAppC_Flag1_Sale_Saved_FromNoUPD
            else if (Flag1 == 73)    //	PrintAppC_Flag1_Sale_JKYQR
            {//	73	)    //	PrintAppC_Flag1_Sale_JKYQR
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(this.tradeTime);
                SimpleDateFormat formatter = new SimpleDateFormat("yyMM");
                String qrContent = String.format(ZUUL, GlobalPara.getInstance().getSystemID(), this.fid, formatter.format(calendar.getTime()));
                // String qrcontent = "JKY:" + GlobalPara.getInstance().getSystemID() + "_" + Integer.toString(this.fid) + "_" + formatter.format(calendar.getTime());
                return printCalculate_DrawBarcode(mapInfo, "0B01030500000000", qrContent.getBytes());
            }//	73	)    //	PrintAppC_Flag1_Sale_JKYQR

            return "";
        } catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    // private static final String ZUUL = "http://jhscale.com/H5/html/tbs/index.html?type=tbs&mac=%s&fid=%s&date=%s&deviceType=android";
    private static final String ZUUL = "http://jhscale.com/H5/index.html?type=tbs&mac=%s&fid=%s&date=%s";

    /*******************************************************************/
    /**
     * @description: 打印静态 工具方法
     **/
    public static int tryParseInt(String toParse, int defaultValue) {
        try {
            return Integer.parseInt(toParse, 10);
        } catch (Exception e) {
            return defaultValue;
        }
    }

    public static int tryParseInt(String toParse) {
        return tryParseInt(toParse, 0);
    }

    public static String printCalculate_Item_Special(String nohead, int itemPos) {
        return "";
    }

    public static String printCalculate_Sale_Special(String nohead) {
        return "";
    }

    public static Integer[] printCalculate_GetNValue(String nohead, int size) {
        String[] nstring = nohead.split("-");
        Integer[] nvalue = new Integer[size];
        Integer loop;
        for (loop = 0; loop < nstring.length; loop++) {
            nvalue[loop] = tryParseInt(nstring[loop]);
        }
        for (; loop < size; loop++) {
            nvalue[loop] = 0;
        }
        return nvalue;
    }

    private static final byte[] HexValue = new byte[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] HexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String printCalculate_getX2(int value) {
        return "" + HexChar[(value >> 4) & 0x0f] + HexChar[value & 0x0f];
    }

    public static String printCalculate_getX4(int value) {
        return "" + HexChar[(value >> 4) & 0x0f] + HexChar[value & 0x0f] + HexChar[(value >> 12) & 0x0f] + HexChar[(value >> 8) & 0x0f];
    }

    public static String printCalculate_GetBarcodeHex(byte[] bytes) {
        int len = bytes.length;
        byte[] hex = new byte[len * 2 + 2];
        int count = 0;
        for (int i = 0; i < len; ++i) {
            int value = bytes[i];
            if (value < 0)
                value += 256;
            //    if(value<=0)                //Barcode may end at 1st \0
            //        break;
            hex[count] = HexValue[(value / 16) & 0x0f];
            hex[count + 1] = HexValue[value & 0x0f];
            count += 2;
        }
        hex[count] = '0';
        hex[count + 1] = '0';
        count += 2;

        return new String(hex);
    }

    public static String printCalculate_GetTextHex(String text) {
        byte[] bytes = text.getBytes();
        int len = bytes.length;
        byte[] hex = new byte[len * 2 + 2];
        int count = 0;
        for (int i = 0; i < len; ++i) {
            int value = bytes[i];
            if (value < 0)
                value += 256;
            if ((value == '\n') || (value == 11))          //'\v'
                value = 11;
            else if (value < 0x20)
                continue;
            hex[count] = HexValue[(value / 16) & 0x0f];
            hex[count + 1] = HexValue[value & 0x0f];
            count += 2;
        }
        hex[count] = '0';
        hex[count + 1] = '0';
        count += 2;

        return new String(Arrays.copyOfRange(hex, 0, count));
    }

    public static String printCalculate_Bitmap(String mapInfo, int bitmap) {
        if (mapInfo == null)
            return "";
        if (mapInfo.isEmpty())
            return "";
        return "16" + mapInfo + printCalculate_getX4(bitmap);
    }

    public static String printCalculate_Bitmap_Inner(String mapInfo, int bitmap) {
        if (mapInfo == null)
            return "";
        if (mapInfo.isEmpty())
            return "";
        return "18" + mapInfo + printCalculate_getX4(bitmap);
    }

    public static String printCalculate_CommandText(String command, String text) {
        if (command == null)
            return "";
        if (command.isEmpty())
            return "";
        if (text == null)
            return "";
        if (text.isEmpty())
            return "";
        return "12" + command + printCalculate_GetTextHex(text);
    }

    public static String printCalculate_DrawBarcode(String mapInfo, String barcodeType, byte[] input) {
        if (mapInfo == null)
            return "";
        if (mapInfo.isEmpty())
            return "";
        if (barcodeType == null)
            return "";
        if (barcodeType.isEmpty())
            return "";
        if (input == null)
            return "";
        return "14" + mapInfo + barcodeType + printCalculate_GetBarcodeHex(input);
    }
    /*******************************************************************/

    /*************************************************** 属性 get set *******************************************************************/

    public void setSpInfo(String key, Object value) {
        spInfo.put(key, value);
    }

    public Object getSpInfo(String key) {
        return spInfo.get(key);
    }

    public List<ItemContent> getItem() {
        return item;
    }

    public void setItem(List<ItemContent> item) {
        this.item = item;
    }

    public boolean isPrePrint() {
        return isPrePrint;
    }

    public void setPrePrint(boolean prePrint) {
        isPrePrint = prePrint;
    }

    public boolean isRePrint() {
        return isRePrint;
    }

    public void setRePrint(boolean rePrint) {
        isRePrint = rePrint;
    }

    public Date getTradeTime() {
        return tradeTime;
    }

    public void setTradeTime(Date tradeTime) {
        this.tradeTime = tradeTime;
    }

    public int getFid() {
        return fid;
    }

    public void setFid(int fid) {
        this.fid = fid;
    }

    public int getSid() {
        return sid;
    }

    public void setSid(int sid) {
        this.sid = sid;
    }

    public int getVid() {
        return vid;
    }

    public void setVid(int vid) {
        this.vid = vid;
    }

    public int getSalesman_Number() {
        return salesman_Number;
    }

    public void setSalesman_Number(int salesman_Number) {
        this.salesman_Number = salesman_Number;
    }

    public String getSalesman_Name() {
        return salesman_Name;
    }

    public void setSalesman_Name(String salesman_Name) {
        this.salesman_Name = salesman_Name;
    }

    public int getServiceman_Number() {
        return serviceman_Number;
    }

    public void setServiceman_Number(int serviceman_Number) {
        this.serviceman_Number = serviceman_Number;
    }

    public String getServiceman_Name() {
        return serviceman_Name;
    }

    public void setServiceman_Name(String serviceman_Name) {
        this.serviceman_Name = serviceman_Name;
    }

    public int getTradeType() {
        return tradeType;
    }

    public void setTradeType(int tradeType) {
        this.tradeType = tradeType;
    }

    public TradeContent tradeType(TradeType tradeType) {
        this.tradeType = tradeType.getType();
        return this;
    }

    public String getTradeTypeName() {
        return tradeTypeName;
    }

    public void setTradeTypeName(String tradeTypeName) {
        this.tradeTypeName = tradeTypeName;
    }

    public BigDecimal gettCount() {
        return tCount;
    }

    public void settCount(BigDecimal tCount) {
        this.tCount = tCount;
    }

    public BigDecimal gettWeight() {
        return tWeight;
    }

    public void settWeight(BigDecimal tWeight) {
        this.tWeight = tWeight;
    }

    public int gettUnitWeight() {
        return tUnitWeight;
    }

    public void settUnitWeight(int tUnitWeight) {
        this.tUnitWeight = tUnitWeight;
    }

    public int getUnit_Weight() {
        return unit_Weight;
    }

    public void setUnit_Weight(int unit_Weight) {
        this.unit_Weight = unit_Weight;
    }

    public BigDecimal getPurTax_FromPLU() {
        return purTax_FromPLU;
    }

    public void setPurTax_FromPLU(BigDecimal purTax_FromPLU) {
        this.purTax_FromPLU = purTax_FromPLU;
    }

    public BigDecimal getPurTax_Addup() {
        return purTax_Addup;
    }

    public void setPurTax_Addup(BigDecimal purTax_Addup) {
        this.purTax_Addup = purTax_Addup;
    }

    public BigDecimal getTax_Addup() {
        return tax_Addup;
    }

    public void setTax_Addup(BigDecimal tax_Addup) {
        this.tax_Addup = tax_Addup;
    }

    public BigDecimal getPurTax_ServiceFee() {
        return purTax_ServiceFee;
    }

    public void setPurTax_ServiceFee(BigDecimal purTax_ServiceFee) {
        this.purTax_ServiceFee = purTax_ServiceFee;
    }

    public BigDecimal getTax_ServiceFee() {
        return tax_ServiceFee;
    }

    public void setTax_ServiceFee(BigDecimal tax_ServiceFee) {
        this.tax_ServiceFee = tax_ServiceFee;
    }

    public int getTotal_ServiceFee_Type() {
        return total_ServiceFee_Type;
    }

    public void setTotal_ServiceFee_Type(int total_ServiceFee_Type) {
        this.total_ServiceFee_Type = total_ServiceFee_Type;
    }

    public BigDecimal getTotal_ServiceFee_Rate() {
        return total_ServiceFee_Rate;
    }

    public void setTotal_ServiceFee_Rate(BigDecimal total_ServiceFee_Rate) {
        this.total_ServiceFee_Rate = total_ServiceFee_Rate;
    }

    public BigDecimal getPurTax_Discounted() {
        return purTax_Discounted;
    }

    public void setPurTax_Discounted(BigDecimal purTax_Discounted) {
        this.purTax_Discounted = purTax_Discounted;
    }

    public BigDecimal getTax_Discounted() {
        return tax_Discounted;
    }

    public void setTax_Discounted(BigDecimal tax_Discounted) {
        this.tax_Discounted = tax_Discounted;
    }

    public BigDecimal getPurTax_Final() {
        return purTax_Final;
    }

    public void setPurTax_Final(BigDecimal purTax_Final) {
        this.purTax_Final = purTax_Final;
    }

    //获取含税折舍金额： use in PrintAppC_Flag1_Sale_PurTaxDiff
    public BigDecimal getPurTax_Diff() {
        return this.purTax_Final.subtract(this.purTax_Addup).subtract(this.purTax_ServiceFee);
    }

    //获取未税折舍金额： use in PrintAppC_Flag1_Sale_PurDiff
    public BigDecimal getPur_Diff() {
        return this.purTax_Final.subtract(this.purTax_Addup).subtract(this.purTax_ServiceFee).subtract(this.tax_Discounted.subtract(this.tax_Addup).subtract(this.tax_ServiceFee));
    }

    public BigDecimal getSurplus_Reject() {
        return surplus_Reject;
    }

    public void setSurplus_Reject(BigDecimal surplus_Reject) {
        this.surplus_Reject = surplus_Reject;
    }

    public BigDecimal getRounding() {
        return rounding;
    }

    public void setRounding(BigDecimal rounding) {
        this.rounding = rounding;
    }

    public BigDecimal getChange() {
        return change;
    }

    public void setChange(BigDecimal change) {
        this.change = change;
    }

    public BigDecimal getPay_Cash() {
        return pay_Cash;
    }

    public void setPay_Cash(BigDecimal pay_Cash) {
        this.pay_Cash = pay_Cash;
    }

    public BigDecimal getPay_Other1() {
        return pay_Other1;
    }

    public void setPay_Other1(BigDecimal pay_Other1) {
        this.pay_Other1 = pay_Other1;
    }

    public BigDecimal getPay_Other2() {
        return pay_Other2;
    }

    public void setPay_Other2(BigDecimal pay_Other2) {
        this.pay_Other2 = pay_Other2;
    }

    public BigDecimal getPay_Other3() {
        return pay_Other3;
    }

    public void setPay_Other3(BigDecimal pay_Other3) {
        this.pay_Other3 = pay_Other3;
    }

    public BigDecimal getPay_JKY_All() {
        return pay_JKY_All;
    }

    public void setPay_JKY_All(BigDecimal pay_JKY_All) {
        this.pay_JKY_All = pay_JKY_All;
    }

    public BigDecimal getPay_JKY_Gift() {
        return pay_JKY_Gift;
    }

    public void setPay_JKY_Gift(BigDecimal pay_JKY_Gift) {
        this.pay_JKY_Gift = pay_JKY_Gift;
    }

    public BigDecimal getPay_Card() {
        return pay_Card;
    }

    public void setPay_Card(BigDecimal pay_Card) {
        this.pay_Card = pay_Card;
    }

    public BigDecimal getPay_VIP_Balance_Old() {
        return pay_VIP_Balance_Old;
    }

    public void setPay_VIP_Balance_Old(BigDecimal pay_VIP_Balance_Old) {
        this.pay_VIP_Balance_Old = pay_VIP_Balance_Old;
    }

    public BigDecimal getPay_VIP_Balance_New() {
        return pay_VIP_Balance_New;
    }

    public void setPay_VIP_Balance_New(BigDecimal pay_VIP_Balance_New) {
        this.pay_VIP_Balance_New = pay_VIP_Balance_New;
    }

    public String getPay_VIP_ID() {
        return pay_VIP_ID;
    }

    public void setPay_VIP_ID(String pay_VIP_ID) {
        this.pay_VIP_ID = pay_VIP_ID;
    }

    public String getPay_VIP_ID_Plus1() {
        return pay_VIP_ID_Plus1;
    }

    public void setPay_VIP_ID_Plus1(String pay_VIP_ID_Plus1) {
        this.pay_VIP_ID_Plus1 = pay_VIP_ID_Plus1;
    }

    public String getPay_VIP_ID_Plus2() {
        return pay_VIP_ID_Plus2;
    }

    public void setPay_VIP_ID_Plus2(String pay_VIP_ID_Plus2) {
        this.pay_VIP_ID_Plus2 = pay_VIP_ID_Plus2;
    }

    public char getPay_VIP_Level() {
        return pay_VIP_Level;
    }

    public void setPay_VIP_Level(char pay_VIP_Level) {
        this.pay_VIP_Level = pay_VIP_Level;
    }

    public int getPay_VIP_DiscountP1W() {
        return pay_VIP_DiscountP1W;
    }

    public void setPay_VIP_DiscountP1W(int pay_VIP_DiscountP1W) {
        this.pay_VIP_DiscountP1W = pay_VIP_DiscountP1W;
    }

    public BigDecimal getPay_VIP_Point() {
        return pay_VIP_Point;
    }

    public void setPay_VIP_Point(BigDecimal pay_VIP_Point) {
        this.pay_VIP_Point = pay_VIP_Point;
    }

    public DSource getSource() {
        return source;
    }

    public TradeContent setSource(DSource source) {
        this.source = source;
        return this;
    }

    public BigDecimal getPay_Cloud() {
        return pay_Cloud;
    }

    public Integer getPay_Cloud_Type() {
        return pay_Cloud_Type;
    }

    public Integer getPay_Cloud_Way() {
        return pay_Cloud_Way;
    }

    public void setPay_Cloud_Way(Integer pay_Cloud_Way) {
        this.pay_Cloud_Way = pay_Cloud_Way;
    }

    public void setPay_Cloud_Type(Integer pay_Cloud_Type) {
        this.pay_Cloud_Type = pay_Cloud_Type;
    }

    public void setPay_Cloud(BigDecimal pay_Cloud) {
        this.pay_Cloud = pay_Cloud;
    }

    public String getPay_Cloud_TypeName() {
        return pay_Cloud_TypeName;
    }

    public void setPay_Cloud_TypeName(String pay_Cloud_TypeName) {
        this.pay_Cloud_TypeName = pay_Cloud_TypeName;
    }

    public String getPay_Cloud_Bill() {
        return pay_Cloud_Bill;
    }

    public void setPay_Cloud_Bill(String pay_Cloud_Bill) {
        this.pay_Cloud_Bill = pay_Cloud_Bill;
    }

    public String getError_code() {
        return error_code;
    }

    public void setError_code(String error_code) {
        this.error_code = error_code;
    }

    public Map<String, String> getCustomInfo() {
        return customInfo;
    }

    public void setCustomInfo(Map<String, String> customInfo) {
        this.customInfo = customInfo;
    }

    public List<PrintContent> getPrintContents() {
        return printContents;
    }

    public void setPrintContents(List<PrintContent> printContents) {
        this.printContents = printContents;
    }

    public DLOGContent getLogContent() {
        return logContent;
    }

    public void setLogContent(DLOGContent logContent) {
        this.logContent = logContent;
    }

    public void putPosOnlyString(Integer number, String value) {
        posOnlyString.put(number, value);
    }

    public String getPosOnlyString(Integer number) {
        return posOnlyString.get(number);
    }

    /*************************************************** 属性 get set *******************************************************************/

//    /**
//     * @description: 重量变化，设置重量 并重算
//     **/
//    public TradeContent Item_Set_Tare(ItemContent itemC, BigDecimal tare) {
//        itemC.setPackageTare(tare);
//        return this;
//    }
//
//    /**
//     * @description: 设置重量
//     **/
//    public void Item_Set_Weight(ItemContent itemC, BigDecimal weight, boolean steable) {
//        if (!GlobalPara.getInstance().EcsCal_Unit_isWeight(itemC.getUnit_weight()))
//            return;
//        if (itemC.getPlu().getTarePercent().compareTo(BigDecimal.ZERO) > 0)
//            itemC.setPercentTare(weight.multiply(itemC.getPlu().getTarePercent()).setScale(GlobalPara.getInstance().getPointOfWeight(), BigDecimal.ROUND_HALF_DOWN));
//        else
//            itemC.setPercentTare(BigDecimal.ZERO.setScale(GlobalPara.getInstance().getPointOfWeight()));
//        itemC.setAmount(weight.subtract(itemC.getPercentTare()));
//        itemC.setValid_Amount((itemC.getAmount().compareTo(BigDecimal.ZERO) != 0) && (steable));
//    }
//
//    /**
//     * @description: 设置数量
//     **/
//    public void Item_Set_Count(ItemContent itemC, BigDecimal pcs) {
//        if (GlobalPara.getInstance().EcsCal_Unit_isWeight(itemC.getUnit_weight()))
//            return;
//        itemC.setAmount(pcs);
//        itemC.setValid_Amount(itemC.getAmount().compareTo(BigDecimal.ZERO) != 0);
//    }
//
//    /**
//     * @description: 计件取重
//     **/
//    public void Item_Set_Amount_Stock(ItemContent itemC, BigDecimal amount) {
//        if (GlobalPara.getInstance().EcsCal_Unit_isWeight(itemC.getUnit_weight()))
//            return;
//        itemC.setAmount_Stock(amount);
//        itemC.setUnit_Stock(GlobalPara.getInstance().getWeightUNIT());
//    }
//
//    /**
//     * @description: 设置单价
//     **/
//    public void Item_Set_UPrice(ItemContent itemC, BigDecimal price) {
//        itemC.setPrice(GlobalPara.getInstance().EcsCal_Rounding(price, GlobalPara.getInstance().getPointOfPrice(), 0));
//        itemC.setPriceIsManual(true);
//    }
//
//    /**
//     * @description: 单条明细重算
//     **/
//    public void Item_ReCal(ItemContent itemC) {
//        BigDecimal purTax, tax;
//        BigDecimal purTax_Orignal;
//        Item_GetUPrice_Track(itemC);
//
//        purTax = GlobalPara.getInstance().EcsCal_Unit_ValueConvert(itemC.getPrice().multiply(itemC.getAmount()), itemC.getUnit_weight(), itemC.getUnit_price());
//        purTax_Orignal = GlobalPara.getInstance().EcsCal_Unit_ValueConvert(itemC.getPrice_Original().multiply(itemC.getAmount()), itemC.getUnit_weight(), itemC.getUnit_price());
//        if (itemC.getTaxType() == 1) {
//            tax = purTax.multiply(itemC.getTaxRate());
//            purTax = purTax.add(tax);
//
//            purTax_Orignal = purTax_Orignal.add(purTax_Orignal.multiply(itemC.getTaxRate()));
//        } else if (itemC.getTaxType() == 2) {
//            tax = purTax.multiply(itemC.getTaxRate()).divide(itemC.getTaxRate().add(BigDecimal.ONE), 7, BigDecimal.ROUND_HALF_UP);
//        } else if (itemC.getTaxType() == 3) {
//            tax = purTax.multiply(itemC.getTaxRate());
//        } else
//            tax = BigDecimal.ZERO;
//
//        itemC.setTax(GlobalPara.getInstance().EcsCal_Rounding_Single(tax));
//        itemC.setSingleWtax(GlobalPara.getInstance().EcsCal_Rounding_Single(purTax));
//        itemC.setSingleNtax(itemC.getSingleWtax().subtract(itemC.getTax()));
//        itemC.setSingleWtax_Original(purTax_Orignal);
//        itemC.setValid_Single((itemC.getSingleWtax().compareTo(BigDecimal.ZERO) != 0) || (GlobalPara.getInstance().getTMS(Fuc_ZeroSale) == 1));
//    }
//
//    /**
//     * @description: 单价追踪重算
//     **/
//     public boolean Item_GetUPrice_Track(ItemContent itemC)           //cal price with VIP-Level && Amount discount. before unit convert
//    {
//        if ((GlobalPara.getInstance().getTMS(Discount_Auto_PriceTrack) <= 0)
//                || GlobalPara.getInstance().getTMS(Discount_Auto_PriceTrack) > 3)
//            return false;
//        if (itemC.isPriceIsManual())
//            return false;
//
//        BigDecimal price = CalPLU_UPrice_VIPed(itemC.getPlu());
//        boolean update = GlobalPara.getInstance().getTMS(Discount_Auto_PriceTrack) == 3;
//
//        Date date = new Date();
//        Calendar calendar = Calendar.getInstance();
//        calendar.setTime(date);
//        int day_week = calendar.get(Calendar.DAY_OF_WEEK);
//        if (calendar.getFirstDayOfWeek() == Calendar.SUNDAY)
//            day_week--;
//        else if (day_week == 7)
//            day_week = 0;
//        day_week = 1 << day_week;
//
//        if (GlobalPara.getInstance().isDiscountAuto_InTime()) {
//            for (int loop = 0; loop < itemC.getPlu().getDa_sort().length; loop++) {
//                if ((itemC.getPlu().getDa_wDay()[loop] & day_week) != 0) {
//                    if (itemC.getPlu().getDa_sort()[loop] == 1) {
//                        if ((itemC.getAmount().compareTo(GlobalPara.getInstance().EcsCal_Unit_WeightConvertSystem(itemC.getPlu().getDa_dLimit()[loop], itemC.getPlu().getUnit())) >= 0)
//                                && (itemC.getAmount().compareTo(GlobalPara.getInstance().EcsCal_Unit_WeightConvertSystem(itemC.getPlu().getDa_uLimit()[loop], itemC.getPlu().getUnit())) <= 0)) {
//                            if (itemC.getPlu().getDa_tarValue()[loop].compareTo(BigDecimal.ZERO) >= 0)
//                                price = itemC.getPlu().getDa_tarValue()[loop];
//                            else
//                                price = price.add(itemC.getPlu().getDa_tarValue()[loop]);
//                        }
//                        update = true;
//                    } else if (itemC.getPlu().getDa_sort()[loop] == 2) {
//                        int hhmm = calendar.get(Calendar.HOUR_OF_DAY) * 100 + calendar.get(Calendar.MINUTE);
//                        if ((hhmm >= itemC.getPlu().getDa_dLimit()[loop].intValue())
//                                && (hhmm <= itemC.getPlu().getDa_uLimit()[loop].intValue())) {
//                            if (itemC.getPlu().getDa_tarValue()[loop].compareTo(BigDecimal.ZERO) >= 0)
//                                price = itemC.getPlu().getDa_tarValue()[loop];
//                            else
//                                price = price.add(itemC.getPlu().getDa_tarValue()[loop]);
//                            update = true;
//                        } else if (GlobalPara.getInstance().getTMS(Discount_Auto_PriceTrack) == 2)
//                            update = true;
//                    } else if (itemC.getPlu().getDa_sort()[loop] == 11) {
//                        if (itemC.getPlu().getDa_tarValue()[loop].compareTo(BigDecimal.ZERO) >= 0)
//                            itemC.setServiceFee(itemC.getPlu().getDa_tarValue()[loop]);
//                    }
//                }
//            }
//        }
//        if (update) {
//            itemC.setPrice(GlobalPara.getInstance().CalPLU_Price_wUnit(price, itemC.getPlu().getUnit()));
//        }
//        return update;
//    }
}
