package com.jhscale.meter.protocol.model;

import com.jhscale.common.em.PayType;
import com.jhscale.common.em.PayWay;
import com.jhscale.common.em.TradeType;
import com.jhscale.common.model.device.UnitType;
import com.jhscale.common.model.device.log.module.DSource;
import com.jhscale.common.model.device.plu.DPLUV5;
import com.jhscale.common.model.device.saleman.DSaleMan;
import com.jhscale.common.model.device.saleman.DSaleManV1;
import com.jhscale.common.model.inter.GJSONModel;
import com.jhscale.common.utils.BigDecimalUtils;
import com.jhscale.common.ysscale.UnitEnum;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.exp.RuntimeMeterException;
import com.jhscale.meter.protocol.constant.TMS;
import com.jhscale.meter.protocol.print.PrintGeneralFactory;
import com.jhscale.meter.protocol.print.entity.PrintResponse;
import com.jhscale.meter.protocol.print.link.IPrintBack;
import com.jhscale.meter.protocol.trade.*;
import com.jhscale.meter.utils.AConstant;

import java.math.BigDecimal;
import java.util.*;

import static com.jhscale.meter.protocol.constant.TMS.*;
import static com.jhscale.meter.utils.MeterConstant.*;

/**
 * @author lie_w
 * @title: TradePipeline
 * @projectName meter-jar
 * @description: TODO
 * @date 2022/12/610:44
 */
public class TradePipeline implements GJSONModel {

    // 交易信息
    private TradeContent tradeContent;

    public TradePipeline() {
        this.Create();
    }

    public TradePipeline(TradeType type, DSaleMan salesman) {
        this.Create(type, salesman);
    }

    public TradePipeline(DSaleMan salesman) {
        this.Create(salesman);
    }

    public TradePipeline(TradeType type) {
        this.Create(type);
    }

    public TradePipeline(int type, DSaleMan salesman) {
        this.Create(type, salesman);
    }

    /**################################################ 开单操作 ##################################################**/

    /**
     * @description: 默认创建销售
     **/
    private TradePipeline Create() {
        return this.Create(TradeType.销售, GlobalPara.getInstance().getSaleMan());
    }

    /**
     * @description: 默认创建销售
     **/
    private TradePipeline Create(DSaleMan salesman) {
        return this.Create(TradeType.销售, salesman);
    }

    /**
     * @description: 开单
     **/
    private TradePipeline Create(TradeType type) {
        return this.Create(type, GlobalPara.getInstance().getSaleMan());
    }

    /**
     * @description: 开单
     **/
    private TradePipeline Create(TradeType type, DSaleMan salesman) {
        return this.Create(type.getType(), salesman);
    }

    /**
     * @description: 开单
     **/
    private TradePipeline Create(int type, DSaleMan salesman) {
        if (salesman == null) salesman = new DSaleManV1<>().setNo(0).setName("");
        this.tradeContent = new TradeContent(type)
                .Total_Salesman_Set(salesman.no(), salesman.getName());
        return this;
    }

    /**
     * @description: 当前交易内容
     */
    public TradeContent Current_TradeContent() throws RuntimeMeterException {
        if (this.tradeContent == null)
            throw new RuntimeMeterException(MeterStateEnum.交易未创建);
        return this.tradeContent;
    }

    /**
     * @description: 当前交易内容
     */
    public TradeContent Current_TradeContent_WOE() {
        if (this.tradeContent == null) this.Create();
        return this.tradeContent;
    }

    /**################################################ 开单操作 ##################################################**/

    /**#################################### 会员操作（可先登陆或结算前登陆） ########################################**/
    /**
     * @description: 会员 卡付 等级|折扣 设置
     **/
    public TradePipeline Total_VIP_Set(char level, int p1w) {
        this.Current_TradeContent_WOE().Total_VIP_Set(level, p1w);
        return this;
    }

    /**
     * @description: 会员 卡付 等级|折扣 重置
     **/
    public TradePipeline Total_VIP_Clear() {
        this.Current_TradeContent_WOE().Total_VIP_Clear();
        return this;
    }
    /**#################################### 会员操作（可先登陆或结算前登陆） ########################################**/

    /**################################################ 单项操作 ##################################################**/

    /**
     * @description: 添加商品检查
     **/
    public boolean Item_New_Check(DPLUV5 content) throws MeterException {
        return GlobalPara.getInstance().EcsCal_MoneyUnitAllowed(content.getUnit());
    }

    /**
     * @param content 商品信息
     * @description: 添加明细
     */
    public ItemContent Item_New(DPLUV5 content) throws RuntimeMeterException {
        // if (!this.Item_New_Check(content))
        //     throw new RuntimeMeterException(MeterStateEnum.所属PLU的单位不被系统允许);
        // 构建明细内容
        ItemContent itemContent = new ItemContent(content, this.Current_TradeContent_WOE());
        WeightCal.getInstance().SetTare_PLUValue(itemContent.getPreTare());
        return itemContent;
    }

    /**
     * @description: 重量内码修改重量信息
     **/
    public ItemContent Item_Set_Weight(ItemContent itemContent, WeightResult wr) throws RuntimeMeterException {
        ItemContent _itemContent = itemContent
                .Item_Set_Weight(wr)
                .Item_ReCal(this.Current_TradeContent_WOE());
        SerialDisplay.getInstance().setItemContentWR(_itemContent, wr);
        return _itemContent;
    }

    /**
     * @description: 读取重量并反馈商品信息
     **/
    @Deprecated
    public ItemContent Item_Set_Weight(ItemContent itemContent, BigDecimal wt) throws RuntimeMeterException {
        ItemContent _itemContent = itemContent
                .Item_Set_Weight(wt, true)
                .Item_ReCal(this.Current_TradeContent_WOE());
        SerialDisplay.getInstance().setItemContentWR(_itemContent);
        return _itemContent;
    }

    /**
     * @description: 读取重量并反馈商品信息
     **/
    public ItemContent Item_Set_Weight(ItemContent itemContent) throws RuntimeMeterException {
        return this.Item_Set_Weight(itemContent, WeightCal.getInstance().GetResult());
    }

    /**
     * @description: 修改数量
     **/
    public ItemContent Item_Set_Count(ItemContent itemContent, BigDecimal pcs) throws RuntimeMeterException {
        ItemContent _itemContent = itemContent
                .Item_Set_Count(pcs)
                .Item_ReCal(this.Current_TradeContent_WOE());
        SerialDisplay.getInstance().setItemContentWR(_itemContent);
        return _itemContent;
    }

    /**
     * @description: 累加数量 +1
     **/
    public ItemContent Item_Set_Count(ItemContent itemContent) throws RuntimeMeterException {
        return this.Item_Set_Count(itemContent, BigDecimal.ONE);
    }

    /**
     * @description: 修改计件取重
     **/
    public ItemContent Item_Set_Amount_Stock(ItemContent itemContent, BigDecimal pcs, WeightResult wr) throws RuntimeMeterException {
        ItemContent _itemContent = itemContent
                .Item_Set_Count(pcs)
                .Item_Set_Amount_Stock(wr)
                .Item_ReCal(this.Current_TradeContent_WOE());
        SerialDisplay.getInstance().setItemContentWR(_itemContent, wr);
        return _itemContent;
    }

    /**
     * @description: 计件取重 修改数量 自动读取重量
     **/
    public ItemContent Item_Set_Amount_Stock(ItemContent itemContent, BigDecimal pcs) throws RuntimeMeterException {
        return this.Item_Set_Amount_Stock(itemContent, pcs, WeightCal.getInstance().GetResult());
    }

    /**
     * @description: 计件取重 修改数量 +1 自动读取重量
     **/
    public ItemContent Item_Set_Amount_Stock(ItemContent itemContent) throws RuntimeMeterException {
        return this.Item_Set_Amount_Stock(itemContent, BigDecimal.ONE, WeightCal.getInstance().GetResult());
    }

    /**
     * @description: 修改单价
     **/
    public ItemContent Item_Set_Price(ItemContent itemContent, BigDecimal price) throws RuntimeMeterException {
        ItemContent _itemContent = itemContent
                .Item_Set_UPrice(price)
                .Item_ReCal(this.Current_TradeContent_WOE());
        SerialDisplay.getInstance().setItemContentWR(_itemContent);
        return _itemContent;
    }

    /**
     * @description: 修改单价
     **/
    public ItemContent Item_Set_Price(ItemContent itemContent, BigDecimal price, int unitPrice) throws RuntimeMeterException {
        ItemContent _itemContent = itemContent
                .Item_Set_UPrice_WithUnit(price, unitPrice)
                .Item_ReCal(this.Current_TradeContent_WOE());
        SerialDisplay.getInstance().setItemContentWR(_itemContent);
        return _itemContent;
    }

    public boolean Item_Check_Price(ItemContent itemContent, BigDecimal price) throws RuntimeMeterException {
        return itemContent.Item_Check_UPrice(price);
    }

    public boolean Item_Check_Price(ItemContent itemContent) throws RuntimeMeterException {
        return itemContent.Item_Check_UPrice();
    }

    /**
     * @description: 确认累计操作检查
     **/
    public boolean Total_AddItem_check(ItemContent itemContent) throws MeterException {
        return itemContent.AddValid();
    }

    /**
     * SP_Sale_Acc_N_Barcode 134 内部条码执行交易时，进入累加模式
     *
     * @description: 添加条码扫码商品
     **/
    public ItemContent Item_Set_Note(ItemContent itemContent, BigDecimal amount, BigDecimal price) {
        itemContent.setSpec(SP_Sale_Acc_N_Barcode);
        ItemContent _itemContent = this.Current_TradeContent().Item_Set_Note(itemContent, amount, price);
        if (_itemContent == null)
            throw new RuntimeMeterException(MeterStateEnum.内部条码无效不允许添加);
        _itemContent.setSpec(SP_Sale_Acc_N_Barcode);
        SerialDisplay.getInstance().setItemContentWR(_itemContent);
        return _itemContent;
    }

    /**
     * SP_Sale_Acc_N_Barcode 134 内部条码执行交易时，进入累加模式
     *
     * @description: 添加条码扫码商品
     **/
    public ItemContent Item_Set_Note(ItemContent itemContent, BarCodeItemResult barCIR) {
        itemContent.setSpec(SP_Sale_Acc_N_Barcode);
        ItemContent _itemContent = this.Current_TradeContent().Item_Set_Note(itemContent, barCIR);
        if (_itemContent == null)
            throw new RuntimeMeterException(MeterStateEnum.内部条码无效不允许添加);
        _itemContent.setSpec(SP_Sale_Acc_N_Barcode);
        SerialDisplay.getInstance().setItemContentWR(_itemContent);
        return _itemContent;
    }

    /**
     * @description: 添加商品现场图片
     **/
    public ItemContent Total_Add_Pics(ItemContent itemContent, String... pics) {
        itemContent.addPics(pics);
        return itemContent;
    }

    /**
     * SP_Sale_Acc_C_Key 132 键盘调用数量PLU时，进入累加模式
     * SP_Sale_Acc_C_Scanner 133 外部条码调用数量PLU时，进入累加模式
     * SP_Sale_Acc_N_Barcode 134 内部条码执行交易时，进入累加模式
     *
     * @description: 确认累计操作 (默认 键盘 调用)
     **/
    public boolean Total_AddItem(ItemContent itemContent) throws RuntimeMeterException {
        if (Objects.isNull(itemContent.getSpec())) itemContent.setSpec(SP_Sale_Acc_C_Key);
        return this.Total_Add_Item(itemContent);
    }

    /**
     * @description: 条码搜索到的商品确认累计操作
     **/
    public boolean Total_AddItem_Index(ItemContent itemContent) throws RuntimeMeterException {
        if (Objects.isNull(itemContent.getSpec())) itemContent.setSpec(SP_Sale_Acc_C_Scanner);
        return this.Total_Add_Item(itemContent);
    }

    /**
     * @param itemContent 添加商品类目(根据商品来源信息添加)
     * @description: 确认累计操作
     **/
    public boolean Total_Add_Item(ItemContent itemContent) throws RuntimeMeterException {
        int tms = GlobalPara.getInstance().getTMS(itemContent.spec());
        TradeContent tradeContent = this.Current_TradeContent_WOE();
        if (tms == SP_Sale_Acc_2 // 0:不进入累加模式|1:进入累加模式(0,1 一样) 2:进入累加模式, 且相同商品自动叠加
                && UnitType.计件.equals(UnitEnum.unit(itemContent.getUnit_weight()).getType())
                && tradeContent.getItem() != null && !tradeContent.getItem().isEmpty()) {
            Iterator<ItemContent> iterator = tradeContent.getItem().iterator();
            while (iterator.hasNext()) {
                ItemContent next = iterator.next();
                if (next != null && next.getPlu().getNo().equals(itemContent.getPlu().getNo())
                        && Objects.nonNull(next.getPrice())
                        && Objects.nonNull(itemContent.getPrice())
                        && BigDecimalUtils.compareEqual(next.getPrice(), itemContent.getPrice())) {
                    itemContent = this.Item_Set_Count(itemContent, next.getAmount().add(itemContent.getAmount()));
                    iterator.remove();
                }
            }
        }
        boolean result = this.ACL_Total_Add_Item(itemContent);
        if (result) SerialDisplay.getInstance().quitItemContent();
        return result;
    }

    /**
     * @description: 确认累计操作
     **/
    private boolean ACL_Total_Add_Item(ItemContent itemContent) throws RuntimeMeterException {
        this.Current_TradeContent().Total_AddItem(itemContent);
        this.Item_Print_Check(itemContent);
        this.Total_QuitItem();
        SerialDisplay.getInstance().quitItemContent();
        return true;
        // if (this.Current_TradeContent().Total_AddItem(itemContent)) {
        //     this.Item_Print_Check(itemContent);
        //     this.Total_QuitItem();
        //     SerialDisplay.getInstance().quitItemContent();
        //     return true;
        // } else {
        //     throw new RuntimeMeterException(MeterStateEnum.规则不允许添加累计);
        // }
    }

    /**
     * @description: 检查标签打印内容
     **/
    private void Item_Print_Check(ItemContent itemContent) {
        int fucPrint = GlobalPara.getInstance().getTMS(TMS.Fuc_Print);

        if ((fucPrint == Fuc_Print7 && itemContent.spec() != SP_Sale_Acc_N_Barcode)
                || ((fucPrint == Fuc_Print8 || fucPrint == Fuc_Print9) && itemContent.spec() == SP_Sale_Acc_C_Key)) {
            if (GlobalPara.getInstance().isRunLog())
                System.out.println("Item_Print_Check Double Print Need");
            try {
                TradePipeline pipeline = new TradePipeline();
                TradeContent tradeContent = pipeline.Current_TradeContent_WOE();
                tradeContent.setTradeTime(new Date());
                tradeContent.Total_AddItem(itemContent);
                pipeline.Settlement_Once(new CashSettlement(tradeContent.Total_Cal_LeftPay()));
                //按照流程打印
                tradeContent.printCalculate(-1, 0);
                PrintGeneralFactory.getInstance().print_answer(tradeContent.getPrintContents(), new IPrintBack() {
                    /**
                     * @param response
                     * @description: 操作结果响应原始信息
                     */
                    @Override
                    public void responseBack(PrintResponse response) {
                        if (GlobalPara.getInstance().isRunLog())
                            System.out.println("Item_Print_Check Double Print Need" + response.toString());
                    }
                });
            } catch (MeterException e) {
                e.printStackTrace();
            }
        }
    }

    /**################################################ 单项操作 ##################################################**/

    /**
     * ################################################ 单笔完结 ##################################################
     **/

    /**
     * @description: 整单改价
     **/
    public TradeContent Total_Set_Discount(BigDecimal total) {
        return this.Current_TradeContent_WOE()
                .Total_Set_Discount(total);
    }

    public boolean Total_Check_Discount(BigDecimal total) {
        return this.Current_TradeContent_WOE()
                .Total_Check_Discount(total);
    }

    public boolean Total_Check_Discount() {
        return this.Current_TradeContent_WOE()
                .Total_Check_Discount();
    }

    /**
     * @description: 交易完结 （单次全部结算） Settlement_All | Settlement_Once 不共用
     **/
    public TradeContent Settlement_All(int fid, int sid, DeviceSettlement... settlements) throws RuntimeMeterException {
        return this.settlement(this.Current_TradeContent_WOE(), settlements)
                .Current_TradeContent_WOE()
                .Total_Close(fid, sid)
                .printCalculate()
                .Total_Log();
    }

    /**
     * @description: 交易完结 （分批结算） Settlement_All | Settlement_Once 不共用
     **/
    public TradeContent Settlement_Once(DeviceSettlement... settlements) throws RuntimeMeterException {
        return this.settlement(this.Current_TradeContent_WOE(), settlements)
                .Current_TradeContent_WOE();
    }

    /**
     * @description: 剩余支付金额
     **/
    public BigDecimal Settlement(DeviceSettlement... settlements) throws RuntimeMeterException {
        BigDecimal pay_Available = BigDecimal.ZERO;
        if (settlements != null) {
            for (DeviceSettlement settlement : settlements) {
                switch (settlement.getType()) {
                    case 现金:
                        pay_Available = pay_Available.add(((CashSettlement) settlement).cash());
                        break;
                    case 聚合支付:
                        pay_Available = pay_Available.add(((CloudPaySettlement) settlement).cloudPay());
                        break;
                    case 吉卡云:
                        pay_Available = pay_Available.add(((JKYSettlement) settlement).jkyPay())
                                .add(((JKYSettlement) settlement).jkyPay_Gift())
                                .add(((JKYSettlement) settlement).getCash());
                        break;
                    case 卡付:
                        pay_Available = pay_Available.add(((CardSettlement) settlement).cardPay());
                        break;
                    case 其他支付:
                        pay_Available = pay_Available.add(((OtherPaySettlement) settlement).other1())
                                .add(((OtherPaySettlement) settlement).other2())
                                .add(((OtherPaySettlement) settlement).other3());
                        break;
                }
            }
        }
        return this.Current_TradeContent_WOE().Total_Cal_LeftPay(pay_Available);
    }

    /**
     * @description: 交易完结(生成日志 ， 会员登出 ， 打印)
     **/
    public TradeContent Settlement(int fid, int sid) throws RuntimeMeterException {
        return this.Current_TradeContent_WOE()
                .Total_Close(fid, sid)
                .printCalculate()
                .Total_Log();
    }

    /**
     * @description: 云支付 未知支付
     **/
    public TradeContent CP_Total_UnKnow_Item(int fid, int sid) throws RuntimeMeterException {
        return this.Total_UnKnow_Item(fid, sid, CloudPaySettlement.class, CP_UN_KNOW_ERROR_CODE, CP_UN_KNOW_ERROR_MSG);
    }

    /**
     * @description: 吉卡云 未知支付
     **/
    public TradeContent JKY_Total_UnKnow_Item(int fid, int sid) throws RuntimeMeterException {
        return this.Total_UnKnow_Item(fid, sid, JKYSettlement.class, JKY_UN_KNOW_ERROR_CODE, JKY_UN_KNOW_ERROR_MSG);
    }

    /**
     * @description: 卡付 未知支付
     **/
    public TradeContent Card_Total_UnKnow_Item(int fid, int sid) throws RuntimeMeterException {
        return this.Total_UnKnow_Item(fid, sid, CardSettlement.class, Card_UN_KNOW_ERROR_CODE, Card_UN_KNOW_ERROR_MSG);
    }

    /**
     * @description: 其他 未知支付
     **/
    public TradeContent Other_Total_UnKnow_Item(int fid, int sid) throws RuntimeMeterException {
        return this.Total_UnKnow_Item(fid, sid, OtherPaySettlement.class, Other_UN_KNOW_ERROR_CODE, Other_UN_KNOW_ERROR_MSG);
    }

    /**
     * @description: 未知支付
     **/
    public <T extends DeviceSettlement> TradeContent Total_UnKnow_Item(int fid, int sid, Class<T> settlementClazz, String errorCode, String errorMsg) throws RuntimeMeterException {
        DeviceSettlement settlement = null;
        try {
            settlement = settlementClazz.newInstance();
        } catch (Exception e) {
            settlement = new CashSettlement();
        }
        BigDecimal leftPay = this.Current_TradeContent_WOE().Total_Cal_LeftPay();
        if (settlement instanceof CloudPaySettlement) {
            ((CloudPaySettlement) settlement).setCloudPay(leftPay);
            ((CloudPaySettlement) settlement).setPayWay(PayWay.Aggregate_PAY);
            ((CloudPaySettlement) settlement).setPayType(PayType.UNKNOWN_PAY);
            ((CloudPaySettlement) settlement).setBillId("");
        } else if (settlement instanceof JKYSettlement) {
            ((JKYSettlement) settlement).setJkyPay(leftPay);
        } else if (settlement instanceof CardSettlement) {
            ((CardSettlement) settlement).setCardPay(leftPay);
        } else if (settlement instanceof OtherPaySettlement) {
            ((OtherPaySettlement) settlement).setOther1(leftPay);
        } else {
            ((CashSettlement) settlement).setCash(leftPay);
        }
        return this.settlement(this.Current_TradeContent_WOE(), settlement)
                .Total_Error(fid, sid, errorCode, errorMsg);
    }

    /**
     * @description: 明细移除生成清除数据(完成流程)
     **/
    public TradeContent Total_RemoveItem(int fid, int sid, Integer... indexes) throws RuntimeMeterException {
        List<ItemContent> itemContents = this.Current_TradeContent_WOE().Total_RemoveItem(indexes);
        return this.Total_RemoveItem(fid, sid, itemContents);
    }

    /**
     * @description: 明细移除生成清除数据(只是移除)
     **/
    public List<ItemContent> Total_RemoveItem(Integer... indexes) throws RuntimeMeterException {
        return this.Current_TradeContent_WOE().Total_RemoveItem(indexes);
    }

    /**
     * @description: 明细移除生成清除数据(根据移除的item创建新的交易信息)
     **/
    public TradeContent Total_RemoveItem(int fid, int sid, List<ItemContent> itemContents) throws RuntimeMeterException {
        return new TradePipeline(TradeType.清除)
                .Current_TradeContent()
                .Total_AddItem(itemContents)
                .Total_Close(fid, sid)
                .printCalculate()
                .Total_Log();
    }

    /**
     * @description: 错误日志
     **/
    public TradeContent Total_Error(int fid, int sid, String error_code, String error_msg) {
        return this.Current_TradeContent_WOE()
                .toObject(TradeContent.class)
                .tradeType(TradeType.错误日志)
                .Total_Close(fid, sid, error_code, error_msg)
                .printCalculate()
                .Total_Log();
    }

    /**
     * @description: 错误日志
     **/
    public TradeContent Total_New_Error(int fid, int sid, String error_code, String error_msg) {
        return new TradePipeline(TradeType.错误日志)
                .Current_TradeContent_WOE()
                .Total_Close(fid, sid, error_code, error_msg)
                .printCalculate()
                .Total_Log();
    }

    /**
     * @description: 未确认
     * 触发条件 商品秤重界面 根据重量回调 一直触发
     **/
    public TradeUnconfirmed Item_Unconfirmed(ItemContent itemContent, WeightResult wr, boolean cancel) throws MeterException {
        if (itemContent == null) return new TradeUnconfirmed();

        if (UnitType.计重.equals(UnitEnum.unit(itemContent.getPlu().getUnit()).getType())) {
            if ((wr != null && itemContent.ItemHasUnconfirmed(wr)) || cancel) {
                TradeContent tradeUnconfirmed = new TradePipeline(TradeType.未确认).Current_TradeContent();
                ItemContent itemCodeUnconfirmed = new ItemContent(itemContent.getPlu(), tradeUnconfirmed)
                        .Item_Set_UPrice(itemContent.getPrice_Unconfirmed())
                        .Item_Set_Weight(itemContent.getAmount_Unconfirmed(), true)
                        .Item_ReCal(tradeUnconfirmed);
                boolean add_status = tradeUnconfirmed.Total_AddItem(itemCodeUnconfirmed);
                //未确认已使用，清空缓冲的Unconfirmed信息
                itemContent.setAmount_Unconfirmed(BigDecimal.ZERO);
                itemContent.setPrice_Unconfirmed(BigDecimal.ZERO);
                return new TradeUnconfirmed(add_status, tradeUnconfirmed, GlobalPara.getInstance().getTMS(TMS.SP_Unconfirmed) == 3);
            }
        } else {
            TradeContent tradeUnconfirmed = new TradePipeline(TradeType.未确认).Current_TradeContent();
            ItemContent itemCodeUnconfirmed = new ItemContent(itemContent.getPlu(), tradeUnconfirmed)
                    .Item_Set_UPrice(itemContent.getPrice_Unconfirmed())
                    .Item_Set_Count(itemContent.getAmount_Unconfirmed())
                    .Item_ReCal(tradeUnconfirmed);
            boolean add_status = tradeUnconfirmed.Total_AddItem(itemCodeUnconfirmed);
            //未确认已使用，清空缓冲的Unconfirmed信息
            itemContent.setAmount_Unconfirmed(BigDecimal.ZERO);
            itemContent.setPrice_Unconfirmed(BigDecimal.ZERO);
            return new TradeUnconfirmed(add_status, tradeUnconfirmed, GlobalPara.getInstance().getTMS(TMS.SP_Unconfirmed) == 3);
        }
        return new TradeUnconfirmed();
    }

    /**
     * @description: 未确认 秤重日志
     * 秤重界面 根据秤重信息 触发回调 执行
     **/
    public TradeUnconfirmed Weight_Notify_Call(ItemContent itemContent, WeightResult wr) throws MeterException {
        return this.Item_Unconfirmed(this.Item_Set_Weight(itemContent, wr), wr, false);
    }

    /**
     * @description: 未确认 秤重日志
     * 未确定交易 点击叉或者返回 退出商品秤重触发
     **/
    public TradeContent Item_Quit(ItemContent itemContent) throws MeterException {
        TradeUnconfirmed tradeUnconfirmed = this.Item_Unconfirmed(itemContent, null, true);
        return tradeUnconfirmed != null && tradeUnconfirmed.isStatus() ? tradeUnconfirmed.getUnconfirmed() : null;
    }

    /**
     * @description: 商品累计退出
     **/
    private TradePipeline Total_QuitItem() {
        // PLU退出，清除PLU去皮
        WeightCal.getInstance().SetTare_PLUReset();
        // 单位重置
        GlobalPara.getInstance().getPriceUNIT_Hold();
        return this;
    }
    /**################################################ 单笔完结 ##################################################**/

    /**
     * @description: 预结算
     **/
    private TradePipeline settlement(TradeContent tradeContent, DeviceSettlement... settlements) {
        if (settlements != null) {
            for (DeviceSettlement settlement : settlements) {
                switch (settlement.getType()) {
                    case 现金:
                        tradeContent.Total_Pay_Cash(((CashSettlement) settlement).getCash());
                        break;
                    case 聚合支付:
                        CloudPaySettlement cloudPaySettlement = (CloudPaySettlement) settlement;
                        tradeContent.Total_Pay_Cloud(cloudPaySettlement.getCloudPay(),
                                cloudPaySettlement.payWay(),
                                cloudPaySettlement.payType(),
                                cloudPaySettlement.getPayType().getDescription(),
                                cloudPaySettlement.getBillId());
                        break;
                    case 吉卡云:
                        JKYSettlement jkySettlement = (JKYSettlement) settlement;
                        tradeContent.Total_Pay_JKY(jkySettlement.getJkyPay().add(jkySettlement.getJkyPay_Gift()),
                                jkySettlement.getJkyPay_Gift(),
                                jkySettlement.getPoint(),
                                jkySettlement.getBalanceOld(),
                                jkySettlement.getBalanceNew(),
                                jkySettlement.getAccount());
                        // .Total_Pay_Cash(jkySettlement.getCash());
                        break;
                    case 卡付:
                        CardSettlement cardSettlement = (CardSettlement) settlement;
                        tradeContent.Total_Pay_Card(cardSettlement.getCardPay(),
                                cardSettlement.getPoint(),
                                cardSettlement.getBalanceOld(),
                                cardSettlement.getBalanceNew(),
                                cardSettlement.getId(),
                                cardSettlement.getId_p1(),
                                cardSettlement.getId_p2());
                        break;
                    case 其他支付:
                        OtherPaySettlement otherPaySettlement = (OtherPaySettlement) settlement;
                        tradeContent.Total_Pay_Other1(otherPaySettlement.getOther1())
                                .Total_Pay_Other2(otherPaySettlement.getOther2())
                                .Total_Pay_Other3(otherPaySettlement.getOther3());
                        break;
                }
            }
        }
        return this;
    }

    /**################################################ 退货操作 ##################################################**/
    /**
     * @description: 退货
     **/
    public TradeReject Item_Reject(TradeContent inputTrade, DSaleMan salesman, int... items) throws MeterException {
        if (!TradeType.销售.getType().equals(inputTrade.getTradeType()))
            return new TradeReject();

        List<ItemContent> itemContents = new ArrayList<>();
        if (items != null && items.length > 0) {
            for (int item : items) {
                ItemContent itemContent = inputTrade.getItem().remove(item);
                if (itemContent != null && !itemContent.reject()) {
                    itemContents.add(itemContent.toObject(ItemContent.class));
                    itemContent.setReject(AConstant.REJECT);
                }
            }
        } else {
            for (ItemContent itemContent : inputTrade.getItem()) {
                if (!itemContent.reject()) {
                    itemContents.add(itemContent.toObject(ItemContent.class));
                    itemContent.setReject(AConstant.REJECT);
                }
            }
        }

        if (!itemContents.isEmpty()) {
            boolean isAll = true;
            for (ItemContent itemContent : inputTrade.getItem()) {
                isAll = isAll && itemContent.reject();
            }

            //需要一个当前营业员的全局变量, 不能用原交易的营业员
            TradeContent rejectTrade = this.Create(TradeType.退货, salesman)
                    .Current_TradeContent()
                    .setSource(new DSource()
                            // .setUnique(GlobalPara.getInstance().) todo 跨设备退款
                            .setFid(inputTrade.getFid())
                            .setTradeTime(inputTrade.getTradeTime()));

            for (ItemContent itemContent : itemContents) {
                ItemContent itemReject = new ItemContent(itemContent.getPlu(), rejectTrade);
                itemReject.Item_Set_UPrice(itemContent.getPrice())
                        .setPrice_Original(itemContent.getPrice()); //为了不计算原价
                if (UnitType.计重.equals(UnitEnum.unit(itemContent.getPlu().getUnit()))) {
                    itemReject.Item_Set_Weight(itemContent.getAmount().negate(), true);
                } else {
                    if (BigDecimalUtils.compareMoreZeroValue(itemContent.getAmount_Stock())) {
                        itemContent.Item_Set_Count_Negate(itemContent.getAmount().negate())
                                .Item_Set_Amount_Stock(itemContent.getAmount_Stock().negate());
                    } else {
                        itemContent.Item_Set_Count(itemContent.getAmount().negate());
                    }
                }
                rejectTrade.Total_AddItem(itemReject);
            }

            if (isAll) {
                rejectTrade.Total_Set_Discount(inputTrade.getSurplus_Reject().negate());
                inputTrade.setSurplus_Reject(BigDecimal.ZERO);
            } else {
                BigDecimal reject_PurTax_Final = rejectTrade.getPurTax_Final().negate();
                if (BigDecimalUtils.compareValue(inputTrade.getSurplus_Reject(), reject_PurTax_Final) >= 0) {
                    inputTrade.setSurplus_Reject(inputTrade.getSurplus_Reject().subtract(reject_PurTax_Final));
                } else {
                    rejectTrade.Total_Set_Discount(inputTrade.getSurplus_Reject().negate());
                    inputTrade.setSurplus_Reject(BigDecimal.ZERO);
                }
            }
            return new TradeReject(inputTrade, rejectTrade);
        }
        return new TradeReject();
    }
    /**################################################ 退货操作 ##################################################**/

    /**################################################ 静态方法 ##################################################**/
    /**
     * @description: 添加Fid Sid 生成日志
     **/
    public static TradeContent Add_Fid_Sid(TradeContent tradeContent, int fid, int sid) {
        tradeContent.Total_Close(fid, sid)
                .Total_Log();
        return tradeContent;
    }

    /**
     * @description: 生成打印信息
     **/
    public static TradeContent Execute_Print(TradeContent tradeContent) {
        tradeContent.printCalculate();
        return tradeContent;
    }


    /**################################################ 静态方法 ##################################################**/

    /**################################################ 秤重管理 ##################################################**/
    /**
     * @description: 仪表重量信息
     **/
    public static WeightResult Weight_Info() {
        return WeightCal.getInstance().GetResult();
    }

    // todo 秤重未选择商品 未确认日志

    /**
     * @description: 去皮
     **/
    public static void SetTare_Button() {
        WeightCal.getInstance().SetTare_Button();
    }

    /**
     * @description: 置零
     **/
    public static void SetZero_Button() {
        WeightCal.getInstance().SetZero_Button();
    }

    /**
     * @description: 强制置零
     **/
    public static void SetZero_Force() {
        WeightCal.getInstance().SetZero_Force();
    }

    /**################################################ 秤重管理 ##################################################**/
}
