package com.jhscale.meter.protocol.model;

import com.jhscale.common.model.inter.GJSONModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author lie_w
 * @title: TradeUnconfirmed
 * @projectName meter-jar
 * @description: TODO
 * @date 2023/1/1118:03
 */
@ApiModel("退款交易")
public class TradeReject implements GJSONModel {

    @ApiModelProperty(value = "退货结果", name = "result")
    private boolean result;

    @ApiModelProperty(value = "原交易信息", name = "inputTrade")
    private TradeContent inputTrade;

    @ApiModelProperty(value = "退货交易信息", name = "rejectTrade")
    private TradeContent rejectTrade;

    public TradeReject() {
    }

    /**
     * @description: 默认成功构造函数
     **/
    public TradeReject(TradeContent inputTrade, TradeContent rejectTrade) {
        this.result = true;
        this.inputTrade = inputTrade;
        this.rejectTrade = rejectTrade;
    }

    public boolean isResult() {
        return result;
    }

    public void setResult(boolean result) {
        this.result = result;
    }

    public TradeContent getInputTrade() {
        return inputTrade;
    }

    public void setInputTrade(TradeContent inputTrade) {
        this.inputTrade = inputTrade;
    }

    public TradeContent getRejectTrade() {
        return rejectTrade;
    }

    public void setRejectTrade(TradeContent rejectTrade) {
        this.rejectTrade = rejectTrade;
    }
}
