package com.jhscale.meter.protocol.model;

import com.jhscale.common.model.inter.GJSONModel;
import com.jhscale.common.utils.ProtectKey;
import com.jhscale.common.utils.SystemtUtils;
import com.jhscale.meter.em.WeighingMode;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.io.control.DeviceControl;
import com.jhscale.meter.model.device.Device;
import com.jhscale.meter.model.device.SealLeadStatus;
import com.jhscale.meter.protocol.IProtocolManager;
import com.jhscale.meter.protocol.IProtocolResponse;
import com.jhscale.meter.protocol.ad.ADScaleProtocolManager;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyRequest;
import com.jhscale.meter.protocol.ad.entity.ADPackDisassemblyResponse;
import com.jhscale.meter.protocol.ad.entity.assembly.*;
import com.jhscale.meter.protocol.ad.entity.disassembly.*;
import com.jhscale.meter.protocol.constant.TMS;
import com.jhscale.meter.protocol.entity.IPackResponse;
import com.jhscale.meter.seal.SealManager;
import com.jhscale.meter.seal.cmd.ObtainStatusResponse;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.*;

import static com.jhscale.meter.protocol.constant.TMS.*;
import static com.jhscale.meter.protocol.model.MeterDBService.LEAD;
import static java.lang.Integer.max;
import static java.lang.Integer.min;

/**
 * @author lie_w
 * @title: PrintContent
 * @projectName hardware-core
 * @description: TODO
 * @date 2022/8/820:06
 */
@ApiModel("重量计算")
public class WeightCal implements IProtocolResponse, GJSONModel {

    @ApiModelProperty(value = "强制去皮范围", name = "tareLimit")
    private BigDecimal tareLimit = null;

    @ApiModelProperty(value = "lb满量程内码", name = "lb_codeFull")
    private int lb_codeFull = 300000;
    @ApiModelProperty(value = "lb量程信息", name = "lb_mn")
    private WeightMN lb_mn = new WeightMN(3, 60000, 30000, 0, 20, 10, 0);

    @ApiModelProperty(value = "kg满量程内码", name = "kg_codeFull")
    private int kg_codeFull = 300000;
    @ApiModelProperty(value = "kg量程信息", name = "kg_mn")
    private WeightMN kg_mn = new WeightMN(3, 30000, 15000, 0, 10, 5, 0);

    @ApiModelProperty(value = "g满量程内码", name = "g_codeFull")
    private int g_codeFull = 300000;
    @ApiModelProperty(value = "kg量程信息", name = "g_mn")
    private WeightMN g_mn = new WeightMN(3, 30000, 15000, 0, 10, 5, 0);

    @ApiModelProperty(value = "满量程内码", name = "codeFull")
    private int codeFull = 300000;
    @ApiModelProperty(value = "分度信息", name = "mn")
    private WeightMN mn = new WeightMN(3, 30000, 15000, 0, 10, 5, 0);

    @ApiModelProperty(value = "标定内码", name = "codeFromCalibrate")
    private int codeFromCalibrate = 0;
    @ApiModelProperty(value = "开机零点内码", name = "codeOfZeroStart")
    private int codeOfZeroStart = 0;
    @ApiModelProperty(value = "当前零点内码", name = "codeOfZeroCurrent")
    private int codeOfZeroCurrent = 0;
    @ApiModelProperty(value = "开机完成标志", name = "finishOfZeroStart")
    private boolean finishOfZeroStart = false;
    // @ApiModelProperty(value = "执行零点标志", name = "runZeroED")
    // private boolean runZeroED = false;
    // @ApiModelProperty(value = "上次执行零点时间", name = "runZeroLast")
    // private Long runZeroLast = null;

    @ApiModelProperty(value = "毛重内码", name = "codeOfGross")
    private int codeOfGross = 0;
    @ApiModelProperty(value = "皮重内码", name = "codeOfTare")
    private int codeOfTare = 0;

    @ApiModelProperty(value = "皮重是否预置", name = "tareIsPreset")
    private boolean tareIsPreset = false;
    @ApiModelProperty(value = "皮重内码_手动", name = "codeOfTare_Manual")
    private int codeOfTare_Manual = 0;
    @ApiModelProperty(value = "皮重内码_PLU", name = "codeOfTare_PLU")
    private int codeOfTare_PLU = 0;
    @ApiModelProperty(value = "稳定", name = "stable")
    private boolean stable = true;

    @ApiModelProperty(value = "ADC错误", name = "adc")
    private boolean adc = false;

    @ApiModelProperty(value = "已使用的重量", name = "usedGross")
    private BigDecimal usedGross = BigDecimal.ZERO;
    @ApiModelProperty(value = "已使用重量对应的PLU", name = "usedGross_PLU")
    private int usedGross_PLU = 0;
    @ApiModelProperty(value = "已使用后的最小重量", name = "minAfterUsedGross")
    private BigDecimal minAfterUsedGross = BigDecimal.ZERO;

    @ApiModelProperty(value = "新结果", name = "newResult")
    private boolean newResult = false;

    @ApiModelProperty(value = "重量零点", name = "weightZero")
    public BigDecimal weightZero = new BigDecimal("0.000");
    @ApiModelProperty(value = "重量满量程", name = "weightFull_0")
    public BigDecimal weightFull_0 = new BigDecimal("30.000");
    @ApiModelProperty(value = "重量量程1", name = "weightFull_1")
    public BigDecimal weightFull_1 = new BigDecimal("30.000");
    @ApiModelProperty(value = "重量量程2", name = "weightFull_2")
    public BigDecimal weightFull_2 = new BigDecimal("30.000");

    @ApiModelProperty(value = "重量分度0", name = "weightDegree_0")
    public BigDecimal weightDegree_0 = new BigDecimal("0.010");
    @ApiModelProperty(value = "重量分度1", name = "weightDegree_1")
    public BigDecimal weightDegree_1 = new BigDecimal("0.010");
    @ApiModelProperty(value = "重量分度2", name = "weightDegree_2")
    public BigDecimal weightDegree_2 = new BigDecimal("0.010");


    // @ApiModelProperty(value = "零点判定范围", name = "zeroJudge")
    // private int zeroJudge = 6;
    // @ApiModelProperty(value = "皮净毛的相关性", name = "tms103")
    // private int tms103 = 3;
    // @ApiModelProperty(value = "精度等级", name = "tms213")
    // private int tms213 = 0;
    // @ApiModelProperty(value = "判零范围", name = "tms223")
    // private int tms223 = 4;
    // @ApiModelProperty(value = "跟零范围", name = "tms224")
    // private int tms224 = 4;
    // @ApiModelProperty(value = "稳定范围", name = "tms225")
    // private int tms225 = 5;
    // @ApiModelProperty(value = "去皮规则", name = "tms68")
    // private int tms68 = 1;                                   //Spec68: Range 0-3
    // @ApiModelProperty(value = "单次置零范围", name = "tms221")
    // private int tms221 = 2;
    // @ApiModelProperty(value = "累计置零范围", name = "tms222")
    // private int tms222 = 2;
    // @ApiModelProperty(value = "置零去皮相关性", name = "tms286")
    // private int tms286 = 0;

    @ApiModelProperty(value = "系统重量单位", name = "weightUNIT")
    private int weightUNIT = 3;

    @ApiModelProperty(value = "精度数值", name = "maxDegrees")
    private int maxDegrees = 3000;

    @ApiModelProperty(value = "稳定内码数", name = "codeForStable")
    private int codeForStable = 50;
    @ApiModelProperty(value = "跟零内码数", name = "codeForZeroTrack")
    private int codeForZeroTrack = 50;
    @ApiModelProperty(value = "判零内码数", name = "codeForZeroJudge")
    private int codeForZeroJudge = 50;
    @ApiModelProperty(value = "零点判定在净重执行", name = "zeroJudge_InNET")
    private boolean zeroJudge_InNET = false;

    private static final int[] const_division = new int[]{1, 2, 2, 5, 5, 10, 10, 20, 20, 50, 50, 100, 100, 200, 200};
    private static final int[] const_division_mid = new int[]{1, 1, 2, 2, 5, 5, 10, 10, 20, 20, 50, 50, 100, 100, 200};
    private static final int[] const_cap_p1 = new int[]{0, 2, 5, 6, 8, 10, 15, 15, 16, 20, 25, 25, 25, 30, 30, 30, 35, 35, 40, 40, 40, 45, 45, 50, 50, 50, 55, 55, 60, 60, 60, 70, 70, 70, 80, 80, 80, 80, 90, 90, 90, 90, 90, 90, 90, 90, 95, 95, 100, 100, 100, 110, 110, 120, 120, 130, 130, 140, 140, 140, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 160, 170, 180, 190, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200};
    private static final int[] const_cap_p2 = new int[]{0, 5, 10, 15, 20, 25, 30, 30, 35, 40, 50, 50, 50, 60, 60, 60, 80, 80, 80, 90, 90, 90, 90, 100, 100, 100, 110, 120, 130, 140, 150, 150, 150, 160, 160, 160, 160, 170, 180, 190, 200, 200, 200, 200, 200, 200, 210, 220, 230, 240, 250, 250, 250, 250, 250, 260, 260, 270, 280, 290, 300, 300, 300, 300, 300, 300, 300, 300, 300, 300, 300, 300, 300, 300, 300, 300, 320, 320, 330, 340, 350, 350, 350, 350, 350, 350, 350, 350, 400, 400, 400, 400, 400, 400, 400, 400, 400, 400, 400, 400};

    // 通讯器
    private IProtocolManager protocolManager;

    // 通讯回调
    private List<WeightNotify> weightNotifies;

    // 日志
    private boolean run;

    private WeightCal() {
    }

    private static class SingleWeightCal {
        private static final WeightCal SINGLETON = new WeightCal();
    }

    public static WeightCal getInstance() {
        return SingleWeightCal.SINGLETON;
    }

    public boolean isRun() {
        return run;
    }

    public void setRun(boolean run) {
        this.run = run;
    }

    public BigDecimal getUsedGross() {
        return usedGross;
    }

    public BigDecimal getTareLimit() {
        return tareLimit;
    }

    public void setTareLimit(BigDecimal tareLimit) {
        this.tareLimit = tareLimit;
    }

    /**
     * @description: 初始化通讯器 ngff
     **/
    public WeightCal Init_Manager(DeviceControl control, Device device) throws MeterException {
        if (Objects.isNull(control))
            throw new MeterException(MeterStateEnum.控制器不存在);
        if (Objects.isNull(device))
            throw new MeterException(MeterStateEnum.通讯设备不存在);
        this.protocolManager = new ADScaleProtocolManager().initPortmanager(control, device, this);
        this.protocolManager.openPort();
        this.debug = false;
        this.Init_Command();
        this.schedule();
        return this;
    }

    // public WeightCal Init_Manager(ADScaleProtocolManager manager) throws MeterException {
    //     if (Objects.isNull(manager))
    //         throw new MeterException(MeterStateEnum.通讯器未初始化);
    //     this.protocolManager = manager;
    //     this.Init_Command();
    //     this.schedule();
    //     return this;
    // }

    /**
     * @description: 关闭方法
     * @date: 2024-08-16 17:15:28
     **/
    public WeightCal close() throws MeterException {
        if (this.protocolManager != null) {
            this.protocolManager.closePort();
        }

        if (this.leadStatusTimer != null) {
            this.leadStatusTimer.cancel();
        }

        this.token = null;
        this.temp = null;
        this.debug = false;

        if (this.weightNotifies != null) {
            this.weightNotifies = null;
        }
        return this;
    }

    // 循环启动器
    private Timer leadStatusTimer;
    private ProtectKey.Token token;
    // 临时铅封放行
    private ProtectKey.Token temp;
    private boolean debug;

    // 升级状态
    private boolean upgrade;

    public boolean isUpgrade() {
        return upgrade;
    }

    public void setUpgrade(boolean upgrade) {
        this.upgrade = upgrade;
    }

    /**
     * @description: 开启调度器
     * @date: 2024-08-16 14:19:33
     **/
    private void schedule() {
        if (!GlobalPara.getInstance().Lead_Check()) return;
        try {
            String value = GlobalPara.getInstance().db_find(LEAD);
            if (StringUtils.isNotBlank(value)) {
                if (SealManager.getInstance().validate()) {
                    GlobalPara.getInstance().db_delete(LEAD);
                } else {
                    this.token = new ProtectKey.Token(value);
                }
            }
        } catch (Exception e) {
            System.out.printf("Schedule Error: %s%n", e.getMessage());
        }

        this.leadStatusTimer = new Timer();
        this.leadStatusTimer.schedule(new TimerTask() {
            @Override
            public void run() {
                if (!upgrade) obtainLeadStatus();
            }
        }, 5000, 30000);
    }

    /**
     * @description:查询电子铅封解锁信息
     * @date: 2024-08-16 15:53:32
     **/
    public LeadInfo leadInfo() {
        return this.token != null ? new LeadInfo(this.token.getT2(), GlobalPara.getInstance().getSystemID()) : null;
    }

    /**
     * @description: 获取临时铅封放行 验证码
     * @date: 2024-09-09 16:44:40
     **/
    public LeadInfo tempLeadInfo() {
        this.temp = ProtectKey.obtainToken(3);
        return new LeadInfo(this.temp.getT2(), GlobalPara.getInstance().getSystemID());
    }

    /**
     * @description: 首次发送日志
     * @date: 2024-08-21 16:35:33
     **/
    public synchronized boolean firstLog() {
        boolean first = this.token != null && !this.token.getAndSet();
        if (first) GlobalPara.getInstance().db_insert(LEAD, this.token.content());
        return first;
    }

    /**
     * @description:铅封重新封塑检查
     * @date: 2024-08-16 15:53:32
     **/
    public boolean leadCheck(String t1) {
        if (this.token == null) {
            return true;
        } else {
            if (StringUtils.isNotBlank(t1) && t1.equals(this.token.getT1())) {
                SealLeadStatus status = this.obtainLeadStatus();
                if (Objects.nonNull(status) && status.isStatus()) {
                    // 未开盖
                    this.token = null;
                    GlobalPara.getInstance().db_delete(LEAD);
                    return true;
                }
            }
            return false;
        }
    }

    /**
     * @description:铅封重新封塑检查
     * @date: 2024-08-16 15:53:32
     **/
    public boolean leadCheck() {
        if (this.token == null) {
            return true;
        } else {
            SealLeadStatus status = this.obtainLeadStatus();
            if (Objects.nonNull(status) && status.isStatus()) {
                // 未开盖
                this.token = null;
                GlobalPara.getInstance().db_delete(LEAD);
                return true;
            }
            return false;
        }
    }

    /**
     * @description: 临时铅封放行
     * @date: 2024-09-09 16:45:16
     **/
    public boolean tempLeadCheck(String t1) {
        if (this.temp == null || StringUtils.isBlank(t1)) return false;
        if (t1.equals(this.temp.getT1())) {
            this.debug = true;
            return true;
        } else {
            return false;
        }
    }

    /**
     * @return
     * @description: 读取铅封状态
     * @date: 2024-08-16 14:31:56
     */
    public SealLeadStatus obtainLeadStatus() {
        boolean result = GlobalPara.getInstance().Lead_Check();
        if (!result) return new SealLeadStatus().setStatus(true);
        if (SealManager.getInstance().validate()) {
            ObtainStatusResponse statusResponse = SealManager.getInstance().status();
            if (statusResponse != null && !statusResponse.statusOK() && this.token == null) {
                GlobalPara.getInstance().Write_Log("蓝牙铅封", statusResponse.toJSON());

                // 已开盖
                this.token = ProtectKey.obtainToken(3);
                GlobalPara.getInstance().db_insert(LEAD, this.token.content());
            }
            return new SealLeadStatus()
                    .setStatus(statusResponse == null || statusResponse.statusOK())
                    .setContent(Objects.nonNull(statusResponse) ? statusResponse.getStatus() : null)
                    .setId(Objects.nonNull(statusResponse) ? statusResponse.getUid() : null);
        } else {
            ObtainLeadStatusADPDResponse execute = this.execute(new ObtainLeadStatusADPARequest(), ObtainLeadStatusADPDResponse.class);
            if (execute != null && execute.getResult().isResult() && this.token == null) {
                GlobalPara.getInstance().Write_Log("仪表铅封", execute.toJSON());
                // 已开盖
                this.token = ProtectKey.obtainToken(3);
                GlobalPara.getInstance().db_insert(LEAD, this.token.content());
            }
            return new SealLeadStatus()
                    .setStatus(execute == null || !execute.getResult().isResult());
        }
    }

    /**
     * @description: 指令执行
     * @date: 2024-09-09 13:34:13
     **/
    public <T extends ADPackDisassemblyResponse> T execute(ADPackAssemblyRequest request, Class<T> clazz) {
        if (this.protocolManager == null) return null;
        final ADPackDisassemblyResponse[] responses = new ADPackDisassemblyResponse[1];
        try {
            this.protocolManager.execute(request, new IProtocolResponse<T>() {
                @Override
                public void target(T target) throws MeterException {
                    responses[0] = target;
                }

                @Override
                public void exp(MeterException e) {

                }
            });

            int count = 1;
            while (count < 5 && responses[0] == null) {
                SystemtUtils.sleep(1);
                count++;
            }

            return (T) responses[0];
        } catch (MeterException e) {
            System.err.printf("WeightCal_Err: %s%n", e.getMessage());
            return null;
        }
    }

    /**
     * @description: 秤台初始化
     **/
    public void Init_Command() throws MeterException {
        // 设置秤重模式
        this.protocolManager.execute(new SetWeighingModelADPARequest(WeighingMode.Wave_Internal_Continuous), new IProtocolResponse<SetWeighingModelADPDResponse>() {
            @Override
            public void target(SetWeighingModelADPDResponse target) throws MeterException {
                if (GlobalPara.getInstance().isRunLog())
                    System.out.println("设置秤重模式 响应：" + target.toJSON());
            }

            @Override
            public void exp(MeterException e) {

            }
        });

        SystemtUtils.sleep(1);

        this.protocolManager.execute(new ObtainVersionADPARequest(), new IProtocolResponse<ObtainVersionADPDResponse>() {
            @Override
            public void target(ObtainVersionADPDResponse target) throws MeterException {
                if (GlobalPara.getInstance().isRunLog())
                    System.out.println("读取版本 响应：" + target.toJSON());
            }

            @Override
            public void exp(MeterException e) {

            }
        });

        SystemtUtils.sleep(1);

        final ObtainFullScaleADPDResponse[] responses = new ObtainFullScaleADPDResponse[1];

        int count = 0;
        while (count < 5 && responses[0] == null) {
            SystemtUtils.sleep(1);
            this.protocolManager.execute(new ObtainFullScaleADPARequest(), new IProtocolResponse<ObtainFullScaleADPDResponse>() {
                @Override
                public void target(ObtainFullScaleADPDResponse target) throws MeterException {
                    if (GlobalPara.getInstance().isRunLog())
                        System.out.println("满量程读取命令 响应：" + target.toJSON());
                    responses[0] = target;
                }

                @Override
                public void exp(MeterException e) {

                }
            });
            count++;
        }

        if (responses[0] == null)
            throw new MeterException(MeterStateEnum.AD_秤台通讯初始化异常);
        Init_Cap(responses[0].getScale(), responses[0].getFloa(), responses[0].getDivision().getDivision());
    }

    public IProtocolManager getProtocolManager() {
        return protocolManager;
    }

    /**
     * @description: 初始化通知器
     **/
    public WeightCal Init_Notifies(WeightNotify... weightNotifies) {
        if (weightNotifies != null && weightNotifies.length > 0) {
            return this.Init_Notifies(Arrays.asList(weightNotifies));
        }
        return this;
    }

    /**
     * @description: 初始化通知器
     **/
    public WeightCal Init_Notifies(List<WeightNotify> weightNotifies) {
        if (weightNotifies != null && !weightNotifies.isEmpty()) {
            if (this.weightNotifies == null) this.weightNotifies = new ArrayList<>();
            Iterator<WeightNotify> iterator = weightNotifies.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() == null) iterator.remove();
            }
            if (!weightNotifies.isEmpty()) this.weightNotifies.addAll(weightNotifies);
        }
        return this;
    }

    /**
     * @description: 移除通知器
     **/
    public WeightCal Remove_Notify(WeightNotify weightNotify) {
        if (Objects.nonNull(weightNotify) && Objects.nonNull(weightNotify.identify()) && this.weightNotifies != null && !this.weightNotifies.isEmpty()) {
            Iterator<WeightNotify> iterator = this.weightNotifies.iterator();
            while (iterator.hasNext()) {
                if (weightNotify.identify().equals(iterator.next().identify())) {
                    iterator.remove();
                    break;
                }
            }
        }
        return this;
    }

    /**
     * @description: 发送获取初始化零点信息的命令
     **/
    private void COM_Get_ZeroInfo(int codeFromCalibrate) {
        //ngff
        try {
            this.protocolManager.execute(new ObtainZeroCodeOpenADPARequest(), new IProtocolResponse<ObtainZeroCodeOpenADPAResponse>() {
                @Override
                public void target(ObtainZeroCodeOpenADPAResponse target) throws MeterException {
                    codeOfZeroStart = target.getZeroCode();
                    int flag = target.getFlag();
                    finishOfZeroStart = (flag & 0x02) != 0;
                    if (!finishOfZeroStart) {
                        int range = codeFull * (GlobalPara.getInstance().getTMS(TMS.Scale_SetZeroStart) % 100) / 100;
                        if ((codeFromCalibrate <= range) && (codeFromCalibrate >= -range))
                            COM_SetZero(codeFromCalibrate);
                    }
                    if (GlobalPara.getInstance().isRunLog())
                        System.out.printf("初始化零点:%s|%s%n", codeOfZeroStart, finishOfZeroStart);
                }

                @Override
                public void exp(MeterException e) {

                }
            });
        } catch (Exception e) {
        }
    }


    private int ParaCal_e_10(int value) {
        return (value * mn.getDivision_2() * codeFull + 5 * mn.getCapacity_0()) / (10 * mn.getCapacity_0());
    }

    /**
     * @description: 发送获取初始化零点信息的命令
     **/
    private void COM_Set_CodesInfo() {
        //codeForZeroTrack;
        //codeForStable;
        //ngff
        CheckStableAndSetZeroCodeADPARequest request = new CheckStableAndSetZeroCodeADPARequest();
        request.setStable(codeForStable);
        request.setZero(codeForZeroTrack);
        try {
            protocolManager.execute(request, new IProtocolResponse<CheckStableAndSetZeroCodeADPAResponse>() {
                @Override
                public void target(CheckStableAndSetZeroCodeADPAResponse target) throws MeterException {
                    if (GlobalPara.getInstance().isRunLog())
                        System.out.println("初始化零点稳定信息完成");
                }

                @Override
                public void exp(MeterException e) {
                    System.err.println("初始化零点稳定信息命令 异常:---" + e.getMessage());
                }
            });
        } catch (Exception e) {
            ;
        }
    }

    private void COM_SetZero(int code) {
        //ngff
        SetInternalCodeZeroADPARequest request = new SetInternalCodeZeroADPARequest();
        request.setZero(code);
        try {
            protocolManager.execute(request, new IProtocolResponse<SetInternalCodeZeroADPAResponse>() {
                @Override
                public void target(SetInternalCodeZeroADPAResponse target) throws MeterException {
                    if (GlobalPara.getInstance().isRunLog())
                        System.out.printf("内码置零完成: %s%n", target.toJSON());
                }

                @Override
                public void exp(MeterException e) {
                    System.err.println("内码置零命令 异常:---" + e.getMessage());
                }
            });
        } catch (Exception e) {
            ;
        }
    }

    public WeightCal ParaCal()          //Load para from GlobalPara
    {
        weightUNIT = GlobalPara.getInstance().getWeightUNIT();

        if (weightUNIT == 6)           //lb
        {
            mn = lb_mn;
            codeFull = lb_codeFull;
        } else if (weightUNIT == 4)      //g
        {
            mn = g_mn;
            codeFull = g_codeFull;
        } else                        //kg
        {
            mn = kg_mn;
            codeFull = kg_codeFull;
        }

        maxDegrees = mn.getCapacity_0() / mn.getDivision_2();

        int value = GlobalPara.getInstance().getTMS(TMS.Scale_ZeroJudge);
        zeroJudge_InNET = ((value >= 100) && (value < 200));
        value = value % 100;
        if (value < 2)
            value = 2;
        codeForZeroJudge = ParaCal_e_10(value);
        value = GlobalPara.getInstance().getTMS(TMS.Scale_ZeroFloat);
        if (maxDegrees <= 4000) {
            if (value < 4)
                value = 4;
        } else if (maxDegrees < 8000) {
            if (value < 7)
                value = 7;
        } else if (maxDegrees < 16000) {
            if (value < 20)
                value = 20;
        } else {
            if (value < 35)
                value = 35;
        }
        codeForZeroTrack = ParaCal_e_10(value);
        codeForStable = ParaCal_e_10(GlobalPara.getInstance().getTMS(TMS.Scale_SteadyJudge));

        COM_Set_CodesInfo();

        weightZero = BigDecimal.ZERO.movePointLeft(mn.getDot());
        weightFull_0 = new BigDecimal(mn.getCapacity_0()).movePointLeft(mn.getDot());
        weightFull_1 = new BigDecimal(mn.getCapacity_1()).movePointLeft(mn.getDot());
        weightFull_2 = new BigDecimal(mn.getCapacity_2()).movePointLeft(mn.getDot());
        weightDegree_0 = new BigDecimal(mn.getDivision_0()).movePointLeft(mn.getDot());
        weightDegree_1 = new BigDecimal(mn.getDivision_1()).movePointLeft(mn.getDot());
        weightDegree_2 = new BigDecimal(mn.getDivision_2()).movePointLeft(mn.getDot());

        return this;
    }

    private int last_Cap = 30000;
    private int last_Dot = 3;
    private int last_Div = 6;
    private boolean last_Init = false;

    public void ReInit() {
        if (last_Init)
            Init_Cap(last_Cap, last_Dot, last_Div);

        if (this.weightNotifies != null && !this.weightNotifies.isEmpty()) {
            for (WeightNotify weightNotify : weightNotifies) {
                if (weightNotify instanceof WeightUnitNotify) {
                    ((WeightUnitNotify) weightNotify).unit_change();
                    break;
                }
            }
        }
    }

    public WeightCal Init_Cap(int cap, int dot, int div) {
        last_Cap = cap;
        last_Dot = dot;
        last_Div = div;
        last_Init = true;

        int spec213 = GlobalPara.getInstance().getTMS(TMS.Scale_Precision);
        BigDecimal kgCap = new BigDecimal(cap).movePointLeft(dot);

        int zeronumber;
        int headvalue;
        int headvalue_p1;
        int headvalue_p2;

        zeronumber = 1;
        headvalue = cap;
        if (headvalue < 0)
            headvalue = -headvalue;

        while (true) {
            if (headvalue <= 99)
                break;
            headvalue /= 10;
            zeronumber *= 10;
        }
        if (headvalue == 0) {
            headvalue = 30;
            zeronumber = 1000;
        }

        headvalue_p1 = const_cap_p1[headvalue];
        headvalue_p2 = const_cap_p2[headvalue];

        if (zeronumber < 100)
            zeronumber = 100;

        if ((div < 0) || (div > 10)) {
            if (headvalue * zeronumber < 10000)
                div = 0;
            else
                div = 6;
        }

        if ((spec213 >= 0) && (spec213 <= 6)) {
            int dvalue = headvalue * zeronumber / 3000;
            if (dvalue < 2)
                dvalue = 0;//1;
            else if (dvalue < 5)
                dvalue = 2;//2;
            else if (dvalue < 10)
                dvalue = 4;//5;
            else if (dvalue < 20)
                dvalue = 6;//10;
            else if (dvalue < 50)
                dvalue = 8;//20;
            else if (dvalue < 100)
                dvalue = 10;//50;
            else if (dvalue < 200)
                dvalue = 12;//100;
            else
                dvalue = 14;//200;

            if (spec213 == 1)
                dvalue -= 1;
            else if (spec213 == 2)
                dvalue -= 3;
            else if (spec213 == 3)
                dvalue -= 5;
            else if (spec213 == 4)
                dvalue -= 2;
            else if (spec213 == 5)
                dvalue -= 4;
            else if (spec213 == 6)
                dvalue -= 6;

            if (dvalue < 0)
                dvalue = 0;
            div = dvalue;
        }

        if ((dot < 0) || (dot > 7))
            dot = 0;

        //    g_mn.capacity_0 = kg_mn.capacity_0 = headvalue * zeronumber;
        //    g_mn.capacity_2 = kg_mn.capacity_2 = g_mn.capacity_1 = kg_mn.capacity_1 = headvalue_p2 * zeronumber / 10;
        //    g_mn.division_0 = kg_mn.division_0 = const_division[div];
        //    g_mn.division_2 = kg_mn.division_2 = g_mn.division_1 = kg_mn.division_1 = const_division_mid[div];
        //    kg_mn.dot = dot;
        //    g_mn.dot = dot - 3;
        //    while (g_mn.dot < 0) {
        //        g_mn.dot++;
        //        g_mn.capacity_0 *= 10;
        //        g_mn.capacity_1 *= 10;
        //        g_mn.capacity_2 *= 10;
        //        g_mn.division_0 *= 10;
        //        g_mn.division_1 *= 10;
        //        g_mn.division_2 *= 10;
        //    }
        //    lb_mn.capacity_0 = headvalue_p1 * zeronumber;
        //    lb_mn.capacity_2 = lb_mn.capacity_1 = headvalue * zeronumber;
        //    lb_mn.division_0 = const_division[div + 2];
        //    lb_mn.division_2 = lb_mn.division_1 = const_division_mid[div + 2];
        //    lb_mn.dot = dot;
        // g_mn=new WeightMN(dot,headvalue * zeronumber,headvalue_p2 * zeronumber / 10,0,const_division[div],const_division_mid[div],0);
        // _mn=new WeightMN(dot-3,headvalue * zeronumber,headvalue_p2 * zeronumber / 10,0,const_division[div],const_division_mid[div],0);
        // b_mn=new WeightMN(dot,headvalue_p1 * zeronumber,headvalue * zeronumber,0,const_division[div + 2],const_division_mid[div + 2],0);
        // g_codeFull = g_codeFull = 300000;
        // b_codeFull = new BigDecimal("0.453592").multiply(new BigDecimal(kg_codeFull * headvalue_p1)).divide(new BigDecimal(headvalue), 0, BigDecimal.ROUND_HALF_UP).intValue();

        kg_mn = GlobalPara.getInstance().get_WeightMN(kgCap, spec213, 3);
        if (kg_mn == null)
            kg_mn = new WeightMN(dot, headvalue * zeronumber, headvalue_p2 * zeronumber / 10, 0, const_division[div], const_division_mid[div], 0);

        g_mn = GlobalPara.getInstance().get_WeightMN(kgCap, spec213, 4);
        if (g_mn == null)
            g_mn = new WeightMN(dot - 3, headvalue * zeronumber, headvalue_p2 * zeronumber / 10, 0, const_division[div], const_division_mid[div], 0);

        lb_mn = GlobalPara.getInstance().get_WeightMN(kgCap, spec213, 6);
        if (lb_mn == null)
            lb_mn = new WeightMN(dot, headvalue_p1 * zeronumber, headvalue * zeronumber, 0, const_division[div + 2], const_division_mid[div + 2], 0);

        kg_codeFull = new BigDecimal(300000).multiply(new BigDecimal(kg_mn.getCapacity_0()))
                .divide(new BigDecimal(cap), 0, BigDecimal.ROUND_HALF_UP).intValue();
        g_codeFull = new BigDecimal(300000).multiply(new BigDecimal(g_mn.getCapacity_0()))
                .divide(new BigDecimal(cap), 0, BigDecimal.ROUND_HALF_UP).intValue();
        lb_codeFull = new BigDecimal("136077.6").multiply(new BigDecimal(lb_mn.getCapacity_0()))
                .divide(new BigDecimal(cap), 0, BigDecimal.ROUND_HALF_UP).intValue();

        ParaCal();

        return this;
    }

    private BigDecimal Cal_Code_To_CurrentDegree(int code) {
        long calbuf = ((long) code) * mn.getCapacity_0();
        long cc_calbuf_1 = ((long) codeFull) * mn.getCapacity_1();
        long cc_calbuf_2 = ((long) codeFull) * mn.getCapacity_2();
        int ctDivision;
        if (calbuf < cc_calbuf_2)
            ctDivision = mn.getDivision_2();
        else if (calbuf < cc_calbuf_1)
            ctDivision = mn.getDivision_1();
        else
            ctDivision = mn.getDivision_0();
        return new BigDecimal(ctDivision).movePointLeft(mn.getDot());
    }

    private BigDecimal Cal_Code_To_Value(int code, boolean toTrack) {

        long calbuf = ((long) code) * mn.getCapacity_0();
        long cc_calbuf_1 = ((long) codeFull) * mn.getCapacity_1();
        long cc_calbuf_2 = ((long) codeFull) * mn.getCapacity_2();
        int ctDivision;
        if (calbuf < cc_calbuf_2)
            ctDivision = mn.getDivision_2();
        else if (calbuf < cc_calbuf_1)
            ctDivision = mn.getDivision_1();
        else
            ctDivision = mn.getDivision_0();

        if ((toTrack) && (code <= codeForZeroJudge) && (code >= -codeForZeroJudge))
            calbuf = 0;
        else {
            if (calbuf > 0)
                calbuf += codeFull * ctDivision / 2;
            else
                calbuf -= codeFull * ctDivision / 2;
            calbuf = calbuf / (codeFull * ctDivision);
        }
        return new BigDecimal(calbuf * ctDivision).movePointLeft(mn.getDot());
        //Value=code/(10*kg_cap)*cap
    }

    private BigDecimal Cal_Code_To_Value(int code) {
        return Cal_Code_To_Value(code, false);
    }

    private int Cal_Value_To_Code(BigDecimal value) {
        if (weightUNIT == 6)           //lb
            mn = lb_mn;
        else if (weightUNIT == 4)      //g
            mn = g_mn;
        else                        //kg
            mn = kg_mn;

        return value.multiply(new BigDecimal(codeFull))
                .divide(new BigDecimal(mn.getCapacity_0()).movePointLeft(mn.getDot()), 0, BigDecimal.ROUND_HALF_UP).intValue();
        //Code=value/fullCap*(10*kg_cap)
    }


    /**
     * @description: 清空重置皮重信息
     **/
    public WeightCal SetTare_ClearAll() {
        this.codeOfTare_Manual = this.codeOfTare_PLU = this.codeOfTare = 0;
        return this;
    }

    public int SetTare_Button() {
        return SetTare_Code_Current(3);
    }

    /**
     * @description: 单击去皮按钮
     **/
    private int SetTare_Code_Current(int m1p2) {
        if (!stable)
            return 3;
        if ((GlobalPara.getInstance().getTMS(TMS.Scale_TareUpdateForbidden) == 1) && (this.codeOfTare > 0)) {
            if (this.codeOfGross > 0)
                return 4;
            else
                return SetTare_Code_M1P2(m1p2, 0);
        } else {
            if (this.codeOfGross > 0) {
                if (GlobalPara.getInstance().getTMS(TMS.Scale_TareUpdateForbidden) == 0) {
                    if (this.codeOfGross < this.codeOfTare)
                        return 5;
                }

                return SetTare_Code_M1P2(m1p2, this.codeOfGross);
            }
        }
        this.codeOfTare_Manual = this.codeOfGross;
        this.SetTare_Update();
        return 0;
    }

    /**
     * @param m1p2 =1 手动设置皮重 =2 PLU皮重 =3 所有皮重
     * @param code 皮重内码
     * @description: 设置皮重
     **/
    private int SetTare_Code_M1P2(int m1p2, int code) {
        BigDecimal dis = Cal_Code_To_Value(code);
        if (dis.compareTo(BigDecimal.ZERO) <= 0)
            code = 0;
        else {
            int spec = GlobalPara.getInstance().getTMS(TMS.Scale_TareMayOverL1max);
            if ((tareLimit != null) && (dis.compareTo(tareLimit) > 0))
                return 1;
            if (((spec & 0x01) == 0) && (dis.compareTo(weightFull_2) > 0))
                return 1;
            spec = GlobalPara.getInstance().getTMS(TMS.Scale_TareRange);
            if (spec <= 0) {
            } else if (spec < 100) {
                if (dis.compareTo(Cal_Code_To_Value(codeFull * spec / 100)) > 0)
                    return 2;
            } else if (spec <= 200) {
                if (dis.compareTo(Cal_Code_To_Value(codeFull * (spec - 100) / 100)) >= 0)
                    return 2;
            } else if (spec <= 210) {
                if (dis.compareTo(Cal_Code_To_Value(codeFull / (spec - 200))) > 0)
                    return 2;
            } else if (spec <= 220) {
                if (dis.compareTo(Cal_Code_To_Value(codeFull / (spec - 210))) >= 0)
                    return 2;
            }
        }
        if ((m1p2 & 0x01) != 0)
            this.codeOfTare_Manual = code;
        if ((m1p2 & 0x02) != 0)
            this.codeOfTare_PLU = code;

        SetTare_Update();
        return 0;
    }

    private boolean SetZero_PercentTest(int code, int percent) {
        code = Cal_Value_To_Code(Cal_Code_To_Value(codeFromCalibrate - code));
        int upper, lowwer;
        if (percent <= 100) {
            upper = percent * codeFull / 100;
            lowwer = -upper;
        } else if (percent <= 199) {
            upper = ((percent % 10) * codeFull) / 100;
            lowwer = ((percent / 10 - 10) * codeFull) / 100;
        } else if ((percent / 10000) == 1) {
            upper = ((percent % 100) * codeFull) / 100;
            lowwer = ((percent / 100 % 100) * codeFull) / 100;
        } else
            return false;

        return (code >= lowwer) && (code <= upper);
    }

    public int SetZero_Button()        //return 0 for success, other for failed.
    {
        if (!this.stable)
            return 1;           //not stable
        if (!this.finishOfZeroStart) //not start
            return 2;

        int tms221 = GlobalPara.getInstance().getTMS(TMS.Scale_SetZeroOnce);
        int tms222 = GlobalPara.getInstance().getTMS(TMS.Scale_SetZeroPacc);
        int tms286 = GlobalPara.getInstance().getTMS(TMS.Arith_ZeroWithTare);

        if (((tms221 == 0) || SetZero_PercentTest(codeOfZeroCurrent, tms221)) &&
                ((tms222 == 0) || SetZero_PercentTest(codeOfZeroStart, tms222)) &&
                ((tms286 != 1) || ((codeOfTare_Manual == 0) && (codeOfTare_PLU == 0)))
        ) {
            SetZero_Force();
            return 0;
        }
        return 3;       //not allowed
    }

    public void SetZero_Force() {
        COM_SetZero(codeFromCalibrate);
    }

    /**
     * @description: PLU皮重重置
     **/
    public WeightCal SetTare_PLUReset() {
        this.SetTare_Code_M1P2(2, 0);
        return this;
    }

    /**
     * @param tare 皮重
     * @description: 设置PLU皮重
     **/
    public int SetTare_PLUValue(BigDecimal tare) {
        return SetTare_Code_M1P2(2, Cal_Value_To_Code(tare));
    }

    /**
     * @description: 手动去皮更新操作
     **/
    private void SetTare_Update()            //手动操作的去皮m1p2=1, PLU调用的去皮m1p2=2
    {
        int tms68 = GlobalPara.getInstance().getTMS(TMS.Fuc_PLUTare);
        int ctTare;
        boolean ctPreset = false;

        if (tms68 == 0)
            ctTare = codeOfTare_Manual;
        else if (tms68 == 2) {
            if (codeOfTare_PLU == 0)
                ctTare = codeOfTare_Manual;
            else {
                ctTare = codeOfTare_PLU;
                ctPreset = true;
            }
        } else if (tms68 == 3) {
            ctTare = codeOfTare_PLU;
            ctPreset = true;
        } else {//if (tms68 == 1)
            if (codeOfTare_Manual == 0) {
                ctTare = codeOfTare_PLU;
                ctPreset = true;
            } else
                ctTare = codeOfTare_Manual;
        }

        BigDecimal tv = Cal_Code_To_Value(ctTare);
        if (tv.compareTo(BigDecimal.ZERO) == 0) {
            ctTare = 0;
            ctPreset = false;
        }

        codeOfTare = ctTare;
        tareIsPreset = ctPreset;
    }

    /**
     * @description: 获取秤重信息
     **/
    @SuppressWarnings("all")
    public WeightResult GetResult() {
        boolean ctZero;
        BigDecimal ctGross;
        BigDecimal ctTare;
        BigDecimal ctNet;
        //0     允许计算并累计
        //1     不允许累计，但允许计算
        //2     不允许计算累计，但允许显示
        //3     不允许显示，UnderFlow
        //4     不允许显示，OverFlow
        //5     不允许显示，未完成开机
        //50    锁机，停止工作环境
        int validType;

        int cdGross = codeOfGross;
        int cdTare = codeOfTare;
        boolean ctIsPreset = tareIsPreset;
        int cdNet;

        if (cdGross < codeForZeroJudge && (cdGross > -codeForZeroJudge)) {
            ctZero = true;
            cdGross = 0;
            cdNet = -cdTare;
        } else {
            cdNet = cdGross - cdTare;
            if (cdNet < codeForZeroJudge && (cdNet > -codeForZeroJudge)) {
                ctZero = zeroJudge_InNET;
                cdNet = 0;
                cdGross = cdTare;
            } else
                ctZero = false;
        }

        ctTare = Cal_Code_To_Value(cdTare);
        ctGross = Cal_Code_To_Value(cdGross, true);
        ctNet = Cal_Code_To_Value(cdNet, true);

        if (this.token != null && !this.debug) {
            validType = 50;
        } else if (!finishOfZeroStart)
            validType = 5;
        else {
            int minusDeg = GlobalPara.getInstance().getTMS(TMS.Scale_MinusDeg);
            int plusDeg = GlobalPara.getInstance().getTMS(TMS.Scale_PlusDeg);
            int saleDeg = GlobalPara.getInstance().getTMS(TMS.Scale_SaleDeg);
            if ((minusDeg > 0) && (ctGross.add(weightDegree_2.multiply(new BigDecimal(minusDeg))).compareTo(BigDecimal.ZERO) < 0))
                validType = 3;
            else if ((plusDeg > 0) && (ctGross.subtract(weightDegree_0.multiply(new BigDecimal(plusDeg))).compareTo(weightFull_0) > 0))
                validType = 4;
            else if ((ctGross.compareTo(BigDecimal.ZERO) <= 0) || (ctGross.compareTo(weightFull_0) > 0))
                validType = 2;
            else if (ctNet.compareTo(BigDecimal.ZERO) <= 0)
                validType = 2;
            else if ((saleDeg > 0) && (ctGross.compareTo(weightDegree_2.multiply(new BigDecimal(saleDeg))) < 0))
                validType = 1;
            else
                validType = 0;

            // long calbuf_Gross = ((long) cdGross) * capacity;
            // long midcalbuf = ((long) codeFull) * capacity_mid;
            // boolean midMore = true;
            // if (calbuf_Gross < midcalbuf) {
            //     midMore = false;
            //     division = division_mid;
            // }

            // if ((cdGross <= codeForZeroJudge) && (cdGross >= -codeForZeroJudge))
            //     calbuf_Gross = 0;
            // else {
            //     if (calbuf_Gross > 0)
            //         calbuf_Gross += codeFull * division / 2;
            //     else
            //         calbuf_Gross -= codeFull * division / 2;
            //     calbuf_Gross = calbuf_Gross / (codeFull * division);
            // }

            // if (midMore) {
            //     int maxDeg = capacity / division;
            //     int plusDeg = GlobalPara.getInstance().getTMS(TMS.Scale_PlusDeg);
            //     if ((plusDeg > 0) && (calbuf_Gross - plusDeg > maxDeg))
            //         validType = 4;
            //     else if (calbuf_Gross > maxDeg)
            //         validType = 2;
            //     else if (ctNet.compareTo(BigDecimal.ZERO) <= 0)
            //         validType = 2;
            //     else
            //         validType = 0;
            // } else {
            //     int minusDeg = GlobalPara.getInstance().getTMS(TMS.Scale_MinusDeg);
            //     int saleDeg = GlobalPara.getInstance().getTMS(TMS.Scale_SaleDeg);
            //     if ((minusDeg > 0) && (calbuf_Gross + minusDeg < 0))
            //         validType = 3;
            //     else if (calbuf_Gross < 0)
            //         validType = 2;
            //     else if (ctNet.compareTo(BigDecimal.ZERO) <= 0)
            //         validType = 2;
            //     else if ((saleDeg > 0) && (calbuf_Gross < saleDeg))
            //         validType = 1;
            //     else
            //         validType = 0;
            // }
        }

        int tms103 = GlobalPara.getInstance().getTMS(TMS.Arith_FixWeightDegree);

        if (tms103 == 1)
            ctTare = ctGross.subtract(ctNet);
        else if (tms103 == 2)
            ctNet = ctGross.subtract(ctTare);
        else if (tms103 == 3)
            ctGross = ctNet.add(ctTare);

        if (minAfterUsedGross.compareTo(ctGross) < 0)
            minAfterUsedGross = ctGross;

        int zeroBackDegree = GlobalPara.getInstance().getTMS(TMS.Scale_ZeroBackDegree);
        if (usedGross.compareTo(BigDecimal.ZERO) > 0) {
            int vau = min(zeroBackDegree, max(GlobalPara.getInstance().getTMS(TMS.Scale_SaleDeg), 1) - 1);
            if (ctGross.compareTo(weightDegree_2.multiply(new BigDecimal(vau))) <= 0)
                usedGross = BigDecimal.ZERO;
            else if ((GlobalPara.getInstance().getTMS(TMS.Fuc_PLUTare) <= 1) && (ctNet.compareTo(BigDecimal.ZERO) <= 0))
                usedGross = BigDecimal.ZERO;
            else if ((zeroBackDegree > 16) && (usedGross.compareTo(BigDecimal.ZERO) > 0)) {
                BigDecimal va = usedGross.multiply(new BigDecimal(32 - zeroBackDegree)).divide(new BigDecimal(16));
                if ((usedGross.subtract(minAfterUsedGross).compareTo(va) > 0) && (ctGross.subtract(minAfterUsedGross).compareTo(va) > 0))
                    usedGross = BigDecimal.ZERO;
            }
        }

        boolean needBackZero;
        int NoZeroBackCheck = GlobalPara.getInstance().getTMS(TMS.Fuc_NoZeroBackCheck);
        if (usedGross.compareTo(BigDecimal.ZERO) == 0)
            needBackZero = false;
        else if (NoZeroBackCheck == 2)
            needBackZero = false;
        else if (NoZeroBackCheck == 1) {
            BigDecimal degree = Cal_Code_To_CurrentDegree(cdNet);
            if ((ctGross.compareTo(usedGross.add(degree)) <= 0) && (ctGross.compareTo(usedGross.subtract(degree)) >= 0))
                needBackZero = false;
            else
                // throw new RuntimeMeterException(MeterStateEnum.重量需要返回零点);
                needBackZero = true;
        } else
            //throw new RuntimeMeterException(MeterStateEnum.重量需要返回零点);
            needBackZero = true;

        WeightResult result = new WeightResult();
        result.setAdc(this.adc);
        result.setFinishOfZeroStart(finishOfZeroStart);
        result.setUnit(weightUNIT);
        result.setStable(stable);
        result.setZero(ctZero);
        result.setTare(ctTare);
        result.setNetWeight(ctNet);
        result.setGross(ctGross);
        result.setValidType(validType);
        result.setTareIsPreset(ctIsPreset);
        result.setAutoAllowed(stable && (validType == 0) && (usedGross.compareTo(BigDecimal.ZERO) == 0));
        result.setNeedBackZero(needBackZero);

        if (this.newResult) {
            this.newResult = false;

            int action = 0;

            int reTimes = GlobalPara.getInstance().getTMS(AI_Stable_ReTimes, 1);
            if ((reTimes < 0) || (reTimes > 9))
                reTimes = 1;

            if (ai_Status == 0) {      //未发生任何触发
                BigDecimal wv = GlobalPara.getInstance().getAiWeightValid();
                boolean isValid;
                if (wv.compareTo(BigDecimal.ZERO) <= 0)
                    isValid = (validType == 0);
                else
                    isValid = (validType <= 1) && (ctNet.compareTo(wv) >= 0);

                if (isValid)
                    ai_Step++;
                else
                    ai_Step = 0;
                //if (ai_Step >= GlobalPara.getInstance().getAiWeightValidCount()) {      //超过要求重量次数达标，start
                if (ai_Step > GlobalPara.getInstance().getTMS(AI_Weight_Valid_Count, 1, 1)) {      //超过要求重量次数达标，start
                    action = 1;
                    if (stable)
                        ai_Status = 2;
                    else
                        ai_Status = 1;
                    ai_Step = 0;
                    ai_LastWeight = ctGross;
                }
                if (isValid) {
                    if ((cameraStatus == 0) && (action == 0))
                        action = 4;
                    cameraStatus = 1;
                } else if (cameraStatus > 0) {
                    cameraStatus++;
                    if (cameraStatus > GlobalPara.getInstance().getTMS(Camera_Close_Delay, 50)) {
                        action = 5;
                        cameraStatus = 0;
                    }
                }
            } else {
                BigDecimal wq = GlobalPara.getInstance().getAiWeightQuit();
                boolean isQuit;
                if (wq.compareTo(BigDecimal.ZERO) <= 0)
                    isQuit = (validType != 0);
                else
                    isQuit = ctNet.compareTo(wq) < 0;

                if (isQuit) {      //重量回落，退出AI界面
                    action = 3;
                    ai_Status = 0;
                    ai_Step = 0;
                } else if (ai_Status == 1) {      //稳定后触发
                    if (stable) {
                        ai_Step++;
                        int st = GlobalPara.getInstance().getTMS(AI_Stable_Trigger, 1);
                        if ((st > 0) && (ai_Step > st)) {      //连续稳定次数达标，触发reconfirm
                            action = 2;
                            ai_Status++;
                            ai_Step = 0;
                            ai_LastWeight = ctGross;
                        }
                    } else
                        ai_Step = 0;
                } else if (ai_Status <= 1 + reTimes) {      //稳定后再次判断
                    if (stable) {
                        ai_Step++;
                        int st = GlobalPara.getInstance().getTMS(AI_Stable_ReTrigger, 20);
                        if ((st >= 0) && (ai_Step > st)) {      //连续稳定次数达标，触发reconfirm
                            action = 2;
                            ai_Status++;
                            ai_Step = 0;
                            ai_LastWeight = ctGross;
                        }
                    } else
                        ai_Step = 0;
                } else {      //已结束
                    int va = GlobalPara.getInstance().getTMS(AI_Restable_Trigger_Degree, 10);
                    if (va < 10)
                        va = 10;
                    BigDecimal range = weightDegree_2.multiply(new BigDecimal(va));
                    BigDecimal dif = ctGross.subtract(ai_LastWeight);
                    if ((dif.compareTo(range) > 0) || (dif.add(range).compareTo(BigDecimal.ZERO) < 0)) {      //重量发生较大变化，去稳定判断循环，等待再次触发reconfirm或cancel
                        ai_Status = 1;
                        ai_Step = 0;
                        ai_LastWeight = ctGross;
                    }
                    if (cameraStatus > 0) {
                        cameraStatus++;
                        if (cameraStatus > GlobalPara.getInstance().getTMS(Camera_Close_Delay, 50)) {
                            action = 5;
                            cameraStatus = 0;
                        }
                    }
                }
            }

            // todo 秤重变更通知 adc false 有效状态1，2 认为称重正常
            if (this.weightNotifies != null && !this.weightNotifies.isEmpty() && !adc && (validType == 0 || validType == 1 || validType == 2)) {
                for (WeightNotify weightNotify : weightNotifies) {
                    if (weightNotify instanceof WeightChangeNotify) {
                        WeightChangeNotify weightChangeNotify = (WeightChangeNotify) weightNotify;
                        if (1 == action) {
                            // todo 开始触发: 如果摄像头没打开，先打开
                            weightChangeNotify.start();
                        } else if (2 == action) {
                            // todo 再次检查触发: 如果摄像头没打开，先打开
                            weightChangeNotify.reconfirm();
                        } else if (3 == action) {
                            // todo 取消触发: 如果摄像头没打开，停止打开
                            weightChangeNotify.cancel();
                        } else if (4 == action) {
                            // todo 预打开摄像头
                            weightChangeNotify.open();
                        } else if (5 == action) {
                            // todo 关闭摄像头
                            weightChangeNotify.close();
                        } else {
                            // todo 暂定
                        }
                    }
                }
            }
        }
        return result.clearWeight();
    }

    public void update_UsedGross(BigDecimal input, int pluN0) {
        if (input.compareTo(BigDecimal.ZERO) > 0) {
            usedGross = minAfterUsedGross = input;
            usedGross_PLU = pluN0;
        }
    }

    /**
     * @description: 摄像头打开成功
     **/
//    public void OpenSuccess() {
//        this._cameraStatus = true;
//    }
//
//    public void IdentifyFinish() {
//        this._cameraStatus = false;
//    }

    // private static final int cameraCloseDelay = 50;
    // private boolean _cameraStatus = false;
    private int cameraStatus = 0;
    private int ai_Status = 0;
    private int ai_Step = 0;
    private BigDecimal ai_LastWeight = BigDecimal.ZERO;

    /**
     * @description: 接受通讯中的内码
     **/
    public WeightCal SetCode(int codeFromCalibrate, int codeOfZeroCurrent, boolean stable, boolean notFinish,
                             boolean adc) {
        if ((!this.finishOfZeroStart) && (stable)) {
            this.COM_Get_ZeroInfo(codeFromCalibrate);
        }
        this.stable = stable;
        this.codeFromCalibrate = codeFromCalibrate;
        this.codeOfZeroCurrent = codeOfZeroCurrent;
        this.codeOfGross = codeFromCalibrate - codeOfZeroCurrent;
        this.newResult = true;
        this.adc = adc;
        return this;
    }

    /**
     * @param target
     * @description: 目标数据 ngff
     */
    @Override
    public void target(IPackResponse target) {
        if (target instanceof ObtainWeightADPDResponse) {
            ObtainWeightADPDResponse response = (ObtainWeightADPDResponse) target;
            // System.out.println(response.toJSON());
            if (response.getLength() == 8) {
                // 秤重信息 调用 SetCode
                this.SetCode(response.getWaveCode(), response.getZeroCode(), response.isS_stb(), response.isS_on(), response.isS_adc());
                GlobalPara.getInstance().setPrivilege(response.isS_privilege());

                WeightResult wr = this.GetResult();
                //  if (GlobalPara.getInstance().isRunLog()
                //          && this.isRun())
                //      System.out.println("重量信息:" + wr.getValidType()
                //              + "|" + wr.getNetWeight()
                //              + "|" + wr.getTare()
                //              + "|" + wr.getUnit()
                //              + "|" + (wr.isStable() ? "S" : "")
                //              + (wr.isZero() ? "Z" : "")
                //              + (wr.isFinishOfZeroStart() ? "F" : ""));

                if (this.weightNotifies != null && !this.weightNotifies.isEmpty()) {
                    for (WeightNotify weightNotify : weightNotifies) {
                        if (weightNotify instanceof WeightInfoNotify) {
                            WeightInfoNotify weightInfoNotify = (WeightInfoNotify) weightNotify;
                            weightInfoNotify.weight(wr);
                            if (wr.isNeedBackZero()) {
                                weightInfoNotify.exp(wr, new MeterException(MeterStateEnum.重量需要返回零点));
                            }
                        }
                    }
                }
                // 添加实时重量信息
                SerialDisplay.getInstance().setWeightResult(wr);
            } else {
                System.err.println("未知重量信息：" + target.toJSON());
            }
        } else {
            System.err.println("通用未知指令内容 -> " + target.toJSON());
        }
    }

    /**
     * @param e
     * @description: 响应异常信息
     */
    @Override
    public void exp(MeterException e) {
        System.err.println("通用异常指令内容 -> " + e.getMessage());
    }
}