package com.jhscale.meter.protocol.model;

import io.swagger.annotations.ApiModelProperty;

public class WeightMN {
    @ApiModelProperty(value = "小数点", name = "dot")
    private int dot = 3;

    @ApiModelProperty(value = "量程0", name = "capacity_0")
    private int capacity_0 = 30000;
    @ApiModelProperty(value = "量程1", name = "capacity_1")
    private int capacity_1 = 15000;
    @ApiModelProperty(value = "量程2", name = "capacity_2")
    private int capacity_2 = 15000;

    @ApiModelProperty(value = "分度值0", name = "division_0")
    private int division_0 = 10;
    @ApiModelProperty(value = "分度值1", name = "division_1")
    private int division_1 = 5;
    @ApiModelProperty(value = "分度值2", name = "division_2")
    private int division_2 = 5;

    public WeightMN(int dot, int cap0, int cap1, int cap2, int div0, int div1, int div2) {

        while (dot < 0) {
            dot++;
            cap0 *= 10;
            cap1 *= 10;
            cap2 *= 10;
            div0 *= 10;
            div1 *= 10;
            div2 *= 10;
        }

        if((cap1==0)||(div1==0)||(cap1>=cap0)||(div1>=div0)) {
            cap2=cap1=cap0;
            div2=div1=div0;
        }
        else if((cap2==0)||(div2==0)||(cap2>=cap1)||(div2>=div1)) {
            cap2=cap1;
            div2=div1;
        }

        this.dot=dot;
        this.capacity_0=cap0;
        this.capacity_1=cap1;
        this.capacity_2=cap2;
        this.division_0=div0;
        this.division_1=div1;
        this.division_2=div2;
    }

    public int getDot() {
        return dot;
    }

    public void setDot(int dot) {
        this.dot = dot;
    }

    public int getCapacity_0() {
        return capacity_0;
    }

    public void setCapacity_0(int capacity_0) {
        this.capacity_0 = capacity_0;
    }

    public int getCapacity_1() {
        return capacity_1;
    }

    public void setCapacity_1(int capacity_1) {
        this.capacity_1 = capacity_1;
    }

    public int getCapacity_2() {
        return capacity_2;
    }

    public void setCapacity_2(int capacity_2) {
        this.capacity_2 = capacity_2;
    }

    public int getDivision_0() {
        return division_0;
    }

    public void setDivision_0(int division_0) {
        this.division_0 = division_0;
    }

    public int getDivision_1() {
        return division_1;
    }

    public void setDivision_1(int division_1) {
        this.division_1 = division_1;
    }

    public int getDivision_2() {
        return division_2;
    }

    public void setDivision_2(int division_2) {
        this.division_2 = division_2;
    }
}
