package com.jhscale.meter.protocol.model;

import com.jhscale.common.model.inter.GJSONModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * @author lie_w
 * @title: WeightResult
 * @projectName meter-jar
 * @description: TODO
 * @date 2022/9/2115:38
 */
@ApiModel("秤重结果")
public class WeightResult implements GJSONModel {

    @ApiModelProperty(value = "稳定", name = "isStable")
    private boolean stable = true;
    @ApiModelProperty(value = "零点", name = "isZero")
    private boolean zero = true;
    @ApiModelProperty(value = "单位", name = "unit")
    private int unit = 3;
    @ApiModelProperty(value = "净重", name = "net")
    private BigDecimal netWeight = BigDecimal.ZERO;
    @ApiModelProperty(value = "皮重", name = "tare")
    private BigDecimal tare = BigDecimal.ZERO;
    @ApiModelProperty(value = "总重", name = "gross")
    private BigDecimal gross = BigDecimal.ZERO;

    @ApiModelProperty(value = "允许自动交易", name = "autoAllowed")
    private boolean autoAllowed = false;

    @ApiModelProperty(value = "需要回零标志", name = "needBackZero")
    private boolean needBackZero = false;


    @ApiModelProperty(value = "皮重是否预置", name = "tareIsPreset")
    private boolean tareIsPreset = false;

    @ApiModelProperty(value = "开机完成标志", name = "finishOfZeroStart")
    private boolean finishOfZeroStart = false;

    //0     允许计算并累计
    //1     不允许累计，但允许计算
    //2     不允许计算累计，但允许显示
    //3     不允许显示，UnderFlow
    //4     不允许显示，OverFlow
    //5     不允许显示，未完成开机
    //50    锁机，停止工作环境
    @ApiModelProperty(value = "有效性", name = "validType")
    private int validType = 0;

    @ApiModelProperty(value = "ADC错误", name = "adc")
    private boolean adc = false;

    public boolean isStable() {
        return stable;
    }

    public void setStable(boolean stable) {
        this.stable = stable;
    }

    public boolean isZero() {
        return zero;
    }

    public void setZero(boolean zero) {
        this.zero = zero;
    }

    public int getUnit() {
        return unit;
    }

    public void setUnit(int unit) {
        this.unit = unit;
    }

    public BigDecimal getNetWeight() {
        return netWeight;
    }

    public void setNetWeight(BigDecimal netWeight) {
        this.netWeight = netWeight;
    }

    public BigDecimal getTare() {
        return tare;
    }

    public void setTare(BigDecimal tare) {
        this.tare = tare;
    }

    public BigDecimal getGross() {
        return gross;
    }

    public void setGross(BigDecimal gross) {
        this.gross = gross;
    }

    public boolean isFinishOfZeroStart() {
        return finishOfZeroStart;
    }

    public void setFinishOfZeroStart(boolean finishOfZeroStart) {
        this.finishOfZeroStart = finishOfZeroStart;
    }

    public int getValidType() {
        return validType;
    }

    public void setValidType(int validType) {
        this.validType = validType;
    }

    public boolean isTareIsPreset() {
        return tareIsPreset;
    }

    public void setTareIsPreset(boolean tareIsPreset) {
        this.tareIsPreset = tareIsPreset;
    }

    public boolean isAutoAllowed() {
        return autoAllowed;
    }

    public void setAutoAllowed(boolean autoAllowed) {
        this.autoAllowed = autoAllowed;
    }

    public boolean isNeedBackZero() {
        return needBackZero;
    }

    public void setNeedBackZero(boolean needBackZero) {
        this.needBackZero = needBackZero;
    }

    public boolean isAdc() {
        return adc;
    }

    public void setAdc(boolean adc) {
        this.adc = adc;
    }

    /**
     * @description: 锁机结果信息重置
     * @date: 2024-08-16 15:48:09
     **/
    public WeightResult clearWeight() {
        if (this.validType == 50) {
            this.stable = false;
            this.zero = false;
            this.netWeight = BigDecimal.ZERO;
            this.tare = BigDecimal.ZERO;
            this.gross = BigDecimal.ZERO;
            this.finishOfZeroStart = false;
        }
        return this;
    }
}
