package com.jhscale.meter.protocol.model.sp;

public class PtMapArea {
    public PtMapAddr ts = new PtMapAddr(0, 0);
    public PtMapAddr te = new PtMapAddr(0, 0);

    static final int UserDir_0 = 0x00;
    static final int UserDir_1 = 0x06;
    static final int UserDir_2 = 0x03;
    static final int UserDir_3 = 0x05;

    static public int GetDir(int angle) {
        if (angle == 0)
            return UserDir_0;
        else if (angle == 1)
            return UserDir_1;
        else if (angle == 2)
            return UserDir_2;
        else if (angle == 3)
            return UserDir_3;
        else if ((angle & 0x80) != 0)
            return (angle & 0x7f);
        else
            return 0;
    }

    public static PtMapAddr Add(PtMapAddr addr1, PtMapAddr addr2) {
        return new PtMapAddr(addr1.x + addr2.x, addr1.y + addr2.y);
    }

    public static PtMapAddr Sub(PtMapAddr addr1, PtMapAddr addr2) {
        return new PtMapAddr(addr1.x - addr2.x, addr1.y - addr2.y);
    }

    public static PtMapAddr Multi(PtMapAddr addr1, PtMapAddr addr2) {
        return new PtMapAddr(addr1.x * addr2.x, addr1.y * addr2.y);
    }

    public static PtMapAddr Offset(PtMapAddr addr, PtMapAddr offset, int dir) {
        if ((dir & 0x04) != 0) {
            int temp;
            temp = offset.x;
            offset.x = offset.y;
            offset.y = temp;
        }
        if ((dir & 0x01) != 0)
            offset.y = -offset.y;
        if ((dir & 0x02) != 0)
            offset.x = -offset.x;
        return Add(addr, offset);
    }

    public static PtMapAddr Offset_M1(PtMapAddr addr, PtMapAddr offset, int dir) {
        int temp;
        temp = offset.x;
        if (temp > 0)
            temp--;
        else if (temp < 0)
            temp++;
        offset.x = temp;

        temp = offset.y;
        if (temp > 0)
            temp--;
        else if (temp < 0)
            temp++;
        offset.y = temp;

        return Offset(addr, offset, dir);
    }

    public PtMapArea(PtMapArea input) {
        ts.x = input.ts.x;
        ts.y = input.ts.y;
        te.x = input.te.x;
        te.y = input.te.y;
    }

    public PtMapArea(PtMapAddr addr1, PtMapAddr addr2) {
        ts.x = Math.min(addr1.x, addr2.x);
        ts.y = Math.min(addr1.y, addr2.y);
        te.x = Math.max(addr1.x, addr2.x);
        te.y = Math.max(addr1.y, addr2.y);
    }

    public PtMapArea(PtMapAddr addr, PtMapAddr offset, int dir) {
        offset = Offset_M1(addr, offset, dir);
        ts.x = Math.min(addr.x, offset.x);
        ts.y = Math.min(addr.y, offset.y);
        te.x = Math.max(addr.x, offset.x);
        te.y = Math.max(addr.y, offset.y);
    }
}
