//package com.jhscale.meter.protocol.model.inner;
//
//import com.jhscale.meter.protocol.model.GlobalPara;
//
//import java.util.HashMap;
//import java.util.Map;
//
//public class SpDWL {
//
//    private Map<String, Map<Integer, SpData>> sds = new HashMap<>();
//
//    private SpDWL() {
//    }
//
//    private static class SingleSpDWL {
//        private static final SpDWL SINGLETON = new SpDWL();
//    }
//
//    public static SpDWL getInstance() {
//        return SingleSpDWL.SINGLETON;
//    }
//
//    public SpData setSpData_FromTMS(String tms) {
//        return setSpData_FromSeg(tms.split("\t", -1));
//    }
//
//    public void setSpData_FromDB(String kid, String content) {
//        String[] kidSeg = kid.split("\t");
//        if (kidSeg.length < 2)
//            return;
//        Integer nameOffset = GlobalPara.getInstance().getSpDWL(kidSeg[0]);
//        if (nameOffset == null)
//            return;
//        String name;
//        if (nameOffset > 0) {
//            String[] contentSeg = content.split("\t", -1);
//            if (contentSeg.length < nameOffset)
//                return;
//            else
//                name = contentSeg[nameOffset - 1];
//        } else
//            name = "";
//
//        SpData sd = new SpData();
//        sd.key = kidSeg[0];
//        sd.id = tryParseInt(kidSeg[1]);
//        if (nameOffset > 0)
//            sd.name = name;
//        else
//            sd.name = "";
//
//        sd.kid = kid;
//        sd.content = content;
//
//        Map<Integer, SpData> lsp = sds.get(kidSeg[0]);
//        if (lsp == null) {
//            lsp = new HashMap<>();
//            sds.put(kidSeg[0], lsp);
//        }
//        lsp.put(sd.id, sd);
//    }
//
//    public SpData setSpData_FromSeg(String[] input) {
//        String key = input[0];
//        Integer nameOffset = GlobalPara.getInstance().getSpDWL(key);
//        if (nameOffset == null)
//            return null;
//        int lng = input.length;
//        if (lng <= nameOffset + 1)
//            return null;
//
//        SpData sd = new SpData();
//        sd.key = key;
//        sd.id = tryParseInt(input[1]);
//        sd.kid = sd.key + "\t" + sd.id.toString();
//        if (nameOffset > 0)
//            sd.name = input[nameOffset + 1];
//        else
//            sd.name = "";
//
//        String content = "";
//        if (2 < lng)
//            content = input[2];
//        for (int loop = 3; loop < lng; loop++)
//            content += "\t" + input[loop];
//
//        sd.content = content;
//
//        Map<Integer, SpData> lsp = sds.get(key);
//        if (lsp == null) {
//            lsp = new HashMap<>();
//            sds.put(key, lsp);
//        }
//        lsp.put(sd.id, sd);
//
//        return sd;
//    }
//
//    public SpData getSpData(String key, Integer id) {
//        Map<Integer, SpData> lsp = sds.get(key);
//        if (lsp == null)
//            return null;
//        return lsp.get(id);
//    }
//
//    public SpData getSpData(String kid) {
//        String[] kidSeg = kid.split("\t");
//        if (kidSeg.length < 2)
//            return null;
//        return getSpData(kidSeg[0], tryParseInt(kidSeg[1]));
//    }
//
//    public String[] getSpSeg(String key, Integer id) {
//        Map<Integer, SpData> lsp = sds.get(key);
//        if (lsp == null)
//            return null;
//        return lsp.get(id).content.split("\t", -1);
//    }
//
//    public String[] getSpSeg(String kid) {
//        String[] kidSeg = kid.split("\t");
//        if (kidSeg.length < 2)
//            return null;
//        return getSpData(kidSeg[0], tryParseInt(kidSeg[1])).content.split("\t", -1);
//    }
//
//    public String getTMS(String key) {
//        String tms = "";
//        Map<Integer, SpData> lsp = sds.get(key);
//
//        if (lsp != null) {
//            //tms+="DWL\t"+key+"\t\r\n";
//            for (Map.Entry<Integer, SpData> entry : lsp.entrySet()) {
//                SpData ct = entry.getValue();
//                tms += ct.kid + "\t" + ct.content + "\r\n";
//            }
//            //tms+="END\tDWL\t\r\n";
//        }
//
//        return tms;
//    }
//
//    public static int tryParseInt(String toParse, int defaultValue) {
//        try {
//            return Integer.parseInt(toParse, 10);
//        } catch (Exception e) {
//            return defaultValue;
//        }
//    }
//
//    public static int tryParseInt(String toParse) {
//        return tryParseInt(toParse, 0);
//    }
//
//}
