package com.jhscale.meter.protocol.model.sp;

import com.jhscale.common.model.device.other.DSpDWL;
import com.jhscale.meter.protocol.model.CalPLU_ShelfDate;
import com.jhscale.meter.protocol.model.GlobalPara;
import com.jhscale.meter.protocol.model.ItemContent;
import com.jhscale.meter.protocol.model.TradeContent;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;

public class TradeSpecial {

    private static int tryParseInt(String toParse) {
        return tryParseInt(toParse, 0);
    }

    private static int tryParseInt(String toParse, int defaultValue) {
        try {
            return Integer.parseInt(toParse, 10);
        } catch (Exception e) {
            return defaultValue;
        }
    }

    private static BigDecimal tryParseBigDecimal(String toParse) {
        try {
            String[] v = toParse.split(",", -1);
            int dot = 0;
            if (v.length >= 2)
                dot = tryParseInt(v[1]);
            return new BigDecimal(tryParseInt(v[0])).movePointLeft(dot);
        } catch (Exception e) {
            return BigDecimal.ZERO;
        }
    }

    public static String printCalculte_Special_ID2Text(int[] itemValue, String key, Integer id) {
        DSpDWL spDWL = GlobalPara.getInstance().getSpData(key, id);
        if (spDWL == null)
            return "";
        if (itemValue[3] == 0)
            return spDWL.no().toString();
        else {
            String[] sg = spDWL.getContent().split("\t", -1);
            if ((itemValue[3] <= 2) && (itemValue[3] <= sg.length))
                return sg[itemValue[3] - 1];
            else
                return "";
        }
    }

    public static String printCalculte_Special_Nutrition_GetMapInfo_Full(PtMapArea area, int angle, int grid, int font, int leftPercent, int rightPercent, boolean autoNewline) {
        int sx;
        int sy;
        int lx;
        int ly = 64;
        if (angle == 2) {
            sx = area.te.x - (area.te.x - area.ts.x) * leftPercent / 100;
            sy = area.ts.y + 64;
            lx = (area.te.x - area.ts.x) * (rightPercent - leftPercent) / 100 + 1;
        } else {
            grid -= 6;

            sx = area.ts.x + (area.te.x - area.ts.x) * leftPercent / 100;
            sy = area.ts.y + 1;
            lx = (area.te.x - area.ts.x) * (rightPercent - leftPercent) / 100 + 1;
        }
        return TradeContent.printCalculate_MapInfo(angle, autoNewline ? 0x20 : 0x00, grid, font, sx, sy, lx, ly);
    }

    public static String printCalculte_Special_Nutrition_GetMapInfo_Simple(PtMapArea area, int angle, int grid, int font) {
        return printCalculte_Special_Nutrition_GetMapInfo_Full(area, angle, grid, font, 0, 100, false);
    }

    public static String printCalculte_Special_Nutrition_Border_FBB(PtMapArea area, int leftPercent, int rightPercent, int angle, int fbb) {
        if (angle == 2) {
            leftPercent = 100 - leftPercent;
            rightPercent = 100 - rightPercent;
        }
        leftPercent = area.ts.x + (area.te.x - area.ts.x) * leftPercent / 100;
        rightPercent = area.ts.x + (area.te.x - area.ts.x) * rightPercent / 100;
        return "0B02" + TradeContent.printCalculate_getX2(fbb) + TradeContent.printCalculate_getX4(leftPercent) + TradeContent.printCalculate_getX4(rightPercent);
    }

    public static String printCalculte_Speical_Nutrition_Buttom(PtMapArea area, String chars, int angle, int grid, int font, int fbb, boolean autoNewline) {
        String mapInfo = printCalculte_Special_Nutrition_GetMapInfo_Full(area, angle, grid, font, 1, 100, autoNewline);
        String out = TradeContent.printCalculate_CommandText(mapInfo, chars);
        out += printCalculte_Special_Nutrition_Border_FBB(area, 0, 100, angle, fbb);
        out += "04";
        return out;
    }

    public static String printCalculte_Speical_Nutrition_Header(PtMapArea area, String chars, int angle, int grid, int font) {
        return printCalculte_Speical_Nutrition_Buttom(area, chars, angle, grid, font, 2, false);
    }

    public static String printCalculte_Speical_Nutrition_Header_UD(PtMapArea area, String unit1, Integer valor, int type, int angle, int font) {
        String out = "";
        String mapInfo;
        int unit;
        if (unit1.length() == 0)
            unit = -1;
        else if (unit1.equals("g"))
            unit = 0;
        else if (unit1.equals("ml"))
            unit = 1;
        else
            unit = 2;

        int loop = 0;
        while (true) {
            String text;
            mapInfo = printCalculte_Special_Nutrition_GetMapInfo_Full(area, angle, 8, font, loop > 0 ? 71 : 56, loop > 0 ? 86 : 71, false);
            if (loop > 0)
                text = valor.toString();
            else
                text = "100";
            if (unit == -1)
                text += (type == 1) ? " ml" : " g";
            else if (unit == 0)
                text += " g";
            else if (unit == 1)
                text += " ml";
            else
                text += unit1;

            out += TradeContent.printCalculate_CommandText(mapInfo, text);

            if (loop > 0)
                break;
            loop++;
        }

        mapInfo = printCalculte_Special_Nutrition_GetMapInfo_Full(area, angle, 8, font, 86, 100, false);
        out += TradeContent.printCalculate_CommandText(mapInfo, "%VD*");

        out += printCalculte_Special_Nutrition_Border_FBB(area, 0, 100, angle, 2);
        out += printCalculte_Special_Nutrition_Border_FBB(area, 56, 71, angle, 2);
        out += printCalculte_Special_Nutrition_Border_FBB(area, 56, 86, angle, 2);

        return out + "04";
    }

    public static String printCalculte_Speical_Nutrition_4_Loop(PtMapArea area, String[] ln_des, BigDecimal[] ln_valor, BigDecimal[] ln_valor100, BigDecimal[] ln_percent, int loop, int type, int angle, boolean percentPrint, boolean tryRemoveDot, int font, boolean bitmapAlways) {

        if (ln_des[loop].length() <= 0)
            return "";

        String mapInfo = printCalculte_Special_Nutrition_GetMapInfo_Full(area, angle, 7, font, 1, 56, false);
        String out = TradeContent.printCalculate_CommandText(mapInfo, ln_des[loop]);

        int loopN = 0;
        BigDecimal value;
        while (true) {
            if (loopN > 0)
                value = ln_valor[loop];
            else
                value = ln_valor100[loop];
            if (!bitmapAlways) {
                if (loop == 0) {
                    if (value.compareTo(BigDecimal.valueOf(40, 1)) <= 0)
                        value = BigDecimal.ZERO;
                    else
                        value = value.setScale(0, BigDecimal.ROUND_HALF_UP);
                } else if (((loop >= 1) && (loop <= 5)) || (loop == 8)) {
                    if (value.compareTo(BigDecimal.valueOf(5, 1)) <= 0)
                        value = BigDecimal.ZERO;
                    else if (value.compareTo(BigDecimal.valueOf(100, 1)) >= 0)
                        value = value.setScale(0, BigDecimal.ROUND_HALF_UP);
                    else
                        value = value.stripTrailingZeros();
                } else if ((loop == 6) || (loop == 7)) {
                    if (value.compareTo(BigDecimal.valueOf(1, 1)) <= 0)
                        value = BigDecimal.ZERO;
                    else if (value.compareTo(BigDecimal.valueOf(100, 1)) >= 0)
                        value = value.setScale(0, BigDecimal.ROUND_HALF_UP);
                    else
                        value = value.stripTrailingZeros();
                } else if (loop == 9) {
                    if (value.compareTo(BigDecimal.valueOf(50, 1)) <= 0)
                        value = BigDecimal.ZERO;
                    else if (value.compareTo(BigDecimal.valueOf(100, 1)) >= 0)
                        value = value.setScale(0, BigDecimal.ROUND_HALF_UP);
                    else
                        value = value.stripTrailingZeros();
                }
            }
            mapInfo = printCalculte_Special_Nutrition_GetMapInfo_Full(area, angle, 8, font, loopN > 0 ? 71 : 56, loopN > 0 ? 86 : 71, false);
            if (tryRemoveDot)
                value = value.stripTrailingZeros();       //??try to remove 0
            out += TradeContent.printCalculate_CommandText(mapInfo, value.toPlainString());

            if (loopN > 0)
                break;
            loopN++;
        }

        mapInfo = printCalculte_Special_Nutrition_GetMapInfo_Full(area, angle, 8, font, 86, 100, false);
        String lpn = ln_percent[loop].toString();
        if (percentPrint)
            lpn += "%";
        out += TradeContent.printCalculate_CommandText(mapInfo, lpn);

        out += printCalculte_Special_Nutrition_Border_FBB(area, 0, 100, angle, 2);
        out += printCalculte_Special_Nutrition_Border_FBB(area, 56, 71, angle, 2);
        out += printCalculte_Special_Nutrition_Border_FBB(area, 56, 86, angle, 2);

        return out + "04";
    }

    public static Object printCalculte_Special_Nutrition_4(ItemContent itemC, int[] itemValue, int subY, int labelwidth, int nu4_id, boolean bitmapAlways, String title, int type, boolean percentPrint, boolean tryRemoveDot, int font_10PB, int font_8P, int font_8PB, int font_6P) {
        String out = "";
        String mapInfo;
        String[] segs = GlobalPara.getInstance().getSpSeg("NU3", nu4_id);
        if ((segs == null) || (segs.length < 55))
            return "";

        int unit = itemC.getPlu().getUnit();
        BigDecimal amount = itemC.getAmount();

        String Info1 = " ﻿* Percentual de valores diários fornecidos pela";
        String Info2 = " porção.";
        String Info3 = " ﻿* Percentual de valores diários fornecidos pela porção.";
        String Info4 = " Porções por embalagem: ";
        String Info5 = " Porção: ";

        String name = segs[0];
        String des = segs[1];
        int valor = tryParseInt(segs[2]);
        String unit1 = segs[3];
        String unit2 = segs[4];

        String[] ln_des = new String[20];
        BigDecimal[] ln_valor = new BigDecimal[20];
        BigDecimal[] ln_valor100 = new BigDecimal[20];
        BigDecimal[] ln_percent = new BigDecimal[20];

        ln_des[0] = "Valor energético(kcal)";
        ln_valor[0] = tryParseBigDecimal(segs[5]);
        ln_percent[0] = tryParseBigDecimal(segs[6]);

        ln_des[1] = "Carboidratos totais(g)";
        ln_valor[1] = tryParseBigDecimal(segs[7]);
        ln_percent[1] = tryParseBigDecimal(segs[8]);

        ln_des[2] = " Açúcares totais(g)";
        ln_valor[2] = tryParseBigDecimal(segs[9]);
        ln_percent[2] = tryParseBigDecimal(segs[10]);

        ln_des[3] = "  Açúcares adicionados(g)";
        ln_valor[3] = tryParseBigDecimal(segs[11]);
        ln_percent[3] = tryParseBigDecimal(segs[12]);

        ln_des[4] = "Proteinas(g)";
        ln_valor[4] = tryParseBigDecimal(segs[13]);
        ln_percent[4] = tryParseBigDecimal(segs[14]);

        ln_des[5] = "Gorduras totais(g)";
        ln_valor[5] = tryParseBigDecimal(segs[15]);
        ln_percent[5] = tryParseBigDecimal(segs[16]);

        ln_des[6] = " Gorduras saturadas(g)";
        ln_valor[6] = tryParseBigDecimal(segs[17]);
        ln_percent[6] = tryParseBigDecimal(segs[18]);

        ln_des[7] = " Gordura trans(g)";
        ln_valor[7] = tryParseBigDecimal(segs[19]);
        ln_percent[7] = tryParseBigDecimal(segs[20]);

        ln_des[8] = "Fibra alimentar(g)";
        ln_valor[8] = tryParseBigDecimal(segs[21]);
        ln_percent[8] = tryParseBigDecimal(segs[22]);

        ln_des[9] = "Sódio(mg)";
        ln_valor[9] = tryParseBigDecimal(segs[23]);
        ln_percent[9] = tryParseBigDecimal(segs[24]);

        ln_des[10] = segs[25];
        ln_valor[10] = tryParseBigDecimal(segs[26]);
        ln_percent[10] = tryParseBigDecimal(segs[27]);

        ln_des[11] = segs[28];
        ln_valor[11] = tryParseBigDecimal(segs[29]);
        ln_percent[11] = tryParseBigDecimal(segs[30]);

        ln_des[12] = segs[31];
        ln_valor[12] = tryParseBigDecimal(segs[32]);
        ln_percent[12] = tryParseBigDecimal(segs[33]);

        ln_des[13] = segs[34];
        ln_valor[13] = tryParseBigDecimal(segs[35]);
        ln_percent[13] = tryParseBigDecimal(segs[36]);

        ln_des[14] = segs[37];
        ln_valor[14] = tryParseBigDecimal(segs[38]);
        ln_percent[14] = tryParseBigDecimal(segs[39]);

        ln_des[15] = segs[40];
        ln_valor[15] = tryParseBigDecimal(segs[41]);
        ln_percent[15] = tryParseBigDecimal(segs[42]);

        ln_des[16] = segs[43];
        ln_valor[16] = tryParseBigDecimal(segs[44]);
        ln_percent[16] = tryParseBigDecimal(segs[45]);

        ln_des[17] = segs[46];
        ln_valor[17] = tryParseBigDecimal(segs[47]);
        ln_percent[17] = tryParseBigDecimal(segs[48]);

        ln_des[18] = segs[49];
        ln_valor[18] = tryParseBigDecimal(segs[50]);
        ln_percent[18] = tryParseBigDecimal(segs[51]);

        ln_des[19] = segs[52];
        ln_valor[19] = tryParseBigDecimal(segs[53]);
        ln_percent[19] = tryParseBigDecimal(segs[54]);

        int loop;
        for (loop = 0; loop < 20; loop++) {
            if (valor > 0)
                ln_valor100[loop] = ln_valor[loop].divide(new BigDecimal(valor).movePointLeft(2));
            else
                ln_valor100[loop] = BigDecimal.ZERO;
        }

        int angle = itemValue[5];
        int dir = PtMapArea.GetDir(angle);
        PtMapArea area = new PtMapArea(new PtMapAddr(itemValue[8], itemValue[9] - subY), new PtMapAddr(itemValue[10], itemValue[11]), dir);
        if (area.ts.y > 0)
            out += "10" + TradeContent.printCalculate_getX4(area.ts.y - 1);
        out += "04";

        subY += area.te.y + 1;

        area.ts.x = 0;
        int widthDot = 42 * 8;
        if (widthDot < labelwidth)
            widthDot = labelwidth;
        area.te.x = widthDot - 1;
        area.ts.y = area.te.y = 0;

        int printAlarm = 0;
        int alarmType;
        if (!bitmapAlways) {
            if (unit1.equals("g"))
                alarmType = 0;
            else if (unit1.equals("ml"))
                alarmType = 1;
            else
                alarmType = type;
        } else
            alarmType = type;

        if (ln_valor100[9].compareTo(new BigDecimal((alarmType == 1) ? 3000 : 6000).movePointLeft(1)) >= 0)
            printAlarm += 4;
        if (ln_valor100[6].compareTo(new BigDecimal((alarmType == 1) ? 30 : 60).movePointLeft(1)) >= 0)
            printAlarm += 2;
        if (ln_valor100[3].compareTo(new BigDecimal((alarmType == 1) ? 75 : 150).movePointLeft(1)) >= 0)
            printAlarm += 1;

        String udline = "0A" + "000000" + TradeContent.printCalculate_getX4(area.ts.x) + TradeContent.printCalculate_getX4(0) + TradeContent.printCalculate_getX4(area.te.x) + TradeContent.printCalculate_getX4(2) + "04";

        if (GlobalPara.getInstance().EcsCal_Unit_isWeight(unit)) {
            if (valor <= 0)
                Info4 += " 0";
            else
                Info4 += " " + itemC.getAmount().divide(new BigDecimal(valor), 0, BigDecimal.ROUND_HALF_UP).toString();
        } else
            Info4 += " " + itemC.getAmount().toString();
        Info4 += " porções";

        Info5 += Integer.toString(valor);
        if (!bitmapAlways)
            Info5 += (alarmType != 0) ? " ml" : " g";
        else
            Info5 += unit1;
        Info5 += unit2;

        if (angle == 2) {
            if (bitmapAlways && (printAlarm > 0)) {
                mapInfo = printCalculte_Special_Nutrition_GetMapInfo_Simple(area, angle, 8, 0);
                out += TradeContent.printCalculate_Bitmap_Inner(mapInfo, printAlarm) + "04";
            }
            out += udline;

//            if(bitmapAlways) {
//                out +=printCalculte_Speical_Nutrition_Buttom(area,Info2,angle,7,font_6P,3, false);
//                out +=printCalculte_Speical_Nutrition_Buttom(area,Info1,angle,7,font_6P,3, false);
//            } else
            out += printCalculte_Speical_Nutrition_Buttom(area, Info3, angle, 7, font_6P, 3, true);

            for (loop = 20; loop > 0; ) {
                loop--;
                out += printCalculte_Speical_Nutrition_4_Loop(area, ln_des, ln_valor, ln_valor100, ln_percent, loop, type, angle, percentPrint, tryRemoveDot, font_8P, bitmapAlways);
            }
            out += printCalculte_Speical_Nutrition_Header_UD(area, unit1, valor, type, angle, font_8PB);
            out += printCalculte_Speical_Nutrition_Header(area, Info5, angle, 7, font_8P);
            out += printCalculte_Speical_Nutrition_Header(area, Info4, angle, 7, font_8P);
            out += printCalculte_Speical_Nutrition_Header(area, title, angle, 8, font_10PB);

            out += udline;

            if ((!bitmapAlways) && (printAlarm > 0)) {
                mapInfo = printCalculte_Special_Nutrition_GetMapInfo_Simple(area, angle, 8, 0);
                out += TradeContent.printCalculate_Bitmap_Inner(mapInfo, printAlarm) + "04";
            }
        } else {
            if ((!bitmapAlways) && (printAlarm > 0)) {
                mapInfo = printCalculte_Special_Nutrition_GetMapInfo_Simple(area, angle, 8, 0);
                out += TradeContent.printCalculate_Bitmap_Inner(mapInfo, printAlarm) + "04";
            }

            out += printCalculte_Speical_Nutrition_Header(area, title, angle, 8, font_10PB);
            out += printCalculte_Speical_Nutrition_Header(area, Info4, angle, 7, font_8P);
            out += printCalculte_Speical_Nutrition_Header(area, Info5, angle, 7, font_8P);
            out += printCalculte_Speical_Nutrition_Header_UD(area, unit1, valor, type, angle, font_8P);
            for (loop = 0; loop < 20; loop++) {
                out += printCalculte_Speical_Nutrition_4_Loop(area, ln_des, ln_valor, ln_valor100, ln_percent, loop, type, angle, percentPrint, tryRemoveDot, font_8P, bitmapAlways);
            }

            out += udline;

//            if(bitmapAlways) {
//                out +=printCalculte_Speical_Nutrition_Buttom(area,Info1,angle,7,font_6P,3, false);
//                out +=printCalculte_Speical_Nutrition_Buttom(area,Info2,angle,7,font_6P,3, false);
//            } else
            out += printCalculte_Speical_Nutrition_Buttom(area, Info3, angle, 7, font_6P, 3, true);

            out += udline;

            if (bitmapAlways && (printAlarm > 0)) {
                mapInfo = printCalculte_Special_Nutrition_GetMapInfo_Simple(area, angle, 8, 0);
                out += TradeContent.printCalculate_Bitmap_Inner(mapInfo, printAlarm) + "04";
            }
        }

        return new TradeSpOut(out, subY);
    }

    public static Object printCalculte_Special_TA128(TradeContent tc, int[] itemValue, String mapInfo, int x_Init, int subY, int labelwidth) {
        String out = "";
        ItemContent itemC = tc.getItem().get((x_Init > 0) ? (x_Init - 1) : 0);
        if (itemValue[2] == 0) {
            return printCalculte_Special_Nutrition_4(itemC, itemValue, subY, labelwidth, itemC.getPlu().getSspVale_0(), true, "INFORMAÇÃO NUTRICIONAL", itemC.getPlu().getSspVale_3(), false, true, 14, 16, 17, 19);
        } else if (itemValue[2] == 1) {
            out = printCalculte_Special_ID2Text(itemValue, "SU2", itemC.getPlu().getSspVale_1());
            return TradeContent.printCalculate_CommandText(mapInfo, out);
        } else if (itemValue[2] == 2) {
            out = printCalculte_Special_ID2Text(itemValue, "IR2", itemC.getPlu().getSspVale_2());
            return TradeContent.printCalculate_CommandText(mapInfo, out);
        } else if (itemValue[2] == 3) {
            if (itemValue[3] == 0) {
                Object loto = tc.getSpInfo("TA128_Lot");
                if ((loto != null) && (loto instanceof String))
                    out = (String) loto;
                else
                    out = itemC.getPlu().getText().text(5);
                return TradeContent.printCalculate_CommandText(mapInfo, out);
            } else if (itemValue[3] == 1) {
                if (GlobalPara.getInstance().EcsCal_Unit_isWeight(itemC.getUnit_weight())) {
                    if (itemC.getTare().compareTo(BigDecimal.ZERO) > 0)
                        out = "L";
                    else
                        out = "B";
                    return TradeContent.printCalculate_CommandText(mapInfo, out);
                } else
                    return "";
            } else if (itemValue[3] == 2) {
                Object dro = tc.getSpInfo("TA128_DateRetro_Start");
                Calendar calendar = Calendar.getInstance();
                if ((dro != null) && (dro instanceof Date))
                    calendar.setTime((Date) dro);
                else
                    calendar.setTime(tc.getTradeTime());
                return TradeContent.printCalculate_CommandText(mapInfo, GlobalPara.getInstance().EcsCal_PrintDate(calendar));
            } else if (itemValue[3] == 3) {
                Object dro = tc.getSpInfo("TA128_DateRetro_Start");
                Object drd = tc.getSpInfo("TA128_DateRetro_Days");
                CalPLU_ShelfDate shelfdate;
                if ((dro != null) && (drd != null) && (dro instanceof Date) && (drd instanceof Integer))
                    shelfdate = new CalPLU_ShelfDate((Integer) drd, (Date) dro);
                else
                    shelfdate = new CalPLU_ShelfDate(itemC, tc.getTradeTime());

                if (!shelfdate.isPrintable())
                    return "";
                else if (shelfdate.isByHour()) {
                    if (shelfdate.getInType() >= 4)
                        return TradeContent.printCalculate_CommandText(mapInfo, shelfdate.getDirectValue().toString() + GlobalPara.getInstance().getLang("Hours"));
                    else {
                        Calendar calendar = shelfdate.getCalendar();
                        return TradeContent.printCalculate_CommandText(mapInfo, GlobalPara.getInstance().EcsCal_PrintDate(calendar) + "\n " + GlobalPara.getInstance().EcsCal_PrintTime(calendar) + " ");
                    }
                } else {
                    if (shelfdate.getInType() >= 4)
                        return TradeContent.printCalculate_CommandText(mapInfo, shelfdate.getDirectValue().toString() + GlobalPara.getInstance().getLang("Days"));
                    else {
                        return TradeContent.printCalculate_CommandText(mapInfo, GlobalPara.getInstance().EcsCal_PrintDate(shelfdate.getCalendar()));
                    }
                }
            } else if (itemValue[3] == 4) {
                return TradeContent.printCalculate_CommandText(mapInfo, itemC.getPlu().getText().text(0) + itemC.getPlu().getText().text(1) + itemC.getPlu().getText().text(2));
            } else
                return "";
        } else
            return "";
    }

    public static Object printCalculte_Special(TradeContent tc, int[] itemValue, String mapInfo, int x_Init, int subY, int labelwidth) {
        String out = "";
        try {
            String tmsVersion = GlobalPara.getInstance().Pos_TMSVersion();
            if ("TA128".equals(tmsVersion)) {
                return printCalculte_Special_TA128(tc, itemValue, mapInfo, x_Init, subY, labelwidth);
            } else {
                int itemNo = (x_Init > 0) ? x_Init : 1;     //input range: 1 to itemsize
                String caled;
                caled = tc.getCustomInfo().get('P' + Integer.toString(itemValue[2]) + '-' + Integer.toString(itemValue[3]) + '-' + Integer.toString(itemNo));
                if (caled == null)
                    caled = tc.getCustomInfo().get('P' + Integer.toString(itemValue[2]) + '-' + Integer.toString(itemValue[3]));
                if (caled != null) {
                    int barPos = caled.indexOf(':');
                    if ((barPos == 18) && (caled.startsWith("#B")))
                        out = TradeContent.printCalculate_DrawBarcode(mapInfo, caled.substring(2, 18), caled.substring(19).getBytes());
                    else
                        out = TradeContent.printCalculate_CommandText(mapInfo, caled);
                }
            }
        } catch (Exception e) {
            out = "";
        }
        return out;
    }


}
