package com.jhscale.meter.protocol.other;

import com.jhscale.meter.model.device.TCPServerDevice;
import com.jhscale.meter.model.device.UDPDevice;
import com.jhscale.meter.protocol.other.cmpt.*;

/**
 * @author wang lie
 * @title: CMPT
 * @projectName meter-jar
 * @description: TODO
 * @date 2023/5/210:55
 */
public enum CMPT {

    大华(1, new TCPServerDevice(4001), new UDPDevice(1021, 1022), "DAHUA", "大华", DAHU_ACMPT.class),
    大华2(6, new TCPServerDevice(4001), new UDPDevice(1021, 1022), "DAHUA2", "大华", DAHU2_ACMPT.class),
    托利多(2, new TCPServerDevice(3001), null, "Toledo", "托利多", Toledo_ACMPT.class),
    太航(3, new TCPServerDevice(1688), null, "Taico", "太航", Taico_ACMPT.class),
    顶尖(4, null, new UDPDevice(5001, 5001), "Aclas", "顶尖", Aclas_ACMPT.class),
    寺冈(5, new TCPServerDevice(2193), null, "Digi", "寺冈", Digi_ACMPT.class),
    ;

    private int serial;

    private TCPServerDevice tcp_server_device;

    private UDPDevice udp_device;

    private String simple;

    private String description;

    private Class clazz;

    CMPT(int serial, TCPServerDevice tcp_server_device, UDPDevice udp_device, String simple, String description, Class clazz) {
        this.serial = serial;
        this.tcp_server_device = tcp_server_device;
        this.udp_device = udp_device;
        this.simple = simple;
        this.description = description;
        this.clazz = clazz;
    }

    /**
     * @description: 获取协议
     **/
    public static CMPT serial(int serial) {
        for (CMPT cmpt : CMPT.values()) {
            if (cmpt.getSerial() == serial) return cmpt;
        }
        return null;
    }

    public int getSerial() {
        return serial;
    }

    public void setSerial(int serial) {
        this.serial = serial;
    }

    public TCPServerDevice getTcp_server_device() {
        return tcp_server_device;
    }

    public void setTcp_server_device(TCPServerDevice tcp_server_device) {
        this.tcp_server_device = tcp_server_device;
    }

    public UDPDevice getUdp_device() {
        return udp_device;
    }

    public void setUdp_device(UDPDevice udp_device) {
        this.udp_device = udp_device;
    }

    public String getSimple() {
        return simple;
    }

    public void setSimple(String simple) {
        this.simple = simple;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Class getClazz() {
        return clazz;
    }

    public void setClazz(Class clazz) {
        this.clazz = clazz;
    }
}
