package com.jhscale.meter.protocol.other.cmpt;

import com.jhscale.common.model.device.plu.DPLUV5;
import com.jhscale.common.model.device.plu.module.DPriceV2;
import com.jhscale.common.model.device.plu.module.DPrintWithBitMapV1;
import com.jhscale.common.model.device.plu.module.DTimeV2;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.io.PortManager;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.net.InetAddress;

/**
 * @author wang lie
 * @title: Aclas_ACMPT
 * @projectName meter-jar
 * @description: 顶尖
 * @date 2023/5/2115:53
 */
public class Aclas_ACMPT extends ACMPTAction<Aclas_ACMPT> {

    /**
     * @description: 初始化 TCP_Server
     **/
    @Override
    public boolean Init_TCP_Server() throws MeterException {
        return true;
    }

    /**
     * @param portManager
     * @param bytes
     * @description: TCP Server 协议解析
     */
    @Override
    public byte[] tcp_server(PortManager portManager, byte[] bytes) {
        return new byte[0];
    }

    /**
     * @param address
     * @param port
     * @param bytes
     * @description: UDP 协议解析
     */
    @Override
    public byte[] udp(PortManager portManager, InetAddress address, int port, byte[] bytes) throws MeterException {
        long tick = System.currentTimeMillis();
        if (tick - buffer_TCP_Tick > 2000)
            buffer_TCP_Pose = 0;
        buffer_TCP_Tick = tick;

        if (bytes != null && bytes.length > 0) {
            for (int loop = 0; loop < bytes.length; loop++) {

                buffer_TCP[buffer_TCP_Pose] = bytes[loop];
                buffer_TCP_Pose++;

                if (buffer_TCP_Pose >= 256 + 3) {
                    buffer_TCP_Pose = 0;
                    int Command = GetU24R(buffer_TCP, 0);
                    if (Command == 0x0e0100) {
                        int Year = GetU8FromBCD(buffer_TCP[7]);
                        int Month = GetU8FromBCD(buffer_TCP[8]);
                        int DayMonth = GetU8FromBCD(buffer_TCP[9]);
                        int Hour = GetU8FromBCD(buffer_TCP[10]);
                        int Minute = GetU8FromBCD(buffer_TCP[11]);
                        int Second = GetU8FromBCD(buffer_TCP[12]);

                        portManager.writeDataImmediately(new byte[]{0x02});
                    } else if (Command == 0x0E0300) {
                        Command = GetU16(buffer_TCP, 3);
                        if (Command == 0x0FFF) {
                            portManager.writeDataImmediately(new byte[]{0x0E, 0x03, 0x00,
                                    (byte) 0xAA, 0x4C, 0x42, 0x31, 0x2E, 0x30, 0x30, (byte) 0xAA, 0x12, (byte) 0xAB, 0x3F, (byte) 0xF8, 0x00, 0x01, 0x00, 0x00,
                                    0x31, 0x44, 0x20, 0x15, 0x09, 0x15, (byte) 0x80, 0x01, (byte) 0xAC, 0x1E, 0x1C, 0x01, 0x00, 0x02, 0x00, 0x00,
                                    0x70, 0x00, 0x40, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00});
                        } else if (buffer_TCP[5] == (byte) 0x80) {
                            portManager.writeDataImmediately(new byte[]{0x0E, 0x03, 0x00,
                                    (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff,
                                    (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff,
                                    (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff,
                                    (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff,
                                    (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff,
                                    (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff,
                                    (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff,
                                    (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff,
                                    (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff,
                                    (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff,
                                    (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff,
                                    (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff,
                                    (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff,
                                    (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff,
                                    (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff,
                                    (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff});
                        } else {
                            portManager.writeDataImmediately(new byte[]{0x0E, 0x03, 0x00,
                                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00});
                        }
                    } else if ((Command == 0x02F803) || (Command == 0x02F903) || (Command == 0x02FA03)) {
                        portManager.writeDataImmediately(new byte[]{0x02});
                    } else if ((Command == 0x0b0000) || ((Command >= 0x010000) && (Command <= 0x01FFFF))) {
                        int Items;
                        for (Items = 0; Items < 4; Items++) {
                            int offset = Items * 64 + 3;

                            int Loop;
                            Loop = 35;
                            while (true) {
                                if ((buffer_TCP[offset + Loop] > 0x20) && (buffer_TCP[offset + Loop] < 0xff))
                                    break;
                                buffer_TCP[Loop] = 0;
                                if (Loop == 0)
                                    break;
                                Loop--;
                            }
                            int Class = 9;
                            String Name;
                            try {
                                Name = new String(buffer_TCP, offset, 36, "GB2312");
                            } catch (Exception exp) {
                                Name = "";
                            }
                            if (StringUtils.isNotBlank(Name)) Name = Name.trim();
                            int sPLUno = GetU24FromBCD(buffer_TCP, offset + 36);
                            if (sPLUno == 0)
                                continue;
                            int BarF1 = GetU8FromBCD(buffer_TCP[offset + 41]);
                            BigDecimal Price = new BigDecimal(GetU32FromBCD(buffer_TCP, offset + 43)).movePointLeft(2);
                            int Unit;
                            BigDecimal Tare;
                            if ((buffer_TCP[offset + 47] >= 9) || (buffer_TCP[offset + 47] < 0)) {
                                Unit = 2;
                                Tare = BigDecimal.ZERO;
                            } else {
                                int[] put = new int[]{3, 0, 3, 0, 3, 0, 3, 0, 3};
                                int[] pu = new int[]{3, 4, 3, 8, 3, 1, 6, 7, 3};
                                BigDecimal pud[] = new BigDecimal[]{new BigDecimal("0.050"), new BigDecimal(1), new BigDecimal("0.010"), new BigDecimal(1), new BigDecimal(1),
                                        new BigDecimal(1), new BigDecimal(1), new BigDecimal(1), new BigDecimal(0.6)};
                                Unit = pu[buffer_TCP[offset + 47]];
                                Price = Price.divide(pud[buffer_TCP[offset + 47]]);
                                Tare = new BigDecimal(GetU24FromBCD(buffer_TCP, offset + 56)).movePointLeft(put[buffer_TCP[offset + 47]]);
                            }
                            //ProtocolV_FData.PLU.Barcode1=TBS[42];
                            int PC_UserDate = GetU16(buffer_TCP, offset + 48);
                            int PS_UserDate = (PC_UserDate != 0) ? 1 : 0;
                            int Note = GetU32FromBCD(buffer_TCP, offset + 60);

                            if (sPLUno > 0 && sPLUno <= 99979 && StringUtils.isNotBlank(Name))
                                this.addCache(new DPLUV5<>()
                                        .setNo(sPLUno)
                                        .setItemCode(Note)
                                        .setUnit(Unit)
                                        .setCategory(Class)
                                        .setName(Name)
                                        .setPrint(new DPrintWithBitMapV1().setBitmap(BarF1))
                                        .setTime(new DTimeV2().setUseDatePS(PS_UserDate).setUseDatePC(PC_UserDate))
                                        .setPrice(new DPriceV2().setPrice(Price))
                                        .setTare(Tare)
                                        .addPinyinSimple());
                        }

                        portManager.writeDataImmediately(new byte[]{0x02});
                    } else if ((Command == 0x6D0000) || (Command == 0x6D0100) || (Command == 0x6D0200) || (Command == 0x0E1100) || ((Command & 0xfff8ff) == 0x780000)) {
                        portManager.writeDataImmediately(new byte[]{(byte) (Command >> 16), (byte) (Command >> 16), (byte) (Command),
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00});
                    } else {
                        portManager.writeDataImmediately(new byte[]{0x02});
                    }
                    //break;
                }
            }
        }

        return new byte[0];
    }

    private static int GetU8FromBCD(int BCD) {
        BCD = BCD & 0xff;
        return BCD - ((BCD >> 4) * 6);
    }

    private static int GetU16(byte[] input, int offset) {
        return (((int) input[offset]) & 0xff) + (((int) input[offset + 1]) & 0xff) * 0x100;
    }

    private static int GetU24R(byte[] input, int offset) {
        return (((int) input[offset + 2]) & 0xff) + (((int) input[offset + 1]) & 0xff) * 0x100 + (((int) input[offset]) & 0xff) * 0x10000;
    }

    private static int GetU24FromBCD(byte[] input, int offset) {
        return GetU8FromBCD(input[offset]) * 10000 + GetU8FromBCD(input[offset + 1]) * 100 + GetU8FromBCD(input[offset + 2]);
    }

    private static int GetU32FromBCD(byte[] input, int offset) {
        return GetU8FromBCD(input[offset]) * 1000000 + GetU8FromBCD(input[offset + 1]) * 10000 + GetU8FromBCD(input[offset + 2]) * 100 + GetU8FromBCD(input[offset + 3]);
    }
}
