package com.jhscale.meter.protocol.other.cmpt;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.io.PortManager;
import com.jhscale.meter.io.control.SocketControl;
import com.jhscale.meter.protocol.model.SocketNotify;
import com.jhscale.meter.protocol.other.CMPT;

import java.net.InetAddress;

/**
 * @author wang lie
 * @title: AgreeAction
 * @projectName meter-jar
 * @description: 兼容协议执行器
 * @date 2023/5/210:52
 */
public interface CMPTAction<T> {

    /**
     * @description: 加载协议
     **/
    T Init_CMPT_Action(CMPT cmpt, SocketControl tcp_server_control, SocketControl udp_control, SocketNotify notify);

    /**
     * @description: 初始化加载器
     **/
    boolean Init_Action() throws MeterException;

    /**
     * @description: 停止服务
     **/
    boolean Stop_Action() throws MeterException;

    /**
     * @description: 初始化 TCP_Server
     **/
    boolean Init_TCP_Server() throws MeterException;

    /**
     * @description: 初始化 UDP
     **/
    boolean Init_UDP() throws MeterException;

    /**
     * @description: 协议定义
     **/
    CMPT CMPT();

    /**
     * @description: TCP Server 协议解析
     **/
    byte[] tcp_server(PortManager portManager, byte[] bytes) throws MeterException;

    /**
     * @description: UDP 协议解析
     **/
    byte[] udp(PortManager portManager, InetAddress address, int port, byte[] bytes) throws MeterException;
}
