package com.jhscale.meter.protocol.other.cmpt;

import com.jhscale.common.model.device.plu.DPLUV5;
import com.jhscale.common.model.device.plu.module.DPriceV2;
import com.jhscale.common.model.device.plu.module.DPrintWithBitMapV1;
import com.jhscale.common.model.device.plu.module.DTextV1;
import com.jhscale.common.model.device.plu.module.DTimeV2;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.io.PortManager;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.net.InetAddress;

/**
 * @author wang lie
 * @title: DHCMPT
 * @projectName meter-jar
 * @description: 大华
 * @date 2023/5/210:57
 */
public class DAHU2_ACMPT extends ACMPTAction<DAHU2_ACMPT> {

    /**
     * @param portManager
     * @param bytes
     * @description: TCP Server 协议解析
     */
    @Override
    public byte[] tcp_server(PortManager portManager, byte[] bytes) throws MeterException {
        byte[] response = new byte[0];
        for (int loop = 0; loop < bytes.length; loop++) {
            byte Data = bytes[loop];
            if (Data == '!')
                buffer_TCP_Pose = 1;
            else if (buffer_TCP_Pose >= 1) {
                if ((Data == 0x0d) || (Data == 0x0a)) {
                    buffer_TCP[buffer_TCP_Pose - 1] = 0;

                    if (buffer_TCP_Pose <= 2) {
                        buffer_TCP_Pose = 0;
                        continue;
                    }
                    if (buffer_TCP[0] == '0') {
                        // static const uint8 ctFontTable[]={1,6,1,4,0,2,0,3};
                        // static const uint8 ctFontSize[][2]=
                        // {
                        //     {16,16},
                        //     {24,24},
                        //     {32,32},
                        //     {16,32},
                        //     {24,48},
                        //     {32,64},
                        //     {48,48},
                        //     {64,64},
                        //     {64,128},
                        //     {96,96},
                        // };
                        if (buffer_TCP[1] == 'M') {
                            // todo
                            response = new byte[]{'0', 'm', 0x0d, 0x0a, 0x03};
                        } else if (buffer_TCP[1] == 'W') {
                            int Class = 9;
                            int PS_UserDate = 1;
                            int sPLUno = CustomProtocol_DAHUA_GetNumber(buffer_TCP, 2);
                            int Note = CustomProtocol_DAHUA_GetNumber_FromCharNext(buffer_TCP, (byte) 'A') % 100000;
                            BigDecimal Price = new BigDecimal(CustomProtocol_DAHUA_GetNumber_FromCharNext(buffer_TCP, (byte) 'B')).movePointLeft(2);
                            int Unit = (CustomProtocol_DAHUA_GetNumber_FromCharNext(buffer_TCP, (byte) 'C') != 0) ? 2 : 3;
                            int PC_UserDate = CustomProtocol_DAHUA_GetNumber_FromCharNext(buffer_TCP, (byte) 'D');
                            int BarF1 = CustomProtocol_DAHUA_GetNumber_FromCharNext(buffer_TCP, (byte) 'E');
                            String Name = CustomProtocol_DAHUA_GetString_FromCharNext(buffer_TCP, (byte) 'H');

                            if (sPLUno > 0 && sPLUno <= 99979 && StringUtils.isNotBlank(Name))
                                this.addCache(new DPLUV5<>()
                                        .setNo(sPLUno)
                                        .setItemCode(Note)
                                        .setUnit(Unit)
                                        .setCategory(Class)
                                        .setName(Name)
                                        .setPrint(new DPrintWithBitMapV1().setBitmap(BarF1))
                                        .setTime(new DTimeV2().setUseDatePS(PS_UserDate).setUseDatePC(PC_UserDate))
                                        .setPrice(new DPriceV2().setPrice(Price))
                                        .addPinyinSimple());

                            // todo 更新PLU信息
                            portManager.writeDataImmediately(CustomProtocol_DAHUA_ASK(new byte[]{'0', 'w', '0', '0', '0', '0', 'a', '0', 0x0d, 0x0a, 0x03}, sPLUno, 4));
                        } else if (buffer_TCP[1] == 'V') {
                            int Pos = CustomProtocol_DAHUA_FoundCharNext(buffer_TCP, (byte) 'A');

                            int Class = 9;
                            int PS_UserDate = 1;
                            int sPLUno = CustomProtocol_DAHUA_GetNumber(buffer_TCP, 2);
                            int Note = CustomProtocol_DAHUA_GetNumber_Lng(buffer_TCP, Pos, 7) % 100000;
                            BigDecimal Price = new BigDecimal(CustomProtocol_DAHUA_GetNumber_Lng(buffer_TCP, Pos + 7, 6)).movePointLeft(2);
                            int Unit = (buffer_TCP[Pos + 13] == '1') ? 2 : 3;
                            int PC_UserDate = CustomProtocol_DAHUA_GetNumber_Lng(buffer_TCP, Pos + 20, 3);
                            int BarF1 = CustomProtocol_DAHUA_GetNumber_Lng(buffer_TCP, Pos + 23, 2);
                            String Index = new String(buffer_TCP, Pos + 27, 13);
                            if (Index.equals("0000000000000")) Index = "";
                            if (StringUtils.isNotBlank(Index)) Index = Index.trim();
                            BigDecimal Tare = new BigDecimal(CustomProtocol_DAHUA_GetNumber_Lng(buffer_TCP, Pos + 40, 5)).movePointLeft(3);
                            String Name = CustomProtocol_DAHUA_GetString_FromCharNext(buffer_TCP, (byte) 'B');
                            String Text1 = CustomProtocol_DAHUA_GetString_FromCharNext(buffer_TCP, (byte) 'C');
                            String Text2 = CustomProtocol_DAHUA_GetString_FromCharNext(buffer_TCP, (byte) 'D');

                            if (sPLUno > 0 && sPLUno <= 99979 && StringUtils.isNotBlank(Name))
                                this.addCache(new DPLUV5<>()
                                        .setNo(sPLUno)
                                        .setItemCode(Note)
                                        .setIndexBar(Index)
                                        .setUnit(Unit)
                                        .setCategory(Class)
                                        .setName(Name)
                                        .setPrint(new DPrintWithBitMapV1().setBitmap(BarF1))
                                        .setText(new DTextV1().addTexts(Text1, Text2))
                                        .setTime(new DTimeV2().setUseDatePS(PS_UserDate).setUseDatePC(PC_UserDate))
                                        .setPrice(new DPriceV2().setPrice(Price))
                                        .setTare(Tare)
                                        .addPinyinSimple());

                            // todo 更新PLU信息
                            portManager.writeDataImmediately(CustomProtocol_DAHUA_ASK(new byte[]{'0', 'v', '0', '0', '0', '0', 'a', '0', 0x0d, 0x0a, 0x03}, sPLUno, 4));
                        } else if (buffer_TCP[1] == 'P') {
                            int Year = CustomProtocol_DAHUA_GetNumber_Lng(buffer_TCP, 2, 2);
                            int Month = CustomProtocol_DAHUA_GetNumber_Lng(buffer_TCP, 4, 2);
                            int DayMonth = CustomProtocol_DAHUA_GetNumber_Lng(buffer_TCP, 6, 2);
                            int Hour = CustomProtocol_DAHUA_GetNumber_Lng(buffer_TCP, 8, 2);
                            int Minute = CustomProtocol_DAHUA_GetNumber_Lng(buffer_TCP, 10, 2);
                            int Second = 0;

                            // todo 什么都不做
                            portManager.writeDataImmediately(new byte[]{'0', 'p', 0x0d, 0x0a, 0x03});
                        } else {
                            // todo 什么都不做
                            byte[] answer = new String(new byte[]{buffer_TCP[1]}).toLowerCase().getBytes();
                            portManager.writeDataImmediately(new byte[]{'0', answer[0], 0x0d, 0x0a, 0x03});
                        }
                    }
                    buffer_TCP_Pose = 0;
                } else if (buffer_TCP_Pose < buffer_TCP.length) {
                    buffer_TCP[buffer_TCP_Pose - 1] = Data;
                    buffer_TCP_Pose++;
                }
            }
        }
        return response;
    }

    /**
     * @param address
     * @param port
     * @param bytes
     * @description: UDP 协议解析
     */
    @Override
    public byte[] udp(PortManager portManager, InetAddress address, int port, byte[] bytes) {
        byte[] response = new byte[0];
        int send = 0;
        if (bytes != null && bytes.length > 0) {
            for (int loop = 0; loop < bytes.length; loop++) {
                if (bytes[loop] == 'U')
                    send = 1;
                else if (bytes[loop] == 'W')
                    send = 2;
                else if (bytes[loop] == 'Y')
                    send = 3;
            }
        }

        if (send == 1) {
            byte[] output = new byte[]{'E', 'T', 'O', 'R', 'S', '2', '3', '2', '_', '0', '0', '0', ' ', ' ', ' ', ' ', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            //ip=
            output[16] = (byte) 192;
            output[17] = (byte) 168;
            output[18] = (byte) 100;
            output[19] = (byte) 193;
            //mac=
            output[20] = 1;
            output[21] = 2;
            output[22] = 3;
            output[23] = 4;
            output[24] = 5;
            output[25] = 6;
            response = output;
        }

        // if (send == 2) {
        //     byte[] output = new byte[]{'E', 'T', 'O', 'R', 'S', '2', '3', '2', '_', '0', '0', '0', ' ', ' ', ' ', ' ',
        //             0, 0, 0, 0,        //ip=16
        //             0, 0, 0, 0,        //mask=20
        //             0, 0, 0, 0,        //gateway=24
        //             (byte) 0xa1, 0x0f,      //4001
        //             0, 0, 0, 0, 0, 0,       //mac=30
        //             0, 0, 0, 0,
        //             (byte) 0xa2, 0x0f,      //4002
        //             0x02, 0x03, 0x02, 0x50, 0x50
        //     };
        //     //ip=
        //     output[16] = (byte) 192;
        //     output[17] = (byte) 168;
        //     output[18] = (byte) 100;
        //     output[19] = (byte) 193;
        //     //mask=
        //     output[16] = (byte) 255;
        //     output[17] = (byte) 255;
        //     output[18] = (byte) 255;
        //     output[19] = (byte) 255;
        //     //gateway=
        //     output[16] = (byte) 192;
        //     output[17] = (byte) 168;
        //     output[18] = (byte) 100;
        //     output[19] = (byte) 1;
        //     //mac=
        //     output[30] = 1;
        //     output[31] = 2;
        //     output[32] = 3;
        //     output[33] = 4;
        //     output[34] = 5;
        //     output[35] = 6;
        //     UDP_Link.writeDataImmediately(output);
        // }
        return response;
    }

    private int CustomProtocol_DAHUA_GetNumber(byte[] input, int offset) {
        int rv = 0;
        while (true) {
            int ctv;
            ctv = input[offset] - 0x30;
            if ((ctv <= 9) && (ctv >= 0))
                rv = rv * 10 + ctv;
            else
                return rv;
            offset++;
        }
    }

    private int CustomProtocol_DAHUA_GetNumber_FromCharNext(byte[] input, byte Char) {
        int Pos;
        Pos = CustomProtocol_DAHUA_FoundCharNext(input, Char);
        if (Pos == 0)
            return 0;
        return CustomProtocol_DAHUA_GetNumber(input, Pos);
    }

    private int CustomProtocol_DAHUA_FoundCharNext(byte[] input, byte Char) {
        int Loop;
        for (Loop = 2; Loop < input.length; Loop++) {
            byte ct = input[Loop];
            if (ct == 0)
                return 0;
            if (ct == Char)
                return Loop + 1;
        }
        return 0;
    }

    private String CustomProtocol_DAHUA_GetString_FromCharNext(byte[] input, byte Char) {
        int sPos;
        sPos = CustomProtocol_DAHUA_FoundCharNext(input, Char);
        if (sPos == 0)
            return "";
        String txt = CustomProtocol_DAHUA_GetString(input, sPos);
        if (StringUtils.isNotBlank(txt)) txt = txt.trim();
        return txt;
    }

    private String CustomProtocol_DAHUA_GetString(byte[] input, int offset) {
        byte[] target = new byte[1024];
        int tPos = 0;

        if (input[offset] == 0)
            return "";

        while (true) {
            if (tPos >= target.length - 3) {
                target[tPos] = 0;
                break;
            }

            int a1 = input[offset] - 0x30;
            int a2 = input[offset + 1] - 0x30;
            int b1 = input[offset + 2] - 0x30;
            int b2 = input[offset + 3] - 0x30;

            int rv0 = a1 * 10 + a2;
            int rv1 = b1 * 10 + b2;

            if ((rv0 < 0) || (rv0 > 99) || (rv1 < 0) || (rv1 > 99))
                rv0 = rv1 = 0;

            if (rv0 == 0) {
                target[tPos] = 0;
                break;
            } else if ((rv0 == 1) && (rv1 == 1)) {
                target[tPos] = ' ';
                tPos++;
            } else if ((rv0 == 3) && (rv1 <= 95)) {
                target[tPos] = (byte) (rv1 + 32);
                tPos++;
            } else {
                target[tPos] = (byte) (rv0 + 0xa0);
                target[tPos + 1] = (byte) (rv1 + 0xa0);
                tPos += 2;
            }

            offset += 4;
        }

        String result;
        try {
            result = new String(target, "GB2312");
        } catch (Exception exp) {
            result = "";
        }
        if (result.equals("上海大华电子秤厂"))
            result = "上海精函信息科技有限公司";
        return result;
    }

    private byte[] CustomProtocol_DAHUA_ASK(byte[] input, int value, int lng) {
        while (lng > 0) {
            lng--;
            input[2 + lng] = (byte) (value % 10 + 0x30);
            value /= 10;
        }
        return input;
    }

    private int CustomProtocol_DAHUA_GetNumber_Lng(byte[] input, int offset, int lng) {
        int result = 0;
        for (int loop = 0; loop < lng; loop++) {
            result = (input[offset + loop] - '0') + result * 10;
        }
        return result;
    }
}
