package com.jhscale.meter.protocol.other.cmpt;

import com.jhscale.common.model.device.plu.DPLUV5;
import com.jhscale.common.model.device.plu.module.DPriceV2;
import com.jhscale.common.model.device.plu.module.DPrintWithBitMapV1;
import com.jhscale.common.model.device.plu.module.DTimeV2;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.io.PortManager;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.net.InetAddress;

/**
 * @author wang lie
 * @title: Digi_ACMPT
 * @projectName meter-jar
 * @description: 寺冈
 * @date 2023/5/2115:55
 */
public class Digi_ACMPT extends ACMPTAction<Digi_ACMPT> {

    /**
     * @description: 初始化 UDP
     **/
    @Override
    public boolean Init_UDP() throws MeterException {
        return true;
    }

    /**
     * @param portManager
     * @param bytes
     * @description: TCP Server 协议解析
     */
    @Override
    public byte[] tcp_server(PortManager portManager, byte[] bytes) throws MeterException {
        for (int loop = 0; loop < bytes.length; loop++) {
            byte Data = bytes[loop];
            if (buffer_TCP_Pose <= 4) {
                buffer_TCP[0] = Data;
                if (Data == (byte) 0xf1)
                    buffer_TCP_Pose = 5;
            } else if (buffer_TCP[0] == (byte) 0xf1) {
                if (buffer_TCP_Pose < 12) {
                    buffer_TCP[buffer_TCP_Pose - 4] = Data;
                    buffer_TCP_Pose++;
                } else if (buffer_TCP_Pose <= buffer_TCP[7] + 4) {
                    buffer_TCP[buffer_TCP_Pose - 4] = Data;
                    buffer_TCP_Pose++;
                } else {
                    int cstep;
                    cstep = buffer_TCP_Pose;
                    buffer_TCP_Pose = 0;
                    int sPLUno = GetU32FromBCD(buffer_TCP, 2);
                    if (sPLUno == 0)
                        continue;
                    int ItemCode = GetU32FromBCD(buffer_TCP, 20) / 1000;
                    int Pos = ((buffer_TCP[25] & 0x01) != 0) ? 26 : 28;
                    int ShelfDay = GetU16FromBCD(buffer_TCP, Pos);
                    Pos += 6;
                    int Length;
                    Length = Math.min(cstep - 4 - Pos, 256);
                    if (Length < 0)
                        continue;

                    int Loop;
                    //uint32 Tip;
                    int CharED;
                    int FirstZERO;

                    byte[] TChars = new byte[10240];
                    int Unit = ((buffer_TCP[8] & 0x01) != 0) ? 2 : 1;
                    BigDecimal Price = new BigDecimal(GetU32FromBCD(buffer_TCP, 13)).movePointLeft(2);
                    int BarF1 = GetU8FromBCD(buffer_TCP[19]);
                    int Note = GetU32FromBCD(buffer_TCP, 20) / 1000;
                    int PC_UserDate = ShelfDay;
                    int PS_UserDate = (ShelfDay != 0) ? 1 : 0;

                    Loop = CharED = FirstZERO = 0;
                    while (true) {
                        int nextLoop;
                        nextLoop = Loop + (buffer_TCP[Pos + Loop + 1] & 0xff) + 3;
                        //if(nextLoop>Length)
                        //	break;
                        if (nextLoop > Length) {
                            if (Length - Loop >= 0x08) {
                                Loop++;
                                continue;
                            } else
                                break;
                        } else if ((buffer_TCP[Pos + nextLoop - 1] != 0x0c) && (buffer_TCP[Pos + nextLoop - 1] != 0x0d)) {
                            Loop++;
                            continue;
                        }
                        for (int copyl = 0; copyl < (buffer_TCP[Pos + Loop + 1] & 0xff); ) {
                            TChars[CharED] = buffer_TCP[Pos + Loop + 2 + copyl];
                            CharED++;
                            copyl++;
                        }
                        if (buffer_TCP[Pos + nextLoop - 1] == 0x0c) {
                            if (FirstZERO == 0) {
                                TChars[CharED] = 0;
                                CharED++;
                                FirstZERO = 1;
                            }
                            TChars[CharED] = 0;
                            CharED++;
                        }
                        Loop = nextLoop;
                    }
                    TChars[CharED] = 0;

                    int Class = 9;
                    String Name;
                    try {
                        Name = new String(TChars, "GB2312");
                    } catch (Exception exp) {
                        Name = "";
                    }
                    if (StringUtils.isNotBlank(Name)) Name = Name.trim();

                    if (sPLUno > 0 && sPLUno <= 99979 && StringUtils.isNotBlank(Name))
                        this.addCache(new DPLUV5<>()
                                .setNo(sPLUno)
                                .setItemCode(Note)
                                .setUnit(Unit)
                                .setCategory(Class)
                                .setName(Name)
                                .setPrint(new DPrintWithBitMapV1().setBitmap(BarF1))
                                .setTime(new DTimeV2().setUseDatePS(PS_UserDate).setUseDatePC(PC_UserDate))
                                .setPrice(new DPriceV2().setPrice(Price))
                                .addPinyinSimple());

                    portManager.writeDataImmediately(new byte[]{0x06});
                }
            }
        }
        return new byte[0];
    }

    /**
     * @param portManager
     * @param address
     * @param port
     * @param bytes
     * @description: UDP 协议解析
     */
    @Override
    public byte[] udp(PortManager portManager, InetAddress address, int port, byte[] bytes) throws MeterException {
        return new byte[0];
    }

    private static int GetU8FromBCD(int BCD) {
        BCD = BCD & 0xff;
        return BCD - ((BCD >> 4) * 6);
    }

    private static int GetU16FromBCD(byte[] input, int offset) {
        return GetU8FromBCD(input[offset]) * 100 + GetU8FromBCD(input[offset + 1]);
    }

    private static int GetU32FromBCD(byte[] input, int offset) {
        return GetU8FromBCD(input[offset]) * 1000000 + GetU8FromBCD(input[offset + 1]) * 10000 + GetU8FromBCD(input[offset + 2]) * 100 + GetU8FromBCD(input[offset + 3]);
    }
}
