package com.jhscale.meter.protocol.other.cmpt;

import com.jhscale.common.model.device.plu.DPLUV5;
import com.jhscale.common.model.device.plu.module.DPriceV2;
import com.jhscale.common.model.device.plu.module.DTimeV2;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.io.PortManager;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.net.InetAddress;

/**
 * @author wang lie
 * @title: Taico_ACMPT
 * @projectName meter-jar
 * @description: 台衡
 * @date 2023/5/2115:52
 */
public class Taico_ACMPT extends ACMPTAction<Taico_ACMPT> {

    /**
     * @description: 初始化 UDP
     **/
    @Override
    public boolean Init_UDP() throws MeterException {
        return true;
    }

    /**
     * @param portManager
     * @param bytes
     * @description: TCP Server 协议解析
     */
    @Override
    public byte[] tcp_server(PortManager portManager, byte[] bytes) throws MeterException {
        byte[] response = new byte[0];
        if (bytes != null && bytes.length > 0) {
            for (int loop = 0; loop < bytes.length; loop++) {
                byte Data = bytes[loop];
                if (buffer_TCP_Pose <= 4) {
                    if (Data == 0x02)
                        buffer_TCP_Pose = 5;
                } else if (Data != 0x03) {
                    if ((buffer_TCP_Pose & 0x01) != 0)
                        buffer_TCP[(buffer_TCP_Pose - 5) / 2] = (byte) (Data << 4);
                    else
                        buffer_TCP[(buffer_TCP_Pose - 5) / 2] |= Data & 0x0f;
                    buffer_TCP_Pose++;
                } else {
                    portManager.writeDataImmediately(new byte[]{0x02, 0x30, 0x32, 0x30, 0x32, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3f, 0x3b, 0x03});
                    if ((buffer_TCP_Pose >= 0x7f + 4) && (buffer_TCP_Pose <= 0x87 + 4)) {
                        int Loop, TLng;
                        Loop = 0;
                        TLng = 0;
                        byte[] target = new byte[1024];

                        while (true) {
                            int Value = GetU16R(buffer_TCP, 18 + 2 * Loop);
                            if ((Value < 100) || (Loop >= 12)) {
                                target[TLng] = 0;
                                break;
                            } else if (Value < 400) {
                                target[TLng] = (byte) ((Value % 100) + 32);
                                TLng++;
                            } else {
                                target[TLng] = (byte) ((Value / 100) + 0xa0);
                                target[TLng + 1] = (byte) ((Value % 100) + 0xa0);
                                TLng += 2;
                            }
                            Loop++;
                        }

                        String Name;
                        try {
                            Name = new String(target, "GB2312");
                        } catch (Exception exp) {
                            Name = "";
                        }
                        if (StringUtils.isNotBlank(Name)) Name = Name.trim();
                        int Class = 9;
                        int PS_UserDate = 1;
                        int PC_UserDate = GetU16R(buffer_TCP, 49) / 100;
                        int sPLUno = GetS32R(buffer_TCP, 8);
                        int Note = GetS32R(buffer_TCP, 12);
                        BigDecimal Price = new BigDecimal(GetS32R(buffer_TCP, 42)).movePointLeft(2);
                        BigDecimal Tare = new BigDecimal(GetS32R(buffer_TCP, 52)).movePointLeft(3);
                        int Unit;
                        if (buffer_TCP[51] == 0)
                            Unit = 1;
                        else
                            Unit = 2;

                        if (sPLUno > 0 && sPLUno <= 99979 && StringUtils.isNotBlank(Name))
                            this.addCache(new DPLUV5<>()
                                    .setNo(sPLUno)
                                    .setItemCode(Note)
                                    .setUnit(Unit)
                                    .setCategory(Class)
                                    .setName(Name)
                                    .setTime(new DTimeV2().setUseDatePS(PS_UserDate).setUseDatePC(PC_UserDate))
                                    .setPrice(new DPriceV2().setPrice(Price))
                                    .setTare(Tare)
                                    .addPinyinSimple());
                    }
                    buffer_TCP_Pose = 0;
                    break;
                }
            }
        }
        return response;
    }

    /**
     * @param address
     * @param port
     * @param bytes
     * @description: UDP 协议解析
     */
    @Override
    public byte[] udp(PortManager portManager, InetAddress address, int port, byte[] bytes) {
        return new byte[0];
    }

    private static int GetS32R(byte[] input, int offset) {
        return (((int) input[offset + 3]) & 0xff) + (((int) input[offset + 2]) & 0xff) * 0x100 + (((int) input[offset + 1]) & 0xff) * 0x10000 + (((int) input[offset]) & 0xff) * 0x1000000;
    }

    private static int GetU16R(byte[] input, int offset) {
        return (((int) input[offset + 1]) & 0xff) + (((int) input[offset]) & 0xff) * 0x100;
    }
}
