package com.jhscale.meter.protocol.other.cmpt;

import com.jhscale.common.model.device.plu.DPLUV5;
import com.jhscale.common.model.device.plu.module.DPriceV2;
import com.jhscale.common.model.device.plu.module.DTimeV2;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.io.PortManager;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.net.InetAddress;

/**
 * @author wang lie
 * @title: Toledo_ACMPT
 * @projectName meter-jar
 * @description: 托利多
 * @date 2023/5/2115:45
 */
public class Toledo_ACMPT extends ACMPTAction<Toledo_ACMPT> {

    /**
     * @description: 初始化 UDP
     **/
    @Override
    public boolean Init_UDP() throws MeterException {
        return true;
    }

    /**
     * @param portManager
     * @param bytes
     * @description: TCP Server 协议解析
     */
    @Override
    public byte[] tcp_server(PortManager portManager, byte[] bytes) throws MeterException {
        byte[] response = new byte[0];
        for (int loop = 0; loop < bytes.length; loop++) {
            byte Data = bytes[loop];
            if (buffer_TCP_Pose == 0) {
                if (Data == 0x02)
                    buffer_TCP_Pose = 1;
            } else if (buffer_TCP_Pose <= 14) {
                buffer_TCP[buffer_TCP_Pose - 1] = Data;
                buffer_TCP_Pose++;
            } else {
                int Local_Lng = GetU16(buffer_TCP, 4);
                int Local_Records = GetU16(buffer_TCP, 2);
                int Local_Type = buffer_TCP[7] & 0xff;
                int Local_NeedVersion = buffer_TCP[9] & 0xff;
                if (Local_Lng == 0)
                    buffer_TCP_Pose = 0;
                else {
                    if (buffer_TCP_Pose < buffer_TCP.length - 3)
                        buffer_TCP[buffer_TCP_Pose - 3] = Data;
                    buffer_TCP_Pose++;
                    if (Local_Records == 0) {
                        if (buffer_TCP_Pose >= 15 + 2) {
                            buffer_TCP_Pose = 0;
                            //if (Local_NeedVersion >= 0x80)          //242
                            portManager.writeDataImmediately(new byte[]{0x66, 0x02, 0x0E, 0x00, 0x01, 0x00, 0x06, 0x00, 0x01, (byte) 0xEE, 0x00, (byte) 0xC0, (byte) 0xB3, 0x01, 0x00, 0x00, 0x14, 0x07, 0x0F, 0x0E, 0x0E, 0x25, 0x30, 0x3B});
                            // else
                            // portManager.writeDataImmediately(new byte[]{0x06});
                        }
                    } else if (buffer_TCP_Pose >= 15 + Local_Lng) {
                        if ((Local_Type == 0xee) && (Local_Lng == 0x06)) {
                            int DayMonth = buffer_TCP[12];
                            int Month = buffer_TCP[13];
                            int Year = buffer_TCP[14];
                            int Hour = buffer_TCP[15];
                            int Minute = buffer_TCP[16];
                            int Second = buffer_TCP[17];
                        } else if ((Local_Type == 0xcf) && (Local_Lng == 0x44)) {
                            int Loop;
                            Loop = 28;
                            while (true) {
                                Loop--;
                                if (buffer_TCP[29 + Loop] == 0x20)
                                    buffer_TCP[29 + Loop] = 0;
                                else
                                    break;
                                if (Loop == 0)
                                    break;
                            }

                            String Name;
                            try {
                                Name = new String(buffer_TCP, 29, 28, "GB2312");
                            } catch (Exception exp) {
                                Name = "";
                            }
                            if (StringUtils.isNotBlank(Name)) Name = Name.trim();
                            int Class = 9;
                            int PS_UserDate = 1;
                            int sPLUno = GetS32(buffer_TCP, 12);
                            int Note = CustomProtocol_DAHUA_GetNumber_Lng(buffer_TCP, 16, 13);
                            BigDecimal Price = new BigDecimal(GetS32(buffer_TCP, 58)).movePointLeft(2);
                            int Unit;
                            if ((buffer_TCP[72] & 0x01) != 0)
                                Unit = 2;
                            else
                                Unit = 1;
                            int PC_UserDate = GetU16(buffer_TCP, 76);

                            if (sPLUno > 0 && sPLUno <= 99979 && StringUtils.isNotBlank(Name))
                                this.addCache(new DPLUV5<>()
                                        .setNo(sPLUno)
                                        .setItemCode(Note)
                                        .setUnit(Unit)
                                        .setCategory(Class)
                                        .setName(Name)
                                        .setTime(new DTimeV2().setUseDatePS(PS_UserDate).setUseDatePC(PC_UserDate))
                                        .setPrice(new DPriceV2().setPrice(Price))
                                        .addPinyinSimple());
                        }

                        Local_Records--;
                        buffer_TCP[2] = (byte) (Local_Records & 0xff);
                        buffer_TCP[3] = (byte) (Local_Records >> 8);
                        buffer_TCP_Pose = 15;
                    }

                }
            }
        }
        return response;
    }

    /**
     * @param address
     * @param port
     * @param bytes
     * @description: UDP 协议解析
     */
    @Override
    public byte[] udp(PortManager portManager, InetAddress address, int port, byte[] bytes) {
        return new byte[0];
    }

    private int GetU16(byte[] input, int offset) {
        return (((int) input[offset]) & 0xff) + (((int) input[offset + 1]) & 0xff) * 0x100;
    }

    private int GetS32(byte[] input, int offset) {
        return (((int) input[offset]) & 0xff) + (((int) input[offset + 1]) & 0xff) * 0x100 + (((int) input[offset + 2]) & 0xff) * 0x10000 + (((int) input[offset + 3]) & 0xff) * 0x1000000;
    }

    private int CustomProtocol_DAHUA_GetNumber_Lng(byte[] input, int offset, int lng) {
        int result = 0;
        for (int loop = 0; loop < lng; loop++) {
            result = (input[offset + loop] - '0') + result * 10;
        }
        return result;
    }
}
