package com.jhscale.meter.protocol.print;

/**
 * @author lie_w
 * @title: PrintConstant
 * @projectName jhscale-agreement
 * @description: 打印常量
 * @date 2020-12-2210:40
 */
public interface PrintConstant {

    /**
     * @description: 数据内容默认 UTF-8 字符集
     **/
    String DEFAULT_CHARSET = "UTF-8";

    /**
     * @description: 默认打印机宽度
     **/
    Integer DEFAULT_PRINT_WIDTH = 48;

    /**
     * @description: 单次通讯最大超时时间 5000ms
     **/
    Long SINGLE_COMMUNICATION_MAX_TIME = 5000L;

    /**
     * @description: 打印命令起始头字段
     **/
    String PRINT_START_TOP = "02";

    /******************************打印状态码***********************************/
    String SUCCESS = "00";
    String BUFFER_LIMIT_EXCEEDED = "01";
    String CRC_ERROR = "02";
    String BUFFER_LIMIT_EXCEEDED_AND_CRC_ERROR = "03";
    String START_ERROR = "04";

    char ZERO = '0';
    char ONE = '1';

    String SPLIT = "\n";

    /**
     * @description: 打印机名称
     **/
    int DEFAULT_PRINT = 0;
    int NODE_DEFAULT = -1;
    int NODE_A_P = 0;
    int NODE_B_P = 1;

}
