package com.jhscale.meter.protocol.print;

import com.jhscale.common.model.license.RSAEncryptDecrypt;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.print.data.PrintDataAssemble;
import com.jhscale.meter.protocol.print.data.PrintDataParse;
import com.jhscale.meter.protocol.print.data.PrintVal;
import com.jhscale.meter.protocol.print.entity.PrintCmdInfo;
import com.jhscale.meter.protocol.print.entity.PrintLOGParam;
import com.jhscale.meter.protocol.print.entity.PrintRequest;
import com.jhscale.meter.protocol.print.entity.PrintResponse;
import com.jhscale.meter.protocol.print.entity.data.PrintDataRequest;
import com.jhscale.meter.protocol.print.entity.para.Para;
import com.jhscale.meter.protocol.print.entity.para.RealBitmapPara;
import com.jhscale.meter.protocol.print.image.ImageProcess;
import com.jhscale.meter.protocol.print.link.IPrintBack;
import com.jhscale.meter.protocol.print.link.Messenger;
import com.jhscale.meter.protocol.print.link.ReadReuslt;
import com.jhscale.meter.protocol.print.link.SendResult;
import com.jhscale.meter.protocol.print.produce.entity.PrintBackResponse;
import com.jhscale.meter.protocol.print.temp.Temp;
import com.jhscale.meter.protocol.print.temp.Temp1;
import com.jhscale.meter.utils.PrintUtils;
import org.apache.commons.lang3.StringUtils;

import java.lang.reflect.ParameterizedType;
import java.nio.charset.Charset;
import java.util.*;

/**
 * @author lie_w
 * @title: PrintFactory
 * @projectName jhscale-agreement
 * @description: 打印工厂节点
 * @date 2020-12-2210:33
 */
public class PrintFactory implements PrintCommunication {

    /******************************** 默认工具规整 ***********************************/

    // 字符集
    private String charset = PrintConstant.DEFAULT_CHARSET;

    // 图片处理器器
    private ImageProcess imageProcess;

    // 加解密工具
    private RSAEncryptDecrypt encryptDecrypt;

    /******************************** 默认工具规整 ***********************************/

    /***************************打印数据字符集 Start***********************************/

    /**
     * @description: 设置加解密方式
     **/
    public PrintFactory addRSAEncryptDecrypt(RSAEncryptDecrypt encryptDecrypt) {
        this.encryptDecrypt = encryptDecrypt;
        return this;
    }

    /**
     * @description: 获取加解密方式
     **/
    public RSAEncryptDecrypt obtainRSAEncryptDecrypt() throws MeterException {
        if (this.encryptDecrypt == null)
            throw new MeterException(MeterStateEnum.加解密模块未初始化);
        return this.encryptDecrypt;
    }

    /**
     * @description: 字符集
     **/
    public Charset charset() {
        return Charset.forName(this.charset);
    }

    /**
     * @description: 设置字符集
     **/
    public PrintFactory setCharset(String charset) {
        this.charset = charset;
        return this;
    }

    /**
     * @description: 获取使用中的字符集
     **/
    public String getCharset() {
        return this.charset;
    }

    /**
     * @description: 设置原始数据响应 默认不响应false
     **/
    public PrintFactory originalResponse(boolean originalResponse) {
        this.originalResponse = originalResponse;
        return this;
    }

    /**
     * @description: 原始数据响应回调状态
     **/
    @Override
    public boolean originalResponse() {
        return this.originalResponse;
    }

    /**
     * @description: 打印日志配置参数
     **/
    @Override
    public PrintLOGParam param() {
        if (this.param == null) this.param = new PrintLOGParam();
        return this.param;
    }

    /**
     * @description: 设置原始数据响应 默认不响应false
     **/
    public void logSwitch(boolean logSwitch, Integer logLength) {
        if (this.param == null) this.param = new PrintLOGParam();
        this.param.set_switch(logSwitch);
        this.param.set_length(Objects.isNull(logLength) || logLength == 0 ? 2048 : logLength);
    }

    /**************************** 打印数据字符集 End ************************************/

    /******************************** 旧版打印操作信息 ***********************************/

    // 打印数据模板信息
    private List<PrintDataParse.PrintPart> printParts;

    // 名称
    private Integer serial;

    // 通讯器
    private Messenger messenger;

    // 单次通讯最大超时时间 默认5S
    private Long communicationMaxTime = PrintConstant.SINGLE_COMMUNICATION_MAX_TIME;

    // 打印缓冲区
    private List<Para> paraCache;

    // 响应原始解析数据
    private boolean originalResponse = false;
    // 全日志
    private PrintLOGParam param;

    /******************************** 旧版打印操作信息 ***********************************/

    private PrintFactory() {
    }

    private static class SinglePrintFactory {
        private static PrintFactory INSTANCE = new PrintFactory();
    }

    public static PrintFactory getInstance() {
        return SinglePrintFactory.INSTANCE;
    }

    /*********************************打印工厂构建 Start******************************************/

    /**
     * @description: 构建打印工厂参数
     **/
    @Deprecated
    public PrintFactory build(String charset, List<PrintDataParse.PrintPart> printParts, Messenger messenger, Long communicationMaxTime) throws MeterException {
        return this.setCharset(charset)
                .setPrintParts(printParts)
                .setMessenger(messenger)
                .setCommunicationMaxTime(communicationMaxTime);
    }

    /**
     * @description: 构建打印工厂参数
     **/
    public PrintFactory build(String charset, List<PrintDataParse.PrintPart> printParts, Messenger messenger) throws MeterException {
        return this.setCharset(charset)
                .setPrintParts(printParts)
                .setMessenger(messenger);
    }

    /**
     * @description: 构建打印工厂参数 默认字符集 默认超时时间
     **/
    public PrintFactory build(List<PrintDataParse.PrintPart> printParts, Messenger messenger) throws MeterException {
        return this.setPrintParts(printParts)
                .setMessenger(messenger);
    }

    /**
     * @description: 构建消息器
     **/
    public PrintFactory build(Messenger messenger) {
        return this.setMessenger(messenger);
    }

    /**
     * @description: 构建消息器
     **/
    public PrintFactory build(Integer serial, Messenger messenger) {
        this.serial = serial;
        return this.setMessenger(messenger);
    }

    /**
     * @description: 构建图片处理器
     **/
    public PrintFactory build(ImageProcess imageProcess) {
        return this.setImageProcess(imageProcess);
    }

    /*********************************打印工厂构建 End******************************************/

    /*********************************打印模板数据处理 Start******************************************/

    /**
     * @description: 打印模板解析
     **/
    public PrintDataParse templateAnalysisPrintData(String template) throws MeterException {
        if (StringUtils.isBlank(template))
            throw new MeterException(MeterStateEnum.解析模板无效);
        return new PrintDataParse(template);
    }

    /**
     * @description: 打印模板解析
     **/
    public List<PrintDataParse.PrintPart> templateAnalysis(String template) throws MeterException {
        return this.templateAnalysisPrintData(template).getPrintParts();
    }

    /**
     * @description: 打印模板解析 并 添加工厂
     **/
    public PrintFactory templateAnalysisAndSet(String template) throws MeterException {
        return this.setPrintParts(templateAnalysis(template));
    }

    /**
     * @description: 设置打印模板信息
     **/
    public PrintFactory setPrintParts(List<PrintDataParse.PrintPart> printParts) throws MeterException {
        if (printParts == null || printParts.isEmpty())
            throw new MeterException(MeterStateEnum.模板片段无效);
        this.printParts = printParts;
        return this;
    }

    /**
     * @description: 获取使用中的打印模板信息
     **/
    public List<PrintDataParse.PrintPart> getUsingPrintParts() {
        return this.printParts;
    }

    /**
     * @description: 单添加映射值
     **/
    public PrintFactory putMapping(Integer index, String field, String mapping) throws MeterException {
        if (this.printParts == null)
            throw new MeterException(MeterStateEnum.打印模板数据未设置);
        if (index >= this.printParts.size())
            throw new MeterException(MeterStateEnum.模板片段不存在);
        this.getUsingPrintParts().get(index).putMapping(field, mapping);
        return this;
    }

    /**
     * @description: 添加内容部分映射值
     **/
    public PrintFactory putMappings(Integer index, Map<String, String> mappings) throws MeterException {
        if (this.printParts == null)
            throw new MeterException(MeterStateEnum.打印模板数据未设置);
        if (index >= this.printParts.size())
            throw new MeterException(MeterStateEnum.模板片段不存在);
        this.getUsingPrintParts().get(index).setMappings(mappings);
        return this;
    }

    /**
     * @description: 拼装打印数据
     **/
    public String assemblePrintData(PrintVal printVal) throws MeterException {
        if (this.printParts == null)
            throw new MeterException(MeterStateEnum.打印模板数据未设置);
        return new PrintDataAssemble(charset(), printParts, printVal).assemble();
    }

    /*********************************打印模板数据处理 End******************************************/

    /*************************************图像处理器 start********************************************/
    /**
     * @description: 添加图片处理器
     **/
    public PrintFactory setImageProcess(ImageProcess imageProcess) {
        if (this.imageProcess == null)
            this.imageProcess = imageProcess;
        return this;
    }

    /**
     * @description: 图片处理器
     **/
    public ImageProcess getImageProcess() {
        return imageProcess;
    }
    /*************************************图像处理器 End***********************************************/


    /*********************************发送打印命令通讯 Start******************************************/

    /**
     * @description: 设置单次通讯最大超时时间
     **/
    @Deprecated
    public PrintFactory setCommunicationMaxTime(Long communicationMaxTime) {
        this.communicationMaxTime = communicationMaxTime;
        return this;
    }

    /**
     * @description: 设置通讯器
     **/
    public PrintFactory setMessenger(Messenger messenger) {
        if (this.messenger == null)
            this.messenger = messenger;

        if (this.printCmdInfoList == null)
            this.printCmdInfoList = Collections.synchronizedList(new ArrayList<>());
        this.printCmdInfoList.clear();

        this.threadStatus = true;
        this.sendStatus = false;

        if (this.thread == null) {
            this.thread = new SendPrintThread();
            this.thread.start();
        }

        return this;
    }

    /**
     * @description: 发送完成
     **/
    @Override
    public void sendSuccess() {
        this.sendStatus = false;
        this.count = 0;
        this.now = null;
    }

    /**
     * @description: 当前发送状态
     **/
    @Override
    public boolean isSendStatus() {
        return this.sendStatus;
    }

    private List<PrintCmdInfo> printCmdInfoList;
    private SendPrintThread thread;
    private boolean threadStatus = false;// 线程执行状态 false-停止 true-启动
    private boolean sendStatus = false;// 发送状态 false-未发送 true-启动中
    private PrintCmdInfo now;
    private int count = 0; // 循环计数器 记录超时时间
    private Integer sleep = 10;// 休眠时间
    private Integer max = 50;// 循环计数器 超时时间 = sleep * max
    private boolean timeout = true;

    /**
     * @description: 发送异步线程
     **/
    private class SendPrintThread extends Thread {
        private int max_length = 510;// 发送最大长度

        /**
         * Allocates a new {@code Thread} object. This constructor has the same
         * effect as {@linkplain #(ThreadGroup, Runnable, String) Thread}
         * {@code (null, null, name)}.
         */
        public SendPrintThread() {
            super("SendPrintThread");
        }

        @Override
        public void run() {
            while (threadStatus && !isInterrupted()) {
                if (!sendStatus) {

                    this.printExecute();

                } else {

                    try {
                        Thread.sleep(sleep);
                    } catch (InterruptedException e) {
                    }

                    count++;

                    // 超过300ms 当超时处理，重新发送一次读取命令
                    if (count > max && now != null) {
                        if (timeout)
                            now.getRequest().timeOut();
                        // 超时复位
                        now.getRequest().getCommunication().sendSuccess();
                    }
                }
            }
        }

        /**
         * @description: 打印执行
         **/
        private synchronized void printExecute() {
            try {
                if (printCmdInfoList != null && !printCmdInfoList.isEmpty()) {
                    try {
                        now = printCmdInfoList.remove(0);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }

                    if (now != null) {
                        try {
                            sendStatus = true;
                            if (now.getRequest().isAll()) {
                                while (now != null && !now.getRequest().isEnd()) {
                                    now.getRequest().setSubContentLength(this.max_length);
                                    now.getRequest().getCommunication().sendCmd(
                                            now.getRequest().cmd(),
                                            now.getRequest()
                                    );
                                }
                            } else {
                                sendCmd(now.getCmd(), now.getRequest());
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                            sendSuccess();// 异常直接响应成功
                            IPrintBack printBack = now.getRequest().getPrintBack();
                            if (printBack != null)
                                printBack.responseBack(PrintBackResponse.fail(
                                        getSerial(),
                                        PrintStateCode.COMMUNICATION_TIME_OUT, "系统异常:" + e.getMessage()));
                        }
                    }
                }

                Thread.sleep(3);
            } catch (Exception e) {
            }
        }
    }

    /**
     * @description: 关闭通讯器
     **/
    @Override
    public void closeMessenger() {
        if (this.messenger != null) {
            this.messenger.close();
            this.messenger = null;
        }

        this.threadStatus = false;
        this.sendStatus = false;

        if (this.printCmdInfoList != null) {
            this.printCmdInfoList.clear();
            this.printCmdInfoList = null;
        }

        if (this.thread != null) {
            this.thread = null;
        }
    }

    /**
     * @description: 设置休眠时间 (超时时间 = sleep * max)
     **/
    public void setSleep(Integer sleep) {
        this.sleep = sleep;
    }

    /**
     * @description: 最大循环锁定次数 (超时时间 = sleep * max)
     **/
    public void setMax(Integer max, boolean timeout) {
        this.max = Objects.nonNull(max) ? max : 50;
        this.timeout = timeout;
    }

    /**
     * @description: 通讯
     **/
    @Deprecated
    public String communication(String content) throws MeterException {
        if (messenger == null || !this.threadStatus)
            throw new MeterException(MeterStateEnum.通讯组件未初始化);

        long start = System.currentTimeMillis();
        SendResult sendResult = this.messenger.send(content);
        while (messenger.effectiveCommunicationTime(sendResult.getCommunicationLogo())) {
            if (System.currentTimeMillis() - start > communicationMaxTime)
                throw new MeterException(MeterStateEnum.通讯超时);

            ReadReuslt readReuslt = this.messenger.read(sendResult.getCommunicationLogo());
            if (readReuslt.hasResponse()) {
                return readReuslt.getResponse();
            } else {
                try {
                    Thread.sleep(100);
                } catch (InterruptedException e) {
                }
            }
        }
        throw new MeterException(MeterStateEnum.通讯超时);
    }

    /**
     * @param serial
     * @description: 通讯器名称
     */
    @Override
    public void setSerial(Integer serial) {
        this.serial = serial;
    }

    @Override
    public Integer getSerial() {
        return this.serial;
    }

    /**
     * @description: 检查通讯器正常状态
     **/
    @Override
    public boolean checkCommunication() throws MeterException {
        if (messenger == null || !this.threadStatus)
            throw new MeterException(MeterStateEnum.通讯组件未初始化);
        return true;
    }

    /**
     * @description: 通讯器
     **/
    @Override
    public Messenger messenger() {
        return this.messenger;
    }

    /**
     * @description: 命令 暂存
     **/
    public void addSendCmd(String cmd, PrintRequest request) throws MeterException {
        this.checkCommunication();
        this.sendSuccess();// 发送完成重置
        this.printCmdInfoList.add(new PrintCmdInfo(cmd, request));
    }

    /**
     * @description: 命令 发送数据
     **/
    public void sendCmd(String cmd, PrintRequest request) throws MeterException {
        try {
            request.setCommunication(this);
            Class clazz = (Class) ((ParameterizedType) request.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            this.messenger.sendCmd(cmd, request, (PrintResponse) clazz.newInstance());
        } catch (Exception e) {
            e.printStackTrace();
            throw new MeterException(MeterStateEnum.系统异常_V1);
        }
    }

    /**
     * @param paras
     * @description: 添加打印部分内容
     */
    @Override
    public void addParas(List<Para> paras) throws MeterException {
        if (this.paraCache == null) this.paraCache = new ArrayList<>();
        PrintUtils.debug(this.param(), paras);
        if (paras != null && !paras.isEmpty()) {
            for (Para para : paras) {
                if (para instanceof RealBitmapPara)
                    throw new MeterException(MeterStateEnum.实时位图使用专用接口);
            }
            this.paraCache.addAll(paras);
        }
        PrintUtils.debug(this.param(), this.paraCache);
    }

    /**
     * @description: 清空打印内容
     **/
    @Override
    public void clearPara() {
        if (this.paraCache != null) {
            this.paraCache.clear();
            this.paraCache = null;
        }
    }

    /**
     * @description: 全部打印内容
     **/
    @Override
    public List<Para> paras() {
        return this.paraCache;
    }

    /*********************************发送打印命令通讯 End******************************************/

    /**********************************临时使用 Start******************************************/
    /**
     * @description: 临时打印方法
     **/
    @Deprecated
    public void printTemp(IPrintBack printBack, PrintVal printVal) throws MeterException {
        if (messenger == null || !this.threadStatus)
            throw new MeterException(MeterStateEnum.通讯组件未初始化);

        if (this.printParts == null)
            new Temp1().tempInit();

        String data = this.assemblePrintData(printVal);
        PrintDataRequest request = new PrintDataRequest();
        request.setPrintBack(printBack);
        request.setData(data);
        this.sendData(request);
    }

    /**
     * @description: 模板方法
     **/
    public void printTemp(IPrintBack printBack, PrintVal printVal, Temp temp) throws MeterException {
        if (messenger == null || !this.threadStatus)
            throw new MeterException(MeterStateEnum.通讯组件未初始化);

        // 初始化模板
        if (temp != null) {
            temp.tempInit();
        } else if (this.printParts == null) {
            new Temp1().tempInit();
        }

        String data = this.assemblePrintData(printVal);
        PrintDataRequest request = new PrintDataRequest();
        request.setPrintBack(printBack);
        request.setData(data);
        this.sendData(request);
    }
    /*********************************临时使用 End******************************************/

}
