package com.jhscale.meter.protocol.print;

import com.jhscale.common.model.device._inner.DLOGContent;
import com.jhscale.common.model.device.bitmap.DBitMap;
import com.jhscale.common.model.device.font.DFont;
import com.jhscale.common.model.device.info.DServerInfo;
import com.jhscale.common.model.device.saleman.DSaleMan;
import com.jhscale.common.utils.ArrayUtils;
import com.jhscale.common.utils.GJSONUtils;
import com.jhscale.common.utils.SystemtUtils;
import com.jhscale.meter.entity.CPReport;
import com.jhscale.meter.entity.LOGReport;
import com.jhscale.meter.entity.PLUReport;
import com.jhscale.meter.entity.server.CPServerReport;
import com.jhscale.meter.entity.server.LOGServerReport;
import com.jhscale.meter.entity.server.PLUServerReport;
import com.jhscale.meter.entity.server.ZXDOrder;
import com.jhscale.meter.entity.server.order.Address;
import com.jhscale.meter.entity.server.order.DistributorNote;
import com.jhscale.meter.entity.server.order.MerchantNote;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.constant.TMS;
import com.jhscale.meter.protocol.model.GlobalPara;
import com.jhscale.meter.protocol.model.PrintContent;
import com.jhscale.meter.protocol.model.PrintState;
import com.jhscale.meter.protocol.model.TradeContent;
import com.jhscale.meter.protocol.print.em.Dir;
import com.jhscale.meter.protocol.print.em.Grid;
import com.jhscale.meter.protocol.print.em.PrintParamSave;
import com.jhscale.meter.protocol.print.entity.PrintRequest;
import com.jhscale.meter.protocol.print.entity.PrintResponse;
import com.jhscale.meter.protocol.print.entity.ServerNotify;
import com.jhscale.meter.protocol.print.entity.cmd.Print0100Request;
import com.jhscale.meter.protocol.print.entity.data.PrintDataRequest;
import com.jhscale.meter.protocol.print.entity.data.PrintTradeRequest;
import com.jhscale.meter.protocol.print.entity.file.bitmap.PrintBitMapRequest;
import com.jhscale.meter.protocol.print.entity.file.font.PrintFontRequest;
import com.jhscale.meter.protocol.print.entity.para.TempBitmapPara;
import com.jhscale.meter.protocol.print.line.PrintLine;
import com.jhscale.meter.protocol.print.line.PrintLineE;
import com.jhscale.meter.protocol.print.line.PrintLineLMR;
import com.jhscale.meter.protocol.print.line.PrintLineN;
import com.jhscale.meter.protocol.print.link.IPrintBack;
import com.jhscale.meter.protocol.print.link.Messenger;
import com.jhscale.meter.protocol.print.produce.IPrintBasic;
import com.jhscale.meter.protocol.print.produce.entity.PrintBackResponse;
import com.jhscale.meter.protocol.print.produce.entity.PrintInfoResponse;
import com.jhscale.meter.protocol.print.produce.impl.PrintProcessor;
import com.jhscale.meter.protocol.print.produce.impl.PrintProcessor_A;
import com.jhscale.meter.protocol.print.produce.impl.PrintProcessor_B;
import com.jhscale.meter.protocol.print.produce.impl.PrintProduce;
import com.jhscale.meter.utils.FileUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.*;

import static com.jhscale.meter.protocol.constant.TMS.*;
import static com.jhscale.meter.protocol.print.PrintConstant.NODE_A_P;
import static com.jhscale.meter.protocol.print.PrintConstant.NODE_B_P;

/**
 * @author lie_w
 * @title: PrintGeneral
 * @projectName meter-jar
 * @description: 打印通用工厂
 * @date 2022/10/2512:17
 */
public class PrintGeneralFactory implements GlobalPara.GlobalParaRefresh {

    // 打印机缓冲列表
    private Map<Integer, PrintProcessor> printProcessorMap;

    private Map<Integer, PrintState> printState = new HashMap<>();

    private Map<Integer, PrintInfoResponse> printInfo = new HashMap<>();

    /**
     * @description: 设置打印机状态
     **/
    public PrintGeneralFactory putPrintState(Integer serial, String state1, String state2) {
        state1 = StringUtils.isBlank(state1) ? "00000000" : state1;
        state2 = StringUtils.isBlank(state2) ? "00000000" : state2;
        printState.put(serial, new PrintState(state1, state2));
        return this;
    }

    public PrintGeneralFactory putPrintInfo(Integer serial, PrintInfoResponse response) {
        printInfo.put(serial, response);
        return this;
    }

    /**
     * @description: 获取打印机状态
     **/
    public Map<Integer, PrintState> getPrintState() {
        return printState;
    }

    public Map<Integer, PrintInfoResponse> getPrintInfo() {
        return printInfo;
    }

    public static final int CLOUD_REPORT = 1;// 云支付报表
    public static final int CLOUD_DETAIL = 2;// 云支付明细 暂不支持
    public static final int LOG_REPORT = 3;// 日志报表
    public static final int LOG_DETAIL = 4;// 日志明细
    public static final int PLU_REPORT = 5;// PLU报表
    public static final int MERCHANT_ORDER = 6;// 商户外卖订单
    public static final int DISTRIBUTOR_ORDER = 7;// 服务商外卖订单

    private Map<Integer, String> dict;

    public static final Integer Date = 1;
    public static final Integer Money_Amount = 2;
    public static final Integer Finish = 3;
    public static final Integer CP_Report = 4;
    public static final Integer LG_Report = 5;
    public static final Integer PLU_Report = 6;
    public static final Integer Ali_Pay = 7;
    public static final Integer WX_Pay = 8;
    public static final Integer Union_Pay = 9;
    public static final Integer JH_Pay = 10;
    public static final Integer YZ_Pay = 11;

    public static final Integer Scale = 12;
    public static final Integer Refund = 13;
    public static final Integer UnConfirm = 14;
    public static final Integer Clear = 15;
    public static final Integer Hedge = 16;
    public static final Integer Auto = 17;
    public static final Integer Input = 18;
    public static final Integer Output = 19;
    public static final Integer Inventory = 20;
    public static final Integer Order = 21;
    public static final Integer Loss = 22;
    public static final Integer Abandonment = 23;
    public static final Integer Cash = 24;
    public static final Integer CardPay = 25;
    public static final Integer OtherPay1 = 26;
    public static final Integer OtherPay2 = 27;
    public static final Integer OtherPay3 = 28;
    public static final Integer JKYPay = 29;
    public static final Integer JKYGivePay = 30;
    public static final Integer JKYRecharge = 31;
    public static final Integer JKYGiveRecharge = 32;
    public static final Integer Special2 = 33;
    public static final Integer Special3 = 34;
    public static final Integer Special4 = 35;
    public static final Integer Special5 = 36;
    public static final Integer Special6 = 37;
    public static final Integer Special7 = 38;
    public static final Integer Summary = 39;
    public static final Integer Error = 40;


    private PrintGeneralFactory() {
        this.printProcessorMap = new HashMap<>();
        this.dict = new HashMap<>();
        GlobalPara.getInstance().addRefresh(this);
    }

    private static class SinglePrintGeneralFactory {
        private static PrintGeneralFactory INSTANCE = new PrintGeneralFactory();
    }

    public static PrintGeneralFactory getInstance() {
        return SinglePrintGeneralFactory.INSTANCE;
    }

    public PrintGeneralFactory putDict(Integer no, String val) {
        this.dict.put(no, val);
        return this;
    }

    public PrintGeneralFactory putDict(Map<Integer, String> dict) {
        if (dict != null && !dict.isEmpty())
            this.dict.putAll(dict);
        return this;
    }

    public PrintGeneralFactory clearDict() {
        this.dict.clear();
        return this;
    }

    public Map<Integer, String> dict() {
        return dict;
    }

    public String dict(Integer no, String def) {
        return this.dict.getOrDefault(no, def);
    }

    public String dict(Integer no) {
        return this.dict.get(no);
    }

    public String dict(String def) {
        if (StringUtils.isNotBlank(def)) {
            switch (def) {
                case "日期":
                    def = this.dict.getOrDefault(Date, def);
                    break;
                case "累计额/笔数":
                    def = this.dict.getOrDefault(Money_Amount, def);
                    break;
                case "完":
                    def = this.dict.getOrDefault(Finish, def);
                    break;
                case "云支付报表":
                    def = this.dict.getOrDefault(CP_Report, def);
                    break;
                case "销售报表":
                    def = this.dict.getOrDefault(LG_Report, def);
                    break;
                case "PLU报表":
                    def = this.dict.getOrDefault(PLU_Report, def);
                    break;

                case "支付宝":
                    def = this.dict.getOrDefault(Ali_Pay, def);
                    break;
                case "微信":
                    def = this.dict.getOrDefault(WX_Pay, def);
                    break;
                case "云闪付":
                    def = this.dict.getOrDefault(Union_Pay, def);
                    break;
                case "建行":
                    def = this.dict.getOrDefault(JH_Pay, def);
                    break;
                case "邮政":
                    def = this.dict.getOrDefault(YZ_Pay, def);
                    break;
                case "销售":
                    def = this.dict.getOrDefault(Scale, def);
                    break;
                case "退款":
                    def = this.dict.getOrDefault(Refund, def);
                    break;
                case "未确认":
                    def = this.dict.getOrDefault(UnConfirm, def);
                    break;
                case "清除":
                    def = this.dict.getOrDefault(Clear, def);
                    break;
                case "挂单笔数":
                    def = this.dict.getOrDefault(Hedge, def);
                    break;
                case "自动模式":
                    def = this.dict.getOrDefault(Auto, def);
                    break;
                case "入库":
                    def = this.dict.getOrDefault(Input, def);
                    break;
                case "出库":
                    def = this.dict.getOrDefault(Output, def);
                    break;
                case "盘库":
                    def = this.dict.getOrDefault(Inventory, def);
                    break;
                case "订单":
                    def = this.dict.getOrDefault(Order, def);
                    break;
                case "损耗":
                    def = this.dict.getOrDefault(Loss, def);
                    break;
                case "折舍":
                    def = this.dict.getOrDefault(Abandonment, def);
                    break;
                case "现金":
                    def = this.dict.getOrDefault(Cash, def);
                    break;
                case "卡付":
                    def = this.dict.getOrDefault(CardPay, def);
                    break;
                case "其他支付1":
                    def = this.dict.getOrDefault(OtherPay1, def);
                    break;
                case "其他支付2":
                    def = this.dict.getOrDefault(OtherPay2, def);
                    break;
                case "其他支付3":
                    def = this.dict.getOrDefault(OtherPay3, def);
                    break;
                case "吉卡云支付":
                    def = this.dict.getOrDefault(JKYPay, def);
                    break;
                case "吉卡云赠送支付":
                    def = this.dict.getOrDefault(JKYGivePay, def);
                    break;
                case "吉卡云充值":
                    def = this.dict.getOrDefault(JKYRecharge, def);
                    break;
                case "吉卡云赠送充值":
                    def = this.dict.getOrDefault(JKYGiveRecharge, def);
                    break;
                case "特殊支付2":
                    def = this.dict.getOrDefault(Special2, def);
                    break;
                case "特殊支付3":
                    def = this.dict.getOrDefault(Special3, def);
                    break;
                case "特殊支付4":
                    def = this.dict.getOrDefault(Special4, def);
                    break;
                case "特殊支付5":
                    def = this.dict.getOrDefault(Special5, def);
                    break;
                case "特殊支付6":
                    def = this.dict.getOrDefault(Special6, def);
                    break;
                case "特殊支付7":
                    def = this.dict.getOrDefault(Special7, def);
                    break;
                case "汇总":
                    def = this.dict.getOrDefault(Summary, def);
                    break;
                case "错误笔数":
                    def = this.dict.getOrDefault(Error, def);
                    break;
                default:
                    break;
            }

        }
        return def;
    }

    /**
     * @description: 初始化工厂通讯器
     **/
    public PrintGeneralFactory Init_Print_Factory(Messenger a, Messenger b) throws MeterException {
        if (a == null && b == null) {
            throw new MeterException(MeterStateEnum.打印模块未初始化);
        }
        if (a != null) {
            PrintProcessor_A processor_a = new PrintProcessor_A().setMessenger(a);
            this.obtainPrintInfo(processor_a);
        }
        if (b != null) {
            PrintProcessor_B printProcessor_b = new PrintProcessor_B().setMessenger(b);
            this.obtainPrintInfo(printProcessor_b);
        }
        return this;
    }

    /**
     * @description: 历史默认工厂
     **/
    public PrintGeneralFactory build_Default(Messenger messenger) {
        PrintProduce printProduce = new PrintProduce().setMessenger(messenger);
        this.obtainPrintInfo(printProduce);
        return this;
    }

    /**
     * @description: 构建A串口
     **/
    public PrintGeneralFactory build_A(Messenger messenger) {
        return this.build(NODE_A_P, messenger);
    }

    /**
     * @description: 构建B串口
     **/
    public PrintGeneralFactory build_B(Messenger messenger) {
        return this.build(NODE_B_P, messenger);
    }

    /**
     * @description: 序号构建自定义打印机（0-1 默认历史|2 双打打印机）
     **/
    public PrintGeneralFactory build(Integer serial, Messenger messenger) {
        IPrintBasic print = this.checkMessage(messenger);
        if (print == null) {
            PrintProcessor printProcessor = new PrintProcessor().setMessenger(serial, messenger);
            this.Put_Print(printProcessor);
            this.obtainPrintInfo(printProcessor);
        }
        return this;
    }

    /**
     * @description: 关闭方法
     * @date: 2024-08-16 17:16:01
     **/
    public PrintGeneralFactory close() throws MeterException {
        if (this.printProcessorMap != null && !this.printProcessorMap.isEmpty()) {
            for (PrintProcessor value : printProcessorMap.values()) {
                if (value != null) value.close();
            }
        }
        return this;
    }

    /**
     * @description: 获取打印机状态 信息
     **/
    public PrintGeneralFactory obtainPrintInfo(PrintProcessor processor) {
        try {
            processor.getPrintInfo(new IPrintBack() {
                /**
                 * @param response
                 * @description: 操作结果响应原始信息
                 */
                @Override
                public void responseBack(PrintBackResponse response) {
                    if (response instanceof PrintInfoResponse) {
                        PrintInfoResponse printInfoResponse = (PrintInfoResponse) response;
                        PrintGeneralFactory.getInstance().putPrintState(processor.communication().getSerial(), printInfoResponse.getState1(), printInfoResponse.getState2());
                        PrintGeneralFactory.getInstance().putPrintInfo(processor.communication().getSerial(), printInfoResponse);
                    } else {
                        try {
                            System.err.printf("获取打印机类型异常,重新获取打印机信息 数据内容%s%n", GJSONUtils.objectToJSON(response));
                        } catch (Exception e) {
                            System.err.printf("获取打印机类型异常: %s%n", e.getMessage());
                        }
                        obtainPrintInfo(processor);
                    }
                }
            });
        } catch (Exception e) {
            System.err.printf("获取打印机信息失败：%s%n", e.getMessage());
        }
        return this;
    }

    /**
     * @description: 检查Message 是否被创建
     **/
    private IPrintBasic checkMessage(Messenger messenger) {
        if (this.printProcessorMap != null && !this.printProcessorMap.isEmpty()) {
            for (IPrintBasic print : printProcessorMap.values()) {
                if (print != null
                        && print.communication().messenger() != null
                        && StringUtils.isBlank(print.communication().messenger().identify())
                        && print.communication().messenger().identify().equals(messenger.identify())) {
                    return print;
                }
            }
        }
        return null;
    }

    /**
     * @description: 构建完成添加打印工厂
     **/
    public PrintGeneralFactory Put_Print(PrintProcessor print) {
        if (this.printProcessorMap == null) this.printProcessorMap = new HashMap<>();
        this.printProcessorMap.put(print.communication().getSerial(), print);
        return this;
    }

    /**
     * @description: 打印机发送指令
     **/
    public List<PrintBackResponse> execute(PrintRequest request, int... ports) {
        return this.execute(40, request, ports);
    }

    /**
     * @description: 打印机发送指令
     **/
    public List<PrintBackResponse> execute(int timeout, PrintRequest request, int... ports) {
        timeout = timeout == 0 ? 40 : timeout;
        Map<Integer, PrintBackResponse> responses = new HashMap<>();
        ports = ports != null && ports.length > 0 ? ports : new int[]{NODE_A_P};
        Integer[] i_ports = ArrayUtils.ifRepeat(ports);
        int count = 0;
        while (count < timeout) {
            int execute_size = 0;
            for (Integer port : i_ports) {
                PrintBackResponse printBackResponse = responses.get(port);
                if (printBackResponse != null) continue;

                try {
                    PrintRequest rq = GJSONUtils.objectToObject(request, request.getClass());
                    rq.setPrintBack(new IPrintBack() {
                        /**
                         * @param response
                         * @description: 操作结果响应原始信息
                         */
                        @Override
                        public void responseBack(PrintBackResponse response) {
                            responses.put(response.getSerial(), response);
                        }
                    });
                    this.getCommunication(port, false).send(rq);
                    execute_size++;
                } catch (MeterException e) {
                    System.err.printf("Serial[%s]_Err: %s%n", port, e.getMessage());
                }
            }

            try {
                Thread.sleep(150);
            } catch (InterruptedException e) {
            }

            if (responses.size() == execute_size)
                break;
            count++;
        }
        return new ArrayList<>(responses.values());
    }

    /**
     * @description: 检查id 是否存在此刷新器中
     */
    @Override
    public int[] refreshIds() {
        return new int[]{Print_Gray_GapPaper, Print_Gray_GenericPaper, Print_PPS_Line, HW_Print_IgnorePBS, HW_Print_Ignore_P2, HW_ConPaper_vPPS};
    }

    /**
     * @description: 执行内容
     **/
    @Override
    public void refreshAction(int no, int value) {
        this.print_set(no);
    }

    /**
     * @description: 打印设置前置
     **/
    public void print_set(int no) {
        List<Print0100Request> a = new ArrayList<>();
        List<Print0100Request> b = new ArrayList<>();

        switch (no) {
            case Print_Gray_GapPaper:
                a.add(new Print0100Request(0, PrintParamSave.FOREVER, GlobalPara.getInstance().getTMS(TMS.Print_Gray_GapPaper)));
                break;
            case Print_Gray_GenericPaper:
                b.add(new Print0100Request(0, PrintParamSave.FOREVER, GlobalPara.getInstance().getTMS(TMS.Print_Gray_GenericPaper)));
                break;
            case Print_PPS_Line:
                b.add(new Print0100Request(Print_PPS_Line, PrintParamSave.FOREVER, GlobalPara.getInstance().getTMS(TMS.Print_PPS_Line, 270)));
                break;
            case HW_Print_IgnorePBS:
            case HW_Print_Ignore_P2:
            case HW_ConPaper_vPPS:
                int ignore = 0;
                if ((GlobalPara.getInstance().getTMS(TMS.HW_Print_IgnorePBS) & 0x01) != 0)
                    ignore |= 0x01;
                if ((GlobalPara.getInstance().getTMS(TMS.HW_Print_Ignore_P2) & 0x01) != 0)
                    ignore |= 0x02;
                if (GlobalPara.getInstance().getTMS(TMS.HW_ConPaper_vPPS) > 0)
                    ignore |= 0x04;
                a.add(new Print0100Request(1, PrintParamSave.FOREVER, ignore));
                b.add(new Print0100Request(1, PrintParamSave.FOREVER, ignore));
                break;
        }
        this.print_set(a, b);
    }

    /**
     * @description: 打印机设置
     **/
    private void print_set(List<Print0100Request> a, List<Print0100Request> b) {
        if (!a.isEmpty()) {
            long start1 = System.currentTimeMillis();
            for (Print0100Request request : a) {
                this.execute(request, NODE_A_P);
            }
            long end1 = System.currentTimeMillis();
            System.out.printf("A %s Time: %s%n", a.size(), (end1 - start1));
        }

        if (!b.isEmpty()) {
            long start1 = System.currentTimeMillis();
            for (Print0100Request request : b) {
                this.execute(request, NODE_B_P);
            }
            long end1 = System.currentTimeMillis();
            System.out.printf("B %s Time: %s%n", b.size(), (end1 - start1));
        }
    }

    /**
     * @description: 打印前置设置
     **/
    @Deprecated
    public void print_before() {
        int[][] ids = new int[][]{
                {TMS.HW_Print_IgnorePBS, TMS.HW_Print_Ignore_P2, TMS.HW_ConPaper_vPPS},
                {TMS.Print_Gray_GapPaper},
                {TMS.Print_Gray_GenericPaper}
        };

        List<Print0100Request> a = new ArrayList<>();
        List<Print0100Request> b = new ArrayList<>();

        for (int i = 0; i < ids.length; i++) {
            switch (i) {
                case 0:
                    if (GlobalPara.getInstance().checkTMS_Update(ids[0])) {
                        int ignore = 0;
                        if ((GlobalPara.getInstance().getTMS(TMS.HW_Print_IgnorePBS) & 0x01) != 0)
                            ignore |= 0x01;
                        if ((GlobalPara.getInstance().getTMS(TMS.HW_Print_Ignore_P2) & 0x01) != 0)
                            ignore |= 0x02;
                        if (GlobalPara.getInstance().getTMS(TMS.HW_ConPaper_vPPS) > 0)
                            ignore |= 0x04;
                        a.add(new Print0100Request(1, PrintParamSave.FOREVER, ignore));
                        b.add(new Print0100Request(1, PrintParamSave.FOREVER, ignore));
                    }
                    break;
                case 1:
                    if (GlobalPara.getInstance().checkTMS_Update(ids[1]))
                        a.add(new Print0100Request(0, PrintParamSave.FOREVER, GlobalPara.getInstance().getTMS(TMS.Print_Gray_GapPaper)));
                    break;
                case 2:
                    if (GlobalPara.getInstance().checkTMS_Update(ids[2]))
                        b.add(new Print0100Request(0, PrintParamSave.FOREVER, GlobalPara.getInstance().getTMS(TMS.Print_Gray_GenericPaper)));
                    break;
            }
        }

        this.print_set(a, b);
    }

    /**
     * @description: 位图升级
     **/
    public void bitMapUpgrade(boolean print, DBitMap bitMap, IPrintBack printBack) throws MeterException {
        this.bitMapUpgrade(print, bitMap, printBack, new Integer[0]);
    }

    /**
     * @description: 位图升级
     **/
    public void bitMapUpgrade(boolean print, DBitMap bitMap, IPrintBack printBack, Integer... ports) throws MeterException {
        this.bitMapUpgrade(print, Arrays.asList(bitMap), printBack, ports);
    }

    /**
     * @description: 位图升级
     **/
    public void bitMapUpgrade(boolean print, List<DBitMap> bitMaps, IPrintBack printBack) throws MeterException {
        this.bitMapUpgrade(print, bitMaps, printBack, new Integer[0]);
    }

    /**
     * @description: 位图升级
     **/
    public void bitMapUpgrade(boolean print, List<DBitMap> bitMaps, IPrintBack printBack, Integer... ports) throws MeterException {
        ports = ports != null && ports.length > 0 ? ports : new Integer[]{NODE_A_P};
        this.bitMapUpgrade(print, 0, bitMaps, printBack, Arrays.asList(ports));


    }

    /**
     * @description: 位图升级
     **/
    private void bitMapUpgrade(boolean print, int i_bitmap, List<DBitMap> bitMaps, IPrintBack printBack, List<Integer> ports) {
        DBitMap bitMap = bitMaps.get(i_bitmap);
        String hexData = FileUtils.fileContentsToHex(bitMap.getBmp());
        i_bitmap++;
        this.bitMapUpgrade(print, bitMap, hexData, i_bitmap, bitMaps, printBack, 0, ports);
    }

    /**
     * @description: 递归升级
     **/
    private void bitMapUpgrade(boolean print, DBitMap bitMap, String hexData, int i_bitmap, List<DBitMap> bitMaps, IPrintBack printBack, int i_port, List<Integer> ports) {
        try {
            Integer port = ports.get(i_port);
            PrintProcessor communication = this.getCommunication(port, false);
            i_port++;
            int finalI_port = i_port;

            PrintBitMapRequest request = new PrintBitMapRequest(null, hexData);
            request.setPrintBack(new IPrintBack() {
                /**
                 * @param response
                 * @description: 操作结果响应业务信息
                 */
                @Override
                public void responseBack(PrintBackResponse response) {
                    System.out.printf("打印机[%s] 位图[%s] 升级响应： %s\n", communication.communication().getSerial(), bitMap.no(), response.toString());

                    if (print) {
                        bitMapPrint(print, response, bitMap, communication, hexData, i_bitmap, bitMaps, printBack, finalI_port, ports);
                    } else {
                        if (finalI_port == ports.size() && i_bitmap == bitMaps.size()) {
                            printBack.responseBack(response);
                        } else if (finalI_port != ports.size()) {
                            bitMapUpgrade(print, bitMap, hexData, i_bitmap, bitMaps, printBack, finalI_port, ports);
                        } else {
                            bitMapUpgrade(print, i_bitmap, bitMaps, printBack, ports);
                        }
                    }
                }
            });
            communication.bitMapUpgrade(request);
        } catch (MeterException e) {
            e.printStackTrace();
        }
    }

    /**
     * @description: 打印位图
     **/
    private void bitMapPrint(boolean print, PrintBackResponse bitMapUpgradeResponse, DBitMap bitMap, PrintProcessor communication, String hexData,
                             int i_bitmap, List<DBitMap> bitMaps, IPrintBack printBack,
                             int finalI_port, List<Integer> ports) {
        if (print) {
            try {
                PrintDataRequest request = new PrintDataRequest()
                        .addPara(new TempBitmapPara()
                                .set_Dir(Dir.ZERO)
                                .set_Grid(Grid.Defaul_Grid)
                                .setStartX(0)
                                .setStartY(0)
                                .setOffsetX(384)
                                .setOffsetY(200)
                                .set_InnerBitmapNumber(bitMap.no()))
                        .addPrintPointAndCutPoint();

                request.setPrintBack(new IPrintBack() {
                    /**
                     * @param response
                     * @description: 操作结果响应业务信息
                     */
                    @Override
                    public void responseBack(PrintBackResponse response) {
                        System.out.printf("打印机[%s] 位图[%s] 打印响应： %s\n", communication.communication().getSerial(), bitMap.no(), response.toString());

                        if (finalI_port == ports.size() && i_bitmap == bitMaps.size()) {
                            printBack.responseBack(bitMapUpgradeResponse);
                        } else if (finalI_port != ports.size()) {
                            SystemtUtils.sleep(6);
                            bitMapUpgrade(print, bitMap, hexData, i_bitmap, bitMaps, printBack, finalI_port, ports);
                        } else {
                            SystemtUtils.sleep(6);
                            bitMapUpgrade(print, i_bitmap, bitMaps, printBack, ports);
                        }
                    }
                });

                communication.printSend(request);
            } catch (MeterException e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * @description: 位图升级
     **/
    public void fontUpgrade(DFont font, IPrintBack printBack) throws MeterException {
        this.fontUpgrade(font, printBack, new int[0]);
    }

    /**
     * @description: 位图升级
     **/
    public void fontUpgrade(DFont font, IPrintBack printBack, int... ports) throws MeterException {
        ports = ports != null && ports.length > 0 ? ports : new int[]{NODE_A_P};
        String hexData = FileUtils.fileContentsToHex(font.getFnt());
        for (int port : ports) {
            PrintFontRequest request = new PrintFontRequest(null, hexData);
            request.setPrintBack(printBack);
            this.getCommunication(port, false).fontUpgrade(request);
        }
    }

    /**
     * @description: 打印(应答模式)
     **/
    public void print_answer(List<PrintContent> printContents, IPrintBack printBack) throws MeterException {
        this.print_answer(printContents, printBack, true);
    }

    /**
     * @description: 打印(整包模式)
     **/
    public void print_direct(List<PrintContent> printContents, IPrintBack printBack) throws MeterException {
        this.print_answer(printContents, printBack, true);
    }

    /**
     * @description: 打印(应答模式)
     **/
    public void print_answer(List<PrintContent> printContents, IPrintBack printBack, boolean first) throws
            MeterException {
        if (printContents != null && !printContents.isEmpty()) {
            // this.print_before(); 撤销打印前命令发送
            for (PrintContent printContent : printContents) {
                if (printContent.getPcs() > 0) {
                    for (int i = 0; i < printContent.getPcs(); i++) {
                        PrintTradeRequest request = new PrintTradeRequest();
                        request.setPrintBack(printBack);
                        request.setNow(i + 1);
                        request.setTotal(printContent.getPcs());
                        request.setHex(printContent.getHex());

                        if (printContent.getWidth() == 48) {
                            this.getNode_A(first).send(request);
                        } else {
                            this.getNode_B(first).send(request);
                        }
                    }
                }
            }
        }
    }

    /**
     * @description: 打印(整包模式)
     **/
    public void print_direct(List<PrintContent> printContents, IPrintBack printBack, boolean first) throws
            MeterException {
        if (printContents != null && !printContents.isEmpty()) {
            // this.print_before(); 撤销打印前命令发送
            for (PrintContent printContent : printContents) {
                if (printContent.getPcs() > 0) {
                    for (int i = 0; i < printContent.getPcs(); i++) {
                        PrintTradeRequest request = new PrintTradeRequest();
                        request.setPrintBack(printBack);
                        request.setNow(i + 1);
                        request.setTotal(printContent.getPcs());
                        request.setHex(printContent.getHex());

                        if (printContent.getWidth() == 48) {
                            this.getNode_A(first).sendAll(request);
                        } else {
                            this.getNode_B(first).sendAll(request);
                        }
                    }
                }
            }
        }
    }

    /**
     * @return
     * @description: 行模式打印
     */
    public boolean Print_Line(IPrintBack printBack, PrintLine... lines) {
        try {
            if (lines != null && lines.length > 0) {
                this.getCommunication().Print_Line(printBack, Arrays.asList(lines));
                return true;
            }
        } catch (MeterException e) {
            e.printStackTrace();
        }
        return false;
    }

    /**
     * @description: 开机打印
     **/
    public void Open_Print(PrintLine... others) {
        DServerInfo serverInfo = GlobalPara.getInstance().getServerInfo();
        DSaleMan saleMan = GlobalPara.getInstance().getSaleMan();

        List<PrintLine> lines = new ArrayList<>();

        if (Objects.nonNull(serverInfo)) {
            lines.add(new PrintLineLMR().setRight(serverInfo.isCloud() ? "云服务已连接" : "云服务未连接"));
            String store_all_info = serverInfo.store_all_info();
            if (StringUtils.isNotBlank(store_all_info)) lines.add(new PrintLineN(store_all_info));

            if (saleMan != null)
                lines.add(new PrintLineN(String.format("P* %s[%s]", saleMan.getName(), saleMan.no())));

            String market_info = serverInfo.market_info();
            if (StringUtils.isNotBlank(market_info)) lines.add(new PrintLineN(market_info));

            String erp_info = serverInfo.erp_info();
            if (StringUtils.isNotBlank(erp_info)) lines.add(new PrintLineN(erp_info));

            List<String> payment = serverInfo.payment();
            if (payment != null && !payment.isEmpty()) {
                for (String s : payment) {
                    if (StringUtils.isNotBlank(s)) lines.add(new PrintLineN(s));
                }
            }


            String device_info = serverInfo.device_info();
            if (StringUtils.isNotBlank(device_info)) lines.add(new PrintLineN(device_info));

        } else {
            lines.add(new PrintLineLMR().setRight("云服务未连接"));
        }

        if (others != null) {
            for (PrintLine other : others) {
                if (other != null) lines.add(other);
            }
        }

        try {
            this.getCommunication().Print_Line(new IPrintBack() {
                /**
                 * @param response
                 * @description: 操作结果响应原始信息
                 */
                @Override
                public void responseBack(PrintResponse response) {
                    if (GlobalPara.getInstance().isRunLog())
                        System.out.println(response.toString());
                }
            }, lines);
        } catch (MeterException e) {
            System.err.printf("开机打印异常：%s%n", e.getMessage());
        }
    }

    /**
     * @description: 查询第一默认节点
     **/
    private PrintProcessor first() {
        if (this.printProcessorMap != null && !this.printProcessorMap.isEmpty()) {
            for (PrintProcessor processor : printProcessorMap.values()) {
                if (processor != null)
                    return processor;
            }
        }
        return null;
    }

    /**
     * @param first 未找到true 返回第一个
     * @description: 获取默认0
     **/
    public PrintProcessor getDefault(boolean first) throws MeterException {
        PrintProcessor Default = this.printProcessorMap.get(PrintConstant.DEFAULT_PRINT);
        if (Default == null && first)
            Default = this.first();
        if (Default == null)
            throw new MeterException(MeterStateEnum.通讯组件未初始化);
        return Default;
    }

    /**
     * @param first 未找到true 返回第一个
     * @description: 获取节点0
     **/
    public PrintProcessor getNode_A(boolean first) throws MeterException {
        PrintProcessor processor = this.printProcessorMap.get(NODE_A_P);
        if (processor == null && first)
            processor = this.first();
        if (processor == null)
            throw new MeterException(MeterStateEnum.通讯组件A未初始化);
        return processor;
    }

    /**
     * @param first 未找到true 返回第一个
     * @description: 获取节点1
     **/
    public PrintProcessor getNode_B(boolean first) throws MeterException {
        PrintProcessor processor = this.printProcessorMap.get(NODE_B_P);
        if (processor == null && first)
            processor = this.first();
        if (processor == null)
            throw new MeterException(MeterStateEnum.通讯组件B未初始化);
        return processor;
    }

    /**
     * @param first 未找到true 返回第一个
     * @description: 获取对饮端口号
     **/
    public PrintProcessor getCommunication(int serial, boolean first) throws MeterException {
        PrintProcessor processor = this.printProcessorMap.get(serial);

        if (processor == null && first)
            processor = this.first();

        if (processor == null) {
            throw new MeterException(MeterStateEnum.通讯组件未初始化);
        }
        return processor;
    }

    /**
     * @description: 获取对饮端口号
     **/
    public PrintProcessor getCommunication() throws MeterException {
        int tms = GlobalPara.getInstance().getTMS(Print_GenericLng_Wide);
        int serial = tms == 48 || tms == 0 ? NODE_A_P : NODE_B_P;
        return this.getCommunication(serial, true);
    }

    /**
     * @description: 获取功能打印机通道
     **/
    public PrintProcessor getFunctionPrintProcess(int tms) throws MeterException {
        int node = GlobalPara.getInstance().getTMS(tms, NODE_A_P);
        return this.getCommunication(node, true);
    }

    /**
     * @description: 服务器通知打印
     * @date: 2024-11-13 14:02:19
     **/
    public void notify(ServerNotify notify, IPrintBack printBack) throws MeterException {
        if (notify != null) {
            if (StringUtils.isBlank(notify.getContent())) {
                this.undefined(notify, printBack);
            } else {
                switch (notify.getCommand()) {
                    case 1:
                        // 云支付报表
                        this.cloudReport(notify, printBack);
                        break;
                    case 2:
                        // 云支付明细
                        this.cloudDetail(notify, printBack);
                        break;
                    case 3:
                        // 日志报表
                        this.logReport(notify, printBack);
                        break;
                    case 4:
                        // 日志明细
                        this.logDetail(notify, printBack);
                        break;
                    case 5:
                        // PLU报表
                        this.pluReport(notify, printBack);
                        break;
                    case 6:
                        // 商户外卖订单
                        this.merchantOrder(notify, printBack);
                        break;
                    case 7:
                        // 服务商外卖订单
                        this.distributorOrder(notify, printBack);
                        break;
                    default:
                        this.undefined(notify, printBack);
                        break;
                }
            }
        }
    }

    /**
     * @description: 服务商外卖订单
     * @date: 2024-11-14 22:18:20
     **/
    private void distributorOrder(ServerNotify notify, IPrintBack printBack) throws MeterException {
        ZXDOrder order = notify.contentToObj(ZXDOrder.class);
        System.out.println(order.toJSON());
        Address address = order.address();
        System.out.println(address.toJSON());
        DistributorNote distributorNote = order.distributorNote();
        System.out.println(distributorNote.toJSON());

        this.distributorOrder(order, printBack);
    }

    /**
     * @description: 服务商外卖订单
     * @date: 2024-11-14 22:18:20
     **/
    public void distributorOrder(ZXDOrder order, IPrintBack printBack) throws MeterException {
        List<PrintLine> lines = order.toDistributorPrintLine();
        this.getCommunication().Print_Line(printBack, lines);
    }

    /**
     * @description: 商户外卖订单
     * @date: 2024-11-13 17:03:40
     **/
    private void merchantOrder(ServerNotify notify, IPrintBack printBack) throws MeterException {
        ZXDOrder order = notify.contentToObj(ZXDOrder.class);
        System.out.println(order.toJSON());
        Address address = order.address();
        System.out.println(address.toJSON());
        MerchantNote merchantNote = order.merchantNote();
        System.out.println(merchantNote.toJSON());

        this.merchantOrder(order, printBack);
    }

    /**
     * @description: 商户外卖订单
     * @date: 2024-11-13 17:03:40
     **/
    public void merchantOrder(ZXDOrder order, IPrintBack printBack) throws MeterException {
        List<PrintLine> lines = order.toMerchantPrintLine();
        this.getCommunication().Print_Line(printBack, lines);
    }


    /**
     * @description: PLU报表打印
     * @date: 2024-11-13 16:11:19
     **/
    private void pluReport(ServerNotify notify, IPrintBack printBack) throws MeterException {
        PLUServerReport serverReport = notify.contentToObj(PLUServerReport.class);
        this.pluReport(serverReport, printBack);
    }

    /**
     * @description: PLU报表打印
     * @date: 2024-11-13 16:11:19
     **/
    public void pluReport(PLUServerReport serverReport, IPrintBack printBack) throws MeterException {
        PLUReport report = serverReport.toReport();
        report.setStoreName(serverReport.getStoreName());
        report.setDeviceName(serverReport.getDeviceName());
        report.setDate(serverReport.getDate());
        report.setMoney(serverReport.moneyPoint());
        report.setWeight(serverReport.weightPoint());
        this.getCommunication().printReport(printBack, report);
    }

    /**
     * @description: 日志明细打印
     * @date: 2024-11-13 14:33:59
     **/
    private void logDetail(ServerNotify notify, IPrintBack printBack) throws MeterException {
        DLOGContent content = notify.contentToObj(DLOGContent.class);
        this.logDetail(content, printBack);
    }

    /**
     * @description: 日志明细打印
     * @date: 2024-11-13 14:33:59
     **/
    public void logDetail(DLOGContent content, IPrintBack printBack) throws MeterException {
        TradeContent tradeContent = new TradeContent()
                .Total_Log(content)
                .printCalculate();
        this.print_answer(tradeContent.getPrintContents(), printBack);
    }

    /**
     * @description: 日志报表打印
     * @date: 2024-11-13 16:10:02
     **/
    private void logReport(ServerNotify notify, IPrintBack printBack) throws MeterException {
        LOGServerReport serverReport = notify.contentToObj(LOGServerReport.class);
        this.logReport(serverReport, printBack);
    }

    /**
     * @description: 日志报表打印
     * @date: 2024-11-13 16:10:02
     **/
    public void logReport(LOGServerReport serverReport, IPrintBack printBack) throws MeterException {
        LOGReport report = serverReport.toReport();
        report.setStoreName(serverReport.getStoreName());
        report.setDeviceName(serverReport.getDeviceName());
        report.setDate(serverReport.getDate());
        report.setMoney(serverReport.moneyPoint());
        report.setWeight(serverReport.weightPoint());
        this.getCommunication().printReport(printBack, report);
    }

    /**
     * @description: 云支付明细打印
     * @date: 2024-11-13 16:09:47
     **/
    private void cloudDetail(ServerNotify notify, IPrintBack printBack) throws MeterException {
        this.undefined(notify, printBack);
    }

    /**
     * @description: 云支付报表打印
     * @date: 2024-11-13 15:50:14
     **/
    private void cloudReport(ServerNotify notify, IPrintBack printBack) throws MeterException {
        CPServerReport serverReport = notify.contentToObj(CPServerReport.class);
        this.cloudReport(serverReport, printBack);
    }

    /**
     * @description: 云支付报表打印
     * @date: 2024-11-13 15:50:14
     **/
    public void cloudReport(CPServerReport serverReport, IPrintBack printBack) throws MeterException {
        CPReport report = serverReport.toReport();
        report.setStoreName(serverReport.getStoreName());
        report.setDeviceName(serverReport.getDeviceName());
        report.setDate(serverReport.getDate());
        report.setMoney(serverReport.moneyPoint());
        report.setWeight(serverReport.weightPoint());
        this.getCommunication().printReport(printBack, report);
    }

    /**
     * @description: 找到定义的数据内容
     * @date: 2024-11-13 14:24:44
     **/
    public void undefined(ServerNotify notify, IPrintBack printBack) throws MeterException {
        PrintLine line = new PrintLineN()
                .setContent(String.format("Undefined Command:[%s] Content:[%s]", notify.getCommand(), notify.getContent()));
        this.getCommunication().printSend(printBack, line, new PrintLineE());
    }
}
