package com.jhscale.meter.protocol.print;

/**
 * @author lie_w
 * @title: PrintStateCode
 * @projectName jhscale-agreement
 * @description: TODO
 * @date 2020-12-2123:58
 */
public interface PrintStateCode {

    /**
     * @description: 业务状态
     **/
    int BIZ_SUCCESS = 0;
    int BIZ_ERROR = 1;
    int BIZ_WARNING = 2;

    // 成功
    String SUCCESS = "000";

    // 参数无效
    String PARAM_ERROR = "001";

    // 超出缓冲极限
    String BUFFER_LIMIT_EXCEEDED = "002";

    // CRC校验失败
    String CRC_ERROR = "003";

    // 超出缓冲极限同时CRC校验失败
    String BUFFER_LIMIT_EXCEEDED_AND_CRC_ERROR = "004";

    // 起始结束标志无效
    String START_ERROR = "005";

    // 未识别的状态码
    String UNKNOW_STATE = "006";

    // 收发长度不同
    String SEND_RECEIVE_LENGTH_DIFF = "007";

    // 收发总长度不同
    String TOTAL_SEND_RECEIVE_LENGTH_DIFF = "008";

    // 无效打印类型
    String INVALID_PRINT_TYPE = "009";

    // 响应体不存在
    String RESPONSE_NOT_EXIST = "00A";

    // 响应体无效
    String RESPONSE_INVALID = "00B";

    // 打印模板数据未设置
    String TEMPLATE_NOT_INIT = "00C";

    // 模板片段不存在
    String TEMPLATE_PART_NOT_EXIST = "00D";

    // 解析模板无效
    String TEMPLATE_NOT_INVALID = "00E";

    // 模板片段无效
    String TEMPLATE_DATA_NOT_INVALIE = "010";

    // 打印缺纸
    String PRINT_OUT_OF_PAPER = "011";

    // 打印过热
    String PRINT_TOO_HOT = "012";

    // 无效条码类型
    String BAR_CODE_INVALID = "013";

    // 边框像素不合法
    String BORDER_INVALID = "014";

    // 打印升级关闭保护失败
    String PRINT_CLOSE_FOR_UPGRADE_ERROR = "015";

    // 打印部件不能为空
    String PARAS_NULL = "016";

    // 打印部件缓冲区为空
    String PARAS_CACHE_NULL = "017";

    // 升级文件名无效
    String UPGRADE_FILE_NAME_INVALID = "018";

    // 无效升级文件检查
    String CHECKE_UPGRADE_INVALID = "019";

    // 字库未升级成功
    String FONT_UPGRADE_ERROR = "01A";

    // 版本未升级成功
    String VERSION_UPGRADE_ERROR = "01B";

    // 实时位图使用专用接口
    String REAL_BIT_MAP_VIP = "01C";

    // 参数不支持
    String PARAM_NO_SUPPORT = "01D";

    // 图片源文件为空
    String SOURCE_IMAGE_BUFFER_NULL = "01E";

    // 图片执行器不存在
    String IMAGE_PROCESS_NULL = "01F";

    // Dither算法不存在
    String DITHER_NOT_EXIST = "020";

    // Dither算法无效
    String DITHER_INVALID = "021";

    // Dither临界值不存在
    String DITHER_CRITICAL_NOT_EXIST = "022";

    // Color临界点百分比不存在
    String COLOR_CRITICAL_PERCENTAGE_NOT_EXIST = "023";

    // 创建保存文件失败
    String CREATE_TARGET_FILE_ERROR = "024";

    // 点图处理方式无效
    String DOTPLOT_INVALID = "025";

    // 通讯超时
    String COMMUNICATION_TIME_OUT = "101";

    // 系统异常
    String SYS_ERROR = "102";

    // 通讯组件未初始化
    String MESSENGER_NOT_INTI = "103";
}
