package com.jhscale.meter.protocol.print;

import com.jhscale.common.utils.SystemtUtils;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.print.entity.cmd.Print0000Request;
import com.jhscale.meter.protocol.print.link.IPrintBack;
import com.jhscale.meter.protocol.print.produce.entity.PrintBackResponse;
import com.jhscale.meter.protocol.print.produce.entity.PrintInfoResponse;

/**
 * @author wang lie
 * @version 1.0
 * @projectName meter-jar
 * @title PrintUpgradeThread
 * @description
 * @create 2024/1/12 12:58
 */
public class PrintUpgradeThread extends Thread {

    // 默认回调内容
    private PrintBackResponse printBackResponse;

    // 通讯器
    private PrintCommunication printCommunication;

    // 回调函数
    private IPrintBack printBack;

    private boolean puase = true;


    /**
     * Allocates a new {@code Thread} object. This constructor has the same
     * effect as {@linkplain #Thread(ThreadGroup, Runnable, String) Thread}
     * {@code (null, null, name)}.
     *
     * @param name the name of the new thread
     */
    public PrintUpgradeThread(String name, PrintCommunication printCommunication, IPrintBack printBack) {
        super(name);
        this.printCommunication = printCommunication;
        this.printBack = printBack;
    }

    private Boolean end = false;
    int count = 0;

    /**
     * If this thread was constructed using a separate
     * <code>Runnable</code> run object, then that
     * <code>Runnable</code> object's <code>run</code> method is called;
     * otherwise, this method does nothing and returns.
     * <p>
     * Subclasses of <code>Thread</code> should override this method.
     *
     * @see #start()
     * @see #stop()
     * @see #Thread(ThreadGroup, Runnable, String)
     */
    @Override
    public void run() {
        while (puase) {
            SystemtUtils.sleep(1);
        }

        while (!end && count < 20) {
            try {
                SystemtUtils.sleep(5);
                Print0000Request request = new Print0000Request();
                request.setPrintBack(new IPrintBack() {
                    @Override
                    public void responseBack(PrintBackResponse printBackResponse) {
                        if (printBackResponse instanceof PrintInfoResponse) {
                            PrintInfoResponse printInfoResponse = (PrintInfoResponse) printBackResponse;
                            if (printInfoResponse.getFont() != null && printInfoResponse.getFont() > 0) {
                                end = true;
                            }
                        }
                    }
                });
                printCommunication.sendData(request);
            } catch (MeterException e) {
                System.err.printf("升级完成后获取信息失败：%s", e.getMessage());
            }
            count++;
        }
        printBack.responseBack(printBackResponse);
    }

    public void response(PrintBackResponse response) {
        if (this.printBackResponse == null) this.printBackResponse = response;
        this.puase = false;
    }
}
