package com.jhscale.meter.protocol.print.data;

import com.jhscale.meter.utils.ByteUtils;
import org.apache.commons.lang3.StringUtils;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * @author lie_w
 * @title: PrintDataAssemble
 * @projectName jhscale-agreement
 * @description: 打印内容组装
 * @date 2020-12-2212:50
 */
public class PrintDataAssemble {

    private Charset charset;

    // 解析后内容片段
    private List<PrintDataParse.PrintPart> printParts;

    // 打印数值
    private PrintVal printVal;

    public PrintDataAssemble() {
    }

    public PrintDataAssemble(Charset charset, List<PrintDataParse.PrintPart> printParts, PrintVal printVal) {
        this.charset = charset;
        this.printParts = printParts;
        this.printVal = printVal;
    }

    /**
     * @description: 拼装数据
     **/
    public String assemble() {
        StringBuffer sb = new StringBuffer();
        if (printParts != null && !printParts.isEmpty()) {
            Collections.sort(printParts);

            for (PrintDataParse.PrintPart printPart : printParts) {
                if (printPart.isCycle()) {
                    // 循环体
                    List<Map<String, String>> cycleList = printVal.getCycle().get(printPart.getOrder());
                    if (cycleList != null && !cycleList.isEmpty()) {
                        for (Map<String, String> cycleVal : cycleList) {
                            List<String> fieldVals = new ArrayList<>();
                            printPart.getFields().forEach(field -> {
                                fieldVals.add(getPrintVal(field, printPart, cycleVal));
                            });
                            sb.append(String.format(printPart.getFilledPart(), fieldVals.toArray()));
                        }
                    }
                } else {
                    // 非循环体
                    List<String> fieldVals = new ArrayList<>();
                    printPart.getFields().forEach(field -> {
                        fieldVals.add(getPrintVal(field, printPart, this.printVal.getSimple()));
                    });
                    sb.append(String.format(printPart.getFilledPart(), fieldVals.toArray()));
                }
            }
        }
        return sb.toString();
    }

    /**
     * @description: 转换输出值
     **/
    private String getPrintVal(String field, PrintDataParse.PrintPart printPart, Map<String, String> printVal) {
        if (StringUtils.isBlank(field)) return "";
        String val = null;
        if (field.startsWith("T")) {
            // 纯文本 如果填写映射值直接使用
            String T_VAL = printPart.mapping(field);
            val = StringUtils.isBlank(T_VAL) ? field : T_VAL;
            val = val.replace("T", "");
        } else if (field.startsWith("R")) {
            // 条码转换规则 目前直接返回 Field
            String R_VAL = printVal.get(printPart.mapping(field));
            val = StringUtils.isBlank(R_VAL) ? " " : R_VAL;
        } else if (field.startsWith("#")) {
            // 条件选择
            String _VAL = printVal.get(printPart.mapping(field));
            val = StringUtils.isBlank(_VAL) ? "" : _VAL;
        } else if (field.startsWith("I") || field.startsWith("i")) {
            // 商品信息
            String I_VAL = printVal.get(printPart.mapping(field));
//            val = StringUtils.isBlank(I_VAL) ? field + "_UF" : I_VAL;
            val = StringUtils.isBlank(I_VAL) ? " " : I_VAL;
        } else if (field.startsWith("S") || field.startsWith("s")) {
            // 交易信息
            String S_VAL = printVal.get(printPart.mapping(field));
//            val = StringUtils.isBlank(S_VAL) ? field + "_UF" : S_VAL;
            val = StringUtils.isBlank(S_VAL) ? " " : S_VAL;
        } else if (field.startsWith("Z") || field.startsWith("z")) {
            // 段落
            val = field;
        } else {
            // 未知类型
            val = field + "_UK";
        }
        val = StringUtils.isNotBlank(val) ? val : "";
        return ByteUtils.toHexAscii(val.getBytes(charset)) + "00";
    }
}
