package com.jhscale.meter.protocol.print.data;

import com.jhscale.meter.utils.MapUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author lie_w
 * @title: PrintVal
 * @projectName jhscale-agreement
 * @description: 打印键值对信息
 * @date 2020-12-168:32
 */
public class PrintVal {

    // 全局使用的Val 字段 S0 -> 对象属性 -> 属性值
    private Map<String, String> simple;

    // 循环使用的Val
    // Integer -> PrintPart Order
    // List<Map> -> 单数据Val
    private Map<Integer, List<Map<String, String>>> cycle;

    public PrintVal() {
    }

    public PrintVal(Map<String, String> simple, Map<Integer, List<Map<String, String>>> cycle) {
        this.simple = simple;
        this.cycle = cycle;
    }

    /**
     * @description: 添加普通键值对
     **/
    public PrintVal addSimple(String key, String val) {
        if (simple == null) simple = new HashMap<>();
        simple.put(key, val);
        return this;
    }

    /**
     * @description: 添加循环体
     **/
    public PrintVal addSimple(Object obj) {
        if (simple == null) simple = new HashMap<>();
        simple.putAll((obj instanceof Map) ? (Map<? extends String, ? extends String>) obj : MapUtils.toMap(obj));
        return this;
    }

    /**
     * @description: 添加循环 Key Val
     **/
    public PrintVal addCycle(Integer printOrder, Map<String, String> keyVals) {
        if (cycle == null) cycle = new HashMap<>();
        List<Map<String, String>> mapList = cycle.get(printOrder);
        if (mapList == null) {
            mapList = new ArrayList<>();
            cycle.put(printOrder, mapList);
        }
        mapList.add(keyVals);
        return this;
    }

    /**
     * @description: 添加循环体
     **/
    public PrintVal addCycle(Integer printOrder, Object obj) {
        this.addCycle(printOrder, (obj instanceof Map) ? (Map<? extends String, ? extends String>) obj : MapUtils.toMap(obj));
        return this;
    }

    /**
     * @description: 获取不同键值对值
     **/
    public String getSimpleVal(String key) {
        if (StringUtils.isBlank(key)) return "";
        return (simple != null) ? simple.get(key) : "";
    }

    public Map<String, String> getSimple() {
        return simple;
    }

    public void setSimple(Map<String, String> simple) {
        this.simple = simple;
    }

    public Map<Integer, List<Map<String, String>>> getCycle() {
        return cycle;
    }

    public void setCycle(Map<Integer, List<Map<String, String>>> cycle) {
        this.cycle = cycle;
    }
}
