package com.jhscale.meter.protocol.print.dither;

import com.jhscale.meter.protocol.print.em.Compress;

/**
 * @author Loveven
 * @title: CompressParam
 * @projectName jhscale-agreement
 * @description: 图片压缩参数
 * @date 2021-03-2614:57
 */
public class CompressParam {

    private static final double DEFAULT_RATE = 1.0;

    // 压缩文件类型
    private Compress compress;

    // 压缩文件指定长宽
    private int width;

    private int height;

    private double rate = DEFAULT_RATE;

    public CompressParam() {
    }

    public CompressParam(int width, int height) {
        this.compress = Compress.Width_Height;
        this.width = width;
        this.height = height;
    }

    public CompressParam(double rate) {
        this.compress = Compress.Proportion;
        this.rate = rate;
    }

    public static double getDefaultRate() {
        return DEFAULT_RATE;
    }

    public Compress getCompress() {
        return compress;
    }

    public void setCompress(Compress compress) {
        this.compress = compress;
    }

    public int getWidth() {
        return width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public double getRate() {
        return rate;
    }

    public void setRate(double rate) {
        this.rate = rate;
    }
}
