package com.jhscale.meter.protocol.print.dither;

import com.jhscale.meter.protocol.print.dither.algorithm.*;
import com.jhscale.meter.protocol.print.image.ImageConstant;
import com.jhscale.meter.protocol.print.image.RGB;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

/**
 * @author lie_w
 * @title: Dithering
 * @projectName jhscale-agreement
 * @description: Dither 图像算法
 * https://github.com/NamanDeept/MonokromCL
 * @date 2021-01-2115:31
 */
@Deprecated
public class DitherFactory {

    private DitherFactory() {
    }

    /**
     * @description: 旋转图片
     **/
    public static BufferedImage rotate(File source, File target, int angel) {
        BufferedImage sourceImage = read(source);
        // 计算旋转后图片的尺寸
        System.out.println("Rotate Image...");
        Rectangle rect_des = CalcRotatedSize(new Rectangle(new Dimension(
                sourceImage.getWidth(), sourceImage.getHeight())), angel);
        BufferedImage targetImage = new BufferedImage(rect_des.width, rect_des.height,
                BufferedImage.TYPE_INT_RGB);
        Graphics2D g2 = targetImage.createGraphics();
        // 进行转换
        g2.translate((rect_des.width - sourceImage.getWidth()) / 2,
                (rect_des.height - sourceImage.getHeight()) / 2);
        g2.rotate(Math.toRadians(angel), sourceImage.getWidth() / 2, sourceImage.getHeight() / 2);
        g2.drawImage(sourceImage, null, null);
        System.out.println("Rotate Image Success.");
        //写文件
        write(target, targetImage);
        return targetImage;
    }

    /**
     * @description: 固定宽高缩放
     **/
    public static BufferedImage compress(File source, File target, int width, int height) {
        return compress(source, target, width, height, null);
    }

    /**
     * @description: 固定宽高缩放
     **/
    public static BufferedImage compress(BufferedImage source, File target, int width, int height) {
        return compress(source, target, width, height, null);
    }

    /**
     * @description: 固定比例缩放
     **/
    public static BufferedImage compress(File source, int width, int height) {
        return compress(source, null, width, height, null);
    }

    /**
     * @description: 固定比例缩放
     **/
    public static BufferedImage compress(BufferedImage source, int width, int height) {
        return compress(source, null, width, height, null);
    }

    /**
     * @description: 固定比例缩放
     **/
    public static BufferedImage compress(File source, File target, Double rate) {
        return compress(source, target, null, null, rate);
    }

    /**
     * @description: 固定比例缩放
     **/
    public static BufferedImage compress(BufferedImage source, File target, Double rate) {
        return compress(source, target, null, null, rate);
    }

    /**
     * @description: 固定比例缩放
     **/
    public static BufferedImage compress(File source, Double rate) {
        return compress(source, null, null, null, rate);
    }

    /**
     * @description: 固定比例缩放
     **/
    public static BufferedImage compress(BufferedImage source, Double rate) {
        return compress(source, null, null, null, rate);
    }

    /**
     * @description: 图片压缩
     **/
    public static BufferedImage compress(File source, File target, Integer width, Integer height, Double rate) {
        if (source != null && source.exists()) {
            BufferedImage src = read(source);
            return compress(src, target, width, height, rate);
        }
        return null;
    }

    /**
     * @description: 图片压缩
     **/
    public static BufferedImage compress(BufferedImage sourceImage, File target, Integer width, Integer height, Double rate) {
        if (sourceImage != null) {
            System.out.println("Processing compress image...");
            if (rate != null && rate > 0) {
                width = (int) (sourceImage.getWidth() * rate);
                height = (int) (sourceImage.getHeight() * rate);
            }
            BufferedImage tag = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
            //绘制图像  getScaledInstance表示创建此图像的缩放版本，返回一个新的缩放版本Image,按指定的width,height呈现图像
            //Image.SCALE_SMOOTH,选择图像平滑度比缩放速度具有更高优先级的图像缩放算法。
            tag.getGraphics().drawImage(sourceImage.getScaledInstance(width, height, Image.SCALE_SMOOTH), 0, 0, null);
            write(tag, target);
            return tag;
        }
        return null;
    }

    /**
     * @description: 图像转换
     **/
    public static DitherVal dither(File file) {
        return dither(file, DitherEnum.burkes);
    }

    /**
     * @description: 图像流转换
     **/
    public static DitherVal dither(BufferedImage sourceImage) {
        BufferedImage targetImage = dither(sourceImage, null, DitherEnum.burkes, ImageConstant.DEFAIL_THRESHOLD);
        return targetImage != null ? new DitherVal(targetImage.getRaster()) : null;
    }

    /**
     * @description: 图像流转换
     **/
    public static DitherVal dither(BufferedImage sourceImage, DitherParam ditherParam) {
        return new DitherVal(imageBuffer(sourceImage), ditherParam);
    }

    /**
     * @description:
     **/
    public static ImageBuffer imageBuffer(BufferedImage sourceImage) {
        ImageBuffer buffer = new ImageBuffer();
        buffer.setMinX(sourceImage.getMinX());
        buffer.setMinY(sourceImage.getMinY());
        buffer.setWidth(sourceImage.getWidth());
        buffer.setHeight(sourceImage.getHeight());

//        StringBuffer sb = new StringBuffer();// 打印日志

        String[][] RGBHEX = new String[sourceImage.getHeight()][sourceImage.getWidth()];
        for (int j = 0; j < sourceImage.getHeight(); j++) {
            for (int i = 0; i < sourceImage.getWidth(); i++) {
                RGBHEX[j][i] = new RGB(sourceImage.getRGB(i, j)).RGB();
//                sb.append(RGB).append(",");
            }
//            sb.append("\n");
        }
//        System.out.println(sb.toString());
        buffer.setRGBHexs(RGBHEX);
        return buffer;
    }

    /**
     * @description: 图片转换
     **/
    public static DitherVal dither(File source, File target) {
        return dither(source, target, DitherEnum.burkes);
    }

    /**
     * @description: 图像流转换
     **/
    public static DitherVal dither(BufferedImage sourceImage, File target) {
        BufferedImage targetImage = dither(sourceImage, target, DitherEnum.burkes, ImageConstant.DEFAIL_THRESHOLD);
        return targetImage != null ? new DitherVal(targetImage.getRaster()) : null;
    }

    /**
     * @description: 图像转换
     **/
    public static DitherVal dither(File file, DitherEnum dither) {
        return dither(file, null, dither);
    }

    /**
     * @description: 图片转换
     **/
    public static DitherVal dither(File source, File target, DitherEnum dither) {
        BufferedImage targetImage = dither(source, target, dither, ImageConstant.DEFAIL_THRESHOLD);
        return targetImage != null ? new DitherVal(targetImage.getRaster()) : null;
    }

    /**
     * @description: 图片转换
     **/
    public static BufferedImage dither(File source, File target, DitherEnum dither, int threshold) {
        BufferedImage sourceImage = read(source);
        return dither(sourceImage, target, dither, threshold);
    }

    /**
     * @description: 写文件
     **/
    private static void write(File target, BufferedImage image) {
        try {
            if (target != null && image != null) {
                System.out.println("Dither Image Writing...");
                File parentFile = target.getParentFile();
                if (!parentFile.exists()) parentFile.mkdirs();
                String destinationPath = target.getAbsolutePath();
                String suffix = destinationPath.substring(destinationPath.lastIndexOf(".") + 1, destinationPath.length());
                ImageIO.write(image, suffix, target);
                System.out.println("Dither Image Write Success.");
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * @description: 写文件
     **/
    private static void write(BufferedImage image, File target) {
        FileOutputStream out = null;
        try {
            if (target != null && image != null) {
                System.out.println("Compress Image Writing...");
                File parentFile = target.getParentFile();
                if (!parentFile.exists()) parentFile.mkdirs();
                out = new FileOutputStream(target);
                //将图片按JPEG压缩，保存到out中
                JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder(out);
                encoder.encode(image);
                System.out.println("Compress Image Writing...");
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                if (out != null)
                    out.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * @description: 读文件
     **/
    public static BufferedImage read(File source) {
        BufferedImage sourceImage = null;
        if (source != null && source.exists()) {
            try {
                sourceImage = ImageIO.read(source);
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sourceImage;
    }

    /**
     * @description: dither算法 图像转换
     **/
    private static BufferedImage dither(BufferedImage sourceImage, File target, DitherEnum dither, int threshold) {
        BufferedImage targetImage = dither(dither, sourceImage, threshold);
        write(target, targetImage);
        return targetImage;
    }

    /**
     * 计算旋转后的图片
     *
     * @param src   被旋转的图片
     * @param angel 旋转角度
     * @return 旋转后的图片
     */
    public static Rectangle CalcRotatedSize(Rectangle src, int angel) {
        // 如果旋转的角度大于90度做相应的转换
        if (angel >= 90) {
            if (angel / 90 % 2 == 1) {
                int temp = src.height;
                src.height = src.width;
                src.width = temp;
            }
            angel = angel % 90;
        }

        double r = Math.sqrt(src.height * src.height + src.width * src.width) / 2;
        double len = 2 * Math.sin(Math.toRadians(angel) / 2) * r;
        double angel_alpha = (Math.PI - Math.toRadians(angel)) / 2;
        double angel_dalta_width = Math.atan((double) src.height / src.width);
        double angel_dalta_height = Math.atan((double) src.width / src.height);

        int len_dalta_width = (int) (len * Math.cos(Math.PI - angel_alpha
                - angel_dalta_width));
        int len_dalta_height = (int) (len * Math.cos(Math.PI - angel_alpha
                - angel_dalta_height));
        int des_width = src.width + len_dalta_width * 2;
        int des_height = src.height + len_dalta_height * 2;
        return new Rectangle(new Dimension(des_width, des_height));
    }

    /**
     * @description: dither算法 图像转换
     **/
    private static BufferedImage dither(DitherEnum dither, BufferedImage source, int threshold) {
        if (source != null) {
            System.out.println("Processing dither image...");

            IDithering dithering = null;
            switch (dither) {
                case ordered2By2Bayer:
                    dithering = new Ordered2By2Bayer();
                    break;
                case ordered3By3Bayer:
                    dithering = new Ordered3By3Bayer();
                    break;
                case ordered4By4Bayer:
                    dithering = new Ordered4By4Bayer();
                    break;
                case ordered8By8Bayer:
                    dithering = new Ordered8By8Bayer();
                    break;
                case floydSteinberg:
                    dithering = new FloydSteinberg();
                    break;
                case jarvisJudiceNinke:
                    dithering = new JarvisJudiceNinke();
                    break;
                case sierra:
                    dithering = new Sierra();
                    break;
                case twoRowSierra:
                    dithering = new TwoRowSierra();
                    break;
                case sierraLite:
                    dithering = new SierraLite();
                    break;
                case atkinson:
                    dithering = new Atkinson();
                    break;
                case stucki:
                    dithering = new Stucki();
                    break;
                case burkes:
                    dithering = new Burkes();
                    break;
                case falseFloydSteinberg:
                    dithering = new FalseFloydSteinberg();
                    break;
                case simpleLeftToRightErrorDiffusion:
                    dithering = new SimpleLeftToRightErrorDiffusion();
                    break;
                case randomDithering:
                    dithering = new RandomDithering();
                    break;
                case simpleThreshold:
                    dithering = new SimpleThreshold();
                    break;
                default:
                    break;
            }
            if (dithering != null) {
                return dithering.dither(source, threshold);
            }
        }
        return null;
    }
}
